﻿
/* 
 * +===================================================================+
 * | XGCI (Xugu DB C Call Interface).                                  |
 * +-------------------------------------------------------------------+                                                      
 * |                                                                   |
 * |              ____ ____   ________   _______   ____                |
 * |             |    |    | /        | /       \ |    |               |
 * |              \       / |    _____||    _____||    |               |
 * |              /       \ |    |_   ||         ||    |               |
 * |             |____|____| \________| \_______/ |____|               |                              
 * |                                                                   |
 * |                                                                   |
 * |   XGCI is a dedicated C/C++ programming language access interface |
 * | for xugu database, independently developed by the company, with   |
 * | high performance and high stability.                              |
 * |   Copyright © Xugu Weiye Technology Co., Ltd.                     |
 * |   All rights reserved.                                            |                    
 * +-------------------------------------------------------------------+                                                      
 */

#ifndef  _XGCI_H_
#define  _XGCI_H_

#ifdef WIN32
#include  <windows.h> 
#endif

#ifdef WIN32
#define XG_API  __stdcall
#else
#define XG_API
#endif


#ifdef __cplusplus
extern "C" { 			/* Assume C declarations for C++   */
#endif  /* __cplusplus */

#if defined(_WIN32) || defined(_WIN64) || defined(__WIN32__) || defined(WIN64)
#define  Platform "Win_x64"
#elif defined(__x86_64__)
#define  Platform "Linux_x64"
#else
#define  Platform "Linux_Aarch64"
#endif

#ifdef WIN32
typedef		unsigned char       uchar;
typedef		char	            int8;
typedef		__int16             int16;
typedef		unsigned __int16	ushort;
typedef		unsigned int        uint;
typedef		__int32             int32;
typedef		unsigned __int32    uint32;
typedef		unsigned long	    ulong;
typedef		__int64             int64;
typedef		unsigned __int64    uint64;
//typedef     unsigned int        size_t;
#else
typedef		unsigned char       uchar;
typedef		  char       int8;
typedef		short               int16;
typedef		unsigned short	    ushort;
typedef		int                 int32;
typedef		unsigned int        uint32;
typedef		unsigned long	    ulong;
typedef		unsigned int	    uint;
typedef		long long           int64;
typedef		unsigned long long  uint64;
typedef   long  unsigned int        size_t;
#endif

#ifdef _LINUX_NOAIX
typedef		long long           int64;
#endif

typedef  int32    XGCIRETURN;

#if !defined(bool) && !defined(__cplusplus)
typedef char  bool;
#endif

//#ifndef true
//#define true   1
//#define false  0
//#endif


#define MAX_NUMERIC_LEN	  64
typedef  char NUMERIC[MAX_NUMERIC_LEN];


typedef struct  TIME_STRUCT
{
    int32   hour;
    int32   minute;
    int32   second;
}TIME;


typedef struct  tagDATE_STRUCT
{
	int32   year;
    int32   month;
    int32   day;
}DATE_STRUCT;


typedef struct  DATETIME_STRUCT
{
    int32   year;
    int32   month;
    int32   day;
    int32   hour;
    int32   minute;
    int32   second;
    int32   fraction;
}DATETIME;

typedef   DATETIME  TIMESTAMP;

typedef struct YEAR_TO_MONTH_STRUCT
{
	int32	year;
	int32	month;
}YEAR_TO_MONTH;

typedef struct DAY_TO_SECOND_STRUCT
{
    int32   day;
    int32   hour;
    int32   minute;
    int32   second;
    int32   fraction;
}DAY_TO_SECOND;


typedef enum  tagINTERVAL_TYPE
{
	INTERVAL_YEAR					= 1,
	INTERVAL_MONTH					= 2,
	INTERVAL_DAY					= 3,
	INTERVAL_HOUR					= 4,
	INTERVAL_MINUTE					= 5,
	INTERVAL_SECOND					= 6,
	INTERVAL_YEAR_TO_MONTH			= 7,
	INTERVAL_DAY_TO_HOUR			= 8,
	INTERVAL_DAY_TO_MINUTE			= 9,
	INTERVAL_DAY_TO_SECOND			= 10,
	INTERVAL_HOUR_TO_MINUTE			= 11,
	INTERVAL_HOUR_TO_SECOND			= 12,
	INTERVAL_MINUTE_TO_SECOND		= 13
}INTERVAL_TYPE;

typedef struct INTERVAL_STRUCT
{
    INTERVAL_TYPE	 intval_type;
	union{
	       YEAR_TO_MONTH  y2m;
	       DAY_TO_SECOND  d2s;
	}intval;
}INTERVAL;

typedef  void *  LobLocator;
typedef void *   XGCIPOINTER;

typedef enum   tagHANDLE_TYPE {
	 HT_UNKNOW,       /* Result set type        */
	 HT_ENV,          /* Environment handle     */
	 HT_SERVER,       /* Service handle         */
	 HT_SESSION,      /* Session handle         */
	 HT_CONNPOOL,     /* Connection pool handle */
	 HT_STATEMENT,    /* Statement handle       */
	 HT_BIND,         /* Binding handle         */
	 HT_DEFINE,       /* Define handle          */
	 HT_ERR,          /* Error handle           */
	 HT_RS,           /* Result set             */
	 XGCI_DTYPE_PARAM,
	 HT_SVCCTX
}HANDLE_TYPE;

/* Result set type */
typedef enum tagResultType
{
	RESULT_UNKNOWN,
	RESULT_INSERT,
	RESULT_SELECT,
	RESULT_UPDATE,
	RESULT_DELETE,
}ResultType;


typedef enum  tagPARAM_TYPE{
	PARAM_UNKNOWN= 0,
	PARAM_IN     = 1,    /* Input parameter        */
	PARAM_OUT    = 2,    /* Output parameter       */
	PARAM_INOUT  = 3,    /* Input Output parameter */
	
}PARAM_TYPE;

struct XGCIHandle{
	HANDLE_TYPE type;    /* handle type */
};

typedef struct XGCIHandle * XGCIHANDLE;

typedef XGCIHANDLE      XGCIHENV;
typedef XGCIHANDLE      XGCIHSRV;
typedef XGCIHANDLE      XGCIHSESS;
typedef XGCIHANDLE      XGCIHCONNPOOL;
typedef XGCIHANDLE      XGCIHSTMT;
typedef XGCIHANDLE      XGCIHBIND;
typedef XGCIHANDLE      XGCIHDEFINE;


/* SQL data type defined */
#define  SQL_BOOL          1
#define  SQL_TINYINT       2
#define  SQL_SMALLINT      3
#define  SQL_INTEGER       4
#define  SQL_BIGINT        5
#define  SQL_FLOAT         6
#define  SQL_DOUBLE        7
#define  SQL_NUMERIC       8
#define  SQL_DATE          9
#define  SQL_TIME          10
#define  SQL_DATETIME      11
#define  SQL_CHAR          12
#define  SQL_BINARY        13
#define  SQL_CLOB          14
#define  SQL_IMAGE         15
#define  SQL_BLOB          16

#define  SQL_INTERVAL_YEAR              20
#define  SQL_INTERVAL_MONTH             21
#define  SQL_INTERVAL_DAY               22
#define  SQL_INTERVAL_HOUR              23
#define  SQL_INTERVAL_MINUTE            24
#define  SQL_INTERVAL_SECOND            25
#define  SQL_INTERVAL_YEAR_TO_MONTH     26
#define  SQL_INTERVAL_DAY_TO_SECOND     27
#define  SQL_INTERVAL_DAY_TO_HOUR       28
#define  SQL_INTERVAL_DAY_TO_MINUTE     29
#define  SQL_INTERVAL_HOUR_TO_MINUTE    30
#define  SQL_INTERVAL_HOUR_TO_SECOND    31
#define  SQL_INTERVAL_MINUTE_TO_SECOND  32

#define  SQL_TIMESTAMP     SQL_DATETIME
			
/* C data type defined */
#define  XG_C_BOOL                                1
#define  XG_C_CHAR                                2
#define  XG_C_TINYINT                             3
#define  XG_C_SHORT                               4
#define  XG_C_INTEGER                             5
#define  XG_C_BIGINT                              6
#define  XG_C_FLOAT                               7
#define  XG_C_DOUBLE                              8
#define  XG_C_NUMERIC                             9
#define  XG_C_DATE	                              10
#define  XG_C_TIME			                      11
#define  XG_C_TIME_TZ                             12
#define  XG_C_DATETIME                            13
#define  XG_C_DATETIME_TZ                         14
#define  XG_C_BINARY                              15


#define  XG_C_INTERVAL                            21
//#define  XG_C_INTERVAL_YEAR				      22
//#define  XG_C_INTERVAL_MONTH			          23
//#define  XG_C_INTERVAL_DAY				      24
//#define  XG_C_INTERVAL_HOUR				      25
//#define  XG_C_INTERVAL_MINUTE			          26
//#define  XG_C_INTERVAL_SECOND	                  27
#define  XG_C_INTERVAL_YEAR_TO_MONTH	          28
//#define  XG_C_INTERVAL_DAY_TO_HOUR		      29
//#define  XG_C_INTERVAL_DAY_TO_MINUTE	          30
#define  XG_C_INTERVAL_DAY_TO_SECOND	          31
//#define  XG_C_INTERVAL_HOUR_TO_MINUTE	          32
//#define  XG_C_INTERVAL_HOUR_TO_SECOND	          33
//#define  XG_C_INTERVAL_MINUTE_TO_SECOND	      34

#define  XG_C_TIMESTAMP                           XG_C_DATETIME

#define  XG_C_LOB                                 40

#define  XG_RESET_PARAM   1
#define  XG_RESET_DEFINE  2
#define  XG_RESET         3

/* Transaction isolation level */
#define   XGCI_ISO_READONLY    1
#define   XGCI_ISO_READCOMMIT  2
#define   XGCI_ISO_READREPEAT  3
#define   XGCI_ISO_SERIAL      4

/* Character set */
#define   XGCI_CHARSET_GBK     1
#define   XGCI_CHARSET_GB2312  2
#define   XGCI_CHARSET_UTF8    3

/* Auto commit */
#define   XGCI_AUTOCOMMIT_OFF  0
#define   XGCI_AUTOCOMMIT_ON   1

/* Safe connection */
#define   XGCI_USESSL_FALSE    0
#define   XGCI_USESSL_TRUE     1

/* Transaction rollback level */
#define ROLLBACK_TRANS 1
#define ROLLBACK_TOSAVEPOINT 2

#define USE_NOT_SERVER_CUR 0
#define USE_SERVER_CURSOR 1  
#define USE_SERVER_CURSOR_ASYNC 2  
#define  XG_USE_DEFAULT 0   

/* Environmental attributes */
#define   XGCI_ATTR_ENV_VERSION   1
#define   XGCI_ATTR_ENV_USE_POOL   2

// conn pool handle attribute
#define XGCI_ATTR_CONNPOOL_TIMEOUT 7
#define XGCI_ATTR_CONNPOOL_IMAX    6
#define XGCI_ATTR_CONNPOOL_IMIN    5

/* Service handle attributes */
#define   XGCI_ATTR_SRV_IP        21		 
#define   XGCI_ATTR_SRV_PORT      22
#define   XGCI_ATTR_SRV_URL       23
#define   XGCI_ATTR_SRV_DBNAME    24     


#define  _USE_TURN_IPS_
#ifdef  _USE_TURN_IPS_
#define  XGCI_ATTR_SRV_TURN_IPS  28 
#endif

/* Session handle attributes */
#define   XGCI_ATTR_SESS_USER         31 		 		
#define   XGCI_ATTR_SESS_PASS         32
#define   XGCI_ATTR_SESS_CHARSET      33
#define   XGCI_ATTR_SESS_TIMEZONE     34
#define   XGCI_ATTR_SESS_ENCRYPTOR    35
#define   XGCI_ATTR_SESS_ISOLEVEL     36
#define   XGCI_ATTR_SESS_SSL          37
#define   XGCI_ATTR_SESS_AUTO_COMMIT  38
#define   XGCI_ATTR_SESS_TIMEOUT      39
#define   XGCI_ATTR_SESS_LOB_DESCRIBER  40
#define   XGCI_ATTR_SESS_VERSION      41    /* for V12.0+ */

/* Statement handle attributes */
#define   XGCI_ATTR_STMT_
#define   XGCI_ATTR_STMT_PREPARE_WITH_SERVER_CURSOR  42
 
#define   XGCI_ATTR_SESS_CURSORID_RET  44
#define   XGCI_ATTR_SESS_LOCKTIMEOUT   45
#define   XGCI_ATTR_SESS_ROWID_RET  46 
#define   XGCI_ATTR_SESS_SCHEMA_RET  47
//describe attr info  
#define XGCI_ATTR_NAME  50
#define XGCI_ATTR_DATA_TYPE 51
#define XGCI_ATTR_ALIAS      52
#define XGCI_ATTR_DATA_SIZE  53
#define XGCI_ATTR_CHAR_SIZE  54
#define XGCI_ATTR_TYPE_NAME  55
#define XGCI_ATTR_CHAR_USED  56
#define XGCI_ATTR_DATA_IS_CHAR  57
#define XGCI_ATTR_PRECISION  58
#define XGCI_ATTR_SCALE      59
#define XGCI_ATTR_DATA_IS_NOTNULL  60

/* Result set attributes */
#define XGCI_ATTR_COL_COUNT  61
#define XGCI_ATTR_ROW_COUNT  62

#define XGCI_ATTR_EFFECT_NUM 63
#define XGCI_ATTR_RESULT_TYPE 64 

#define XGCI_ATTR_SQL_TYPE 65

#define XGCI_NTS             -1                /* NULL terminated string */

#define XGCI_SUCCESS           0               /* The execution is successful */
#define XGCI_SUCCESS_WITH_INFO 1               /* The execution is successful, but there are prompts or warnings */
#define XGCI_NO_DATA        100                /* Reach the end of SELECT RESULT, no data */
#define XGCI_NULL_ROW       101                /* the network has no row data, and returns a blank row */
#define XGCI_ERROR          -1                 /* Execution error   */
#define XGCI_INVALID_HANDLE -2                 /* Invalid handle    */
#define XGCI_INVALID_ARG    -3                 /* Invalid parameter */
#define XGCI_NET_ERROR      -4                 /* Network error     */
#define XGCI_MEM_ERROR      -5                 /* Memory error      */
#define XGCI_INVALID_ATTR   -6                 /* Invalid attribute */
#define XGCI_NO_RESULT      -7                 /* Reach the end of the result set list */

#define XGCI_BINDPARAM_NO_ERROR  -8            /* Parameter binding column number error */

/* Violation of the unique value constraint */
#define XGCI_UNIQ_ERR -13  
#define XGCI_TIME_OUT  -14
#define XG_CON_SOCKET_CLOSE  -16

/* Value beyond bounds */
#define XGCI_DATA_LEN_ERR -17

#define XGCI_CON_TIME_OUT  -24

#define XGCI_SQL_TIME_OUT -25

/* Column-level return codes */
#define XGCI_NULL_DATA       -1                 /* No data returned */
#define XGCI_TRUNCATED_DATA  -2                 /* Data is truncated */
#define XGCI_DATATYPE_ERROR  -3                 /* Data type cannot be converted */
#define XGCI_FLOW_DATA       -4                 /* Data type out of range */

typedef struct SLIST
{
	struct  SLIST * next;
}SLIST;
 
 
//结果集结构
struct  Result_f{

	SLIST        * next;             // Statement-use
 
 virtual bool  nextrow();
virtual char* getString(int iColNum); 
 virtual float getFloat(int iColNum);	 
 virtual int getInteger(int iColNum);	 
 virtual void rs_close();
};
//add V11.4
struct ConnnectionPointer
{
	XGCIHANDLE hdenv;
	XGCIHANDLE hdsver;
	XGCIHANDLE hddbc;
	XGCIHANDLE hderr;//错误信息句柄-- 2022_1013 new add
};
typedef struct 	Ips_Artrs {
	int ips_num; //total num 
	int cur_use; //this conn used' ip	 //ips0: for ip high -avilable-use 
	char** ips_avilab; //-- avilable array
	char** ips_invalid;//-- pre-set  invalid array
	int num_av;//num avilable
}Ips_Artrs;
struct Conn_Params
{
	char ip_str[16]; /* ip信息，默认本机：127.0.0.1 */
	int port;        /* 端口信息，默认：5138        */
	char database[128]; /*数据库信息，默认系统库 SYSTEM */
	char  user[128];    /*用户名*/
	char  password[128];/*口令 以上5个参数为必填 可以有默认值 下面的参数为选填 不填则默认值填充*/

	char  char_set[32];  /*字符集 */
	char  time_zone[16]; /* 时区信息 */
	char  iso_level[16]; /* 安全隔离级别 */
	char  lock_timeout[16]; /* 加锁超时时间 */
	int   auto_commit;      /* 自动提交开关 */
	char  encryptor[64]; /* 加密 默认 "" */
	bool  usessl;       /*启用加密通讯 on/off;true/false */
	bool  lobret;       /*启用大对象描述符*/
	bool  retcursorid; /* 返回游标id，还是直接返回游标结果集*/
	bool  retschema;   /* 返回结果集的模式名 */
	bool  retrowid;      /* 返回结果集行的rowid */
	bool  usecacheret;   /* 接收使用缓存是否  */
	bool  useservercursor;  /* 查询是否使用服务端游标 */
	bool  useips;      /* 是否启用多IP连接 */
	int   cachednum;   /*接收首次结果集数据，之后启用异步 默认2000*/
	bool  strictcommit; /*是否严格提交模式 */
	bool  retaschar;    /*是否以字符串方式返回结果 */
	Ips_Artrs* ips;
	char * ips_str;
};
//////////////////////////////api-function define/////////////////////////////////////////////////////////

//alloc handle 
XGCIRETURN XG_API XGCIHandleAlloc( XGCIHANDLE parenthndp, XGCIHANDLE * hndlpp, HANDLE_TYPE type );

XGCIRETURN XG_API XGCIHandleFree( XGCIHANDLE hndp );

//get handle attr
XGCIRETURN XG_API XGCIHandleAttrGet( XGCIHANDLE hndp, int32 Attribute, void * ValuePtr, int32 BuffLen );

//set handle attr
XGCIRETURN XG_API XGCIHandleAttrSet( XGCIHANDLE hndp, int32 Attribute, const void * ValuePtr, int32 BuffLen );

//reset hstmt handle attrs
XGCIRETURN XG_API XGCIFreeStmt( XGCIHSTMT hndp,int32 Option );


// 
XGCIRETURN XG_API XGCISessionBegin(XGCIHSESS sesshndp, char * puser, char * ppwd);

// 
XGCIRETURN XG_API XGCISessionEnd(XGCIHSESS sesshndp);



//PREPARE a sql  
XGCIRETURN XG_API XGCIPrepare(XGCIHSTMT hndlp,char* sql_str,int32 str_len);

//execute prepared sql
XGCIRETURN XG_API XGCIExecute(XGCIHSTMT hndlp);

XGCIRETURN XG_API XGCIExecDirect(XGCIHSTMT hndlp,char* sql_str,int32 str_len);
 
 Result_f * XG_API  XGCIExecDirect_f(XGCIHSTMT hndlp,char* sql_str,int32 str_len); 
 
Result_f * XG_API XGCIExecute_f(XGCIHSTMT hndlp);
//muti-results get next result

XGCIRETURN XG_API XGCINextResult(XGCIHSTMT hndlp);

XGCIRETURN XG_API XGCITables(XGCIHSTMT, char*, int32, char*, int32, char*, int32, char*, int32);

//get result-set data
XGCIRETURN XG_API XGCIFetch(XGCIHSTMT hndlp);

// Col_Number begin from 1 
XGCIRETURN XG_API XGCIGetData(XGCIHSTMT hndlp, int32 ColNumber, int32 TargetCType,  void * TargetValuePtr, int32 BufferLen, int32 * StrLenPtr);

// 
LobLocator XG_API XGCILobCreate(void);

// 
XGCIRETURN XG_API XGCILobRelease(LobLocator  pLob);

 
XGCIRETURN XG_API XGCILobReset(LobLocator pLob);

//put data to locator
XGCIRETURN XG_API XGCILobPutData(LobLocator  pLob, int32 DataLen, void * pData);

//return data_len and pointer  
XGCIRETURN XG_API XGCILobGetDataPtr(LobLocator  pLob, int32 * pDataLen, char ** ppOutData);

//copy data to user define buff 
XGCIRETURN XG_API XGCILobGetData(LobLocator pLob,int32 DataOffset, int32 BuffLen, char * BuffPtr,int32 * pOutLen );

//bind params -by name 
XGCIRETURN XG_API XGCIBindParamByName(XGCIHSTMT Hndp,char* Name,PARAM_TYPE IoType,void * ValuePtr,int32 BuffSize,
						   int32 CType, int32 * rCodep, int32 * ActualLenp, int32 SqlType);
//bind param acording pos
XGCIRETURN XG_API XGCIBindParamByPos(XGCIHSTMT Hndp,int32 Position,PARAM_TYPE type,void * ValuePtr,int32 BuffSize, 
						 int32 CType, int32 * rCodep, int32 * ActualLenp, int32 SqlType);
//output columns-bind 
XGCIRETURN XG_API XGCIDefineByPos(XGCIHSTMT Hndp,int32 ColNum,void * ValuePtr,int32 BuffSize, 
						 int32 CType, int32 * rCodep, int32 * ActualLenp);
//define attr-get 
XGCIRETURN XG_API XGCIAttrGet(XGCIHANDLE hndlp,HANDLE_TYPE type,void* attributep,uint32* sizep,int attrtype);//20140707

XGCIRETURN XG_API XGCITransBegin(XGCIHSESS sesshndp);
XGCIRETURN XG_API XGCITransCommit(XGCIHSESS sesshndp);
XGCIRETURN XG_API XGCITransCreateSavepoint(XGCIHSESS sesshndp,int sp_no);//savepoint number
 
XGCIRETURN XG_API XGCITransRollback(XGCIHSESS sesshndp,int type,int lvl);// type 1 whole 2 to level 

//error info get
XGCIRETURN XG_API XGCIErrors(XGCIHSTMT Hndp,char* ccode,char* errmessage,int* rlen);
 
//bind param with array values  acording pos
XGCIRETURN XG_API XGCIBindParamArrayByPos(XGCIHSTMT Hndp,int32 Position,int32 param_num,PARAM_TYPE type,int32 array_size,void * ValuePtr,int32 BuffSize, 
						 int32 CType, int32 * rCodep, int32 * ActualLenp, int32 SqlType);
 
XGCIRETURN XG_API XGCIExecDirectBatch(XGCIHSTMT hndlp,char* sql_str,int32 str_len);

XGCIRETURN XG_API XGCIParamGet(XGCIHANDLE hndlp,HANDLE_TYPE type,void ** ptr_param, int param_no);
//bind param with array values  acording names
XGCIRETURN XG_API XGCIBindParamArrayByName(XGCIHSTMT Hndp, char* Name, int32 param_num, PARAM_TYPE type, int32 array_size, void * ValuePtr, int32 BuffSize,
	                     int32 CType, int32 * rCodep, int32 * ActualLenp, int32 SqlType);

//根据连接串信息，创建一个连接会话的结构体 v11.4
XGCIRETURN XGCIConnectbyStr(char* conn_str, ConnnectionPointer * connp);
//根据连接结构体信息，创建一个连接会话的结构体 
XGCIRETURN XGCIConnectbyAttrs(Conn_Params* conn_params, ConnnectionPointer  *connp);
//根据连接会话结构体,获得错误信息 ccode 输入字符串数组拷贝，错误信息直接指针指向 用完驱动内部销毁。11.4新增
XGCIRETURN XG_API XGCIGetError(ConnnectionPointer * connp, char* ccode, char** perrmessage);
//获取指定表的列信息，返回指定表中的列名列表，驱动程序将此信息作为结果集返回到指定的stmt句柄中。
XGCIRETURN XGCIColumns(XGCIHSTMT hndlp, char * schema_name, short name_len1, char * table_name, short name_len2, char * column_name, short name_len3);
//获取存储过程信息
XGCIRETURN XGCIProcedures(XGCIHSTMT hndlp, char * schema_name, short name_len1, char * proc_name, short name_len2);
//获取视图信息
XGCIRETURN XGCIViews(XGCIHSTMT hndlp, char * schema_name, short name_len1, char * view_name, short name_len2);
//获取主键信息，返回构成表的主键的列名称。以结果集形式存放在stmt句柄中
XGCIRETURN XGCIPrimaryKeys(XGCIHSTMT hndlp, char * schema_name, short name_len1, char * table_name, short name_len2);
//获取外键信息
XGCIRETURN XGCIForeignKeys(XGCIHSTMT hndlp, char * PKschema_name, short name_len1, char * PKtable_name, short name_len2, char * FKschema_name, short name_len3, char * FKtable_name, short name_len4);
//获取索引信息 
XGCIRETURN XGCIIndexes(XGCIHSTMT hndlp, char * schema_name, short name_len1, char * table_name, short name_len2);
 

#ifdef __cplusplus
}                                    /* End of extern "C" { */
#endif  /* __cplusplus */

#endif //_XGCI_H_
