#ifndef _OCI_H_
#define _OCI_H_

#ifdef __cplusplus
extern "C"{
#endif

typedef	void OCIEnv;
typedef	void OCIError;
typedef	void OCIServer;
typedef	void OCISession;
typedef	void OCISvcCtx;
typedef	void OCIStmt;

typedef struct OCIDefine		OCIDefine;
typedef struct OCISnapshot		OCISnapshot;
typedef struct OCIBind			OCIBind;
typedef void					OCIParam;

typedef   signed int	sword;
typedef unsigned char	ub1;
typedef unsigned int	ub2;
typedef unsigned int	ub4;
typedef   signed short	sb2;
typedef   signed int	sb4;
typedef unsigned char	oratext;
typedef unsigned int	uword;
typedef	 oratext		text;
typedef  oratext		OraText;
typedef	     int		OCIRETURN;
#if !defined(_WIN32)
#define BOOL            int
#define	TRUE            1
#define FALSE           0
typedef long unsigned int size_t;
#endif
typedef unsigned char boolean;

typedef struct OCITime
{
    ub1 OCITimeHH;                         /* hours; range is 0 <= hours <= 23 */
    ub1 OCITimeMI;                     /* minutes; range is 0 <= minutes <= 59 */
    ub1 OCITimeSS;                     /* seconds; range is 0 <= seconds <= 59 */
}OCITime;

typedef struct OCIDate
{
    sb2 OCIDateYYYY;         /* gregorian year; range is -4712 <= year <= 9999 */
    ub1 OCIDateMM;                          /* month; range is 1 <= month < 12 */
    ub1 OCIDateDD;                             /* day; range is 1 <= day <= 31 */
    OCITime OCIDateTime;                                               /* time */
}OCIDate;

#define OCI_HTYPE_ENV            1
#define OCI_HTYPE_ERROR          8
#define OCI_HTYPE_SVCCTX         11
#define OCI_HTYPE_STMT           5
#define OCI_HTYPE_SERVER         2
#define OCI_HTYPE_SESSION        3
#define OCI_HTYPE_BIND           20


#define OCI_SUCCESS				 0
#define OCI_SUCCESS_WITH_INFO	 1
#define OCI_NO_DATA				 100
#define OCI_ERROR				 -1
#define OCI_INVALID_HANDLE		 -2
#define OCI_INVALID_ATTR		 -6
#define OCI_NEED_DATA			 99

#define OCI_ATTR_DATA_SIZE		 53
#define OCI_ATTR_DATA_TYPE		 51
#define OCI_ATTR_NAME			 50
#define OCI_ATTR_PRECISION		 58
#define OCI_ATTR_SCALE			 59
#define OCI_ATTR_TYPE_NAME		 55
#define OCI_ATTR_SERVER			 6
#define OCI_ATTR_USERNAME		 31 
#define OCI_ATTR_PASSWORD		 32
#define OCI_ATTR_SESSION		 42
#define OCI_ATTR_STMT_TYPE		 103
#define OCI_ATTR_ROW_COUNT		 62  /* the rows processed so far */
#define OCI_ATTR_ROWS_FETCHED    197 /* rows fetched in last call */
#define OCI_ATTR_PARAM_COUNT     61  /* number of column in the select list */
#define OCI_ATTR_STATEMENT       144 /* statement txt in stmt hdl */
#define OCI_ATTR_HANDLE_POSITION 191 /* pos of bind/define handle */

#define OCI_DTYPE_PARAM			 10
#define OCI_DTYPE_LOB			 50
#define OCI_DTYPE_DATE           65

#define OCI_DEFAULT				 0
#define OCI_DATA_AT_EXEC         2
#define dvoid					 void
#define CONST					 const


#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else
#define NULL ((void *)0)
#endif
#endif

#define OCI_NTV_SYNTAX		     1

#define OCI_CRED_RDBMS           1
#define OCI_COMMIT_ON_SUCCESS    0x00000020

#define SQLT_CHR			     2
#define SQLT_NUM			     9
#define SQLT_INT			     5
#define SQLT_FLT			     7
#define SQLT_STR			     1000
#define SQLT_VNU			     9
#define SQLT_PDN			     9
#define SQLT_ODT			     13
#define SQLT_BFLOAT			     7
#define SQLT_BDOUBLE		     8
#define SQLT_BLOB			     1001
#define SQLT_CLOB		       	 1002
#define SQLT_BIN                 1003
#define SQLT_LBI                 1004
#define SQLT_LNG                 1005

typedef struct OCILobLocator OCILobLocator;
typedef OCILobLocator OCIBlobLocator;
typedef OCILobLocator OCIClobLocator;

#define OCILobLocator void
typedef sb4(*OCICallbackLobRead)(void* ctxp, const void* bufp,
    ub4 len, ub1 piece);
typedef sb4(*OCICallbackLobWrite)(void* ctxp, void* bufp,
    ub4* lenp, ub1* piece);

/* OCI_*_PIECE defines the piece types that are returned or set
*/
#define OCI_ONE_PIECE   0                 /* there or this is the only piece */
#define OCI_FIRST_PIECE 1                        /* the first of many pieces */
#define OCI_NEXT_PIECE  2                         /* the next of many pieces */
#define OCI_LAST_PIECE  3                   /* the last piece of this column */

/* CHAR/NCHAR/VARCHAR2/NVARCHAR2/CLOB/NCLOB char set "form" information */
#define SQLCS_IMPLICIT 1     /* for CHAR, VARCHAR2, CLOB w/o a specified set */
#define SQLCS_NCHAR    2                  /* for NCHAR, NCHAR VARYING, NCLOB */
#define SQLCS_EXPLICIT 3   /* for CHAR, etc, with "CHARACTER SET ..." syntax */
#define SQLCS_FLEXIBLE 4                 /* for PL/SQL "flexible" parameters */
#define SQLCS_LIT_NULL 5      /* for typecheck of NULL and empty_clob() lits */

#define OCI_DYNAMIC_FETCH 2
#define OCI_HTYPE_DEFINE  6

#define OCI_CHARSET_GBK     1
#define OCI_CHARSET_GB2312  2
#define OCI_CHARSET_UTF8    3

#define OCI_SQLSTATE_SIZE       5  
#define OCI_ERROR_MAXMSG_SIZE   1024         /* max size of an error message */
#define OCI_ERROR_MAXMSG_SIZE2  3072 /* new len max size of an error message */

/*------------------------(Scrollable Cursor) Fetch Options-------------------
 * For non-scrollable cursor, the only valid (and default) orientation is
 * OCI_FETCH_NEXT
 */
#define OCI_FETCH_CURRENT    0x00000001      /* refetching current position  */
#define OCI_FETCH_NEXT       0x00000002                          /* next row */
#define OCI_FETCH_FIRST      0x00000004       /* first row of the result set */
#define OCI_FETCH_LAST       0x00000008    /* the last row of the result set */
#define OCI_FETCH_PRIOR      0x00000010  /* previous row relative to current */
#define OCI_FETCH_ABSOLUTE   0x00000020        /* absolute offset from first */
#define OCI_FETCH_RELATIVE   0x00000040        /* offset relative to current */

/*--------------------------------LOB types ---------------------------------*/
#define OCI_TEMP_BLOB 1                                   /* LOB type - BLOB */
#define OCI_TEMP_CLOB 2                                   /* LOB type - CLOB */
/*---------------------------------------------------------------------------*/

/*-------------------------- OBJECT Duration --------------------------------*/
typedef ub2 OCIDuration;

#define  OCI_DURATION_INVALID 0xFFFF                     /* Invalid duration */
#define  OCI_DURATION_BEGIN (OCIDuration)10/* beginning sequence of duration */
                                                            /* null duration */
#define  OCI_DURATION_NULL (OCIDuration)(OCI_DURATION_BEGIN-1)
#define  OCI_DURATION_DEFAULT (OCIDuration)(OCI_DURATION_BEGIN-2) /* default */
#define  OCI_DURATION_USER_CALLBACK (OCIDuration)(OCI_DURATION_BEGIN-3)
                                                    /* next special duration */
#define  OCI_DURATION_NEXT (OCIDuration)(OCI_DURATION_BEGIN-4)
                                                  /* the end of user session */
#define  OCI_DURATION_SESSION (OCIDuration)(OCI_DURATION_BEGIN)
                                              /* the end of user transaction */
#define  OCI_DURATION_TRANS (OCIDuration)(OCI_DURATION_BEGIN+1)
/*---------------------------------------------------------------------------*/

/*------------------------ Transaction Start Flags --------------------------*/
/* NOTE: OCI_TRANS_JOIN and OCI_TRANS_NOMIGRATE not supported in 8.0.X       */
#define OCI_TRANS_NEW          0x00000001 /* start a new local or global txn */
#define OCI_TRANS_JOIN         0x00000002     /* join an existing global txn */
#define OCI_TRANS_RESUME       0x00000004    /* resume the global txn branch */
#define OCI_TRANS_PROMOTE      0x00000008 /* promote the local txn to global */
#define OCI_TRANS_STARTMASK    0x000000ff  /* mask for start operation flags */

#define OCI_TRANS_READONLY     0x00000100            /* start a readonly txn */
#define OCI_TRANS_READWRITE    0x00000200          /* start a read-write txn */
#define OCI_TRANS_SERIALIZABLE 0x00000400        /* start a serializable txn */
#define OCI_TRANS_ISOLMASK     0x0000ff00  /* mask for start isolation flags */

#define OCI_TRANS_LOOSE        0x00010000        /* a loosely coupled branch */
#define OCI_TRANS_TIGHT        0x00020000        /* a tightly coupled branch */
#define OCI_TRANS_TYPEMASK     0x000f0000      /* mask for branch type flags */

#define OCI_TRANS_NOMIGRATE    0x00100000      /* non migratable transaction */
#define OCI_TRANS_SEPARABLE    0x00200000  /* separable transaction (8.1.6+) */
#define OCI_TRANS_OTSRESUME    0x00400000      /* OTS resuming a transaction */
#define OCI_TRANS_OTHRMASK     0xfff00000      /* mask for other start flags */
/*---------------------------------------------------------------------------*/

/*------------------------ Transaction End Flags ----------------------------*/
#define OCI_TRANS_TWOPHASE      0x01000000           /* use two phase commit */
#define OCI_TRANS_WRITEBATCH    0x00000001  /* force cmt-redo for local txns */
#define OCI_TRANS_WRITEIMMED    0x00000002              /* no force cmt-redo */
#define OCI_TRANS_WRITEWAIT     0x00000004               /* no sync cmt-redo */
#define OCI_TRANS_WRITENOWAIT   0x00000008   /* sync cmt-redo for local txns */
/*---------------------------------------------------------------------------*/

/*--------------------- User Callback Return Values -------------------------*/
#define OCI_CONTINUE -24200    /* Continue with the body of the OCI function */
#define OCI_ROWCBK_DONE   -24201              /* done with user row callback */
/*---------------------------------------------------------------------------*/


sword	OCIInitialize(ub4 mode, const void* ctxp,
        const void* (*malocfp) (void* ctxp, size_t size),
        const void* (*ralocfp) (void* ctxp, void* memptr, size_t newsize),
        const void (*mfreefp) (void* ctxp, void* memptr));

sword	OCIEnvInit(OCIEnv** envhpp, ub4 mode,
        size_t xtramemsz,
        void** usrmempp);

sword   OCIEnvCreate(OCIEnv** envp, ub4 mode, void* ctxp,
        void* (*malocfp)(void* ctxp, size_t size),
        void* (*ralocfp)(void* ctxp, void* memptr, size_t newsize),
        void  (*mfreefp)(void* ctxp, void* memptr),
        size_t xtramem_sz, void** usrmempp);

sword   OCIHandleAlloc(const void* parenth, void** hndlpp, const ub4 type,
        const size_t xtramem_sz, void** usrmempp);

sword   OCIHandleFree(void* hndlp, const ub4 type);

sword   OCIServerAttach(OCIServer* srvhp, OCIError* errhp,
        const OraText* dblink, sb4 dblink_len, ub4 mode);

sword	OCIServerDetach(OCIServer* srvhp, OCIError* errhp, ub4 mode);

sword   OCIErrorGet(void* hndlp, ub4 recordno, OraText* sqlstate,
        sb4* errcodep, OraText* bufp, ub4 bufsiz, ub4 type);

sword   OCIAttrSet(void* trgthndlp, ub4 trghndltyp, void* attributep,
        ub4 size, ub4 attrtype, OCIError* errhp);

sword   OCIParamGet(const void* hndlp, ub4 htype, OCIError* errhp,
        void** parmdpp, ub4 pos);

sword   OCIAttrGet(const void* trgthndlp, ub4 trghndltyp,
        void* attributep, ub4* sizep, ub4 attrtype,
        OCIError* errhp);

sword   OCISessionBegin(OCISvcCtx* svchp, OCIError* errhp, OCISession* usrhp,
        ub4 credt, ub4 mode);

sword   OCISessionEnd(OCISvcCtx* svchp, OCIError* errhp, OCISession* usrhp,
        ub4 mode);

sword   OCIStmtPrepare(OCIStmt* stmtp, OCIError* errhp, const OraText* stmt,
        ub4 stmt_len, ub4 language, ub4 mode);

sword   OCIDefineByPos(OCIStmt* stmtp, OCIDefine** defnp, OCIError* errhp,
        ub4 position, void* valuep, sb4 value_sz, ub2 dty,
        void* indp, ub2* rlenp, ub2* rcodep, ub4 mode);

sword   OCIBindByPos(OCIStmt* stmtp, OCIBind** bindp, OCIError* errhp,
        ub4 position, void* valuep, sb4 value_sz,
        ub2 dty, void* indp, ub2* alenp, ub2* rcodep,
        ub4 maxarr_len, ub4* curelep, ub4 mode);

sword   OCIBindByName(OCIStmt* stmtp, OCIBind** bindp, OCIError* errhp,
        const OraText* placeholder, sb4 placeh_len,
        void* valuep, sb4 value_sz, ub2 dty,
        void* indp, ub2* alenp, ub2* rcodep,
        ub4 maxarr_len, ub4* curelep, ub4 mode);

sword   OCIStmtExecute(OCISvcCtx* svchp, OCIStmt* stmtp, OCIError* errhp,
        ub4 iters, ub4 rowoff, const OCISnapshot* snap_in,
        OCISnapshot* snap_out, ub4 mode);

sword   OCIStmtFetch(OCIStmt* stmtp, OCIError* errhp, ub4 nrows,
        ub2 orientation, ub4 mode);

sword   OCIStmtFetch2(OCIStmt* stmtp, OCIError* errhp, ub4 nrows,
        ub2 orientation, sb4 scrollOffset, ub4 mode);

sword   OCIStmtRelease(OCIStmt* stmtp, OCIError* errhp, const OraText* key,
        ub4 key_len, ub4 mode);

sword   OCILogon(OCIEnv* envhp, OCIError* errhp, OCISvcCtx** svchp,
        const OraText* username, ub4 uname_len,
        const OraText* password, ub4 passwd_len,
        const OraText* dbname, ub4 dbname_len);

sword   OCILogoff(OCISvcCtx* svchp, OCIError* errhp);

sword   OCITransStart(OCISvcCtx* svchp, OCIError* errhp,
        uword timeout, ub4 flags);

sword   OCITransCommit(OCISvcCtx* svchp, OCIError* errhp, ub4 flags);

sword   OCITransRollback(OCISvcCtx* svchp, OCIError* errhp, ub4 flags);

sword   OCITransDetach(OCISvcCtx* svchp, OCIError* errhp, ub4 flags);

sword	OCITerminate(ub4 mode);

sword   OCIDescriptorAlloc(const void* parenth, void** descpp,
        const ub4 type, const size_t xtramem_sz,
        void** usrmempp);

sword   OCIDescriptorFree(void* descp, ub4 type);

sword   OCILobRead(OCISvcCtx* svchp, OCIError* errhp, OCILobLocator* locp,
        ub4* amtp, ub4 offset, void* bufp, ub4 bufl, void* ctxp,
        OCICallbackLobRead cbfp, ub2 csid, ub1 csfrm);

sword   OCILobWrite(OCISvcCtx* svchp, OCIError* errhp, OCILobLocator* locp,
        ub4* amtp, ub4 offset, void* bufp, ub4 buflen,
        ub1 piece, void* ctxp, OCICallbackLobWrite cbfp,
        ub2 csid, ub1 csfrm);

sword   OCILobCreateTemporary(OCISvcCtx* svchp, OCIError* errhp,
        OCILobLocator* locp, ub2 csid, ub1 csfrm, ub1 lobtype,
        boolean cache, OCIDuration duration);

sword   OCIStmtSetPieceInfo(void* hndlp, ub4 type, OCIError* errhp,
        const void* bufp, ub4* alenp, ub1 piece,
        const void* indp, ub2* rcodep);

sword   OCIStmtGetPieceInfo(const OCIStmt* stmtp, OCIError* errhp,
        void** hndlpp, ub4* typep, ub1* in_outp, ub4* iterp,
        ub4* idxp, ub1* piecep);

sword   OCIServerVersion(void* hndlp, OCIError* errhp, OraText* bufp,
        ub4 bufsz,
        ub1 hndltype);

void    OCIDateGetDate(const OCIDate* date, sb2* year, ub1* month, ub1* day);

void    OCIDateGetTime(const OCIDate* date, ub1* hour, ub1* min, ub1* sec);

void    OCIDateSetDate(OCIDate* date, sb2 year, ub1 month, ub1 day);

void    OCIDateSetTime(OCIDate* date, ub1 hour, ub1 min, ub1 sec);

sword	OCIDateAddDays(OCIError* err, const OCIDate* date, sb4 num_days,
        OCIDate* result);

sword   OCIDateAddMonths(OCIError* err, const OCIDate* date, sb4 num_months, OCIDate* result);

sword   OCIDateAssign(OCIError* err, const OCIDate* from, OCIDate* to);

sword   OCIDateCompare(OCIError* err, const OCIDate* date1,
        const OCIDate* date2, sword* result);

sword   OCIDateLastDay(OCIError* err, const OCIDate* date,
        OCIDate* last_day);

sword   OCIDateSysDate(OCIError* err, OCIDate* sys_date);

sword   OCIDateToText(OCIError* err, const OCIDate* date,
        const oratext* fmt, ub1 fmt_length,
        const oratext* lang_name, ub4 lang_length,
        ub4* buf_size, oratext* buf);

#ifdef __cplusplus
}
#endif

#endif // !_OCI_H
