package xugusql

type xugusqlResult struct {

	// Returns the number of rows affected
	// by update, delete and other related operations
	affectedRows int64

	// Returns the GUID number of
	// the insert operation (not supported)
	insertId int64
}

// LastInsertId returns the integer generated by the database
// in response to a command. Typically this will be from an
// "auto increment" column when inserting a new row. Not all
// databases support this feature, and the syntax of such
// statements varies.
func (self *xugusqlResult) LastInsertId() (int64, error) {
	return self.insertId, nil
}

// RowsAffected returns the number of rows affected by an
// update, insert, or delete. Not every database or database
// driver may support this.
func (self *xugusqlResult) RowsAffected() (int64, error) {
	return self.affectedRows, nil
}
