/*
 * VERSION: 12.8.4
 * LAST MODIFIED TIME: 2025-03-11
 */
----Ա߰------------------
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_DBA 
IS
       PROCEDURE KILL_TRANS(NODEID INTEGER,TRANID BIGINT);
       PROCEDURE KILL_SESSION(NODEID INTEGER,SESSID INTEGER);
       PROCEDURE KILL_SESSION_TRANS(NODEID INTEGER,SESSID INTEGER);
END SYSDBA.DBMS_DBA;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_DBA 
IS
	PROCEDURE KILL_TRANS(NODEID INTEGER,TRANID BIGINT)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_KILL_TRANS";
        
	PROCEDURE KILL_SESSION(NODEID INTEGER,SESSID INTEGER)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_KILL_SESSION";
	
	PROCEDURE KILL_SESSION_TRANS(NODEID INTEGER,SESSID INTEGER)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_KILL_SESSION_TRANS";

END SYSDBA.DBMS_DBA;
/


/***********DBMS_OUTPUT*****************************/
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_OUTPUT 
IS
	PROCEDURE PUT_LINE(str VARCHAR);
END SYSDBA.DBMS_OUTPUT;
/

----
CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_OUTPUT 
IS
	
	PROCEDURE PUT_LINE(str VARCHAR)
	IS
	BEGIN
		send_msg(str);
	END;
	
END SYSDBA.DBMS_OUTPUT;
/

/***********DBMS_INFO(ڲѯϵͳϢ)***************/
----ͷ
CREATE PACKAGE SYSDBA.DBMS_INFO 
IS
	SUBTYPE  FileInfo IS RECORD(IS_DIR BOOLEAN,DB_PATH VARCHAR(256),OS_PATH VARCHAR(256));
	SUBTYPE  FInfoTab IS TABLE OF FileInfo;
	FUNCTION FILE_LIST(_dir VARCHAR) RETURN FInfoTab;
END SYSDBA.DBMS_INFO;
/

----
CREATE PACKAGE BODY SYSDBA.DBMS_INFO 
IS
	FUNCTION FILE_LIST(_dir VARCHAR) RETURN FInfoTab
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_FILE_LIST";
END SYSDBA.DBMS_INFO;
/


----԰------------------
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_TEST 
IS
	FUNCTION TEST_PING_PONG1(TARG_NID INTEGER,PACK_NUM INTEGER) RETURN INTEGER;
	FUNCTION TEST_PING_PONG2(TARG_NID INTEGER,PACK_SIZE INTEGER,PACK_NUM INTEGER) RETURN INTEGER;
	FUNCTION TEST_MSG_SEND1(TARG_NID INTEGER,PACK_SIZE INTEGER,PACK_NUM INTEGER) RETURN INTEGER;
	FUNCTION TEST_MSG_SEND2(TARG_NID INTEGER,PACK_SIZE INTEGER,PACK_NUM INTEGER) RETURN INTEGER;
	FUNCTION TEST_RPC_SEND(TARG_NID INTEGER,SEND_SIZE INTEGER) RETURN INTEGER;
END SYSDBA.DBMS_TEST ;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_TEST  
IS
	FUNCTION TEST_PING_PONG1(TARG_NID INTEGER,PACK_NUM INTEGER) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_TEST_PING_PONG1";

	FUNCTION TEST_PING_PONG2(TARG_NID INTEGER,PACK_SIZE INTEGER,PACK_NUM INTEGER) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_TEST_PING_PONG2";
	
	FUNCTION TEST_MSG_SEND1(TARG_NID INTEGER,PACK_SIZE INTEGER,PACK_NUM INTEGER) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_TEST_MSG_SEND1";
	
	FUNCTION TEST_MSG_SEND2(TARG_NID INTEGER,PACK_SIZE INTEGER,PACK_NUM INTEGER) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_TEST_MSG_SEND2";
	
	FUNCTION TEST_RPC_SEND(TARG_NID INTEGER,SEND_SIZE INTEGER) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_TEST_RPC_SEND";
END SYSDBA.DBMS_TEST ;
/

-----ͳϢð-------------
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_STAT
IS
	PROCEDURE SET_STAT_INFO(TABLE_NAME VARCHAR,FIELD_NAME VARCHAR,MAX_VAL VARCHAR,MIN_VAL VARCHAR,REPET_RATE DOUBLE,DISPERSION DOUBLE,NON_NULL_RATE DOUBLE DEFAULT 0.0);
	PROCEDURE ANALYZE_TABLE(TABLE_NAME VARCHAR,FIELD_NAME VARCHAR,SAMPLE_RATE INTEGER,HSITOGRAM_NUM INTEGER,AUTO_ADJUST BOOL DEFAULT TRUE,PARALLEL INTEGER DEFAULT 1);
        PROCEDURE SET_ANALYZE_SCHEME(TABLE_NAME VARCHAR,SCHE_NAME VARCHAR,ENABLE BOOL);
        PROCEDURE SET_ANALYZE_PARAM(TABLE_NAME VARCHAR,MODE TINYINT,THRESHOLD TINYINT,LEVEL TINYINT);
        PROCEDURE SET_ANALYZE_OPTIMIZE(TABLE_NAME VARCHAR,PERIOD SMALLINT,MODE TINYINT);
        PROCEDURE SET_ANALYZE_COLUMNS(TABLE_NAME VARCHAR,FIELD_NAME VARCHAR,STATUS TINYINT); 
        FUNCTION  GET_STAT_INFO(TABLE_NAME VARCHAR) RETURN VARCHAR;
END SYSDBA.DBMS_STAT ;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_STAT  
IS
	PROCEDURE SET_STAT_INFO(TABLE_NAME VARCHAR,FIELD_NAME VARCHAR, MAX_VAL VARCHAR,MIN_VAL VARCHAR,REPET_RATE DOUBLE,DISPERSION DOUBLE,NON_NULL_RATE DOUBLE DEFAULT 0.0)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_STAT_INFO";

	PROCEDURE ANALYZE_TABLE(TABLE_NAME VARCHAR,FIELD_NAME VARCHAR,SAMPLE_RATE INTEGER,HSITOGRAM_NUM INTEGER,AUTO_ADJUST BOOL DEFAULT TRUE,PARALLEL INTEGER DEFAULT 1)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_ANALYZE_TABLE";

        PROCEDURE SET_ANALYZE_SCHEME(TABLE_NAME VARCHAR,SCHE_NAME VARCHAR,ENABLE BOOL)
        IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_ANALYZE_SCHEME";

        PROCEDURE SET_ANALYZE_PARAM(TABLE_NAME VARCHAR,MODE TINYINT,THRESHOLD TINYINT,LEVEL TINYINT)
        IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_ANALYZE_PARAM";

        PROCEDURE SET_ANALYZE_OPTIMIZE(TABLE_NAME VARCHAR,PERIOD SMALLINT,OPTI_MODE TINYINT)
        IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_ANALYZE_OPTIMIZE";

        PROCEDURE SET_ANALYZE_COLUMNS(TABLE_NAME VARCHAR,FIELD_NAME VARCHAR,STATUS TINYINT)
        IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_ANALYZE_COLUMNS";

        FUNCTION  GET_STAT_INFO(TABLE_NAME VARCHAR) RETURN VARCHAR
        IS
	LANGUAGE  "C"
	NAME	  "BLDIN_GET_STAT_INFO";
	
END SYSDBA.DBMS_STAT ;
/

----ϵͳʹʽٵݣҪҪֶ-------
CREATE OR REPLACE  PACKAGE SYSDBA.DBMS_IMPORT
IS
  /* зָʽݵ */
  FUNCTION IMPORT_TABLE_FROM_TXT(TABLE_NAME VARCHAR,    /*  */
                                 MODE INTEGER,          /* ׷ģʽ 1:append 2:replace 쳣ֵappend*/
								 FLD_SEPARATOR VARCHAR, /* зֵַָ֧ */
								 REINDEX BOOL)          /* δʹ */
								 RETURN BIGINT;         /* ص */
  /* ָʾʽݵ */
  FUNCTION IMPORT_TABLE_FROM_NET(TABLE_NAME VARCHAR,    /*  */
                                 MODE INTEGER,          /* ׷ģʽ 1:append 2:replace 쳣ֵappend*/
								 REINDEX BOOL)          /* δʹ */
								 RETURN BIGINT;	        /* ص */
END SYSDBA.DBMS_TEST;
/

CREATE OR REPLACE  PACKAGE BODY SYSDBA.DBMS_IMPORT  
IS
	FUNCTION IMPORT_TABLE_FROM_TXT(TABLE_NAME VARCHAR,MODE INTEGER,FLD_SEPARATOR VARCHAR,REINDEX BOOL) RETURN BIGINT
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_IMPORT_TABLE_FROM_TXT";
	
	FUNCTION IMPORT_TABLE_FROM_NET(TABLE_NAME VARCHAR,MODE INTEGER,REINDEX BOOL) RETURN BIGINT
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_IMPORT_TABLE_FROM_NET";	
END SYSDBA.DBMS_IMPORT ;
/

/***********DBMS_SCHEDULER(ڲѯϵͳϢ)***************/
----ͷ
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_SCHEDULER 
AUTHID CURRENT_USER
IS
	 PROCEDURE CREATE_JOB (
	   job_name             IN VARCHAR2,
	   job_type             IN VARCHAR2,
	   job_action           IN VARCHAR2,
	   number_of_arguments  IN PLS_INTEGER              DEFAULT 0,
	   start_date           IN TIMESTAMP  							DEFAULT NULL,
	   repeat_interval      IN VARCHAR2                 DEFAULT NULL,
	   end_date             IN TIMESTAMP 								DEFAULT NULL,
	   job_class            IN VARCHAR2                 DEFAULT 'DEFAULT_JOB_CLASS',
	   enabled              IN BOOLEAN                  DEFAULT FALSE,
	   auto_drop            IN BOOLEAN                  DEFAULT TRUE,
	   comments             IN VARCHAR2                 DEFAULT NULL);

	 PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN VARCHAR2);

	 PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN TIMESTAMP);
                      
	 PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN PLS_INTEGER);
   	
	 PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN BOOLEAN);
   	
	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN VARCHAR2);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN VARCHAR2);
  
  PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN TINYINT);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN TINYINT); 
   
  PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN SMALLINT);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN SMALLINT); 

  PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN INTEGER);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN INTEGER);
	
PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN BIGINT);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN BIGINT);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN FLOAT);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN FLOAT);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN DOUBLE);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN DOUBLE);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN NUMERIC);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN NUMERIC);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN BOOLEAN); 

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN BOOLEAN);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN TIME);

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN TIME);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN DATE); 

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN DATE);

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN DATETIME); 

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN DATETIME);

	PROCEDURE RUN_JOB (
   job_name                IN VARCHAR2,
   use_current_session     IN BOOLEAN DEFAULT TRUE);

	PROCEDURE ENABLE (
  	name              		IN VARCHAR2);
	   
	PROCEDURE DISABLE (
  	name              		IN VARCHAR2,
   	force             		IN BOOLEAN DEFAULT FALSE);
  
  PROCEDURE DROP_JOB (
   job_name           		IN VARCHAR2,
   force              		IN BOOLEAN DEFAULT FALSE);
	
	FUNCTION  JOB_NEXT_RUNTIME(
	 job_name								IN VARCHAR2,
	 last_rt								IN DATETIME) RETURN DATETIME;

	FUNCTION  NEXT_RUNTIME(
	 repeat_interval 				IN VARCHAR2,
	 last_rt		IN DATETIME) RETURN DATETIME;
	 		 	   	 
END SYSDBA.DBMS_SCHEDULER;
/

----
CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_SCHEDULER 
IS
	 PROCEDURE CREATE_JOB (
	   job_name             IN VARCHAR2,
	   job_type             IN VARCHAR2,
	   job_action           IN VARCHAR2,
	   number_of_arguments  IN PLS_INTEGER              DEFAULT 0,
	   start_date           IN TIMESTAMP  							DEFAULT NULL,
	   repeat_interval      IN VARCHAR2                 DEFAULT NULL,
	   end_date             IN TIMESTAMP  							DEFAULT NULL,
	   job_class            IN VARCHAR2                 DEFAULT 'DEFAULT_JOB_CLASS',
	   enabled              IN BOOLEAN                  DEFAULT FALSE,
	   auto_drop            IN BOOLEAN                  DEFAULT TRUE,
	   comments             IN VARCHAR2                 DEFAULT NULL)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_CREATE_JOB";   

PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN VARCHAR2)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_SET_STR_ATTRIBUTE";   

PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN TIMESTAMP)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_SET_DT_ATTRIBUTE";   
                      
PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN PLS_INTEGER)
 IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_SET_I4_ATTRIBUTE";   
  	
PROCEDURE SET_ATTRIBUTE (
   	name           IN VARCHAR2,
   	attribute      IN VARCHAR2,
   	value          IN BOOLEAN)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_SET_BOOL_ATTRIBUTE";   

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN VARCHAR2)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_STR_ARG_BY_ORD";   
   	
PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN VARCHAR2)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_STR_ARG_BY_NAME";   

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN INTEGER)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I4_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN INTEGER)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I4_ARG_BY_NAME";  
	
	
PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN TINYINT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I1_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN TINYINT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I1_ARG_BY_NAME";  	
	
PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN SMALLINT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I2_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN SMALLINT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I2_ARG_BY_NAME";  		
	
	
PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN BIGINT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I8_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN BIGINT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_I8_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN FLOAT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_R4_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN FLOAT)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_R4_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN DOUBLE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_R8_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN DOUBLE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_R8_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN NUMERIC)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_NUM_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN NUMERIC)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_NUM_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN BOOLEAN)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_BOOL_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN BOOLEAN)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_BOOL_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN TIME)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_TIME_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN TIME)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_TIME_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN DATE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_DATE_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN DATE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_DATE_ARG_BY_NAME";  

PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_position      IN PLS_INTEGER,
   argument_value         IN DATETIME)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_DT_ARG_BY_ORD";   

	PROCEDURE SET_JOB_ARGUMENT_VALUE (
   job_name               IN VARCHAR2,
   argument_name          IN VARCHAR2,
   argument_value         IN DATETIME)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_SET_JOB_DT_ARG_BY_NAME";  

	PROCEDURE RUN_JOB (
   job_name                IN VARCHAR2,
   use_current_session     IN BOOLEAN DEFAULT TRUE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RUN_JOB";   
  	
	PROCEDURE ENABLE (
  	name              		IN VARCHAR2)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_ENABLE_JOB";   
  	
	   
	PROCEDURE DISABLE (
  	name              		IN VARCHAR2,
   	force             		IN BOOLEAN DEFAULT FALSE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_DISABLE_JOB";
  
  PROCEDURE DROP_JOB (
   job_name           		IN VARCHAR2,
   force              		IN BOOLEAN DEFAULT FALSE)
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_DROP_JOB";

	FUNCTION  JOB_NEXT_RUNTIME(
	 job_name								IN VARCHAR2,
	 last_rt								IN DATETIME) RETURN DATETIME
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_GET_JOB_NEXT_RUNTIME";	 

	FUNCTION  NEXT_RUNTIME(
	 repeat_interval 				IN VARCHAR2,
	 last_rt								IN DATETIME) RETURN DATETIME
IS
	LANGUAGE  "C"
	NAME	  "BLDIN_GET_NEXT_RUNTIME";
	   
END SYSDBA.DBMS_SCHEDULER;
/

/**************DBMS_SQL********************/
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_SQL
AUTHID CURRENT_USER
IS
	  --Ϣṹ 
	SUBTYPE	 TParaInfo IS RECORD(ParaName VARCHAR(128),	--
		 			ParaNo    INTEGER, 		--
		 			ParaTid   INTEGER,		--ID
		 			ParaScale INTEGER,		--ȱ
		 			BindState INTEGER);	 	--״̬(0:δ 1:Ѱ)	
	SUBTYPE	 TParams  IS TABLE OF TParaInfo;
	--ֶϢṹ
	SUBTYPE	 TResInfo IS  RECORD(ResName VARCHAR(128),	--ֶ
		 			ResTid   INTEGER,		--ֶ
		 			ResScale INTEGER,		--ȱ
		 			ResFlag  INTEGER,		--ӱ־
		 			TargTid INTEGER,		--ձID
		 			TargScale INTEGER);		--ձ;ȱ
	SUBTYPE	 TResults IS TABLE OF TResInfo;
	--αṹ
	SUBTYPE  TCursor IS RECORD(StmtState  INTEGER,		--ǰ״̬
	   				StmtType INTEGER,		--parseص
	   				StmtSQL VARCHAR(2000),		--SQL
	   				ObjPtr VARCHAR(20),		--ڲ(ϵͳʹ)
	   				ParaInfos TParams,		--
	   				ResInfos TResults);	 	--
	SUBTYPE  CursorVarr IS VARRAY(100) OF TCursor;
	--
	NATIVE			      INTEGER :=1;
	   				      
	TYPE_BOOL			  INTEGER :=2;
	TYPE_I1			      INTEGER :=3;
	TYPE_I2			      INTEGER :=4;
	TYPE_I4			      INTEGER :=5;
	TYPE_I8			      INTEGER :=6;
	TYPE_NUMERIC	      INTEGER :=7;
	TYPE_R4			      INTEGER :=8;
	TYPE_R8			      INTEGER :=9;	   
	TYPE_DATE		      INTEGER :=10;
	TYPE_TIME		      INTEGER :=11;
	TYPE_TIMEZ		      INTEGER :=12;
	TYPE_DATETIME	      INTEGER :=13;
	TYPE_DATETIMEZ        INTEGER :=14;
	TYPE_INTERVAL_Y		  INTEGER :=15;
	TYPE_INTERVAL_Y2M	  INTEGER :=16;
	TYPE_INTERVAL_M		  INTEGER :=17;
	TYPE_INTERVAL_D		  INTEGER :=18;
	TYPE_INTERVAL_D2H     INTEGER :=19;
	TYPE_INTERVAL_H		  INTEGER :=20;
	TYPE_INTERVAL_D2M	  INTEGER :=21;
	TYPE_INTERVAL_H2M	  INTEGER :=22;
	TYPE_INTERVAL_MI	  INTEGER :=23;
	TYPE_INTERVAL_D2S	  INTEGER :=24;
	TYPE_INTERVAL_H2S	  INTEGER :=25;
	TYPE_INTERVAL_M2S	  INTEGER :=26;
	TYPE_INTERVAL_S		  INTEGER :=27;
	TYPE_ROWVER			  INTEGER :=28;
	TYPE_GUID			  INTEGER :=29;
	TYPE_STR		      INTEGER :=30;
	TYPE_CHAR		      INTEGER :=30;
	TYPE_VARCHAR	      INTEGER :=30;
	TYPE_CLOB		      INTEGER :=32;
	TYPE_BINARY		      INTEGER :=33;
	TYPE_BLOB	  	      INTEGER :=34;
	TYPE_ROWID	  	      INTEGER :=45;
	TYPE_I4ARR	  	      INTEGER :=10005;
	
	--SQL״̬
	STMT_STATE_OPENED      INTEGER := 1;
	STMT_STATE_PARSED      INTEGER := 2;
	STMT_STATE_BINDED      INTEGER := 3;
	STMT_STATE_DEFINED     INTEGER := 4;
	STMT_STATE_EXCUTED     INTEGER := 5;
	STMT_STATE_FETCHED     INTEGER := 6;

	--α 																
	Cursors	  CursorVarr;
	   
	FUNCTION  STROF_CURSOR(CurNo INTEGER) RETURN VARCHAR(5000);
	FUNCTION  OPEN_CURSOR() RETURN INTEGER;		 
	FUNCTION  IS_OPEN(c IN INTEGER) RETURN BOOLEAN;
	FUNCTION  PARSE(CurNo INTEGER,StmtSQL VARCHAR,SqlType INTEGER) RETURN INTEGER;
	FUNCTION  EXECUTE(CurNo INTEGER) RETURN INTEGER;
	FUNCTION  FETCH_ROWS(CurNo INTEGER) RETURN INTEGER;
	FUNCTION  CLOSE_CURSOR(CurNo INTEGER) RETURN INTEGER;

	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BOOLEAN) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val TINYINT) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val SMALLINT) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTEGER) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BIGINT) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val FLOAT) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DOUBLE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val NUMERIC) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val VARCHAR) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val CLOB) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BLOB) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val TIME) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val TIME WITH TIME ZONE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DATE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DATETIME) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DATETIME WITH TIME ZONE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL YEAR) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL YEAR TO MONTH) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL MONTH) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY TO HOUR) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL HOUR) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY TO MINUTE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL HOUR TO MINUTE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL MINUTE) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY TO SECOND) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL HOUR TO SECOND) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL MINUTE TO SECOND) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL SECOND) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val GUID) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BINARY) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val ROWID) RETURN INTEGER;
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTEGER[]) RETURN INTEGER;
		 
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BOOLEAN) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT TINYINT) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT SMALLINT) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BIGINT) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT FLOAT) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DOUBLE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT NUMERIC) RETURN INTEGER;	
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT VARCHAR) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT CLOB) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BLOB) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME WITH TIME ZONE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DATE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME WITH TIME ZONE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR TO MONTH) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MONTH) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO HOUR) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO MINUTE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO MINUTE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO SECOND) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO SECOND) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE TO SECOND) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL SECOND) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT GUID) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BINARY) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT ROWID) RETURN INTEGER;
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER[]) RETURN INTEGER;

	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BOOLEAN) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT TINYINT) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT SMALLINT) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BIGINT) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT FLOAT)  RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DOUBLE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT NUMERIC) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT VARCHAR) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT CLOB) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BLOB) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME WITH TIME ZONE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DATE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME WITH TIME ZONE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR TO MONTH) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MONTH) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO HOUR) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO MINUTE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO MINUTE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO SECOND) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO SECOND) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE TO SECOND) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL SECOND) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT GUID) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BINARY) RETURN INTEGER;
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT ROWID) RETURN INTEGER;
    FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER[]) RETURN INTEGER;
END  SYSDBA.DBMS_SQL;
/

/**************DBMS_SQL********************/
CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_SQL
IS

	FUNCTION	BLDIN_PARSE(sql_str VARCHAR,sys_obj OUT VARCHAR,paras_info OUT TParams,targs_info OUT TResults) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_PARSE";

	FUNCTION 	BLDIN_EXECUTE(ObjName VARCHAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_EXECUTE";
		
	FUNCTION 	BLDIN_FETCH_ROWS (ObjName VARCHAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_FETCH";

	FUNCTION	BLDIN_CLOSE_CURSOR(Cur VARCHAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_CLOSE_STMT";

	FUNCTION	BLDIN_PARA_NAME_CMP(sor_name VARCHAR,targ_name VARCHAR) RETURN BOOLEAN
		IS	LANGUAGE  "C"  NAME  "BLDIN_PARA_NAME_CMP";
		
	FUNCTION	BLDIN_BIND_BOOL(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val BOOLEAN) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_BOOL(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val BOOLEAN) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_I1(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val TINYINT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_I1(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val TINYINT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
		
	FUNCTION	BLDIN_BIND_I2(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val SMALLINT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_I2(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val SMALLINT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
				
	FUNCTION	BLDIN_BIND_I4(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTEGER) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_I4(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTEGER) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
			
	FUNCTION	BLDIN_BIND_I8(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val BIGINT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";	

	FUNCTION	BLDIN_NAME_BIND_I8(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val BIGINT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";	
	
	FUNCTION	BLDIN_BIND_R4(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val FLOAT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
		
	FUNCTION	BLDIN_NAME_BIND_R4(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val FLOAT) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_R8(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val DOUBLE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_R8(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val DOUBLE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_Str(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val VARCHAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_Str(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val VARCHAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_CLOB(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val CLOB) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";		
		
	FUNCTION	BLDIN_NAME_BIND_CLOB(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val CLOB) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_BLOB(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val BLOB) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_BLOB(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val BLOB) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_T(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val TIME) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_T(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val TIME) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
		
	FUNCTION	BLDIN_BIND_TZ(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val TIME WITH TIME ZONE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_TZ(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val TIME WITH TIME ZONE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_D(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val DATE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_D(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val DATE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_DT(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val DATETIME) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_DT(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val DATETIME) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_DTZ(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val DATETIME WITH TIME ZONE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_DTZ(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val DATETIME WITH TIME ZONE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IY(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL YEAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_IY(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL YEAR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IY2M(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL YEAR TO MONTH) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IY2M(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL YEAR TO MONTH) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IM(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL MONTH) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IM(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL MONTH) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_ID(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL DAY) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_ID(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL DAY) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_ID2H(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL DAY TO HOUR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_ID2H(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL DAY TO HOUR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IH(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL HOUR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IH(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL HOUR) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_ID2M(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL DAY TO MINUTE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_ID2M(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL DAY TO MINUTE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IH2M(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL HOUR TO MINUTE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IH2M(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL HOUR TO MINUTE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IMI(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL MINUTE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IMI(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL MINUTE) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_ID2S(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL DAY TO SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_ID2S(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL DAY TO SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IH2S(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL HOUR TO SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IH2S(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL HOUR TO SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IM2S(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL MINUTE TO SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IM2S(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL MINUTE TO SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_IS(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTERVAL SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_IS(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTERVAL SECOND) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_N(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val NUMERIC) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";

	FUNCTION	BLDIN_NAME_BIND_N(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val NUMERIC) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_GUID(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val GUID) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_GUID(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val GUID) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_BINARY(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val BINARY) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_BINARY(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val BINARY) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";
	
	FUNCTION	BLDIN_BIND_ROWID(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val ROWID) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
	
	FUNCTION	BLDIN_NAME_BIND_ROWID(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val ROWID) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION	BLDIN_BIND_I4ARR(obj_name VARCHAR,para_no INTEGER,para_tid INTEGER,para_val INTEGER[]) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND";
		
	FUNCTION	BLDIN_NAME_BIND_I4ARR(obj_name VARCHAR,para_name VARCHAR,para_tid INTEGER,para_val INTEGER[]) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_BIND_BY_NAME";

	FUNCTION 	BLDIN_DEFINE_COLUMN (ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_DEFINE_COLUMN";

	FUNCTION 	BLDIN_COLUMN_VALUE_BOOL(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN BOOLEAN
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";
	
	FUNCTION 	BLDIN_COLUMN_VALUE_I1(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN TINYINT
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_I2(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN SMALLINT
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_I4(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTEGER
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_I8(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN BIGINT
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_R4(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN FLOAT
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_R8(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN DOUBLE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_N(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN NUMERIC
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_STR(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN VARCHAR
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_CLOB(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN CLOB
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_BLOB(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN BLOB
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_T(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN TIME
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_TZ(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN TIME WITH TIME ZONE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_D(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN DATE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_DT(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN DATETIME
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_DTZ(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN DATETIME WITH TIME ZONE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IY(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL YEAR
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IY2M(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL YEAR TO MONTH
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IM(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL MONTH
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_ID(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL DAY
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_ID2H(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL DAY TO HOUR
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IH(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL HOUR
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_ID2M(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL DAY TO MINUTE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IH2M(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL HOUR TO MINUTE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IMI(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL MINUTE
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_ID2S(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL DAY TO SECOND
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IH2S(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL HOUR TO SECOND
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IM2S(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL MINUTE TO SECOND
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_IS(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTERVAL SECOND
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_GUID(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN GUID
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_BINARY(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN BINARY
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_ROWID(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN ROWID
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	FUNCTION 	BLDIN_COLUMN_VALUE_I4ARR(ObjName VARCHAR,ColNo INTEGER,var_tid INTEGER,var_scale INTEGER) RETURN INTEGER[]
		IS	LANGUAGE  "C"  NAME  "BLDIN_GET";

	/******************ŷΧ***********/ 
	FUNCTION CHECK_CURNO_RANGE(CurNo INTEGER) RETURN INTEGER
		IS
		BEGIN
			IF (CurNo ISNULL OR CurNo<1 OR CurNo>100) THEN
				RAISE_APPLICATION_ERROR(-1002,'αŴ');	
				RETURN -1;
			END IF;
		END;
	/*****************************/ 
	FUNCTION CHECK_CURNO_EXIST(CurNo INTEGER) RETURN INTEGER
		IS
		BEGIN
			IF cursors(CurNo).StmtState ISNULL THEN
				RAISE_APPLICATION_ERROR(-1003,'Ϊ'||CurNo||'α겻');	
				RETURN -1;
			ENDIF;
		END;
	/******************״̬***********/ 
	FUNCTION CHECK_CURNO_STATE(CurNo INTEGER,STATE INTEGER) RETURN INTEGER
		IS
		BEGIN
			IF STATE = STMT_STATE_PARSED AND cursors(CurNo).StmtState < STMT_STATE_PARSED THEN
				RAISE_APPLICATION_ERROR(-1005,'Ϊ'||CurNo||'αδparse׶');	
				RETURN -1;
			ELSIF STATE = STMT_STATE_EXCUTED AND cursors(CurNo).StmtState < STMT_STATE_EXCUTED THEN
				RAISE_APPLICATION_ERROR(-1005,'Ϊ'||CurNo||'αδexecute׶');	
				RETURN -1;
			ELSIF STATE = STMT_STATE_FETCHED AND cursors(CurNo).StmtState < STMT_STATE_FETCHED THEN
				RAISE_APPLICATION_ERROR(-1005,'Ϊ'||CurNo||'αδfetch׶');	
				RETURN -1;
			ENDIF;
		END;
	/********************************/ 
	FUNCTION CHECK_CURNO(CurNo INTEGER,STATE INTEGER) RETURN INTEGER
		IS
		BEGIN
			--ŷΧ
			CHECK_CURNO_RANGE(CurNo);
			--
			CHECK_CURNO_EXIST(CurNo);
			--״̬
			CHECK_CURNO_STATE(CurNo,STATE);
		END;
	/******************ŷΧʹ**************/ 
	FUNCTION CHECK_CURNO_RANGE_AND_EXIST(CurNo INTEGER) RETURN INTEGER
		IS
		BEGIN
			--ŷΧ
			CHECK_CURNO_RANGE(CurNo);
			--
			CHECK_CURNO_EXIST(CurNo);
		END;

	/******************ǷѰ**************/ 
	FUNCTION CHECK_PARA_BIND_STATE(Paras TParams) RETURN INTEGER
		IS
			para		TParaInfo;
		BEGIN
			--вǷѰ
			IF(Paras NOTNULL AND Paras.count>0) THEN
				FOR i IN 1 .. Paras.COUNT LOOP
					para:=Paras(i);
					if(para ISNULL OR  para.BindState=0) THEN
						RAISE_APPLICATION_ERROR(-1006, ''||para.ParaName||'δ');
					ENDIF;
				END FOR;
			ENDIF;
		END;

	/******************ð󶨲İ״̬°󶨲**************/ 
	FUNCTION SET_BIND_PARA_INFO(Paras IN OUT TParams,ParaName VARCHAR,ParaTid INTEGER) RETURN INTEGER
		IS
			para_no		INTEGER;
		BEGIN
			--жӦĲǰλ°󶨵Ĳ͡
			IF(Paras NOTNULL AND Paras.count>0) THEN
				para_no:=0;
				FOR i IN 1 .. Paras.COUNT LOOP
					if(Paras(i) NOTNULL AND (BLDIN_PARA_NAME_CMP(Paras(i).ParaName,ParaName) OR BLDIN_PARA_NAME_CMP(Paras(i).ParaName,(':'||ParaName)))) THEN
						Paras(i).BindState:=1;
						Paras(i).ParaTid:=ParaTid;
						para_no:=i;
						EXIT;
					ENDIF;
				END FOR;
				IF(para_no=0) THEN
					RAISE_APPLICATION_ERROR(-1007,'󶨲'||ParaName||'');
				ENDIF;
			ENDIF;
		END;


	/******************ɱΪCurNoCursorıϢ,ֵ֧***********/ 		
	FUNCTION STROF_CURSOR(CurNo INTEGER) RETURN VARCHAR(5000)
		IS
			cur 		TCursor;
			str 		VARCHAR(5000);
			para		TParaInfo;
			targ		TResInfo;
		BEGIN
			--ŷΧ
			CHECK_CURNO_RANGE(CurNo);
			--
			CHECK_CURNO_EXIST(CurNo);
			cur:=cursors(CurNo);
			--״̬,ڲַ,SQL
			str:='Cursor{' || NEWLINE || '       state=' || cur.StmtState || '  ' || 'ObjPtr=' || cur.ObjPtr 
				|| NEWLINE || '       SQL=' || cur.StmtSQL || NEWLINE;	
			--Ϣ
			IF(cur.ParaInfos NOTNULL AND cur.ParaInfos.count>0) THEN
				str:=str || '       Paras[' || NEWLINE;
				FOR i IN 1 .. cur.ParaInfos.COUNT LOOP
					para:=cur.ParaInfos(i);
					str:=str || '             (' || para.ParaName || ' ' || para.ParaNo || ' ' || para.ParaTid 
						 || ' ' || para.ParaScale || ')' || NEWLINE;
				END FOR;
				str:=str || '            ]' || NEWLINE;	 
			ENDIF;
			--ֶϢ		
			IF(cur.ResInfos NOTNULL AND cur.ResInfos.count>0) THEN
				str:=str || '       Targets[' || NEWLINE;
				FOR i IN 1 .. cur.ResInfos.COUNT LOOP
					targ:=cur.ResInfos(i);
					str:=str || '              (' || targ.ResName || ' ' || targ.ResTid || ' ' || targ.ResScale 
						 || ' ' || targ.ResFlag || ')'||NEWLINE;
				END FOR;
				str:=str || '              ]' || NEWLINE;	 
			ENDIF;
			--ؽ	
			RETURN str;				 	
		END;
	
	/*****************һα(һα,α)**************/
	FUNCTION  OPEN_CURSOR() RETURN INTEGER
		 IS
		 i	INTEGER;
		 BEGIN
		 	/*ҳֵ,ڴcursor*/
		 	FOR i IN 1...100 LOOP
		 		IF (Cursors(i).StmtState ISNULL) THEN
		 			Cursors(i).StmtState := STMT_STATE_OPENED;
		 			RETURN i;
		 		END IF;
		 	END FOR;
		 	RAISE_APPLICATION_ERROR(-1001,'α̫(100)');	
		 	RETURN -1;
		 END;

	/*****************رһα*****************************/
	FUNCTION  CLOSE_CURSOR(CurNo INTEGER) RETURN INTEGER
		IS
		BEGIN
			--ŷΧ
			CHECK_CURNO_RANGE(CurNo);
			--
			CHECK_CURNO_EXIST(CurNo);
			--ڲرں˶
			IF (cursors(CurNo).ObjPtr NOTNULL) THEN
				BLDIN_CLOSE_CURSOR(cursors(CurNo).ObjPtr);
			ENDIF;
			cursors(CurNo).StmtState := NULL;
			cursors(CurNo).StmtSQL   := NULL;
	   		cursors(CurNo).ObjPtr    := NULL;
	   		cursors(CurNo).ParaInfos := NULL;
	   		cursors(CurNo).ResInfos  := NULL;
			RETURN 1;
		END;	
	
	/*****************һαǷڿ״̬***************************/
	FUNCTION  IS_OPEN(CurNo IN INTEGER) RETURN BOOLEAN
		IS
		BEGIN
			--ŷΧ
			CHECK_CURNO_RANGE(CurNo);
			--	 
			IF (cursors(CurNo).StmtState IS NULL) THEN
				RETURN FALSE;
			ELSE
				RETURN TRUE;
			END IF;
		END;	
		
	/********************ΪCursorһSQL,*****************/		
	FUNCTION  PARSE(CurNo INTEGER,SqlStr VARCHAR,SqlType INTEGER) RETURN INTEGER
		IS
			cur	TCursor;
		BEGIN
			--ŷΧ
			CHECK_CURNO_RANGE(CurNo);
			--
			CHECK_CURNO_EXIST(CurNo);
			--SQL
			cursors(CurNo).StmtSQL:=SqlStr;
			--ںִ滮
			cursors(CurNo).StmtType := BLDIN_PARSE(SqlStr,cursors(CurNo).ObjPtr,cursors(CurNo).ParaInfos,cursors(CurNo).ResInfos);
			--޸cursor״̬
			IF(cursors(CurNo).StmtType>0) THEN
				cursors(CurNo).StmtState := STMT_STATE_PARSED;	--ʾѷ,δ󶨱
			ELSE
				RAISE_APPLICATION_ERROR(-1004,'δ֪SQL');
			END IF;
			--
			RETURN cursors(CurNo).StmtType;		
		END;
	
	/**************ִα*************/	
	FUNCTION  EXECUTE(CurNo INTEGER) RETURN INTEGER
		IS
			cur_name VARCHAR;
			ret      INTEGER;
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			CHECK_PARA_BIND_STATE(cursors(CurNo).ParaInfos);
			ret := BLDIN_EXECUTE(cursors(CurNo).ObjPtr);
			cursors(CurNo).StmtState := STMT_STATE_EXCUTED;
			RETURN ret;
		END;
			
	/****************ǰץȡһ*************/		
	FUNCTION 	FETCH_ROWS(CurNo INTEGER) RETURN INTEGER
		IS
			ret      INTEGER;
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_EXCUTED);
			ret := BLDIN_FETCH_ROWS(cursors(CurNo).ObjPtr);
			cursors(CurNo).StmtState := STMT_STATE_FETCHED;
			RETURN ret;
		END;
	
	/*********************BOOLEANͲ**********************/	
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BOOLEAN) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_BOOL);
			RETURN BLDIN_NAME_BIND_BOOL(cursors(CurNo).ObjPtr,col_name,TYPE_BOOL,Val);	
		END;

	/*********************TinyintͲ**********************/	
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val TINYINT) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_I1);
			RETURN BLDIN_NAME_BIND_I1(cursors(CurNo).ObjPtr,col_name,TYPE_I1,Val);	
		END;
	
	/*********************SmallIntͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val SMALLINT) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_I2);
			RETURN BLDIN_NAME_BIND_I2(cursors(CurNo).ObjPtr,col_name,TYPE_I2,Val);	
		END;
			
	/*********************IntegerͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTEGER) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_I4);
			RETURN BLDIN_NAME_BIND_I4(cursors(CurNo).ObjPtr,col_name,TYPE_I4,Val);
		END;
	
	/*********************BigIntͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BIGINT) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_I8);
			RETURN BLDIN_NAME_BIND_I8(cursors(CurNo).ObjPtr,col_name,TYPE_I8,Val);
		END;

	/*********************FloatͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val Float) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_R4);
			RETURN BLDIN_NAME_BIND_R4(cursors(CurNo).ObjPtr,col_name,TYPE_R4,Val);
		END;

	/*********************DoubleͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DOUBLE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_R8);
			RETURN BLDIN_NAME_BIND_R8(cursors(CurNo).ObjPtr,col_name,TYPE_R8,Val);		
		END;

	/*********************NumericͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val NUMERIC) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_NUMERIC);
			RETURN BLDIN_NAME_BIND_N(cursors(CurNo).ObjPtr,col_name,TYPE_NUMERIC,Val);	
		END;

	/*********************CLOBͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val CLOB) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_CLOB);
			RETURN BLDIN_NAME_BIND_CLOB(cursors(CurNo).ObjPtr,col_name,TYPE_CLOB,Val);		
		END;

	/*********************BLOBͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BLOB) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_BLOB);
			RETURN BLDIN_NAME_BIND_BLOB(cursors(CurNo).ObjPtr,col_name,TYPE_BLOB,Val);
		END;
		
	/*********************VARCHARͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val VARCHAR) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_VARCHAR);
			RETURN BLDIN_NAME_BIND_STR(cursors(CurNo).ObjPtr,col_name,TYPE_VARCHAR,Val);
		END;

	/*********************TimeͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val TIME) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_TIME);
			RETURN BLDIN_NAME_BIND_T(cursors(CurNo).ObjPtr,col_name,TYPE_TIME,Val);		
		END;

	/********************* TIME WITH TIME ZONE Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val TIME WITH TIME ZONE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_TIMEZ);
			RETURN BLDIN_NAME_BIND_TZ(cursors(CurNo).ObjPtr,col_name,TYPE_TIMEZ,Val);		
		END;

	/*********************DateͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DATE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_DATE);
			RETURN BLDIN_NAME_BIND_D(cursors(CurNo).ObjPtr,col_name,TYPE_DATE,Val);	
		END;

	/*********************DateTimeͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DATETIME) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_DATETIME);
			RETURN BLDIN_NAME_BIND_DT(cursors(CurNo).ObjPtr,col_name,TYPE_DATETIME,Val);	
		END;

	/*********************DATETIME WITH TIME ZONEͲ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val DATETIME WITH TIME ZONE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_DATETIMEZ);
			RETURN BLDIN_NAME_BIND_DTZ(cursors(CurNo).ObjPtr,col_name,TYPE_DATETIMEZ,Val);	
		END;

	/********************* INTERVAL YEAR Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL YEAR) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_Y);
			RETURN BLDIN_NAME_BIND_IY(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_Y,Val);	
		END;
	
	/********************* INTERVAL YEAR TO MONTH Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL YEAR TO MONTH) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_Y2M);
			RETURN BLDIN_NAME_BIND_IY2M(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_Y2M,Val);	
		END;

	/********************* INTERVAL MONTH Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL MONTH) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_M);
			RETURN BLDIN_NAME_BIND_IM(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_M,Val);	
		END;

	/********************* INTERVAL DAY Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_D);
			RETURN BLDIN_NAME_BIND_ID(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_D,Val);	
		END;

	/********************* INTERVAL DAY TO HOUR Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY TO HOUR) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_D2H);
			RETURN BLDIN_NAME_BIND_ID2H(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_D2H,Val);	
		END;

	/********************* INTERVAL HOUR Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL HOUR) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_H);
			RETURN BLDIN_NAME_BIND_IH(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_H,Val);	
		END;
	
	/********************* INTERVAL DAY TO MINUTE Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY TO MINUTE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_D2M);
			RETURN BLDIN_NAME_BIND_ID2M(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_D2M,Val);	
		END;
	
	/********************* INTERVAL HOUR TO MINUTE Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL HOUR TO MINUTE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_H2M);
			RETURN BLDIN_NAME_BIND_IH2M(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_H2M,Val);	
		END;
		
	/********************* INTERVAL MINUTE Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL MINUTE) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_MI);
			RETURN BLDIN_NAME_BIND_IMI(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_MI,Val);	
		END;
	
	/********************* INTERVAL DAY TO SECOND Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL DAY TO SECOND) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_D2S);
			RETURN BLDIN_NAME_BIND_ID2S(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_D2S,Val);	
		END;
	
	/********************* INTERVAL HOUR TO SECOND Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL HOUR TO SECOND) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_H2S);
			RETURN BLDIN_NAME_BIND_IH2S(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_H2S,Val);	
		END;
		
	/********************* INTERVAL MINUTE TO SECOND Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL MINUTE TO SECOND) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_M2S);
			RETURN BLDIN_NAME_BIND_IM2S(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_M2S,Val);	
		END;
	
	/********************* INTERVAL SECOND Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTERVAL SECOND) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_INTERVAL_S);
			RETURN BLDIN_NAME_BIND_IS(cursors(CurNo).ObjPtr,col_name,TYPE_INTERVAL_S,Val);	
		END;
	
	/********************* GUID Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val GUID) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_GUID);
			RETURN BLDIN_NAME_BIND_GUID(cursors(CurNo).ObjPtr,col_name,TYPE_GUID,Val);	
		END;
	
	/********************* BINARY Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val BINARY) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_BINARY);
			RETURN BLDIN_NAME_BIND_BINARY(cursors(CurNo).ObjPtr,col_name,TYPE_BINARY,Val);	
		END;
	
	/********************* ROWID Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val ROWID) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,TYPE_ROWID);
			RETURN BLDIN_NAME_BIND_ROWID(cursors(CurNo).ObjPtr,col_name,TYPE_ROWID,Val);	
		END;

	/********************* I4ARR Ͳ**********************/			
	FUNCTION  BIND_VARIABLE(CurNo INTEGER,ColName VARCHAR,Val INTEGER[]) RETURN INTEGER
		IS
			col_name VARCHAR:=UPPER(ColName);
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_PARSED);
			SET_BIND_PARA_INFO(cursors(CurNo).ParaInfos,col_name,(TYPE_I4ARR));
			RETURN BLDIN_NAME_BIND_I4ARR(cursors(CurNo).ObjPtr,col_name,(TYPE_I4ARR),Val);	
		END;
	
	/***********Boolean***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BOOLEAN) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_BOOL,-1);
		END;
	
	/***********TinyInt***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT TINYINT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_I1,-1);
		END;
	
	/***********SmallInt***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT SMALLINT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_I2,-1);
		END;

	/***********Integer***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_I4,-1);
		END;

	/***********Bigint***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BIGINT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_I8,-1);
		END;

	/***********Float***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT FLOAT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_R4,-1);
		END;

	/***********Double***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DOUBLE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_R8,-1);
		END;

	/***********NUMERIC***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT NUMERIC) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_NUMERIC,-1);
		END;

	/***********Char***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT CHAR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_STR,-1);
		END;

	/***********Varchar***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT VARCHAR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_STR,-1);
		END;

	/***********CLOB***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT CLOB) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_CLOB,-1);
		END;

	/***********BLOB***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BLOB) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_BLOB,-1);
		END;

	/***********TIME***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_TIME,-1);
		END;

	/***********TIME WITH TIME ZONE ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME WITH TIME ZONE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_TIMEZ,-1);
		END;

	/***********Date***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DATE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_DATE,-1);
		END;

	/***********Datetime***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_DATETIME,-1);
		END;

	/***********DATETIME WITH TIME ZONE***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME WITH TIME ZONE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_DATETIMEZ,-1);
		END;
	
	/*********** INTERVAL YEAR ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_Y,-1);
		END;
	
	/*********** INTERVAL YEAR TO MONTH ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR TO MONTH) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_Y2M,-1);
		END;
	
	/*********** INTERVAL MONTH ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MONTH) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_M,-1);
		END;
	
	/*********** INTERVAL DAY ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D,-1);
		END;
	
	/*********** INTERVAL DAY TO HOUR ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO HOUR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D2H,-1);
		END;
	
	/*********** INTERVAL HOUR ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_H,-1);
		END;
	
	/*********** INTERVAL DAY TO MINUTE ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO MINUTE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D2M,-1);
		END;
	
	/*********** INTERVAL HOUR TO MINUTE ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO MINUTE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_H2M,-1);
		END;
	
	/*********** INTERVAL MINUTE ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_MI,-1);
		END;
	
	/*********** INTERVAL DAY TO SECOND ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D2S,-1);
		END;
	
	/*********** INTERVAL HOUR TO SECOND ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_H2S,-1);
		END;
	
	/*********** INTERVAL MINUTE TO SECOND ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE TO SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_M2S,-1);
		END;
	
	/*********** INTERVAL SECOND ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_S,-1);
		END;
	
	/*********** GUID ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT GUID) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_GUID,-1);
		END;
	
	/*********** BINARY ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT BINARY) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_BINARY,-1);
		END;
	
	/*********** ROWID ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT ROWID) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,TYPE_ROWID,-1);
		END;

	/*********** I4ARR ***********/
	FUNCTION  DEFINE_COLUMN(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER[]) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			RETURN BLDIN_DEFINE_COLUMN(cursors(CurNo).ObjPtr,ColNo,(TYPE_I4ARR),-1);
		END;
	
	/***********ȡBOOLEANֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BOOLEAN) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_BOOL(cursors(CurNo).ObjPtr,ColNo,TYPE_BOOL,-1);
			RETURN 1;
		END;

	/***********ȡTinyIntֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT TINYINT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_I1(cursors(CurNo).ObjPtr,ColNo,TYPE_I1,-1);
			RETURN 1;
		END;

	/***********ȡSmallIntֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT SMALLINT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_I2(cursors(CurNo).ObjPtr,ColNo,TYPE_I2,-1);
			RETURN 1;
		END;
	
	/***********ȡIntegerֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_I4(cursors(CurNo).ObjPtr,ColNo,TYPE_I4,-1);
			RETURN 1;
		END;
	
	/***********ȡBigIntֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BIGINT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_I8(cursors(CurNo).ObjPtr,ColNo,TYPE_I8,-1);
			RETURN 1;
		END;

	/***********ȡFloatֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT FLOAT) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_R4(cursors(CurNo).ObjPtr,ColNo,TYPE_R4,-1);
			RETURN 1;
		END;

	/***********ȡDOUBLEֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DOUBLE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_R8(cursors(CurNo).ObjPtr,ColNo,TYPE_R8,-1);
			RETURN 1;
		END;

	/***********ȡNumericֵֶ***************/	
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT NUMERIC) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_N(cursors(CurNo).ObjPtr,ColNo,TYPE_NUMERIC,-1);
			RETURN 1;
		END;

	/***********ȡCharֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT CHAR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_STR(cursors(CurNo).ObjPtr,ColNo,TYPE_STR,-1);
			RETURN 1;
		END;

	/***********ȡVarcharֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT VARCHAR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_STR(cursors(CurNo).ObjPtr,ColNo,TYPE_STR,-1);
			RETURN 1;
		END;

	/***********ȡCLOBֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT CLOB) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_CLOB(cursors(CurNo).ObjPtr,ColNo,TYPE_CLOB,-1);
			RETURN 1;
		END;

	/***********ȡBLOBֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BLOB) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_BLOB(cursors(CurNo).ObjPtr,ColNo,TYPE_BLOB,-1);
			RETURN 1;
		END;
	/***********ȡTIMEֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_T(cursors(CurNo).ObjPtr,ColNo,TYPE_TIME,-1);
			RETURN 1;
		END;

	/***********ȡTIME WITH TIME ZONEֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT TIME WITH TIME ZONE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_TZ(cursors(CurNo).ObjPtr,ColNo,TYPE_TIMEZ,-1);
			RETURN 1;
		END;

	/***********ȡDATEֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DATE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_D(cursors(CurNo).ObjPtr,ColNo,TYPE_DATE,-1);
			RETURN 1;
		END;

	/***********ȡDateTimeֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_DT(cursors(CurNo).ObjPtr,ColNo,TYPE_DATETIME,-1);
			RETURN 1;
		END;

	/***********ȡDATETIME WITH TIME ZONEֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT DATETIME WITH TIME ZONE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_DTZ(cursors(CurNo).ObjPtr,ColNo,TYPE_DATETIMEZ,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL YEAR ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IY(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_Y,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL YEAR TO MONTH ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL YEAR TO MONTH) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IY2M(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_Y2M,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL MONTHֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MONTH) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IM(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_M,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL DAY ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_ID(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL DAY TO HOUR ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO HOUR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_ID2H(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D2H,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL HOUR ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IH(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_H,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL DAY TO MINUTE ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO MINUTE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_ID2M(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D2M,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL HOUR TO MINUTE ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO MINUTE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IH2M(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_H2M,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL MINUTE ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IMI(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_MI,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL DAY TO SECOND ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL DAY TO SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_ID2S(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_D2S,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL HOUR TO SECONDֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL HOUR TO SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO(CurNo,STMT_STATE_FETCHED);
			Var:= BLDIN_COLUMN_VALUE_IH2S(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_H2S,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL MINUTE TO SECONDֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL MINUTE TO SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			Var:= BLDIN_COLUMN_VALUE_IM2S(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_M2S,-1);
			RETURN 1;
		END;
	
	/***********ȡ INTERVAL SECONDֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTERVAL SECOND) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			Var:= BLDIN_COLUMN_VALUE_IS(cursors(CurNo).ObjPtr,ColNo,TYPE_INTERVAL_S,-1);
			RETURN 1;
		END;
	
	/***********ȡ GUIDֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT GUID) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			Var:= BLDIN_COLUMN_VALUE_GUID(cursors(CurNo).ObjPtr,ColNo,TYPE_GUID,-1);
			RETURN 1;
		END;
	
	/***********ȡ BINARY ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT BINARY) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			Var:= BLDIN_COLUMN_VALUE_BINARY(cursors(CurNo).ObjPtr,ColNo,TYPE_BINARY,-1);
			RETURN 1;
		END;
	
	/***********ȡ ROWID ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT ROWID) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			Var:= BLDIN_COLUMN_VALUE_ROWID(cursors(CurNo).ObjPtr,ColNo,TYPE_ROWID,-1);
			RETURN 1;
		END;

	/***********ȡ I4ARR ֵֶ***************/		
	FUNCTION  COLUMN_VALUE(CurNo INTEGER,ColNo INTEGER,Var  OUT INTEGER[]) RETURN INTEGER
		IS
		BEGIN
			--
			CHECK_CURNO_RANGE_AND_EXIST(CurNo);
			Var:= BLDIN_COLUMN_VALUE_I4ARR(cursors(CurNo).ObjPtr,ColNo,(TYPE_I4ARR),-1);
			RETURN 1;
		END;
	
BEGIN
	Cursors.extend(100);	
END  SYSDBA.DBMS_SQL;
/

/*************CTX_DOC******************************/
CREATE OR REPLACE PACKAGE  "SYSDBA"."CTX_DOC"
AUTHID CURRENT_USER
COMMENT 'ȫļְ֧'  
IS
	SUBTYPE TOKEN_REC  IS RECORD(TOKEN VARCHAR(64),OFFSET INTEGER,LENGTH INTEGER);
	SUBTYPE TOKEN_REC2 IS RECORD(TOKEN VARCHAR(64),REPET_N INTEGER,LENGTH INTEGER);
	SUBTYPE TOKEN_TAB  IS TABLE OF TOKEN_REC;
	SUBTYPE TOKEN_TAB2 IS TABLE OF TOKEN_REC2;
	
	SP_MAX_LEN		CONSTANT INTEGER := 0;	--ʻ
	SP_MIN_LEN		CONSTANT INTEGER := 1;	--̴ʻ
	SP_SUB_WORD1	CONSTANT INTEGER := 2;	--ʵӴ
	SP_SUB_WORD2	CONSTANT INTEGER := 4;	--зͷӴ
	SP_ASCII	    CONSTANT INTEGER := 8;	--ascii
	SP_DIGIT	    CONSTANT INTEGER := 16; --ִ
	
	SPILIT_POLICY INTEGER:= 0;	--MAX_LEN
	VOCA_NAME VARCHAR(20):='STD_VOC';
	KEY_TYPE  VARCHAR(10):='PRIMARY';
	
	PROCEDURE SET_KEY_TYPE(key_type  IN VARCHAR2);  --ü
	PROCEDURE SET_SPLIT_POLICY(_policy  IN INTEGER);--÷ִʲ
	PROCEDURE TOKENS(index_name      IN VARCHAR2,		
                   textkey         IN VARCHAR2,
                   restab          IN OUT TOKEN_TAB);
  PROCEDURE TOKENS(index_name      IN VARCHAR2,
                   textkey         IN VARCHAR2,
                   restab          IN VARCHAR2,
                   query_id        IN NUMBER DEFAULT 0);
  PROCEDURE TOKENS(content         IN VARCHAR2,
                   restab          IN OUT TOKEN_TAB);
  PROCEDURE TOKENS(content         IN CLOB,
                   restab          IN OUT TOKEN_TAB);
               
	PROCEDURE TOKENS2(index_name     IN VARCHAR2,
                    textkey        IN VARCHAR2,
                    restab         IN OUT TOKEN_TAB);
  PROCEDURE TOKENS2(index_name     IN VARCHAR2,
                    textkey        IN VARCHAR2,
                    restab         IN VARCHAR2,
                    query_id       IN NUMBER DEFAULT 0);
  PROCEDURE TOKENS2(content        IN VARCHAR2,
                    restab         IN OUT TOKEN_TAB);
  PROCEDURE TOKENS2(content        IN CLOB,
                    restab         IN OUT TOKEN_TAB);
END  "SYSDBA"."CTX_DOC";
/

/*************CTX_DOC******************************/
CREATE OR REPLACE PACKAGE BODY "SYSDBA"."CTX_DOC"
IS
	
	PROCEDURE SET_KEY_TYPE(_key_type  IN VARCHAR2)
	IS
	BEGIN
		key_type:=_key_type;
	END;
	
	
	PROCEDURE SET_SPLIT_POLICY(_policy  IN INTEGER)
	IS
	BEGIN
		SPILIT_POLICY:=_policy;
	END;
	
	PROCEDURE BLDIN_TOKENS(
	                 voca_name       IN VARCHAR2,    
	                 content         IN VARCHAR,
                   restab          IN OUT TOKEN_TAB,
                   sp_policy	     IN INTEGER)
  IS  LANGUAGE "C" NAME  "BLDIN_TOKENS1";

	PROCEDURE BLDIN_TOKENS2(
	                 voca_name       IN VARCHAR2,    
	                 content         IN VARCHAR,
                   restab          IN OUT TOKEN_TAB,
                   sp_policy	     IN INTEGER)
  IS  LANGUAGE "C" NAME  "BLDIN_TOKENS2";
  
  PROCEDURE TOKENS(index_name      IN VARCHAR2,
                   textkey         IN VARCHAR2,
                   restab          IN OUT TOKEN_TAB)
  IS
  BEGIN
  	NULL;
  END;
    
  PROCEDURE TOKENS(index_name      IN VARCHAR2,
                   textkey         IN VARCHAR2,
                   restab          IN VARCHAR2,
                   query_id        IN NUMBER DEFAULT 0)
  IS
  BEGIN
  	NULL;
  END;
  
  PROCEDURE TOKENS(content         IN VARCHAR2,
                   restab          IN OUT TOKEN_TAB)
  IS
  BEGIN
   	BLDIN_TOKENS(voca_name,content,restab,SPILIT_POLICY);
  END;
  
  PROCEDURE TOKENS(content         IN CLOB,
                   restab          IN OUT TOKEN_TAB)
  IS
  BEGIN
   	BLDIN_TOKENS(voca_name,content,restab,SPILIT_POLICY);
  END;
               
	PROCEDURE TOKENS2(index_name     IN VARCHAR2,
                    textkey        IN VARCHAR2,
                    restab         IN OUT TOKEN_TAB)
  IS
  BEGIN
   	NULL;
  END;
  
  PROCEDURE TOKENS2(index_name     IN VARCHAR2,
                    textkey        IN VARCHAR2,
                    restab         IN VARCHAR2,
                    query_id       IN NUMBER DEFAULT 0)
  IS
  BEGIN
   	NULL;
  END;
             
  PROCEDURE TOKENS2(content        IN VARCHAR2,
                   restab          IN OUT TOKEN_TAB)
  IS
  BEGIN
  	BLDIN_TOKENS2(voca_name,content,restab,SPILIT_POLICY);
  END;                 
                             
  PROCEDURE TOKENS2(content        IN CLOB,
                    restab         IN OUT TOKEN_TAB)
  IS
  BEGIN
  	BLDIN_TOKENS2(voca_name,content,restab,SPILIT_POLICY);
  END;
  
END  "SYSDBA"."CTX_DOC";
/

/***********DBMS_LOB(ִ֧)***************/
----ͷ
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_LOB 
IS
	FUNCTION  GETLENGTH(lob_loc BLOB) RETURN INTEGER;
	FUNCTION  GETLENGTH(lob_loc CLOB) RETURN INTEGER;
	PROCEDURE READ(lob_loc BLOB,AMOUNT INTEGER,OFFSET INTEGER, OUT_BUFF OUT VARCHAR);
	PROCEDURE READ(lob_loc CLOB,AMOUNT INTEGER,OFFSET INTEGER, OUT_BUFF OUT VARCHAR);
END SYSDBA.DBMS_LOB;
/

----
CREATE PACKAGE BODY SYSDBA.DBMS_LOB 
IS
	FUNCTION  GETLENGTH(lob_loc BLOB) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_BLOB_GETLENGTH";
	
	FUNCTION  GETLENGTH(lob_loc CLOB) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_CLOB_GETLENGTH";
	
	PROCEDURE READ(lob_loc BLOB,AMOUNT INTEGER,OFFSET INTEGER, OUT_BUFF OUT VARCHAR)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_BLOB_READ";

	PROCEDURE READ(lob_loc CLOB,AMOUNT INTEGER,OFFSET INTEGER, OUT_BUFF OUT VARCHAR)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_CLOB_READ";
	
END SYSDBA.DBMS_LOB;
/

-----UTL_RAW--------------------
CREATE PACKAGE SYSDBA.UTL_RAW
IS    
       big_endian     CONSTANT PLS_INTEGER := 1;
       little_endian  CONSTANT PLS_INTEGER := 2;
       machine_endian CONSTANT PLS_INTEGER := 3;  
       FUNCTION BIT_AND (r1 IN RAW, r2 IN RAW) RETURN RAW;
       FUNCTION BIT_COMPLEMENT (r1 IN RAW, r2 IN RAW) RETURN RAW;
       FUNCTION BIT_OR (r1 IN RAW, r2 IN RAW) RETURN RAW;
       FUNCTION BIT_XOR (r1 IN RAW, r2 IN RAW) RETURN RAW;
       FUNCTION CAST_FROM_BINARY_DOUBLE (n IN BINARY_DOUBLE, endianess IN BINARY_INTEGER DEFAULT 1) RETURN RAW;
       FUNCTION CAST_FROM_BINARY_FLOAT (n IN BINARY_FLOAT, endianess IN BINARY_INTEGER DEFAULT 1) RETURN RAW;
       FUNCTION CAST_FROM_BINARY_INTEGER (n IN BINARY_INTEGER, endianess IN BINARY_INTEGER DEFAULT 1) RETURN RAW;
       FUNCTION CAST_FROM_NUMBER (n  IN NUMBER) RETURN RAW;
       FUNCTION CAST_TO_BINARY_DOUBLE (r IN RAW,endianess IN BINARY_INTEGER DEFAULT 1) RETURN BINARY_DOUBLE;
       FUNCTION CAST_TO_BINARY_FLOAT (r IN RAW, endianess IN BINARY_INTEGER DEFAULT 1) RETURN BINARY_FLOAT;
       FUNCTION CAST_TO_BINARY_INTEGER (r IN RAW, endianess IN BINARY_INTEGER DEFAULT 1) RETURN BINARY_INTEGER;
       FUNCTION CAST_TO_NUMBER (r IN RAW) RETURN NUMBER;
       FUNCTION CAST_TO_NVARCHAR2 (r IN RAW) RETURN NVARCHAR2;
       FUNCTION CAST_TO_RAW (c IN VARCHAR2) RETURN RAW;
       FUNCTION CAST_TO_VARCHAR2 (r IN RAW) RETURN VARCHAR2;
       FUNCTION COMPARE (r1 IN RAW,r2 IN RAW,pad IN RAW DEFAULT NULL) RETURN INTEGER;
       FUNCTION CONCAT (r1  IN RAW DEFAULT NULL,
			  r2  IN RAW DEFAULT NULL,
   			r3  IN RAW DEFAULT NULL,
   			r4  IN RAW DEFAULT NULL,
   			r5  IN RAW DEFAULT NULL,
   			r6  IN RAW DEFAULT NULL,
   			r7  IN RAW DEFAULT NULL,
   			r8  IN RAW DEFAULT NULL,
   			r9  IN RAW DEFAULT NULL,
   			r10 IN RAW DEFAULT NULL,
   			r11 IN RAW DEFAULT NULL,
   			r12 IN RAW DEFAULT NULL) 
  			RETURN RAW;
       FUNCTION CONVERT(r IN RAW,to_charset IN VARCHAR2,from_charset IN VARCHAR2) RETURN RAW;
       FUNCTION COPIES (r IN RAW,n IN INTEGER) RETURN RAW;
       FUNCTION LENGTH (r IN RAW) RETURN INTEGER;
       FUNCTION OVERLAY(overlay_str IN RAW,target IN RAW,
			pos IN BINARY_INTEGER DEFAULT 1,
			len IN BINARY_INTEGER DEFAULT NULL,
   			pad IN RAW DEFAULT NULL) 
  			RETURN RAW;
       FUNCTION REVERSE (r IN RAW) RETURN RAW;
       FUNCTION SUBSTR (r IN RAW,pos IN BINARY_INTEGER,len IN BINARY_INTEGER DEFAULT NULL) RETURN RAW;
       FUNCTION TRANSLATE (r IN RAW,from_set IN RAW,to_set IN RAW) RETURN RAW;
       FUNCTION TRANSLITERATE (r IN RAW,to_set IN RAW DEFAULT NULL,from_set IN RAW DEFAULT NULL,pad IN RAW DEFAULT NULL) RETURN RAW;
       FUNCTION XRANGE (start_byte IN RAW DEFAULT NULL,end_byte IN RAW DEFAULT NULL) RETURN RAW;
END SYSDBA.UTL_RAW;
/

CREATE PACKAGE BODY SYSDBA.UTL_RAW
IS    
       FUNCTION BIT_AND (r1 IN RAW, r2 IN RAW) RETURN RAW 
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_BIT_AND";

       FUNCTION BIT_COMPLEMENT (r1 IN RAW, r2 IN RAW) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_COMPLEMENT";

       FUNCTION BIT_OR (r1 IN RAW, r2 IN RAW) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_BIT_OR";

       FUNCTION BIT_XOR (r1 IN RAW, r2 IN RAW) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_BIT_XOR";

       FUNCTION CAST_FROM_BINARY_DOUBLE (n IN BINARY_DOUBLE, endianess IN BINARY_INTEGER DEFAULT 1) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_DOUBLE2RAW";

       FUNCTION CAST_FROM_BINARY_FLOAT (n IN BINARY_FLOAT, endianess IN BINARY_INTEGER DEFAULT 1) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_FLOAT2RAW";

       FUNCTION CAST_FROM_BINARY_INTEGER (n IN BINARY_INTEGER, endianess IN BINARY_INTEGER DEFAULT 1) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_INTEGER2RAW";

       FUNCTION CAST_FROM_NUMBER (n  IN NUMBER) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_NUMERIC2RAW";

       FUNCTION CAST_TO_BINARY_DOUBLE (r IN RAW,endianess IN BINARY_INTEGER DEFAULT 1) RETURN BINARY_DOUBLE
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW2DOUBLE";

       FUNCTION CAST_TO_BINARY_FLOAT (r IN RAW, endianess IN BINARY_INTEGER DEFAULT 1) RETURN BINARY_FLOAT
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW2FLOAT";

       FUNCTION CAST_TO_BINARY_INTEGER (r IN RAW, endianess IN BINARY_INTEGER DEFAULT 1) RETURN BINARY_INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW2INTEGER";

       FUNCTION CAST_TO_NUMBER (r IN RAW) RETURN NUMBER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW2NUMERIC";

       FUNCTION CAST_TO_NVARCHAR2 (r IN RAW) RETURN NVARCHAR2
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW2NVARCHAR2";

       FUNCTION CAST_TO_RAW (c IN VARCHAR2) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	 "BLDIN_VARCHAR22RAW";

       FUNCTION CAST_TO_VARCHAR2 (r IN RAW) RETURN VARCHAR2
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW2VARCHAE2";

       FUNCTION COMPARE (r1 IN RAW,r2 IN RAW,pad IN RAW DEFAULT NULL) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_COMPARE";

       FUNCTION CONCAT (r1  IN RAW DEFAULT NULL,
			  r2  IN RAW DEFAULT NULL,
   			r3  IN RAW DEFAULT NULL,
   			r4  IN RAW DEFAULT NULL,
   			r5  IN RAW DEFAULT NULL,
   			r6  IN RAW DEFAULT NULL,
   			r7  IN RAW DEFAULT NULL,
   			r8  IN RAW DEFAULT NULL,
   			r9  IN RAW DEFAULT NULL,
   			r10 IN RAW DEFAULT NULL,
   			r11 IN RAW DEFAULT NULL,
   			r12 IN RAW DEFAULT NULL) 
  			RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_CONCAT";

       FUNCTION CONVERT(r IN RAW,to_charset IN VARCHAR2,from_charset IN VARCHAR2) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_CONVERT";

       FUNCTION COPIES (r IN RAW,n IN INTEGER) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_COPYS";

       FUNCTION LENGTH (r IN RAW) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_LENGTH";

       FUNCTION OVERLAY(overlay_str IN RAW,target IN RAW,
			pos IN BINARY_INTEGER DEFAULT 1,
			len IN BINARY_INTEGER DEFAULT NULL,
   			pad IN RAW DEFAULT NULL) 
  			RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_OVERLAY";

       FUNCTION REVERSE (r IN RAW) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_REVERSE";

       FUNCTION SUBSTR (r IN RAW,pos IN BINARY_INTEGER,len IN BINARY_INTEGER DEFAULT NULL) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_SUBSTR";

       FUNCTION TRANSLATE (r IN RAW,from_set IN RAW,to_set IN RAW) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_TRANSLATE";

       FUNCTION TRANSLITERATE (r IN RAW,to_set IN RAW DEFAULT NULL,from_set IN RAW DEFAULT NULL,pad IN RAW DEFAULT NULL) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_TRANSLITERATE";

       FUNCTION XRANGE (start_byte IN RAW DEFAULT NULL,end_byte IN RAW DEFAULT NULL) RETURN RAW
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_RAW_XRANGE";

END SYSDBA.UTL_RAW;
/




CREATE OR REPLACE PACKAGE SYSDBA.DBMS_REPLICATION
IS    
  PROCEDURE CREATE_MODIFY_SOURCE(SCHEMA_NAME VARCHAR,TABLE_NAME VARCHAR);
  PROCEDURE DROP_MODIFY_SOURCE(SCHEMA_NAME VARCHAR,TABLE_NAME VARCHAR);
 
  PROCEDURE CREATE_SUBSCRIBER(SUBSCRIBER_NAME VARCHAR,USEER_NAME VARCHAR);
  PROCEDURE DROP_SUBSCRIBER(SUBSCRIBER_NAME VARCHAR,USEER_NAME VARCHAR);
  PROCEDURE SWITCH_FILE();
  PROCEDURE POLL_MODIFY_DATA(SUBSCRIBER_NAME VARCHAR,PARTI_NO INTEGER,FILTER VARCHAR,POLL_LEN BIGINT,KEEP_POS BOOLEAN,FNO INTEGER DEFAULT -1,FPOS BIGINT DEFAULT 0,RET_TYPE INTEGER DEFAULT 0);
  PROCEDURE DUMP_TABLE( TABLE_NAME VARCHAR,					--
						FILTER VARCHAR,						--where (дwhereؼ)
						PATH VARCHAR,						-- INSERT SQL ݿļ(NULLʱļ)
						IS_SEND BOOLEAN DEFAULT false,		-- Ƿ INSERT SQLĽ ؿͻ
						IS_DUMP_META BOOLEAN DEFAULT false);-- ǷǰDDL
END SYSDBA.DBMS_REPLICATION;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_REPLICATION
IS
    
  PROCEDURE CREATE_MODIFY_SOURCE(SCHEMA_NAME VARCHAR,TABLE_NAME VARCHAR)
  IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_CREATE_MODIFY_SOURCE";

  PROCEDURE DROP_MODIFY_SOURCE(SCHEMA_NAME VARCHAR,TABLE_NAME VARCHAR)
  IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_DROP_MODIFY_SOURCE";
 
  PROCEDURE CREATE_SUBSCRIBER(SUBSCRIBER_NAME VARCHAR,USEER_NAME VARCHAR)
  IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_CREATE_SUBSCRIBER";

  PROCEDURE DROP_SUBSCRIBER(SUBSCRIBER_NAME VARCHAR,USEER_NAME VARCHAR)
  IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_DROP_SUBSCRIBER";
  
  PROCEDURE SWITCH_FILE()
  IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_SWITCH_FILE";

  PROCEDURE POLL_MODIFY_DATA(SUBSCRIBER_NAME VARCHAR,PARTI_NO INTEGER,FILTER VARCHAR,POLL_LEN BIGINT,KEEP_POS BOOLEAN,FNO INTEGER DEFAULT -1,FPOS BIGINT DEFAULT 0,RET_TYPE INTEGER DEFAULT 0)
  IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_POLL_MODIFY_DATA";
  
  PROCEDURE DUMP_TABLE(TABLE_NAME VARCHAR,FILTER VARCHAR,PATH VARCHAR,IS_SEND BOOLEAN DEFAULT false,IS_DUMP_META BOOLEAN DEFAULT false)
	IS 
  LANGUAGE  "C"
  NAME	  "BLDIN_DUMP_TABLE";
  
END SYSDBA.DBMS_REPLICATION;
/


CREATE OR REPLACE PACKAGE SYSDBA.DBMS_CRYPTO IS
    -- hash㷨
    HASH_MD4  INTEGER :=     1;
    HASH_MD5  INTEGER :=     2;
    HASH_SH1  INTEGER :=     3;

    -- Ϣ֤hashʽ
    HMAC_MD5  INTEGER :=     1;
    HMAC_SH1  INTEGER :=     2;

    -- 㷨
    ENCRYPT_DES        INTEGER :=     1;  -- 0x0001
    ENCRYPT_3DES_2KEY  INTEGER :=     2;  -- 0x0002
    ENCRYPT_3DES       INTEGER :=     3;  -- 0x0003
    ENCRYPT_AES        INTEGER :=     4;  -- 0x0004
    ENCRYPT_PBE_MD5DES INTEGER :=     5;  -- 0x0005
    ENCRYPT_AES128     INTEGER :=     6;  -- 0x0006
    ENCRYPT_AES192     INTEGER :=     7;  -- 0x0007
    ENCRYPT_AES256     INTEGER :=     8;  -- 0x0008

    -- ģʽ
    CHAIN_CBC INTEGER :=   256;  -- 0x0100
    CHAIN_CFB INTEGER :=   512;  -- 0x0200
    CHAIN_ECB INTEGER :=   768;  -- 0x0300
    CHAIN_OFB INTEGER :=  1024;  -- 0x0400

    -- ䷽ʽ
    PAD_PKCS5 INTEGER :=  4096;  -- 0x1000
    PAD_NONE  INTEGER :=  8192;  -- 0x2000
    PAD_ZERO  INTEGER := 12288;  -- 0x3000
    PAD_SELF  INTEGER := 16384;  -- 0x4000

    -- 㷨
    ENCRYPT_RC4        INTEGER :=   129;  -- 0x0081
    
    -- ü׼
    DES_CBC_PKCS5      INTEGER := ENCRYPT_DES+ CHAIN_CBC+ PAD_PKCS5;
    DES3_CBC_PKCS5     INTEGER := ENCRYPT_3DES+ CHAIN_CBC+ PAD_PKCS5;
    AES_CBC_PKCS5      INTEGER := ENCRYPT_AES+ CHAIN_CBC+ PAD_PKCS5;
		--ܽӿ
    FUNCTION  Encrypt (src IN RAW,typ IN INTEGER, key IN RAW,iv IN RAW DEFAULT NULL) RETURN RAW;
    FUNCTION  Encrypt (src IN VARCHAR,typ IN INTEGER, key IN VARCHAR,iv IN VARCHAR DEFAULT NULL) RETURN RAW;
    
    PROCEDURE Encrypt (dst IN OUT BLOB,src IN BLOB,typ IN INTEGER,key IN RAW,iv IN RAW DEFAULT NULL);
    PROCEDURE Encrypt (dst IN OUT BLOB,src IN CLOB ,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL);
		--ܽӿ
    FUNCTION  Decrypt (src IN RAW,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL)RETURN RAW;
    FUNCTION  Decrypt (src IN RAW,typ IN INTEGER,key IN VARCHAR,iv  IN VARCHAR DEFAULT NULL)RETURN VARCHAR;
    
    PROCEDURE Decrypt (dst IN OUT BLOB,src IN BLOB,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL);
    PROCEDURE Decrypt (dst IN OUT CLOB,src IN BLOB,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL);

		--hash ӿ
    FUNCTION Hash (src IN RAW,typ IN INTEGER)RETURN RAW ;
    FUNCTION Hash (src IN BLOB,typ IN INTEGER)RETURN RAW ;
    FUNCTION Hash (src IN CLOB,typ IN INTEGER)RETURN RAW ;

		--Ϣ֤
    FUNCTION Mac (src IN RAW,typ IN INTEGER,key IN RAW)RETURN RAW;
    FUNCTION Mac (src IN BLOB,typ IN INTEGER,key IN RAW)RETURN RAW;
    FUNCTION Mac (src IN CLOB,typ IN INTEGER,key IN RAW)RETURN RAW;

		--
    FUNCTION RandomBytes (number_bytes IN INTEGER) RETURN RAW;
    FUNCTION RandomNumber RETURN NUMBER;
    FUNCTION RandomInteger RETURN INTEGER;

END SYSDBA.DBMS_CRYPTO;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_CRYPTO IS
		FUNCTION  Encrypt (src IN VARCHAR,typ IN INTEGER, key IN VARCHAR,iv IN VARCHAR DEFAULT NULL) RETURN RAW
		IS
		LANGUAGE "C"
		NAME			"BLDIN_ENCRYPT1";
		
		FUNCTION  Decrypt (src IN RAW,typ IN INTEGER,key IN VARCHAR,iv  IN VARCHAR DEFAULT NULL) RETURN VARCHAR
		IS
		LANGUAGE "C"
		NAME			"BLDIN_DECRYPT1";

		FUNCTION  Encrypt (src IN RAW,typ IN INTEGER, key IN RAW,iv IN RAW DEFAULT NULL) RETURN RAW
		IS
		LANGUAGE "C"
		NAME			"BLDIN_ENCRYPT1";
		
		FUNCTION  Decrypt (src IN RAW,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL) RETURN RAW
		IS
		LANGUAGE "C"
		NAME			"BLDIN_DECRYPT1";

		PROCEDURE Encrypt (dst IN OUT BLOB,src IN BLOB,typ IN INTEGER,key IN RAW,iv IN RAW DEFAULT NULL)
		IS
		LANGUAGE "C"
		NAME            "BLDIN_ENCRYPT_LOB";

		PROCEDURE Decrypt (dst IN OUT BLOB,src IN BLOB,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL)
		IS
		LANGUAGE "C"
		NAME            "BLDIN_DECRYPT_LOB";

		PROCEDURE Encrypt (dst IN OUT BLOB,src IN CLOB ,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL)
		IS
		LANGUAGE "C"
		NAME            "BLDIN_ENCRYPT_LOB";

		PROCEDURE Decrypt (dst IN OUT CLOB,src IN BLOB,typ IN INTEGER,key IN RAW,iv  IN RAW DEFAULT NULL)
		IS
		LANGUAGE "C"
		NAME            "BLDIN_DECRYPT_LOB";
		
		FUNCTION Hash (src IN RAW, typ IN INTEGER)RETURN RAW
		IS
		LANGUAGE "C"
		NAME            "BLDIN_RAW_HASH";

		FUNCTION Hash (src IN BLOB,typ IN INTEGER)RETURN RAW
		IS
		LANGUAGE "C"
		NAME            "BLDIN_LOB_HASH";

		FUNCTION Hash (src IN CLOB,typ IN INTEGER)RETURN RAW
		IS
		LANGUAGE "C"
		NAME            "BLDIN_LOB_HASH";

		FUNCTION Mac (src IN RAW, typ IN INTEGER, key IN RAW) RETURN RAW
		IS
		LANGUAGE "C"
		NAME            "BLDIN_RAW_HMAC";

		FUNCTION Mac (src IN BLOB, typ IN INTEGER, key IN RAW) RETURN RAW
		IS
		LANGUAGE "C"
		NAME            "BLDIN_LOB_HMAC";

		FUNCTION Mac (src IN CLOB, typ IN INTEGER, key IN RAW) RETURN RAW
		IS
		LANGUAGE "C"
		NAME            "BLDIN_LOB_HMAC";

		FUNCTION  RandomBytes (number_bytes IN INTEGER) RETURN RAW
		IS
		LANGUAGE "C"
		NAME			"BLDIN_RANDOM_BYTES";

		FUNCTION  RandomNumber RETURN NUMBER
		IS
		LANGUAGE "C"
		NAME			"BLDIN_RANDOM_NUMBER";

		FUNCTION  RandomInteger RETURN INTEGER
		IS
		LANGUAGE "C"
		NAME			"BLDIN_RANDOM_INTEGER";

END SYSDBA.DBMS_CRYPTO;
/

CREATE OR REPLACE PACKAGE  "SYSDBA"."DBMS_BACKUP"
COMMENT 'Ӧó'  
IS
  /**
    :
    planname	ݼƻ
    plantype 	 ϵͳݣBAKor ߼ݣEXP
    path		 	ļ·ʱַֻ֧·ֱ֧ͻ
    starttime	ƻʼʱ
    period		ƻִڣΪλ
  **/
	PROCEDURE  Create_Plan(planname VARCHAR, plantype VARCHAR, path VARCHAR, starttime DATETIME, period INTERVAL DAY TO MINUTE);
	
	/**
    :
    planname	ݼƻ
    ena 			true̬false̬ϵͳҽһƻΪ̬
  **/
	PROCEDURE  Enable_Plan(planname VARCHAR, ena BOOLEAN);	
		
	/**
    :
    planname	ݼƻƣɾ̬ƻɾʱͬʱɾƻĿ
  **/
	PROCEDURE  Drop_Plan(planname VARCHAR); 
	
	/**
		ϵͳݣBAKӿ,ȫʽ
    :
    planname		ݼƻ
    filename 		ļ
    time_offset	ڼƻʼʱʱƫƣΪλܳƻ
    iperiod			ƻִڣΪλ,ȫʱ˲ΪNULL
  **/
	PROCEDURE  Add_Backup_Item(planname	VARCHAR,filename VARCHAR, time_offset INTERVAL DAY TO MINUTE);
	PROCEDURE  Add_Backup_Inc_Item(planname	VARCHAR,time_offset INTERVAL DAY TO MINUTE,iperiod INTERVAL DAY TO MINUTE DEFAULT NULL);
	
	/**
		߼ݣEXPӿ,⼶ͱ
    :
    planname		ݼƻ
    obj_name		
    obj_type		ݶ ȡֵDATABASE,TABLE)
    filename 		ļ·Ϣ
    time_offset	ڼƻʼʱʱƫƣΪλܳƻ
  **/
	PROCEDURE  Add_Export_Item(planname VARCHAR,obj_name VARCHAR, obj_type	VARCHAR, filename VARCHAR,time_offset INTERVAL DAY TO MINUTE);
	
	/**
		ļӽӿ
    :
    planname		ݼƻ
    filename 		ļ·Ϣ
    bak_count		ļ
    optype			ļʽDELETEMOVE
    dstpath			MOVE ǵĿ·
  **/
	PROCEDURE  Add_File_Item(planname VARCHAR,filename VARCHAR, bak_count INTEGER,optype VARCHAR,dstpath VARCHAR DEFAULT NULL);
						
	/**
		ɾϵͳݼƻ
    :
    planname		ݼƻ
    item_n 			ţʱԶɣ
  **/
	PROCEDURE  Drop_Item(planname VARCHAR, item_n INTEGER);
	
	/**
		ɾ߼ļ
    :
    planname		ݼƻ
    objtype 		 ȡֵ'DATABASE','TABLE','FILE'
  **/
	PROCEDURE  Alter_Plan_Del_Item(planname VARCHAR,objtype VARCHAR,objname VARCHAR);	
	/**
	üƻǰĿ
	 :
    planname		ݼƻ
    curr_item 	ǰĿ
	**/
	PROCEDURE  alter_modify_curr_item(planname VARCHAR,curr_item INTEGER);
	/**
	´ʱ
	:
    planname			ݼƻ
    curr_item 		ǰĿ
    next_run_time ´ʱ
    istart_t			ʼʱ
	**/
	PROCEDURE  alter_modify_run_time(planname VARCHAR,curr_item INTEGER,next_run_time DATETIME,istart_t DATETIME DEFAULT NULL);
	
	/**
		ݼƻִк
  **/						
	PROCEDURE  Run();
	
	/**
		־ļɾӿڣδʹ
  **/	
	PROCEDURE  Del_xfn();
	PROCEDURE  FILE_OPTION(PATH VARCHAR,OBJ_NAME VARCHAR,BAK_COUNT INT,OP_TYPE VARCHAR,PLAN_NAME VARCHAR,ITEM_NO INT);
 
END "SYSDBA"."DBMS_BACKUP";
/

CREATE OR Replace Package Body  "DBMS_BACKUP" IS
  /************ݼƻ**********/
  PROCEDURE Create_Plan(planname  VARCHAR,
                        plantype  VARCHAR,
                        path      VARCHAR,
                        starttime DATETIME,
                        period    INTERVAL DAY TO MINUTE) IS
    LANGUAGE "C" NAME "BLDIN_BAK_CREATE_PLAN";
  /*************ñݼƻĻ־************/
  PROCEDURE Enable_Plan(planname VARCHAR, b boolean) IS
    LANGUAGE "C" NAME "BLDIN_BAK_MODIFY_PLAN_STATE";

  /************ɾݼƻ*******************/
  PROCEDURE Drop_Plan(planname VARCHAR) IS
    LANGUAGE "C" NAME "BLDIN_BAK_DROP_PLAN";

  /************ȫĿ*************/
  PROCEDURE Add_Backup_Item(planname    VARCHAR,
                            filename    VARCHAR,
                            time_offset INTERVAL DAY TO MINUTE) IS
    LANGUAGE "C" NAME "BLDIN_BAK_ADD_BAK_ITEM";

  /************Ŀ*************/
  PROCEDURE Add_Backup_Inc_Item(planname    VARCHAR,
                                time_offset INTERVAL DAY TO MINUTE,
                                iperiod     INTERVAL DAY TO MINUTE DEFAULT NULL) IS
    LANGUAGE "C" NAME "BLDIN_BAK_ADD_INC_ITEM";

  /************ӵĿ*************/
  PROCEDURE Add_Export_Item(planname    VARCHAR,
                            obj_name    VARCHAR,
                            obj_type    VARCHAR,
                            filename    VARCHAR,
                            time_offset INTERVAL DAY TO MINUTE) IS
    LANGUAGE "C" NAME "BLDIN_BAK_ADD_EXP_ITEM";

  /************ļĿ***************/
  PROCEDURE Add_File_Item(planname  VARCHAR,
                          filename  VARCHAR,
                          bak_count INTEGER,
                          optype    VARCHAR,
                          dstpath   VARCHAR DEFAULT NULL) IS
    LANGUAGE "C" NAME "BLDIN_BAK_ADD_FILE_ITEM";

  /************ɾĿ****************/
  PROCEDURE Drop_Item(planname VARCHAR, item_n INTEGER) IS
    LANGUAGE "C" NAME "BLDIN_BAK_DROP_ITEM_BY_NO";

  /****************************ɾtable,database,file************************************/
  PROCEDURE Alter_Plan_Del_Item(planname VARCHAR,
                                objtype  VARCHAR,
                                objname  VARCHAR) IS
    LANGUAGE "C" NAME "BLDIN_BAK_DROP_ITEM_BY_OBJNAME";
  /****************************üƻǰĿ************************************/
  PROCEDURE alter_modify_curr_item(planname VARCHAR, curr_item INTEGER) IS
    LANGUAGE "C" NAME "BLDIN_BAK_MODIFY_PLAN_CURR_ITEM";
  /****************************´ʱ************************************/
  PROCEDURE alter_modify_run_time(planname      VARCHAR,
                                  curr_item     INTEGER,
                                  next_run_time DATETIME,
                                  istart_t      DATETIME DEFAULT NULL) IS
    LANGUAGE "C" NAME "BLDIN_BAK_MODIFY_ITEM_RUN_TIME";

  /*************ļʱ׺****************/
  FUNCTION append_file_tail(srcpathname varchar) RETURN VARCHAR IS
    pos         INTEGER;
    tail        VARCHAR;
    str_year    VARCHAR;
    str_month   VARCHAR;
    str_day     VARCHAR;
    str_hour    VARCHAR;
    str_minute  VARCHAR;
    str_second  VARCHAR;
    str_ext     VARCHAR;
    dstpathname VARCHAR;
  BEGIN
    if not FILE_EXISTS(srcpathname) then
      RETURN NULL;
    end if;
  
    tail := to_char(sysdate);
  
    str_year   := substr(tail, 1, 4);
    str_month  := substr(tail, 6, 2);
    str_day    := substr(tail, 9, 2);
    str_hour   := substr(tail, 12, 2);
    str_minute := substr(tail, 15, 2);
    str_second := substr(tail, 18, 2);
  
    tail := str_year || str_month || str_day || str_hour || str_minute ||
            str_second;
  
    pos := POSITION('.' IN REVERSE_STR(srcpathname));
    if pos > 0 then
      str_ext     := tailing(srcpathname, pos - 1);
      dstpathname := heading(srcpathname, len(srcpathname) - pos);
    else
      dstpathname := srcpathname;
    end if;
  
    dstpathname := dstpathname || '_' || tail || '.' || str_ext;
  
    --send_msg(dstpathname);
  
    RETURN dstpathname;
  
END;

  /**********************ȡļĩβĴʱ********************/
  FUNCTION get_file_create_time(filename VARCHAR, compfilename VARCHAR)
    RETURN DATETIME IS
    dt         DATETIME;
    dt_str     VARCHAR;
    str_year   VARCHAR;
    str_month  VARCHAR;
    str_day    VARCHAR;
    str_hour   VARCHAR;
    str_minute VARCHAR;
    str_second VARCHAR;
    pos        INTEGER;
  BEGIN
  
    --ļУȡʱ䴮
    dt_str := substr(filename, len(compfilename) + 2, 14);
    if len(dt_str) != 14 then
      dt_str := '99991231235959';
    end if;
  
    str_year   := substr(dt_str, 1, 4);
    str_month  := substr(dt_str, 5, 2);
    str_day    := substr(dt_str, 7, 2);
    str_hour   := substr(dt_str, 9, 2);
    str_minute := substr(dt_str, 11, 2);
    str_second := substr(dt_str, 13, 2);
  
    dt_str := str_year || '-' || str_month || '-' || str_day || ' ' ||
              str_hour || ':' || str_minute || ':' || str_second;
    dt     := To_date(dt_str, 'yyyy-mm-dd hh24:mi:ss');
    RETURN dt;
END;

  /************ȡָ·£ƥָֿʼַһļ*********/
  FUNCTION get_first_file(path      VARCHAR,filename  VARCHAR,bak_count out integer) RETURN VARCHAR IS
    str_name     varchar;
    str_ext      varchar;
    str_filename varchar;
    str_fileext  varchar;
    pos          integer;
    create_dt    datetime;
    ret_filename varchar;
    dt_str       varchar;
  BEGIN
    bak_count    := 0;
    ret_filename := NULL;
  
    --·
    if not dir_exists(path) then
      RAISE_APPLICATION_ERROR(-30012, 'Ŀ·' || path || '.');
    end if;
  
    --ָļֺͺ׺
    pos := POSITION('.' IN REVERSE_STR(filename));
    if pos > 0 then
      str_ext  := tailing(filename, pos - 1);
      str_name := heading(filename, len(filename) - pos);
    end if;
  
    create_dt := To_date('9999-12-31 23:59:59', 'yyyy-mm-dd hh24:mi:ss');
  
    FOR r IN (select * from TABLE(DBMS_INFO.FILE_LIST(path))) LOOP
      if not r.is_dir then
        pos := position('/' IN REVERSE_STR(r.db_path));
        if pos > 0 then
          str_filename := tailing(r.db_path, pos - 1);
        else
          str_filename := r.db_path;
        end if;
      
        pos := POSITION('.' IN REVERSE_STR(str_filename));
        if pos > 0 then
          str_fileext  := tailing(str_filename, pos - 1);
          str_filename := heading(str_filename, len(str_filename) - pos);
        end if;
      
        pos := position(str_name in str_filename);
        if pos = 1 and '_' = substr(str_filename, len(str_name) + 1, 1) and
           str_ext = str_fileext then
          bak_count := bak_count + 1;
          if create_dt > get_file_create_time(str_filename, str_name) then
            create_dt    := get_file_create_time(str_filename, str_name);
            ret_filename := r.db_path;
          end if;
        end if;
      end if;
    END FOR;
  
    RETURN ret_filename; 
END;

  /*************************************************************/
  PROCEDURE rename_op(path VARCHAR, fname VARCHAR) IS
    pos         INTEGER;
    srcfilename VARCHAR;
    dstfilename VARCHAR;
  BEGIN
    --
    
    IF path ISNULL THEN
      RAISE_APPLICATION_ERROR(-30020, 'pathΪ');
    END IF;
  
    IF fname ISNULL THEN
      RAISE_APPLICATION_ERROR(-30020, 'fnameΪ');
    END IF;
  
    --·
    pos := position('/' in reverse_str(path));
 
    IF pos = 1 THEN
      srcfilename := path;
    ELSE
      srcfilename := CONCAT(path, '/');
    END IF;

    srcfilename := CONCAT(srcfilename, fname);
    dstfilename := append_file_tail(srcfilename);
    IF dstfilename is not null then
        if not RENAME_FILE(srcfilename, dstfilename) then
      RAISE_APPLICATION_ERROR(-30015,'ļ' || srcfilename || 'ʧ.');
    end if;
    end if;
END;

PROCEDURE Del_xfn() as
    path_str varchar;
    xfn_str  varchar;
    min_xfn  integer;
    path_len integer;
    xfn      integer;
  BEGIN
    select MIN_RESTORE_XFN into min_xfn from sys_ctl_vars;
    for r in (select db_path
                from TABLE(DBMS_INFO.FILE_LIST('/ARCH'))
               ORDER BY DB_PATH) loop
      path_str := r.db_path;
      --ȡù鵵
      path_len := len(path_str);
      path_str := heading(path_str, path_len - 4);
      xfn_str  := tailing(path_str, path_len - 4 - len('/HOME/ARCH/REDO'));
      xfn      := atol(xfn_str);
      --鵵ССȫţɾ鵵ļ
      if xfn < min_xfn then
        DROP_FILE(r.db_path);
      end if;
    end for;
END;

PROCEDURE FILE_OPTION (PATH VARCHAR,OBJ_NAME VARCHAR,SAVE_BAK INT,OP_TYPE VARCHAR,PLAN_NAME VARCHAR,ITEM_NO INT,PATH_BAK VARCHAR)
AS
srcfilename 	VARCHAR;
bak_count 		int;
pos          	INTEGER;
tmp_item_no  	INTEGER;
s_t          	DATETIME;
bakpathname 	VARCHAR;
dstfilename 	VARCHAR;
 BEGIN
      --ɾļ    
      IF UPPER(OP_TYPE) = 'DELETE' THEN
      --    
      rename_op(PATH, OBJ_NAME);
      --ɾ
      srcfilename := get_first_file(PATH, OBJ_NAME, bak_count);
      if srcfilename notnull and bak_count > SAVE_BAK then
        if not DROP_FILE(srcfilename) then
          RAISE_APPLICATION_ERROR(-30016,'ɾļ' || srcfilename || 'ʧ.');
        end if;
      end if;
      --ƶļ                  
    ELSIF
     UPPER(OP_TYPE) = 'MOVE' THEN
    --
    rename_op(PATH, OBJ_NAME);
    --ƶ
    srcfilename := get_first_file(PATH, OBJ_NAME, bak_count);
    if srcfilename notnull and bak_count > SAVE_BAK then
      pos := POSITION('/' IN REVERSE_STR(srcfilename));
      if pos > 0 then
        dstfilename := tailing(srcfilename, pos - 1);
      end if;
    
      if '/' = TAILING(PATH_BAK, 1) then
        dstfilename := CONCAT(PATH_BAK, dstfilename);
      else
        dstfilename := CONCAT('/', dstfilename);
        dstfilename := CONCAT(PATH_BAK, dstfilename);
      end if;
    
      if not RENAME_FILE(srcfilename, dstfilename) then
        RAISE_APPLICATION_ERROR(-30017,'ƶļ' || srcfilename || 'ʧ.');
      end if;
    end if;
    END IF;
END;--end file_op

/************ݼƻִ(JOB)****************/
PROCEDURE Run() IS
    mark_str    VARCHAR;
    sql_str     VARCHAR;
    tv          INTERVAL DAY TO MINUTE;
    nt          DATETIME;
    tmp_item_no INTEGER;
    s_t         DATETIME;
    bakpathname VARCHAR;
    option_type varchar;
  BEGIN
    --ȡƻеִʱ
    FOR r IN (SELECT * FROM DBA_BACKUP_ITEMS R1 ,DBA_BACKUP_PLANS R2
               WHERE  r2.ENABLE=true AND NEXT_RUN_T < SYSDATE AND R1.PLAN_NAME=R2.PLAN_NAME
               ORDER BY R1.PLAN_NAME, ITEM_NO) LOOP   
     
     IF r.op_type='BACKUP' THEN
     		option_type:='BACKUP SYSTEM';
     ELSIF r.op_type='BACKUP_INC' THEN
     		option_type:='BACKUP SYSTEM INCREMENT';
     ELSIF r.op_type='EXPORT'  AND r.OBJ_TYPE = 'DATABASE' THEN
     		option_type:='EXPORT DATABASE';
     ELSIF r.op_type='EXPORT'  AND r.OBJ_TYPE = 'TABLE' THEN
     		option_type:='EXPORT TABLE';
     END IF;
      
      ----ÿαǰļļд,
      IF R.OP_TYPE = 'BACKUP' or R.OP_TYPE='EXPORT' THEN
        FILE_OPTION(r.PATH,r.FILE_NAME,r.FILE_KEEP_CNT,r.file_op,r.plan_name,r.item_no,r.FILE_MOVE_PATH);
        nt := r.NEXT_RUN_T;
        while nt <= SYSDATE LOOP
           nt := nt + r.PERIOD;
        END LOOP;
        
        --޸´ִʱ(۳ɹʧ,޸ִʱ)
        dbms_backup.alter_modify_curr_item(r.PLAN_NAME, r.ITEM_NO);
        dbms_backup.alter_modify_run_time(r.PLAN_NAME, r.ITEM_NO, nt);
      ELSE
        nt  := r.NEXT_RUN_T;
        s_t := r.ISTART_T;
        WHILE nt <= SYSDATE LOOP
          nt := nt + r.IPERIOD;
          IF nt > s_t + r.PERIOD THEN
            s_t := s_t + r.PERIOD;
            nt  := s_t + r.TIME_OFF;
          END IF;
        END LOOP;
        dbms_backup.alter_modify_curr_item(r.PLAN_NAME, r.ITEM_NO);
        dbms_backup.alter_modify_run_time(r.PLAN_NAME, r.ITEM_NO, nt, s_t);
      END IF;




      bakpathname := r.PATH;
      IF '/' != TAILING(bakpathname, 1) THEN
        bakpathname := CONCAT(bakpathname, '/');
      END IF;
      bakpathname := CONCAT(bakpathname, r.FILE_NAME);
      
      IF r.OP_TYPE = 'BACKUP' THEN
        sql_str := 'BACKUP SYSTEM TO ''' || bakpathname || ''' online;';
      ELSIF r.OP_TYPE = 'BACKUP_INC' THEN
        sql_str := 'BACKUP SYSTEM INCREMENT APPEND TO ''' || bakpathname || ''' online;';
      ELSIF r.OP_TYPE = 'EXPORT' AND r.OBJ_TYPE = 'DATABASE' THEN
        sql_str := 'BACKUP DATABASE TO ''' || bakpathname || ''';';
      ELSIF r.OP_TYPE = 'EXPORT' AND r.OBJ_TYPE = 'TABLE' THEN
        sql_str := 'BACKUP TABLE ' || r.OBJ_NAME || ' APPEND TO ''' || bakpathname || ''';';
      ELSE
        CONTINUE;
      END IF;   
       
      BEGIN
	      EXECUTE IMMEDIATE sql_str;        
	   END;--end execute
END FOR;
END; --end Run
END DBMS_BACKUP;
/

CREATE OR REPLACE PACKAGE SYSDBA.DBMS_METADATA AUTHID CURRENT_USER
IS
	FUNCTION GET_DDL(obj_name IN VARCHAR) RETURN CLOB;
	FUNCTION GET_DDL(obj_type IN VARCHAR,obj_name IN VARCHAR,schema_name IN VARCHAR DEFAULT NULL) RETURN CLOB;
	FUNCTION GET_DDL_INDEX(tab_name IN VARCHAR, idx_name IN VARCHAR DEFAULT 'ALL') RETURN CLOB;
END SYSDBA.DBMS_METADATA;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_METADATA 
IS
	FUNCTION GET_DDL(obj_name IN VARCHAR) RETURN CLOB
	IS
 	LANGUAGE  "C"
	NAME	  "BLDIN_GET_DDL";
	
	FUNCTION GET_DDL(obj_type IN VARCHAR,obj_name IN VARCHAR,schema_name IN VARCHAR DEFAULT NULL) RETURN CLOB
	IS
 	LANGUAGE  "C"
	NAME	  "BLDIN_GET_DDL_P3";

	FUNCTION GET_DDL_INDEX(tab_name IN VARCHAR, idx_name IN VARCHAR DEFAULT 'ALL') RETURN CLOB
	IS
 	LANGUAGE  "C"
	NAME	  "BLDIN_GET_DDL_INDEX";
END SYSDBA.DBMS_METADATA;
/


----------ݿͨù߰()------------------
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_UTILITY 
IS
       FUNCTION GET_TIME() RETURN BIGINT;
       FUNCTION FORMAT_ERROR_STACK() RETURN VARCHAR(5000);
       FUNCTION FORMAT_ERROR_BACKTRACE() RETURN VARCHAR(5000);
	   PROCEDURE OPEN_TABLE(name IN VARCHAR,		-- '*' ǰб'schema_name.*' ָģʽб'tab_name' ǰ ģʽµı
							node_id IN INTEGER)		--ڵid '0' ǰڵ㣬 '-1' нڵ㣬 '0' ָڵ㣩
							AUTHID USER;
END SYSDBA.DBMS_UTILITY;
/

----------ݿͨù߰(ʵ)------------------
CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_UTILITY 
IS
	FUNCTION GET_TIME() RETURN BIGINT
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_GET_TIME";
        
	FUNCTION FORMAT_ERROR_STACK() RETURN VARCHAR(5000)
	IS
	BEGIN
		return SQLERRM;
	END;
        
	FUNCTION FORMAT_ERROR_BACKTRACE() RETURN VARCHAR(5000)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_FORMAT_ERROR_BACKTRACE";
      
	PROCEDURE OPEN_TABLE(name IN VARCHAR, node_id IN INTEGER)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_OPEN_TABLE";

END SYSDBA.DBMS_UTILITY;
/


CREATE OR REPLACE PACKAGE DBMS_RANDOM AS

    -- Seed with a binary integer
    PROCEDURE SEED(val IN INTEGER);

    -- Seed with a string (up to length 2000)
    PROCEDURE SEED(val IN VARCHAR2);

    -- Get a random 18-digit precision number, 0.0 <= value < 1.0
    FUNCTION VALUE RETURN NUMBER(38,18);

    -- get a random Oracle number x, low <= x < high
    FUNCTION VALUE (low IN NUMBER, high IN NUMBER) RETURN NUMBER(38,18);

    -- get a random number from a normal distribution
    FUNCTION normal RETURN NUMBER ;

    -- get a random string
    FUNCTION STRING (opt char, len NUMBER)
          /* "opt" specifies that the returned string may contain:
             'u','U'  :  upper case alpha characters only
             'l','L'  :  lower case alpha characters only
             'a','A'  :  alpha characters only (mixed case)
             'x','X'  :  any alpha-numeric characters (upper)
             'p','P'  :  any printable characters
          */
        RETURN VARCHAR2 ;  -- string of <len> characters

    -- Obsolete, just calls seed(val)
    PROCEDURE INITIALIZE(val IN INTEGER);

    -- Obsolete, get integer in ( -power(2,31) <= random < power(2,31) )
    FUNCTION RANDOM RETURN INTEGER;

    TYPE NUM_ARRAY IS TABLE OF NUMBER(38,38) INDEX BY INTEGER;
END DBMS_RANDOM;
/


CREATE OR REPLACE PACKAGE BODY DBMS_RANDOM AS
    mem        num_array;           -- big internal state hidden from the user
    counter    INTEGER := 55;       -- counter through the results
    saved_norm NUMBER := NULL;      -- unused random normally distributed value
    need_init  BOOLEAN := TRUE;     -- do we still need to initialize

    -- Seed the random number generator with a INTEGER
    PROCEDURE SEED(val IN INTEGER) IS
    BEGIN
		SEED(TO_CHAR(val));
    END SEED;

    -- Seed the random number generator with a string.
    PROCEDURE SEED(val IN VARCHAR2) IS
        junk     VARCHAR2(2000);
        piece    VARCHAR2(20);
        randval  NUMBER(38,37);
        mytemp   NUMBER(38,0);
        vatemp   NUMBER(38,14);
        j        INTEGER;
    BEGIN
        need_init   := FALSE;
        saved_norm  := NULL;
        counter     := 0;
        junk        := val;
        FOR i IN 0..54 LOOP
            piece   := SUBSTR(junk,1,19);
            randval := 0;
            j       := 1;

            -- convert 19 characters to a 38-digit number
            FOR j IN 1..19 LOOP
                randval := 1e2*randval + NVL(ASCII(SUBSTR(piece,j,1)),0.0);
            END LOOP;

            -- try to avoid lots of zeros
            randval := randval*1e-38+i*.01020304050607080910111213141516171819;
            mem(i)  := randval - TRUNC(randval);

            -- we've handled these first 19 characters already; move on
            junk    := SUBSTR(junk,20);
        END LOOP;

	    randval := mem(54);
        FOR j IN 0..10 LOOP
            FOR i IN 0..54 LOOP
                
                -- barrelshift mem(i-1) by 24 digits
                vatemp  := randval * 1e24;
                mytemp  := TRUNC(randval);
                randval := (randval - mytemp) + (mytemp * 1e-38);

                -- add it to mem(i)
                randval := mem(i)+randval;
                IF (randval >= 1.0) THEN
                    randval := randval - 1.0;
                END IF;

		        -- record the result
                mem(i) := randval;
            END LOOP;
        END LOOP;
    END seed;

    -- give values to the user
    -- Delayed Fibonacci, pilfered from Knuth volume 2
    FUNCTION VALUE RETURN NUMBER(38,18) IS
    randval  NUMBER(38,18);
    BEGIN
        counter := counter + 1;
        IF counter >= 55 THEN

            -- initialize if needed
            IF (need_init = TRUE) THEN
                SEED(TO_CHAR(SYSDATE,'MM-DD-YYYY HH24:MI:SS') ||
                     USER || USERENV('SESSIONID'));
            ELSE
                -- need to generate 55 more results
                FOR i IN 0..30 LOOP
                    randval := mem(i+24) + mem(i);
                    IF (randval >= 1.0) THEN
                        randval := randval - 1.0;
                    END IF;
                    mem(i) := randval;
                END LOOP;
                FOR i IN 31..54 LOOP
                    randval := mem(i-31) + mem(i);
                    IF (randval >= 1.0) THEN
                        randval := randval - 1.0;
                    END IF;
                    mem(i) := randval;
                END LOOP;
            END IF;
            counter := 0;
        END IF;
        RETURN mem(counter)*mem(counter)*mem(counter);
    END VALUE;

    -- Random 38-digit number between LOW and HIGH.
    FUNCTION VALUE ( low in NUMBER, high in NUMBER) RETURN NUMBER(38,18)
    is
    val numeric(38,18);
    BEGIN
        val  := VALUE();
        val  := val*(high-low);
        RETURN val+low;
    END VALUE;

    -- Random numbers in a normal distribution.
    -- Pilfered from Knuth volume 2.
    FUNCTION NORMAL RETURN NUMBER is
                    -- 38 decimal places: Mean 0, Variance 1
        v1  NUMBER(38,18);
        v2  NUMBER(38,18);
        r2  NUMBER(38,18);
        fac NUMBER(38,18);
    BEGIN
        IF saved_norm is not NULL THEN     -- saved from last time
            v1 := saved_norm;              -- to be returned this time
            saved_norm := NULL;
        ELSE
            r2 := 2;
            -- Find two independent uniform variables
            WHILE r2 > 1 OR r2 = 0 LOOP
                v1 := value();
                v1 := v1 + v1 - 1;
                v2 := value();
                v2 := v2 + v2 - 1;
                r2 := v1*v1 + v2*v2;  -- r2 is radius
            END LOOP;      -- 0 < r2 <= 1:  in unit circle
            /* Now derive two independent normally-distributed variables */
            fac := sqrt(-2*ln(r2)/r2);
            v1 := v1*fac;          -- to be returned this time
            saved_norm := v2*fac;  -- to be saved for next time
        END IF;
        RETURN v1;
    END  NORMAL;

    -- Random string.  Pilfered from Chris Ellis.
    FUNCTION STRING (opt char, len NUMBER)
        RETURN VARCHAR2 is      -- string of <len> characters
        optx char (1)  := lower(opt);
        rng  NUMBER;
        tmp  NUMBER(38,18);
        n    INTEGER;
        ccs  VARCHAR2 (128);    -- candidate character subset
        xstr VARCHAR2 (4000) := NULL;
    BEGIN
        IF    optx = 'u' THEN    -- upper case alpha characters only
            ccs := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            rng := 26;
        ELSIF optx = 'l' THEN    -- lower case alpha characters only
            ccs := 'abcdefghijklmnopqrstuvwxyz';
            rng := 26;
        ELSIF optx = 'a' THEN    -- alpha characters only (mixed case)
            ccs := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' ||
                  'abcdefghijklmnopqrstuvwxyz';
            rng := 52;
        ELSIF optx = 'x' THEN    -- any alpha-numeric characters (upper)
            ccs := '0123456789' ||
                  'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            rng := 36;
        ELSIF optx = 'p' THEN    -- any printable char (ASCII subset)
            ccs := ' !"#$%&''()*+,-./' || '0123456789' || ':;<=>?@' ||
                  'ABCDEFGHIJKLMNOPQRSTUVWXYZ' || '[\]^_`' ||
                  'abcdefghijklmnopqrstuvwxyz' || '{|}~' ;
            rng := 95;
        ELSE
            ccs := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            rng := 26;          -- default to upper case
        END IF;
        FOR i IN 1 .. least(len,4000) LOOP
            /* Get random integer within specified range */
            tmp := rng * value;
            n := TRUNC(tmp) + 1;
            /* Append character to string  */
            xstr := xstr || SUBSTR(ccs,n,1);
        END LOOP;
        RETURN xstr;
    END STRING;

    -- For compatibility with 8.1
    PROCEDURE INITIALIZE(val IN INTEGER) IS
    BEGIN
		SEED(to_char(val));
    END INITIALIZE;

    -- For compatibility with 8.1
    -- Random INTEGER, -power(2,31) <= Random < power(2,31)
    -- Delayed Fibonacci, pilfered from Knuth volume 2
    FUNCTION RANDOM RETURN INTEGER IS
    BEGIN
	RETURN TRUNC(Value*4294967296)-2147483648;
    END RANDOM;

END DBMS_RANDOM;
/


CREATE OR REPLACE PACKAGE SYSDBA.DBMS_JOB
IS
	PROCEDURE SUBMIT(job OUT INTEGER,what IN VARCHAR,next_date IN DATETIME DEFAULT sysdate,pop_interval IN VARCHAR DEFAULT NULL,no_parse IN BOOLEAN DEFAULT FALSE,instance IN INTEGER DEFAULT 0,force IN BOOLEAN DEFAULT FALSE);
	PROCEDURE RUN(job INTEGER,force IN BOOLEAN DEFAULT FALSE);
	PROCEDURE REMOVE(job INTEGER);
END SYSDBA.DBMS_JOB;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_JOB 
IS
	PROCEDURE SUBMIT(job OUT INTEGER,what IN VARCHAR,next_date IN DATETIME DEFAULT sysdate,pop_interval IN VARCHAR DEFAULT NULL,no_parse IN BOOLEAN DEFAULT FALSE,instance IN INTEGER DEFAULT 0,force IN BOOLEAN DEFAULT FALSE)
	IS
		name varchar;
	BEGIN
		name := dbms_random.string('u',20);
 		DBMS_SCHEDULER.CREATE_JOB(name,'stored_procedure',what,0,next_date,pop_interval,'2099-12-31 00:00:00','JOB_CLASS',force,FALSE,NULL);
		SELECT JOB_ID INTO job FROM ALL_JOBS WHERE JOB_NAME=name;
	END;

	PROCEDURE RUN(job INTEGER,force IN BOOLEAN DEFAULT FALSE)
	IS
		name varchar;
	BEGIN
		SELECT JOB_NAME INTO name FROM ALL_JOBS WHERE JOB_ID=job;
		DBMS_SCHEDULER.RUN_JOB(name,force);
	END;

	PROCEDURE REMOVE(job INTEGER)
	IS
		name varchar;
	BEGIN
		SELECT JOB_NAME INTO name FROM ALL_JOBS WHERE JOB_ID=job;
		DBMS_SCHEDULER.DROP_JOB(name,TRUE);
	END;
	
END SYSDBA.DBMS_JOB;
/

 ----------SYNONYM DEFINE-------------
CREATE OR REPLACE PUBLIC SYNONYM RECYCLEBIN FOR USER_RECYCLEBIN;
/

-- Cluster Global Storage Migrate --
CREATE OR REPLACE PACKAGE  SYSDBA.DBMS_STORAGE
COMMENT '洢ά'  
IS
	PROCEDURE MIGRATE_STORAGE(zone_name VARCHAR,drop_node INT);
END SYSDBA.DBMS_STORAGE;
/

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_STORAGE 
IS
	PROCEDURE MIGRATE_STORAGE(zone_name VARCHAR,drop_node INT)
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_MIGRATE_STORAGE";

END SYSDBA.DBMS_STORAGE;
/



/** ʹʱ
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_SESSION
IS
	PROCEDURE SET_CONTEXT(context_name VARCHAR,attribute VARCHAR,value VARCHAR,username VARCHAR DEFAULT NULL,client_id VARCHAR DEFAULT NULL);
END SYSDBA.DBMS_SESSION;


----
CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_SESSION 
IS
	PROCEDURE SET_CONTEXT(context_name VARCHAR,attribute VARCHAR,value VARCHAR,username VARCHAR DEFAULT NULL,client_id VARCHAR DEFAULT NULL)
IS
 	LANGUAGE  "C"
  NAME	  "BLDIN_SET_CONTEXT";
	
END SYSDBA.DBMS_SESSION;


CREATE OR REPLACE PACKAGE SYSDBA.DBMS_RLS
IS
CONTEXT_SENSITIVE integer :=1;
	PROCEDURE ADD_POLICY(
	 object_schema            IN VARCHAR,
   object_name              IN VARCHAR,
   policy_name              IN VARCHAR,
   function_schema          IN VARCHAR,
   policy_function          IN VARCHAR,
   statement_types          IN VARCHAR,
   update_check             IN BOOLEAN DEFAULT FALSE,
   enable                   IN BOOLEAN DEFAULT TRUE,
   static_policy            IN BOOLEAN DEFAULT FALSE,
   policy_type              IN BINARY_INTEGER DEFAULT NULL,
   long_predicate           IN BOOLEAN DEFAULT FALSE,
   sec_relevant_cols        IN VARCHAR2 DEFAULT NULL,
   sec_relevant_cols_opt    IN BINARY_INTEGER DEFAULT NULL);
   PROCEDURE DROP_POLICY(
	 object_schema            IN VARCHAR,
   object_name              IN VARCHAR,
   policy_name              IN VARCHAR);
END SYSDBA.DBMS_RLS;


----
CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_RLS 
IS
	PROCEDURE ADD_POLICY(
	 object_schema            IN VARCHAR,
   object_name              IN VARCHAR,
   policy_name              IN VARCHAR,
   function_schema          IN VARCHAR,
   policy_function          IN VARCHAR,
   statement_types          IN VARCHAR,
   update_check             IN BOOLEAN DEFAULT FALSE,
   enable                   IN BOOLEAN DEFAULT TRUE,
   static_policy            IN BOOLEAN DEFAULT FALSE,
   policy_type              IN BINARY_INTEGER DEFAULT NULL,
   long_predicate           IN BOOLEAN DEFAULT FALSE,
   sec_relevant_cols        IN VARCHAR2 DEFAULT NULL,
   sec_relevant_cols_opt    IN BINARY_INTEGER DEFAULT NULL)
  IS
 	LANGUAGE  "C"
  NAME	  "BLDIN_ADD_POLICY";
  
  PROCEDURE DROP_POLICY(
	 object_schema            IN VARCHAR,
   object_name              IN VARCHAR,
   policy_name              IN VARCHAR)
	 IS
 	LANGUAGE  "C"
  NAME	  "BLDIN_DROP_POLICY";
END SYSDBA.DBMS_RLS;


--˰ϵͳؽӿڶ
CREATE OR REPLACE PACKAGE SYSDBA.DBMS_BUFFER 
IS
	 --̭LRU buffer 
	 --BUFFER_NUM̭ĸСڵ0ʱʾ̭LRU
	 --RETURN:ʵ̭ĸ
	FUNCTION ELIMINATE_LRU_BUFFER(BUFFER_NUM INTEGER) RETURN INTEGER;
END SYSDBA.DBMS_BUFFER;

CREATE OR REPLACE PACKAGE BODY SYSDBA.DBMS_BUFFER
IS
	FUNCTION ELIMINATE_LRU_BUFFER(BUFFER_NUM INTEGER) RETURN INTEGER
	IS
	LANGUAGE  "C"
	NAME	  "BLDIN_ELIMINATE_LRU_BUFFER";
END SYSDBA.DBMS_BUFFER;
**/

