#!/bin/bash

# Copyright (c) 2002-2025 Chengdu Xugu Weiye Technology Co.,Ltd.  All rights reserved.
# XuguDB server console runner script for Linux

# 设置默认值
server="127.0.0.1"
port="5138"
ssl_str="nssl"
database="SYSTEM"
username="SYSDBA"
password="SYSDBA"


options=$(getopt -o l --long locate -n "$0" -- "$@")
# 设置位置参数为解析后的选项
eval set -- "$options"
while true; do
  case "$1" in
    -l|--locate)
      "$PWD/xgconsole" -s $ssl_str -P $port -h $server -d $database -u "$username" -p "$password"
      exit 0
      ;;
    --)
      shift
      break
      ;;
    *)
      echo "内部错误"
      exit 1
      ;;
  esac
done

read -p "Server [$server]: " input
if [ -n "$input" ]; then
  server="$input"
fi

read -p "Port [$port]: " input
if [ -n "$input" ]; then
  port="$input"
fi

read -p "SSL [$ssl_str]: " input
if [ -n "$input" ]; then
  ssl_str="$input"
fi

read -p "Database [$database]: " input
if [ -n "$input" ]; then
  database="$input"
fi

read -p "Username [$username]: " input
if [ -n "$input" ]; then
  username="$input"
fi

# Run xgconsole
"$PWD/xgconsole" -s $ssl_str -P $port -h $server -d "$database" -u "$username"
