#!/bin/bash
function error() {
    echo "执行失败，请查看上方执行日志！"
    exit 1
}

OPENSSL_CONF="config/openssl.cnf"
WORK_DIR="./demoCA"

REVOKE_FILE="$WORK_DIR/cacert.pem"
CRL_FILE="$WORK_DIR/crl.pem"

echo "======== 注意事项 ========"
echo
echo "当前使用配置文件：$OPENSSL_CONF"
echo "当前脚本工作目录：$WORK_DIR"
echo "请确保脚本 WORK_DIR 参数与配置文件中 dir 参数一致"
echo
echo "======== 吊销证书 ========"
echo
openssl ca -revoke "$REVOKE_FILE" -config "$OPENSSL_CONF" || error
openssl ca -gencrl -out "$CRL_FILE" -config "$OPENSSL_CONF" || error
echo
echo "脚本执行成功，相关证书已吊销。"