#!/bin/bash
function error() {
    echo "执行失败，请查看上方执行日志！"
    exit 1
}

OPENSSL_CONF="config/openssl.cnf"
WORK_DIR="./demoCA"

KEY_DIR="$WORK_DIR/private"
CSR_DIR="$WORK_DIR/newcerts"
CRT_DIR="$WORK_DIR/certs"
CRL_DIR="$WORK_DIR/crl"
SERIAL_FILE="$WORK_DIR/serial"
INDEX_FILE="$WORK_DIR/index.txt"
INDEX_ATTR_FILE="$WORK_DIR/index.txt.attr"
CRL_NUMBER_FILE="$WORK_DIR/crlnumber"

CA_KEY_FILE="$KEY_DIR/cakey.pem"
CA_CSR_FILE="$WORK_DIR/careq.pem"
CA_CRT_FILE="$WORK_DIR/cacert.pem"
CA_CRL_FILE="$WORK_DIR/crl.pem"
CA_SUBJ="/C=CN/ST=Sichuan/L=Chengdu/O=Chengdu Xugu Weiye Technology CO., Ltd/OU=Development/CN=Xugu Root CA"

DATABASE_KEY_FILE="$KEY_DIR/database.key"
DATABASE_CSR_FILE="$CSR_DIR/database.csr"
DATABASE_CRT_FILE="$CRT_DIR/database.crt"
DATABASE_SUBJ="/C=CN/ST=Sichuan/L=Chengdu/O=Chengdu Xugu Weiye Technology CO., Ltd/OU=Development/CN=Xugu Database"

DRIVER_KEY_FILE="$KEY_DIR/driver.key"
DRIVER_CSR_FILE="$CSR_DIR/driver.csr"
DRIVER_CRT_FILE="$CRT_DIR/driver.crt"
DRIVER_SUBJ="/C=CN/ST=Sichuan/L=Chengdu/O=Chengdu Xugu Weiye Technology CO., Ltd/OU=Development/CN=Xugu Driver"

if test ! -e $WORK_DIR; then mkdir $WORK_DIR; fi
if test ! -e $KEY_DIR; then mkdir $KEY_DIR; fi
if test ! -e $CSR_DIR; then mkdir $CSR_DIR; fi
if test ! -e $CRT_DIR; then mkdir $CRT_DIR; fi
if test ! -e $CRL_DIR; then mkdir $CRL_DIR; fi
if test ! -e $SERIAL_FILE; then
    SERIAL_NUMBER=`openssl rand -hex 20`
    echo ${SERIAL_NUMBER^^} >$SERIAL_FILE
fi
if test ! -e $INDEX_FILE; then touch $INDEX_FILE; fi
if test ! -e $INDEX_ATTR_FILE; then echo "unique_subject = yes" >$INDEX_ATTR_FILE; fi
if test ! -e $CRL_NUMBER_FILE; then
    CRL_NUMBER=`openssl rand -hex 20`
    echo ${CRL_NUMBER^^} >$CRL_NUMBER_FILE
fi

echo "======== 注意事项 ========"
echo
echo "当前使用配置文件：$OPENSSL_CONF"
echo "当前脚本工作目录：$WORK_DIR"
echo "请确保脚本 WORK_DIR 参数与配置文件中 dir 参数一致"
echo
echo "======== 证书颁发机构 ========"
echo
openssl genpkey -algorithm RSA -out "$CA_KEY_FILE" || error
echo "已生成证书颁发机构私钥文件：$CA_KEY_FILE"
openssl req -new -key "$CA_KEY_FILE" -out "$CA_CSR_FILE" -subj "$CA_SUBJ" -config "$OPENSSL_CONF" || error
echo "已生成证书颁发机构请求文件：$CA_CSR_FILE"
openssl ca -batch -selfsign -days 11688 -in "$CA_CSR_FILE" -outdir "$WORK_DIR" -keyfile "$CA_KEY_FILE" -extensions v3_ca -config "$OPENSSL_CONF" || error
SERIAL_NUMBER=$(<$SERIAL_FILE.old) || error
mv $WORK_DIR/$SERIAL_NUMBER.pem $CA_CRT_FILE || error
echo "已生成证书颁发机构证书文件：$CA_CRT_FILE"
openssl ca -gencrl -out "$CA_CRL_FILE" -config "$OPENSSL_CONF" || error
echo "已生成证书颁发机构吊销文件：$CA_CRL_FILE"
echo
echo "======== 数据库 ========"
echo
openssl genpkey -algorithm RSA -out "$DATABASE_KEY_FILE" || error
echo "已生成数据库私钥文件：$DATABASE_KEY_FILE"
openssl req -new -key "$DATABASE_KEY_FILE" -out "$DATABASE_CSR_FILE" -subj "$DATABASE_SUBJ" -config "$OPENSSL_CONF" || error
echo "已生成数据库请求文件：$DATABASE_CSR_FILE"
openssl ca -batch -days 4383 -in "$DATABASE_CSR_FILE" -outdir "$CRT_DIR" -keyfile "$CA_KEY_FILE" -cert "$CA_CRT_FILE" -extensions usr_cert -config "$OPENSSL_CONF" || error
SERIAL_NUMBER=$(<$SERIAL_FILE.old) || error
mv $CRT_DIR/$SERIAL_NUMBER.pem $DATABASE_CRT_FILE || error
echo "已生成数据库证书文件：$DATABASE_CRT_FILE"
echo
echo "======== 驱动 ========"
echo
openssl genpkey -algorithm RSA -out "$DRIVER_KEY_FILE" || error
echo "已生成驱动私钥文件：$DRIVER_KEY_FILE"
openssl req -new -key "$DRIVER_KEY_FILE" -out "$DRIVER_CSR_FILE" -subj "$DRIVER_SUBJ" -config "$OPENSSL_CONF" || error
echo "已生成驱动请求文件：$DRIVER_CSR_FILE"
openssl ca -batch -days 4383 -in "$DRIVER_CSR_FILE" -outdir "$CRT_DIR" -keyfile "$CA_KEY_FILE" -cert "$CA_CRT_FILE" -extensions usr_cert -config "$OPENSSL_CONF" || error
SERIAL_NUMBER=$(<$SERIAL_FILE.old) || error
mv $CRT_DIR/$SERIAL_NUMBER.pem $DRIVER_CRT_FILE || error
echo "已生成驱动证书文件：$DRIVER_CRT_FILE"
echo
echo "脚本执行成功，相关文件已生成。"
exit 0