# 环境配置

本文档针对于驱动开发者，配置说明基于以下假设：

- 使用 OpensSSL 1.x 或 keytool 生成脚本
- KeyStore 文件存放于 `用户目录/.keystore`
- TrustStore 文件存放于 `JRE目录/lib/security/cacerts`
- KeyStore 密码：`changeit`
- TrustStore 密码：`changeit`
- 驱动私钥密码：`changeit`

**注意**：若您系统安装的是 JDK 而非 JRE，则默认 `cacerts` 文件位于 `JDK目录/jre/lib/security`

## 客户端

使用生成脚本（推荐使用 OpenSSL）生成相关文件后，客户端需要以下文件：

- `cacert.pem`：证书颁发机构证书
- `crl.pem`：证书颁发机构证书吊销清单
- `driver.crt`：驱动证书
- `driver.key`：驱动私钥

### 系统环境

#### 使用 OpenSSL 生成脚本

1. 将 OpenSSL 生成的驱动私钥与证书，合并转换为 PKCS12 格式文件：  
    ```shell
    openssl pkcs12 -export -in driver.crt -inkey driver.key -out driver.p12 -password pass:changeit
    ```
    **-password pass:changit**：设置 PKCS12 格式文件中私钥加密密码，密码内容为 `changeit`
1. 使用 `keytool` 工具将生成的 PKCS12 格式文件导入 `用户目录/.keystore` 文件：  
    ```shell
    keytool -importkeystore -srckeystore driver.p12 -srcstoretype PKCS12 -srcstorepass changeit -destkeystore 用户目录/.keystore -srcalias 1 -deststoretype PKCS12 -deststorepass changeit -destalias xugu-driver
    ```
    **-srcstorepass changeit**：`driver.p12` 私钥加密的密码，密码内容为 `changeit`  
    **-deststorepass changeit**：`用户目录/.keystore` 密钥库的密码，密码内容为 `changeit`
1. 使用 `keytool` 工具将证书颁发机构 CA 的证书文件导入 `JRE目录/lib/security/cacerts` 文件：  
    ```sh
    keytool -importcert -file cacert.pem -keystore JRE目录/lib/security/cacerts -deststoretype JKS -storepass changeit -alias xugu-root-ca
    ```

#### 使用 keytool 生成脚本

1. 使用 `keytool` 工具将驱动的证书文件导入 `用户目录/.keystore` 文件：  
    ```sh
    keytool -importcert -file driver.crt -keystore 用户目录/.keystore -storetype PKCS12 -storepass changeit -alias xugu-driver
    ```
1. 使用 `keytool` 工具将证书颁发机构 CA 的证书文件导入 `JRE目录/lib/security/cacerts` 文件：  
    ```sh
    keytool -importcert -file cacert.pem -keystore JRE目录/lib/security/cacerts -deststoretype JKS -storepass changeit -alias xugu-root-ca
    ```

### 驱动环境

Java 驱动应提供连接串参数设置以下属性：

- SSL模式：
    - `nssl`：不开启连接加密
    - `ssl`：虚谷自有 SSL 协议
    - `tls`：标准 TLS 协议
- keyStore 与 trustStore 位置、类型、密码  
    若用户连接串未设置，可从以下系统属性获取：
    ```properties
    javax.net.ssl.keyStore=$USER_HOME/.keystore
    javax.net.ssl.keyStoreType=JKS
    javax.net.ssl.keyStorePassword=changeit
    javax.net.ssl.trustStore=$JAVA_HOME/lib/security/cacerts
    javax.net.ssl.trustStoreType=JKS
    javax.net.ssl.trustStorePassword=changeit
    ```
- CRL 证书吊销清单文件路径（可为空）