#!/bin/bash
function error() {
    echo "执行失败，请查看上方执行日志！"
    exit 1
}

USER_HOME="/home/username"
JAVA_HOME="/usr/lib/jvm/jdk/jre"
WORK_DIR="./demoCA"

KEY_STORE_FILE="$USER_HOME/.keystore"
KEY_STORE_PASS="changeit"
KEY_STORE_TYPE="PKCS12"
TRUST_STORE_FILE="$JAVA_HOME/bin/security/cacerts"
TRUST_STORE_PASS="changeit"
TRUST_STORE_TYPE="JKS"

CA_ALIAS="xugu-root-ca"
CA_PKCS12_FILE="$WORK_DIR/ca.p12"
CA_PKCS12_PASS="changeit"
CA_KEY_FILE="$WORK_DIR/cakey.pem"
CA_KEY_PASS="changeit"
CA_CRT_FILE="$WORK_DIR/cacert.pem"
CA_SUBJ="C=CN, ST=Sichuan, L=Chengdu, O=Chengdu Xugu Weiye Technology CO.\, Ltd, OU=Development, CN=Xugu Root CA"

DATABASE_ALIAS="xugu-database"
DATABASE_KEY_PASS="changeit"
DATABASE_PKCS12_FILE="$WORK_DIR/database.p12"
DATABASE_PKCS12_PASS=changeit
DATABASE_KEY_FILE="$WORK_DIR/database.key"
DATABASE_CSR_FILE="$WORK_DIR/database.csr"
DATABASE_CRT_FILE="$WORK_DIR/database.crt"
DATABASE_SUBJ="C=CN, ST=Sichuan, L=Chengdu, O=Chengdu Xugu Weiye Technology CO.\, Ltd, OU=Development, CN=Xugu Database"

DRIVER_ALIAS="xugu-driver"
DRIVER_KEY_PASS="changeit"
DRIVER_PKCS12_FILE="$WORK_DIR/driver.p12"
DRIVER_PKCS12_PASS="changeit"
DRIVER_KEY_FILE="$WORK_DIR/driver.key"
DRIVER_CSR_FILE="$WORK_DIR/driver.csr"
DRIVER_CRT_FILE="$WORK_DIR/driver.crt"
DRIVER_SUBJ="C=CN, ST=Sichuan, L=Chengdu, O=Chengdu Xugu Weiye Technology CO.\, Ltd, OU=Development, CN=Xugu Driver"

if test ! -e $WORK_DIR; then mkdir $WORK_DIR; fi

echo "======== 注意事项 ========"
echo
echo "使用 KeyStore 文件：$KEY_STORE_FILE"
echo "使用 TrustStore 文件：$TRUST_STORE_FILE"
echo
echo "======== 证书颁发机构 ========"
echo
keytool -genkeypair -alias $CA_ALIAS -keyalg RSA -keysize 2048 -dname "$CA_SUBJ" -ext bc:c -validity 11688 -keypass $CA_KEY_PASS -keystore $KEY_STORE_FILE -storepass $KEY_STORE_PASS -storetype $KEY_STORE_TYPE -v || error
keytool -exportcert -alias $CA_ALIAS -file $CA_CRT_FILE -keystore $KEY_STORE_FILE -storetype $KEY_STORE_TYPE -storepass $KEY_STORE_PASS -v || error
echo
echo "======== 数据库 ========"
echo 
keytool -genkeypair -alias $DATABASE_ALIAS -keyalg RSA -keysize 2048 -dname "$DATABASE_SUBJ" -ext bc:c=ca:false -validity 4383 -keypass $DATABASE_KEY_PASS -keystore $KEY_STORE_FILE -storepass $KEY_STORE_PASS -storetype $KEY_STORE_TYPE -v || error
keytool -certreq -alias $DATABASE_ALIAS -file $DATABASE_CSR_FILE -keypass $DATABASE_KEY_PASS -keystore $KEY_STORE_FILE -storetype $KEY_STORE_TYPE -storepass $KEY_STORE_PASS -v || error
keytool -gencert -infile $DATABASE_CSR_FILE -outfile $DATABASE_CRT_FILE -alias $CA_ALIAS -ext bc:c=ca:false -keypass $DATABASE_KEY_PASS -keystore $KEY_STORE_FILE -storepass $KEY_STORE_PASS -storetype $KEY_STORE_TYPE -v || error
echo
echo "======== 驱动 ========"
echo
keytool -genkeypair -alias $DRIVER_ALIAS -keyalg RSA -keysize 2048 -dname "$DRIVER_SUBJ" -ext bc:c=ca:false -validity 4383 -keypass $DRIVER_KEY_PASS -keystore $KEY_STORE_FILE -storepass $KEY_STORE_PASS -storetype $KEY_STORE_TYPE -v || error
keytool -certreq -alias $DRIVER_ALIAS -file $DRIVER_CSR_FILE -keypass $DRIVER_KEY_PASS -keystore $KEY_STORE_FILE -storetype $KEY_STORE_TYPE -storepass $KEY_STORE_PASS -v || error
keytool -gencert -infile $DRIVER_CSR_FILE -outfile $DRIVER_CRT_FILE -alias $CA_ALIAS -ext bc:c=ca:false -keypass $DRIVER_KEY_PASS -keystore $KEY_STORE_FILE -storepass $KEY_STORE_PASS -storetype $KEY_STORE_TYPE -v || error
echo
echo "======== 私钥 ========"
echo
openssl version
if [ $? -ne 0 ]; then
    echo 脚本执行成功，由于未安装 OpenSSL 命令行，已跳过私钥文件生成。
    goto :EOF
fi
keytool -importkeystore -srckeystore $KEY_STORE_FILE -srcstoretype $KEY_STORE_TYPE -srcstorepass $KEY_STORE_PASS -srcalias $CA_ALIAS -destkeystore $CA_PKCS12_FILE -deststoretype PKCS12 -deststorepass $CA_PKCS12_PASS || error
openssl pkcs12 -in $CA_PKCS12_FILE -password pass:$CA_PKCS12_PASS -nocerts -nodes -out $CA_KEY_FILE || error
keytool -importkeystore -srckeystore $KEY_STORE_FILE -srcstoretype $KEY_STORE_TYPE -srcstorepass $KEY_STORE_PASS -srcalias $DATABASE_ALIAS -destkeystore $DATABASE_PKCS12_FILE -deststoretype PKCS12 -deststorepass $DATABASE_PKCS12_PASS || error
openssl pkcs12 -in $DATABASE_PKCS12_FILE -password pass:$DATABASE_PKCS12_PASS -nocerts -nodes -out $DATABASE_KEY_FILE || error
keytool -importkeystore -srckeystore $KEY_STORE_FILE -srcstoretype $KEY_STORE_TYPE -srcstorepass $KEY_STORE_PASS -srcalias $DRIVER_ALIAS -destkeystore $DRIVER_PKCS12_FILE -deststoretype PKCS12 -deststorepass $DRIVER_PKCS12_PASS || error
openssl pkcs12 -in $DRIVER_PKCS12_FILE -password pass:$DRIVER_PKCS12_PASS -nocerts -nodes -out $DRIVER_KEY_FILE || error
echo
echo "脚本执行成功，相关文件已生成。"
exit 0