/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.log4j.Logger;

public class jTPCCTerminal
implements jTPCCConfig,
Runnable {
    private static Logger log = Logger.getLogger(jTPCCTerminal.class);
    private String terminalName;
    private Connection conn = null;
    private Statement stmt = null;
    private Statement stmt1 = null;
    private ResultSet rs = null;
    private int terminalWarehouseID;
    private int terminalDistrictID;
    private int paymentWeight;
    private int orderStatusWeight;
    private int deliveryWeight;
    private int stockLevelWeight;
    private int limPerMin_Terminal;
    private jTPCC parent;
    private Random gen;
    private int transactionCount = 1;
    private int numTransactions;
    private int numWarehouses;
    private int newOrderCounter;
    private long totalTnxs = 1L;
    private StringBuffer query = null;
    private int result = 0;
    private boolean stopRunningSignal = false;
    private PreparedStatement getNewName = null;
    private PreparedStatement stmtGetCustWhse = null;
    private PreparedStatement stmtGetDist = null;
    private PreparedStatement stmtInsertNewOrder = null;
    private PreparedStatement stmtUpdateDist = null;
    private PreparedStatement stmtInsertOOrder = null;
    private PreparedStatement stmtGetItem = null;
    private PreparedStatement stmtGetStock = null;
    private PreparedStatement stmtUpdateStock = null;
    private PreparedStatement stmtInsertOrderLine = null;
    private PreparedStatement payUpdateWhse = null;
    private PreparedStatement payGetWhse = null;
    private PreparedStatement payUpdateDist = null;
    private PreparedStatement payGetDist = null;
    private PreparedStatement payCountCust = null;
    private PreparedStatement payCursorCustByName = null;
    private PreparedStatement payGetCust = null;
    private PreparedStatement payGetCustCdata = null;
    private PreparedStatement payUpdateCustBalCdata = null;
    private PreparedStatement payUpdateCustBal = null;
    private PreparedStatement payInsertHist = null;
    private PreparedStatement ordStatCountCust = null;
    private PreparedStatement ordStatGetCust = null;
    private PreparedStatement ordStatGetNewestOrd = null;
    private PreparedStatement ordStatGetCustBal = null;
    private PreparedStatement ordStatGetOrder = null;
    private PreparedStatement ordStatGetOrderLines = null;
    private PreparedStatement delivGetOrderId = null;
    private PreparedStatement delivDeleteNewOrder = null;
    private PreparedStatement delivGetCustId = null;
    private PreparedStatement delivUpdateCarrierId = null;
    private PreparedStatement delivUpdateDeliveryDate = null;
    private PreparedStatement delivSumOrderAmount = null;
    private PreparedStatement delivUpdateCustBalDelivCnt = null;
    private PreparedStatement stockGetDistOrderId = null;
    private PreparedStatement stockGetCountStock = null;
    private CallableStatement deliveryCS = null;
    private CallableStatement ordStatCS = null;
    private CallableStatement stockGetCS = null;
    private CallableStatement payCS = null;
    private CallableStatement newOrderCS = null;
    long terminalStartTime = 0L;
    long transactionEnd = 0L;

    public jTPCCTerminal(String terminalName, int terminalWarehouseID, int terminalDistrictID, Connection conn, int numTransactions, int paymentWeight, int orderStatusWeight, int deliveryWeight, int stockLevelWeight, int numWarehouses, int limPerMin_Terminal, jTPCC parent) throws SQLException {
        this.terminalName = terminalName;
        this.conn = conn;
        this.stmt = conn.createStatement();
        this.stmt.setMaxRows(200);
        this.stmt.setFetchSize(100);
        this.stmt1 = conn.createStatement();
        this.stmt1.setMaxRows(1);
        this.terminalWarehouseID = terminalWarehouseID;
        this.terminalDistrictID = terminalDistrictID;
        this.parent = parent;
        this.numTransactions = numTransactions;
        this.paymentWeight = paymentWeight;
        this.orderStatusWeight = orderStatusWeight;
        this.deliveryWeight = deliveryWeight;
        this.stockLevelWeight = stockLevelWeight;
        this.numWarehouses = numWarehouses;
        this.newOrderCounter = 0;
        this.limPerMin_Terminal = limPerMin_Terminal;
        this.terminalMessage("");
        this.terminalMessage("Terminal '" + terminalName + "' has WarehouseID=" + terminalWarehouseID + " and DistrictID=" + terminalDistrictID + ".");
        this.terminalStartTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.gen = new Random(System.currentTimeMillis() * (long)this.conn.hashCode());
        this.executeTransactions(this.numTransactions);
        try {
            this.printMessage("");
            this.printMessage("Closing statement and connection...");
            this.stmt.close();
            this.conn.close();
        }
        catch (Exception e) {
            this.printMessage("");
            this.printMessage("An error occurred!");
            this.logException(e);
        }
        this.printMessage("");
        this.printMessage("Terminal '" + this.terminalName + "' finished after " + (this.transactionCount - 1) + " transaction(s).");
        this.parent.signalTerminalEnded(this, this.newOrderCounter);
    }

    public void stopRunningWhenPossible() {
        this.stopRunningSignal = true;
        this.printMessage("");
        this.printMessage("Terminal received stop signal!");
        this.printMessage("Finishing current transaction before exit...");
    }

    private void executeTransactions(int numTransactions) {
        boolean stopRunning = false;
        if (numTransactions != -1) {
            this.printMessage("Executing " + numTransactions + " transactions...");
        } else {
            this.printMessage("Executing for a limited time...");
        }
        for (int i = 0; !(i >= numTransactions && numTransactions != -1 || stopRunning); ++i) {
            long timePerTx;
            long elapse;
            String transactionTypeName;
            long transactionType = jTPCCUtil.randomNumber(1, 100, this.gen);
            int skippedDeliveries = 0;
            int newOrder = 0;
            long transactionStart = System.currentTimeMillis();
            if (transactionType <= (long)this.paymentWeight) {
                this.executeTransaction(2);
                transactionTypeName = "Payment";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight)) {
                this.executeTransaction(5);
                transactionTypeName = "Stock-Level";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight + this.orderStatusWeight)) {
                this.executeTransaction(3);
                transactionTypeName = "Order-Status";
            } else if (transactionType <= (long)(this.paymentWeight + this.stockLevelWeight + this.orderStatusWeight + this.deliveryWeight)) {
                skippedDeliveries = this.executeTransaction(4);
                transactionTypeName = "Delivery";
            } else {
                this.executeTransaction(1);
                transactionTypeName = "New-Order";
                ++this.newOrderCounter;
                newOrder = 1;
            }
            long transactionEnd = System.currentTimeMillis();
            if (!transactionTypeName.equals("Delivery")) {
                this.parent.signalTerminalEndedTransaction(this.terminalName, transactionTypeName, transactionEnd - transactionStart, null, newOrder);
            } else {
                this.parent.signalTerminalEndedTransaction(this.terminalName, transactionTypeName, transactionEnd - transactionStart, skippedDeliveries == 0 ? "None" : "" + skippedDeliveries + " delivery(ies) skipped.", newOrder);
            }
            if (this.limPerMin_Terminal > 0 && (elapse = transactionEnd - transactionStart) < (timePerTx = (long)(60000 / this.limPerMin_Terminal))) {
                try {
                    long sleepTime = timePerTx - elapse;
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.stopRunningSignal) continue;
            stopRunning = true;
        }
    }

    private int executeTransaction(int transaction) {
        int result = 0;
        switch (transaction) {
            case 1: {
                int districtID = jTPCCUtil.randomNumber(1, 10, this.gen);
                int customerID = jTPCCUtil.getCustomerID(this.gen);
                int numItems = jTPCCUtil.randomNumber(5, 15, this.gen);
                int[] itemIDs = new int[numItems];
                int[] supplierWarehouseIDs = new int[numItems];
                int[] orderQuantities = new int[numItems];
                int allLocal = 1;
                for (int i = 0; i < numItems; ++i) {
                    itemIDs[i] = jTPCCUtil.getItemID(this.gen);
                    if (jTPCCUtil.randomNumber(1, 100, this.gen) > 1) {
                        supplierWarehouseIDs[i] = this.terminalWarehouseID;
                    } else {
                        do {
                            supplierWarehouseIDs[i] = jTPCCUtil.randomNumber(1, this.numWarehouses, this.gen);
                        } while (supplierWarehouseIDs[i] == this.terminalWarehouseID && this.numWarehouses > 1);
                        allLocal = 0;
                    }
                    orderQuantities[i] = jTPCCUtil.randomNumber(1, 10, this.gen);
                }
                if (jTPCCUtil.randomNumber(1, 100, this.gen) == 1) {
                    itemIDs[numItems - 1] = -12345;
                }
                this.terminalMessage("");
                this.terminalMessage("Starting txn:" + this.terminalName + ":" + this.transactionCount + " (New-Order)");
                this.newOrderTransaction(this.terminalWarehouseID, districtID, customerID, numItems, allLocal, itemIDs, supplierWarehouseIDs, orderQuantities);
                break;
            }
            case 2: {
                int customerWarehouseID;
                int customerDistrictID;
                int districtID = jTPCCUtil.randomNumber(1, 10, this.gen);
                int x = jTPCCUtil.randomNumber(1, 100, this.gen);
                if (x <= 85) {
                    customerDistrictID = districtID;
                    customerWarehouseID = this.terminalWarehouseID;
                } else {
                    customerDistrictID = jTPCCUtil.randomNumber(1, 10, this.gen);
                    while ((customerWarehouseID = jTPCCUtil.randomNumber(1, this.numWarehouses, this.gen)) == this.terminalWarehouseID && this.numWarehouses > 1) {
                    }
                }
                int y = jTPCCUtil.randomNumber(1, 100, this.gen);
                boolean customerByName = false;
                String customerLastName = null;
                int customerID = -1;
                if (y <= 60) {
                    customerByName = true;
                    customerLastName = jTPCCUtil.getLastName(this.gen);
                    this.printMessage("Last name lookup = " + customerLastName);
                } else {
                    customerByName = false;
                    customerID = jTPCCUtil.getCustomerID(this.gen);
                }
                customerByName = false;
                customerID = jTPCCUtil.getCustomerID(this.gen);
                float paymentAmount = (float)((double)jTPCCUtil.randomNumber(100, 500000, this.gen) / 100.0);
                this.terminalMessage("");
                this.terminalMessage("Starting transaction #" + this.transactionCount + " (Payment)...");
                this.paymentTransaction(this.terminalWarehouseID, customerWarehouseID, paymentAmount, districtID, customerDistrictID, customerID, customerLastName, customerByName);
                break;
            }
            case 5: {
                int threshold = jTPCCUtil.randomNumber(10, 20, this.gen);
                this.terminalMessage("");
                this.terminalMessage("Starting transaction #" + this.transactionCount + " (Stock-Level)...");
                this.stockLevelTransaction(this.terminalWarehouseID, this.terminalDistrictID, threshold);
                break;
            }
            case 3: {
                int districtID = jTPCCUtil.randomNumber(1, 10, this.gen);
                int y = jTPCCUtil.randomNumber(1, 100, this.gen);
                boolean customerByName = false;
                String customerLastName = null;
                int customerID = -1;
                customerID = jTPCCUtil.getCustomerID(this.gen);
                customerByName = false;
                this.terminalMessage("");
                this.terminalMessage("Starting transaction #" + this.transactionCount + " (Order-Status)...");
                this.orderStatusTransaction(this.terminalWarehouseID, districtID, customerID, customerLastName, customerByName);
                break;
            }
            case 4: {
                int orderCarrierID = jTPCCUtil.randomNumber(1, 10, this.gen);
                this.terminalMessage("");
                this.terminalMessage("Starting transaction #" + this.transactionCount + " (Delivery)...");
                result = this.deliveryTransaction(this.terminalWarehouseID, orderCarrierID);
                break;
            }
            default: {
                this.error("EMPTY-TYPE");
            }
        }
        ++this.transactionCount;
        return result;
    }

    private int deliveryTransaction(int w_id, int o_carrier_id) {
        int ret = 0;
        try {
            if (this.deliveryCS == null) {
                this.deliveryCS = this.conn.prepareCall("call TPCC_DELIVERY(?,?,?)");
            }
            this.deliveryCS.setInt(1, w_id);
            this.deliveryCS.setInt(2, o_carrier_id);
            this.deliveryCS.registerOutParameter(3, 4);
            this.deliveryCS.execute();
            ret = this.deliveryCS.getInt(3);
        }
        catch (Exception e) {
            try {
                this.deliveryCS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.deliveryCS = null;
            this.error("DELIVERY");
            this.logException(e);
        }
        return ret;
    }

    private int orderStatusTransaction(int w_id, int d_id, int c_id, String c_last, boolean c_by_name) {
        int ret = 0;
        try {
            if (this.ordStatCS == null) {
                this.ordStatCS = this.conn.prepareCall("call TPCC_ORDSTAT(?,?,?,?,?,?)");
            }
            this.ordStatCS.setInt(1, c_id);
            this.ordStatCS.setInt(2, w_id);
            this.ordStatCS.setInt(3, d_id);
            this.ordStatCS.setString(4, c_last);
            this.ordStatCS.setInt(5, c_by_name ? 1 : 0);
            this.ordStatCS.registerOutParameter(6, 4);
            this.ordStatCS.execute();
            ret = this.ordStatCS.getInt(6);
        }
        catch (Exception e) {
            try {
                this.ordStatCS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ordStatCS = null;
            this.error("ORDER-STATUS");
            this.logException(e);
        }
        return ret;
    }

    private int newOrderTransaction(int w_id, int d_id, int c_id, int o_ol_cnt, int o_all_local, int[] itemIDs, int[] supplierWarehouseIDs, int[] orderQuantities) {
        int ret = 0;
        try {
            int i;
            if (this.newOrderCS == null) {
                this.newOrderCS = this.conn.prepareCall("call TPCC_NEWORDER(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            }
            this.newOrderCS.setInt(1, w_id);
            this.newOrderCS.setInt(2, d_id);
            this.newOrderCS.setInt(3, c_id);
            this.newOrderCS.setInt(4, o_ol_cnt);
            int idx = 5;
            for (i = 0; i < 15; ++i) {
                if (i < o_ol_cnt) {
                    this.newOrderCS.setInt(idx++, itemIDs[0]);
                    continue;
                }
                this.newOrderCS.setInt(idx++, 0);
            }
            for (i = 0; i < 15; ++i) {
                if (i < o_ol_cnt) {
                    this.newOrderCS.setInt(idx++, supplierWarehouseIDs[0]);
                    continue;
                }
                this.newOrderCS.setInt(idx++, 0);
            }
            for (i = 0; i < 15; ++i) {
                if (i < o_ol_cnt) {
                    this.newOrderCS.setInt(idx++, orderQuantities[0]);
                    continue;
                }
                this.newOrderCS.setInt(idx++, 0);
            }
            this.newOrderCS.setInt(idx, o_all_local);
            this.newOrderCS.registerOutParameter(51, 4);
            this.newOrderCS.execute();
            ret = this.newOrderCS.getInt(51);
        }
        catch (SQLException ex) {
            try {
                this.newOrderCS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.newOrderCS = null;
            this.error("NEW-ORDER-ROLLBACK");
            this.logException(ex);
        }
        return ret;
    }

    private int stockLevelTransaction(int w_id, int d_id, int threshold) {
        int ret = 0;
        try {
            if (this.stockGetCS == null) {
                this.stockGetCS = this.conn.prepareCall("call TPCC_STOCKLEVEL(?,?,?,?)");
            }
            this.stockGetCS.setInt(1, w_id);
            this.stockGetCS.setInt(2, d_id);
            this.stockGetCS.setInt(3, threshold);
            this.stockGetCS.registerOutParameter(4, 4);
            this.stockGetCS.execute();
            ret = this.stockGetCS.getInt(4);
        }
        catch (Exception e) {
            try {
                this.stockGetCS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.stockGetCS = null;
            this.error("STOCK-LEVEL");
            this.logException(e);
        }
        return ret;
    }

    private int paymentTransaction(int w_id, int c_w_id, float h_amount, int d_id, int c_d_id, int c_id, String c_last, boolean c_by_name) {
        int ret = 0;
        try {
            if (this.payCS == null) {
                this.payCS = this.conn.prepareCall("call TPCC_PAYMENT(?,?,?,?,?,?,?,?,?)");
            }
            this.payCS.setInt(1, w_id);
            this.payCS.setInt(2, d_id);
            this.payCS.setInt(3, c_id);
            this.payCS.setInt(4, c_w_id);
            this.payCS.setInt(5, c_d_id);
            this.payCS.setString(6, c_last);
            this.payCS.setFloat(7, h_amount);
            this.payCS.setInt(8, c_by_name ? 1 : 0);
            this.payCS.registerOutParameter(9, 4);
            this.payCS.execute();
            ret = this.payCS.getInt(9);
            this.payCS.clearParameters();
        }
        catch (Exception e) {
            try {
                this.payCS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.payCS = null;
            this.error("PAYMENT");
            this.logException(e);
        }
        return ret;
    }

    private void error(String type) {
        log.error((Object)(this.terminalName + ", TERMINAL=" + this.terminalName + "  TYPE=" + type + "  COUNT=" + this.transactionCount));
        System.out.println(this.terminalName + ", TERMINAL=" + this.terminalName + "  TYPE=" + type + "  COUNT=" + this.transactionCount);
    }

    private void logException(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.close();
        log.error((Object)stringWriter.toString());
    }

    private void terminalMessage(String message) {
        log.trace((Object)(this.terminalName + ", " + message));
    }

    private void printMessage(String message) {
        log.trace((Object)(this.terminalName + ", " + message));
    }

    void transRollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage());
        }
    }

    void transCommit() {
        try {
            this.conn.commit();
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage());
            this.transRollback();
        }
    }
}

