/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class jTPCC
implements jTPCCConfig {
    private static Logger log = Logger.getLogger(jTPCC.class);
    private int currentlyDisplayedTerminal;
    private jTPCCTerminal[] terminals;
    private String[] terminalNames;
    private boolean terminalsBlockingExit = false;
    private Random random;
    private long terminalsStarted = 0L;
    private long sessionCount = 0L;
    private long transactionCount;
    private long newOrderCounter;
    private long sessionStartTimestamp;
    private long sessionEndTimestamp;
    private long sessionNextTimestamp = 0L;
    private long sessionNextKounter = 0L;
    private long sessionEndTargetTime = -1L;
    private long fastNewOrderCounter;
    private long recentTpmC = 0L;
    private long recentTpmTotal = 0L;
    private boolean signalTerminalsRequestEndSent = false;
    private boolean databaseDriverLoaded = false;
    private FileOutputStream fileOutputStream;
    private PrintStream printStreamReport;
    private String sessionStart;
    private String sessionEnd;
    private int limPerMin_Terminal;
    private double tpmC;

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"log4j.xml");
        new jTPCC();
    }

    private String getProp(Properties p, String pName) {
        String prop = p.getProperty(pName);
        log.info((Object)("Term-00, " + pName + "=" + prop));
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public jTPCC() {
        Properties ini = new Properties();
        try {
            ini.load(new FileInputStream(System.getProperty("prop")));
        }
        catch (IOException e) {
            this.errorMessage("Term-00, could not load properties file");
        }
        log.info((Object)"Term-00, ");
        log.info((Object)"Term-00, +-------------------------------------------------------------+");
        log.info((Object)"Term-00,      BenchmarkSQL v4.1.1");
        log.info((Object)"Term-00, +-------------------------------------------------------------+");
        log.info((Object)"Term-00,  (c) 2003, Raul Barbosa");
        log.info((Object)"Term-00,  (c) 2004-2016, Denis Lussier");
        log.info((Object)"Term-00,  (c) 2016, Jan Wieck");
        log.info((Object)"Term-00, +-------------------------------------------------------------+");
        log.info((Object)"Term-00, ");
        String iDriver = this.getProp(ini, "driver");
        String iConn = this.getProp(ini, "conn");
        String iUser = this.getProp(ini, "user");
        String iPassword = ini.getProperty("password");
        log.info((Object)"Term-00, ");
        String iWarehouses = this.getProp(ini, "warehouses");
        String iTerminals = this.getProp(ini, "terminals");
        String iRunTxnsPerTerminal = ini.getProperty("runTxnsPerTerminal");
        String iRunMins = ini.getProperty("runMins");
        if (Integer.parseInt(iRunTxnsPerTerminal) == 0 && Integer.parseInt(iRunMins) != 0) {
            log.info((Object)("Term-00, runMins=" + iRunMins));
        } else if (Integer.parseInt(iRunTxnsPerTerminal) != 0 && Integer.parseInt(iRunMins) == 0) {
            log.info((Object)("Term-00, runTxnsPerTerminal=" + iRunTxnsPerTerminal));
        } else {
            this.errorMessage("Term-00, Must indicate either transactions per terminal or number of run minutes!");
        }
        String limPerMin = this.getProp(ini, "limitTxnsPerMin");
        log.info((Object)"Term-00, ");
        String iNewOrderWeight = this.getProp(ini, "newOrderWeight");
        String iPaymentWeight = this.getProp(ini, "paymentWeight");
        String iOrderStatusWeight = this.getProp(ini, "orderStatusWeight");
        String iDeliveryWeight = this.getProp(ini, "deliveryWeight");
        String iStockLevelWeight = this.getProp(ini, "stockLevelWeight");
        log.info((Object)"Term-00, ");
        this.limPerMin_Terminal = Integer.parseInt(limPerMin) != 0 ? Integer.parseInt(limPerMin) / Integer.parseInt(iTerminals) : -1;
        boolean iRunMinsBool = false;
        this.random = new Random(System.currentTimeMillis());
        this.fastNewOrderCounter = 0L;
        this.updateStatusLine();
        try {
            String driver = iDriver;
            this.printMessage("Loading database driver: '" + driver + "'...");
            Class.forName(iDriver);
            this.databaseDriverLoaded = true;
        }
        catch (Exception ex) {
            this.errorMessage("Unable to load the database driver!");
            this.databaseDriverLoaded = false;
        }
        if (this.databaseDriverLoaded) {
            try {
                long executionTimeMillis;
                int stockLevelWeightValue;
                int deliveryWeightValue;
                int orderStatusWeightValue;
                int paymentWeightValue;
                int newOrderWeightValue;
                int numWarehouses;
                int transactionsPerTerminal;
                int numTerminals;
                boolean limitIsTime;
                block47: {
                    limitIsTime = iRunMinsBool;
                    numTerminals = -1;
                    transactionsPerTerminal = -1;
                    numWarehouses = -1;
                    newOrderWeightValue = -1;
                    paymentWeightValue = -1;
                    orderStatusWeightValue = -1;
                    deliveryWeightValue = -1;
                    stockLevelWeightValue = -1;
                    executionTimeMillis = -1L;
                    try {
                        if (Integer.parseInt(iRunMins) != 0 && Integer.parseInt(iRunTxnsPerTerminal) == 0) {
                            iRunMinsBool = true;
                        } else {
                            if (Integer.parseInt(iRunMins) != 0) throw new NumberFormatException();
                            if (Integer.parseInt(iRunTxnsPerTerminal) == 0) throw new NumberFormatException();
                            iRunMinsBool = false;
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Must indicate either transactions per terminal or number of run minutes!");
                        throw new Exception();
                    }
                    try {
                        numWarehouses = Integer.parseInt(iWarehouses);
                        if (numWarehouses <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number of warehouses!");
                        throw new Exception();
                    }
                    try {
                        numTerminals = Integer.parseInt(iTerminals);
                        if (numTerminals <= 0) throw new NumberFormatException();
                        if (numTerminals > 10 * numWarehouses) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number of terminals!");
                        throw new Exception();
                    }
                    if (Long.parseLong(iRunMins) != 0L && Integer.parseInt(iRunTxnsPerTerminal) == 0) {
                        try {
                            executionTimeMillis = Long.parseLong(iRunMins) * 60000L;
                            if (executionTimeMillis <= 0L) {
                                throw new NumberFormatException();
                            }
                            break block47;
                        }
                        catch (NumberFormatException e1) {
                            this.errorMessage("Invalid number of minutes!");
                            throw new Exception();
                        }
                    }
                    try {
                        transactionsPerTerminal = Integer.parseInt(iRunTxnsPerTerminal);
                        if (transactionsPerTerminal <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number of transactions per terminal!");
                        throw new Exception();
                    }
                }
                try {
                    newOrderWeightValue = Integer.parseInt(iNewOrderWeight);
                    paymentWeightValue = Integer.parseInt(iPaymentWeight);
                    orderStatusWeightValue = Integer.parseInt(iOrderStatusWeight);
                    deliveryWeightValue = Integer.parseInt(iDeliveryWeight);
                    stockLevelWeightValue = Integer.parseInt(iStockLevelWeight);
                    if (newOrderWeightValue < 0) throw new NumberFormatException();
                    if (paymentWeightValue < 0) throw new NumberFormatException();
                    if (orderStatusWeightValue < 0) throw new NumberFormatException();
                    if (deliveryWeightValue < 0) throw new NumberFormatException();
                    if (stockLevelWeightValue < 0) {
                        throw new NumberFormatException();
                    }
                    if (newOrderWeightValue == 0 && paymentWeightValue == 0 && orderStatusWeightValue == 0 && deliveryWeightValue == 0 && stockLevelWeightValue == 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e1) {
                    this.errorMessage("Invalid number in mix percentage!");
                    throw new Exception();
                }
                if (newOrderWeightValue + paymentWeightValue + orderStatusWeightValue + deliveryWeightValue + stockLevelWeightValue > 100) {
                    this.errorMessage("Sum of mix percentage parameters exceeds 100%!");
                    throw new Exception();
                }
                this.newOrderCounter = 0L;
                this.printMessage("Session started!");
                if (!limitIsTime) {
                    this.printMessage("Creating " + numTerminals + " terminal(s) with " + transactionsPerTerminal + " transaction(s) per terminal...");
                } else {
                    this.printMessage("Creating " + numTerminals + " terminal(s) with " + executionTimeMillis / 60000L + " minute(s) of execution...");
                }
                this.printMessage("Transaction Weights: " + newOrderWeightValue + "% New-Order, " + paymentWeightValue + "% Payment, " + orderStatusWeightValue + "% Order-Status, " + deliveryWeightValue + "% Delivery, " + stockLevelWeightValue + "% Stock-Level");
                this.printMessage("Number of Terminals\t" + numTerminals);
                this.terminals = new jTPCCTerminal[numTerminals];
                this.terminalNames = new String[numTerminals];
                this.terminalsStarted = numTerminals;
                try {
                    int i;
                    String database = iConn;
                    String username = iUser;
                    String password = iPassword;
                    int[][] usedTerminals = new int[numWarehouses][10];
                    for (i = 0; i < numWarehouses; ++i) {
                        for (int j = 0; j < 10; ++j) {
                            usedTerminals[i][j] = 0;
                        }
                    }
                    for (i = 0; i < numTerminals; ++i) {
                        jTPCCTerminal terminal;
                        int terminalDistrictID;
                        int terminalWarehouseID = i % numWarehouses + 1;
                        while (usedTerminals[terminalWarehouseID - 1][(terminalDistrictID = (int)this.randomNumber(1L, 10L)) - 1] == 1) {
                        }
                        usedTerminals[terminalWarehouseID - 1][terminalDistrictID - 1] = 1;
                        String terminalName = "Term-" + (i >= 9 ? "" + (i + 1) : "0" + (i + 1));
                        Connection conn = null;
                        this.printMessage("Creating database connection for " + terminalName + "...");
                        conn = DriverManager.getConnection(jTPCC.rebuild_conn_str(database, terminalWarehouseID), username, password);
                        conn.setAutoCommit(false);
                        this.terminals[i] = terminal = new jTPCCTerminal(terminalName, terminalWarehouseID, terminalDistrictID, conn, transactionsPerTerminal, paymentWeightValue, orderStatusWeightValue, deliveryWeightValue, stockLevelWeightValue, numWarehouses, this.limPerMin_Terminal, this);
                        this.terminalNames[i] = terminalName;
                        this.printMessage(terminalName + "\t" + terminalWarehouseID);
                    }
                    this.sessionEndTargetTime = executionTimeMillis;
                    this.signalTerminalsRequestEndSent = false;
                    this.printMessage("Transaction\tWeight");
                    this.printMessage("% New-Order\t" + newOrderWeightValue);
                    this.printMessage("% Payment\t" + paymentWeightValue);
                    this.printMessage("% Order-Status\t" + orderStatusWeightValue);
                    this.printMessage("% Delivery\t" + deliveryWeightValue);
                    this.printMessage("% Stock-Level\t" + stockLevelWeightValue);
                    this.printMessage("Transaction Number\tTerminal\tType\tExecution Time (ms)\t\tComment");
                    this.printMessage("Created " + numTerminals + " terminal(s) successfully!");
                    boolean dummvar = true;
                    if (dummvar) {
                        this.sessionStart = this.getCurrentTime();
                        this.sessionNextTimestamp = this.sessionStartTimestamp = System.currentTimeMillis();
                        if (this.sessionEndTargetTime != -1L) {
                            this.sessionEndTargetTime += this.sessionStartTimestamp;
                        }
                        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
                        // MONITORENTER : this.terminals
                        this.printMessage("Starting all terminals...");
                        this.transactionCount = 1L;
                        for (int i2 = 0; i2 < this.terminals.length; ++i2) {
                            new Thread(this.terminals[i2]).start();
                        }
                        // MONITOREXIT : jTPCCTerminalArray
                        this.printMessage("All terminals started executing " + this.sessionStart);
                    }
                }
                catch (Exception e1) {
                    this.errorMessage("This session ended with errors!");
                    this.printStreamReport.close();
                    this.fileOutputStream.close();
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateStatusLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalTerminalsRequestEnd(boolean timeTriggered) {
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            if (!this.signalTerminalsRequestEndSent) {
                if (timeTriggered) {
                    this.printMessage("The time limit has been reached.");
                }
                this.printMessage("Signalling all terminals to stop...");
                this.signalTerminalsRequestEndSent = true;
                for (int i = 0; i < this.terminals.length; ++i) {
                    if (this.terminals[i] == null) continue;
                    this.terminals[i].stopRunningWhenPossible();
                }
                this.printMessage("Waiting for all active transactions to end...");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTerminalEnded(jTPCCTerminal terminal, long countNewOrdersExecuted) {
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            boolean found = false;
            --this.terminalsStarted;
            for (int i = 0; i < this.terminals.length && !found; ++i) {
                if (this.terminals[i] != terminal) continue;
                this.terminals[i] = null;
                this.terminalNames[i] = "(" + this.terminalNames[i] + ")";
                this.newOrderCounter += countNewOrdersExecuted;
                found = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.terminalsStarted == 0L) {
                this.sessionEnd = this.getCurrentTime();
                this.sessionEndTimestamp = System.currentTimeMillis();
                this.sessionEndTargetTime = -1L;
                this.printMessage("All terminals finished executing " + this.sessionEnd);
                this.endReport();
                this.terminalsBlockingExit = false;
                this.printMessage("Session finished!");
            }
            return;
        }
    }

    public void signalTerminalEndedTransaction(String terminalName, String transactionType, long executionTime, String comment, int newOrder) {
        ++this.transactionCount;
        this.fastNewOrderCounter += (long)newOrder;
        if (this.sessionEndTargetTime != -1L && System.currentTimeMillis() > this.sessionEndTargetTime) {
            this.signalTerminalsRequestEnd(true);
        }
        this.updateStatusLine();
    }

    private void endReport() {
        long currTimeMillis = System.currentTimeMillis();
        long freeMem = Runtime.getRuntime().freeMemory() / 0x100000L;
        long totalMem = Runtime.getRuntime().totalMemory() / 0x100000L;
        double tpmC = (double)(6000000L * this.fastNewOrderCounter / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
        double tpmTotal = (double)(6000000L * this.transactionCount / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
        System.out.println("");
        log.info((Object)"Term-00, ");
        log.info((Object)"Term-00, ");
        log.info((Object)("Term-00, Measured tpmC (NewOrders) = " + tpmC));
        log.info((Object)("Term-00, Measured tpmTOTAL = " + tpmTotal));
        log.info((Object)("Term-00, Session Start     = " + this.sessionStart));
        log.info((Object)("Term-00, Session End       = " + this.sessionEnd));
        log.info((Object)("Term-00, Transaction Count = " + (this.transactionCount - 1L)));
    }

    private void printMessage(String message) {
        log.trace((Object)("Term-00, " + message));
    }

    private void errorMessage(String message) {
        log.error((Object)("Term-00, " + message));
    }

    private void exit() {
        System.exit(0);
    }

    private long randomNumber(long min, long max) {
        return (long)(this.random.nextDouble() * (double)(max - min + 1L) + (double)min);
    }

    private String getCurrentTime() {
        return dateFormat.format(new Date());
    }

    private String getFileNameSuffix() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    private synchronized void updateStatusLine() {
        long currTimeMillis = System.currentTimeMillis();
        if (currTimeMillis > this.sessionNextTimestamp) {
            StringBuilder informativeText = new StringBuilder("");
            Formatter fmt = new Formatter(informativeText);
            double tpmC = (double)(6000000L * this.fastNewOrderCounter / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
            double tpmTotal = (double)(6000000L * this.transactionCount / (currTimeMillis - this.sessionStartTimestamp)) / 100.0;
            this.sessionNextTimestamp += 1000L;
            fmt.format("Term-00, Running Average tpmTOTAL: %.2f", tpmTotal);
            this.recentTpmC = (this.fastNewOrderCounter - this.sessionNextKounter) * 12L;
            this.recentTpmTotal = (this.transactionCount - this.sessionNextKounter) * 12L;
            this.sessionNextKounter = this.fastNewOrderCounter;
            fmt.format("    Current tpmTOTAL: %d", this.recentTpmTotal);
            long freeMem = Runtime.getRuntime().freeMemory() / 0x100000L;
            long totalMem = Runtime.getRuntime().totalMemory() / 0x100000L;
            fmt.format("    Memory Usage: %dMB / %dMB          ", totalMem - freeMem, totalMem);
            System.out.print(informativeText);
            for (int count = 0; count < 1 + informativeText.length(); ++count) {
                System.out.print("\b");
            }
        }
    }

    public static String rebuild_conn_str(String url, int w_id) {
        String conn_url = "";
        boolean off = false;
        Vector<String> set = new Vector<String>();
        conn_url = url.replaceFirst("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:", "%s:").replaceFirst("ips=.*&", "");
        Pattern p = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            set.add(m.group());
        }
        String[] ipv = set.toArray(new String[0]);
        conn_url = String.format(conn_url, ipv[w_id % ipv.length]);
        return conn_url;
    }
}

