<!-- PROJECT LOGO -->
<p align="center">
  <a href="https://github.com/xugu-publish/xugu-jdbc-demo">
    <img src="src/main/resources/images/xugu.jpg" alt="Logo" width="80" height="80">
  </a>

  <h3 align="center">虚谷数据库JDBC标准接口</h3>
  <p align="center">
    <br />
    <a href="https://github.com/xugu-publish/xugu-jdbc-demo">View Demo</a>
    ·
    <a href="https://github.com/xugu-publish/xugu-jdbc-demo/issues">Report Bug</a>
    ·
    <a href="https://github.com/xugu-publish/xugu-jdbc-demo/issues">Request Feature</a>
  </p>
</p>

## 项目简介

JDBC（Java Database Connection）为Java开发者使用数据库提供了统一的编程接口，它由一组Java类和接口组成。是Java程序与数据库通信的标准API。JDBC API使得开发人员可以使用纯Java的方式来连接数 据库，并执行操作.

虚谷数据库JDBC接口基于sun公司JDBC API接口实现，通过此接口可实现与虚谷数据库的访问及操作。

### 开发环境配置
#### 开发工具
| 工具                     | 版本           | 说明                     |
| ------------------------ | ------------- | ------------------------ |
| Eclipse                  | 3.6           | 后端开发工具             |
| IDEA                     | 2019.1.1      | 后端开发工具             |
| Git                      | 2.21.0        | 代码托管平台             |
| Google   Chrome          | 75.0.3770.100 | 浏览器、前端调试工具       |
| Postman                  | 7.1.0         | 接口测试工具              |
| GitLab-ee                | 12.8.1        | 私有源代码管理            |
| FitNesse                 | 20150424      | JDBC测试平台             |
| TeX Live                 | 2019          | LaTex文档编译            |
| TexStudio                | 2.12.14       | LaTex文档开发            |
| 阿里编码规约               | -------       | Java语言编码规范         |
| Statistic                | -------       | 代码数量，注释数量统计     |
| JaCoCo                   | -------       | 单元测试代码覆盖率        |
| Log4j                    | -------       | 日志输出                |
| Maven                    | 3.6.1         | 项目管理                |

### 发布版本
| 版本                     | 日期          | 说明                     |
| ------------------------ | ------------- | ------------------------ |
| cloudjdbc-11.0.8         | 2020.03.××    | 虚谷数据库JDBC标准接口(通用) |
| cloudjdbc-1.3.14         | 2020.03.××    | 虚谷数据库JDBC标准接口(气象) |

### 软件打包
使用maven-jar-plugin插件配置打包信息，主要包体信息如下：

~~~ md
- manifest文件的版本
Manifest-Version: 1.0
- 打包版本名称
Version-Name: cloudjdbc-11.0.8-test
- 打包使用JDK版本
Build-Jdk-Spec: 1.8
- 文件生成者
Created-By: Maven Jar Plugin 3.2.0
- jar文件的签名版本
Specification-Version: 11.0
- 打包时间
Build-Time: 2020-03-18T05:06:32Z
- 扩展实现的标题
Implementation-Title: XuGuJdbcDriver
- 定义扩展实现的版本
Implementation-Version: 11.0.8-test
- 最低SDK版本要求
MinSdkVersion: JDK 1.6
- 扩展规范的标题
Specification-Title: XuGuJdbcDriver
- 主要/核心包体
ApplicationId: com.xugu.cloudjdbc
~~~

## 功能介绍

### 运行环境概述
虚谷数据库JDBC按照JDK1.6设计实现，对java运行环境要求最低版本为jre1.6。

### 访问数据库流程
    1. 导入包
    在程序中包含数据库编程所需的JDBC类。如本项目：cloudjdbc-×.×.×.jar
    2. 注册JDBC驱动程序
    初始化驱动程序，建立与数据库的通信。
    3. 打开一个连接
    使用DriverManager.getConnection()方法来创建一个Connection对象，它代表数据库的物理连接。
    4. 执行一个查询
    使用类型为Statement或PreparedStatement的对象，并提交一个SQL语句到数据库执行查询。
    5. 从结果集中提取数据
    使用ResultSet.getXXX()方法来检索的数据结果。
    6. 清理环境资源
    使用JDBC与数据交互操作数据库中的数据后，应明确地关闭所有的数据库资源以减少资源的浪费。

### JDBC Driver结构图

 ![JDBC Driver结构图](src/main/resources/images/jdbc-struct.png) 

### 组织结构
``` lua
src/main/java
├── com.xugu.common    -- 工具类及通用代码
├──main.java.com.xugu.pool      -- 虚谷数据库JDBC连接池
├── com.xugu.ssl       -- 虚谷数据库JDBC连接加密
└── com.xugu.cloudjdbc -- 虚谷数据库JDBC接口核心

src/main/resources
├── images             -- 虚谷数据库图标
├── CHANGELOG.MD       -- 开发变更日志
├── JdbcErrorCode.txt  -- 内部错误码定义
├── ExecuteInnerSQL.properties        -- 数据库元数据信息获取SQL定义
├── XuguJdbcListenerExample.xml       -- IP负载均衡XML示例文件
└── 虚谷JDBC接口IP地址负载均衡使用说明.md  -- IP负载均衡使用说明

src/main/test
├── test.java.com.xugu.conn      -- JDBC连接接口测试
└── com.xugu.test      -- JDBC接口测试代码
```

### 搭建步骤(IDEA开发工具)
    1. 依据开发工具要求配置开发环境
    
    2. 从源码服务器克隆源码
    
```sh
git clone http://192.168.2.211:8012/xugu-itfs/cloudjdbc.git
```
    3. 导入工程

## 版本控制

使用虚谷伟业技术部《Java项目控制规范》进行版本控制。亦可参照: https://semver.org/lang/zh-CN/ 

## 项目管理

- 源码管理  http://192.168.2.208:8012/xugu-itfs/cloudjdbc.git
- 测试平台  http://192.168.2.208:8086/JDBC
- BUG管理  http://192.168.2.208/zentaopms/www/index.php?m=product&f=browse&productID=30
- 常见问题
- 路线图

