/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.pool;

import com.xugu.cloudjdbc.Connection;
import com.xugu.common.ReplaceEnum;
import com.xugu.pool.ConnectionWrapper;
import com.xugu.pool.MyTaskTimer;
import com.xugu.pool.XgConnectionEvent;
import com.xugu.pool.XgConnectionEventListener;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class XgPooledConnection
implements PooledConnection {
    private int client;
    private int maxConn;
    private int minIdle;
    private long maxWait;
    private String user;
    private String password;
    private String url;
    private static Vector connPool = new Vector();
    private Hashtable listenHash;
    private SQLException sqlE;
    private boolean autoComm;
    protected Vector<StatementEventListener> statementListener;
    private boolean isDirect = false;
    private boolean isReCycle;
    private ConnectionEventListener listener;
    private Timer myTimer = new Timer();
    private ConnectionWrapper xgcw;
    protected java.sql.Connection physicalConn;
    protected java.sql.Connection logicalConn;
    public static final int CONNECTION_CLOSED_EVENT = 1;
    public static final int CONNECTION_ERROR_EVENT = 2;
    Object mutex = new Object();
    private boolean connBlocked = false;

    public XgPooledConnection() {
    }

    public XgPooledConnection(Connection conn, Properties pro) {
        this.xgcw = null;
        this.sqlE = null;
        this.client = 1;
        this.autoComm = true;
        this.physicalConn = conn;
        this.isReCycle = false;
        this.maxConn = pro.getProperty("maxConn") != null ? Integer.parseInt(pro.getProperty("maxConn")) : connPool.capacity();
        this.maxWait = pro.getProperty("maxWaitTime") != null ? (long)Integer.parseInt(pro.getProperty("maxWaitTime")) : 0L;
        this.minIdle = pro.getProperty("minIdle") != null ? Integer.parseInt(pro.getProperty("minIdle")) : 0;
        this.user = pro.getProperty("user");
        this.password = pro.getProperty("password");
        this.url = pro.getProperty("url");
        while (connPool.size() < this.minIdle) {
            try {
                Connection conns = null;
                Class.forName(ReplaceEnum.productDriverName.getReplaceStr());
                if (this.user != null) {
                    conns = (Connection)DriverManager.getConnection(this.url, this.user, this.password);
                    conns.setAutoCommit(this.autoComm);
                } else {
                    conns = (Connection)DriverManager.getConnection(this.url);
                    conns.setAutoCommit(this.autoComm);
                }
                connPool.add(new ConnectionWrapper(this, conns, this.isDirect));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.statementListener = new Vector();
        this.listenHash = new Hashtable(10);
        this.listener = new XgConnectionEventListener(this);
        this.addConnectionEventListener(this.listener);
        this.myTimer.schedule((TimerTask)new MyTaskTimer(connPool), 0L, 5000L);
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.listenHash != null) {
            this.listenHash.put(listener, listener);
        }
    }

    @Override
    public synchronized void addStatementEventListener(StatementEventListener listener) {
        int i = 0;
        while (i < this.statementListener.size()) {
            if (listener.equals(this.statementListener.elementAt(i))) {
                return;
            }
            ++i;
        }
        this.statementListener.add(listener);
    }

    @Override
    public synchronized void close() throws SQLException {
        Enumeration allConnections = connPool.elements();
        while (allConnections.hasMoreElements()) {
            ConnectionWrapper conn = (ConnectionWrapper)allConnections.nextElement();
            conn.close(false);
        }
        connPool.removeAllElements();
        if (this.physicalConn != null) {
            this.physicalConn.close();
        }
        this.physicalConn = null;
        this.myTimer.cancel();
    }

    synchronized void errorClose() {
        Enumeration allConnections = connPool.elements();
        while (allConnections.hasMoreElements()) {
            java.sql.Connection conn = (java.sql.Connection)allConnections.nextElement();
            Object var2_2 = null;
        }
        connPool.removeAllElements();
        connPool = null;
        this.physicalConn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized java.sql.Connection getConnection() throws SQLException {
        ConnectionWrapper realConn = null;
        if (this.physicalConn == null) {
            this.sqlE = new SQLException("Physical Connection doesn't exist");
            throw this.sqlE;
        }
        Object object = this.getMutex();
        synchronized (object) {
            if (!this.connBlocked) {
                this.connBlocked = true;
                if (connPool.size() > 0) {
                    realConn = (ConnectionWrapper)connPool.firstElement();
                    connPool.removeElementAt(0);
                    ++this.client;
                } else if (this.client <= this.maxConn || this.maxConn == 0) {
                    realConn = new ConnectionWrapper(this, this.newConnection(), this.isDirect);
                    this.isDirect = false;
                    ++this.client;
                } else {
                    realConn = this.getConnection(this.maxWait);
                }
                this.connBlocked = false;
            }
        }
        return realConn;
    }

    private synchronized ConnectionWrapper getWaitConnection() {
        ConnectionWrapper ConnWait = null;
        if (connPool.size() > 0) {
            ConnWait = (ConnectionWrapper)connPool.firstElement();
            connPool.removeElementAt(0);
            ++this.client;
        } else if (this.client <= this.maxConn || this.maxConn == 0) {
            ConnWait = new ConnectionWrapper(this, this.newConnection(), this.isDirect);
            this.isDirect = false;
            ++this.client;
        }
        return ConnWait;
    }

    public synchronized ConnectionWrapper getConnection(long timeout) {
        ConnectionWrapper conn = null;
        long startTime = new Date().getTime();
        while (new Date().getTime() - startTime < timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            conn = this.getWaitConnection();
            if (conn != null) break;
        }
        return conn;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listenHash != null) {
            this.listenHash.remove(listener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        int i = 0;
        while (i < this.statementListener.size()) {
            if (listener.equals(this.statementListener.elementAt(i))) {
                this.statementListener.remove(listener);
            }
            ++i;
        }
    }

    synchronized void callListener(int eventType, SQLException sqlException, ConnectionWrapper cw) {
        XgConnectionEvent connectionEvent = null;
        if (this.listenHash == null) {
            return;
        }
        Enumeration enumer = this.listenHash.keys();
        connectionEvent = sqlException == null ? new XgConnectionEvent((PooledConnection)this, cw) : new XgConnectionEvent(this, sqlException, cw);
        while (enumer.hasMoreElements()) {
            XgConnectionEventListener connectioneventlistener1 = (XgConnectionEventListener)enumer.nextElement();
            XgConnectionEventListener connectioneventlistener2 = (XgConnectionEventListener)this.listenHash.get(connectioneventlistener1);
            if (eventType == 1) {
                connectioneventlistener2.connectionClosed(connectionEvent);
            }
            if (eventType != 2) continue;
            connectioneventlistener2.connectionErrorOccurred(connectionEvent);
        }
    }

    private Connection newConnection() {
        java.sql.Connection conn = null;
        try {
            conn = this.user != null ? DriverManager.getConnection(this.url, this.user, this.password) : DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.isDirect = true;
        return (Connection)conn;
    }

    public synchronized void freeConnection(Connection con) {
        connPool.addElement(con);
        --this.client;
    }

    synchronized Vector getConnPool() {
        return connPool;
    }

    Object getMutex() {
        return this.mutex;
    }
}

