/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.pool;

import com.xugu.cloudjdbc.Driver;
import com.xugu.common.ReplaceEnum;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class XgDataSource
implements DataSource,
Referenceable,
Serializable {
    protected static Driver xgDriver;
    protected String url = "jdbc:" + (Object)((Object)ReplaceEnum.conStrProName) + "://127.0.0.1:5138/SYSTEM?user=GUEST&password=GUEST&version=201";
    protected String hostName = "localhost";
    protected String databaseName = "SYSTEM";
    protected String user;
    protected String password;
    protected int port = 5138;
    protected Properties pro;
    protected PrintWriter logWriter;
    protected int loginTimeout = 0;
    protected Connection dsConnection;
    protected long maxWaitTime;
    protected int maxActive;
    protected int minIdle;
    protected boolean explicitUrl = false;

    static {
        try {
            xgDriver = (Driver)Class.forName(ReplaceEnum.productDriverName.getReplaceStr()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("[E50073]\u65e0\u6cd5\u52a0\u8f7d" + ReplaceEnum.excCHNStr.getReplaceStr() + "\u9a71\u52a8Driver");
        }
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnection(Connection con) {
        this.dsConnection = con;
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            String baseUrl = "jdbc:" + (Object)((Object)ReplaceEnum.conStrProName) + "://";
            baseUrl = String.valueOf(baseUrl) + this.getHostName() + ":" + this.getPort() + "/" + this.getDatabaseName();
            return baseUrl;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.dsConnection != null) {
            return this.dsConnection;
        }
        if (username == null) {
            username = "GUEST";
        }
        if (password == null) {
            password = "GUEST";
        }
        if (this.pro == null) {
            Properties pro = new Properties();
            pro.setProperty("user", username);
            pro.setProperty("password", password);
            return this.getConnection(pro);
        }
        this.pro.setProperty("user", username);
        this.pro.setProperty("password", password);
        return this.getConnection(this.pro);
    }

    protected Connection getConnection(Properties props) throws SQLException {
        String useUrl = null;
        if (!this.explicitUrl) {
            StringBuffer jdbcUrl = new StringBuffer("jdbc:" + (Object)((Object)ReplaceEnum.conStrProName) + "://");
            jdbcUrl.append(this.hostName);
            jdbcUrl.append(":");
            jdbcUrl.append(this.port);
            jdbcUrl.append("/");
            jdbcUrl.append(this.databaseName);
            useUrl = jdbcUrl.toString();
        } else {
            useUrl = this.url;
        }
        return xgDriver.connect(useUrl, props);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    @Override
    public Reference getReference() throws NamingException {
        String factoryName = "com." + ReplaceEnum.conStrProName.getReplaceStr() + ".cloudjdbc.pool.XgDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("HOST", this.getHostName()));
        ref.add(new StringRefAddr("PORT", String.valueOf(this.getPort())));
        ref.add(new StringRefAddr("URL", this.getUrl()));
        ref.add(new StringRefAddr("USER", this.getUser()));
        ref.add(new StringRefAddr("PASSWORD", this.getPassword()));
        ref.add(new StringRefAddr("DBNAME", this.getDatabaseName()));
        return ref;
    }

    public Properties getPro() {
        return this.pro;
    }

    public void setPro(Properties ds_pro) {
        this.pro = ds_pro;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }
}

