/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

public class TypesUtil {
    static final short REDHORSE_TYPE_EMPTY = 0;
    static final short REDHORSE_TYPE_NULL = 1;
    static final short REDHORSE_TYPE_BOOLEAN = 2;
    static final short REDHORSE_TYPE_TINYINT = 3;
    static final short REDHORSE_TYPE_SMALLINT = 4;
    static final short REDHORSE_TYPE_INTEGER = 5;
    static final short REDHORSE_TYPE_BIGINT = 6;
    static final short REDHORSE_TYPE_NUMERIC = 7;
    static final short REDHORSE_TYPE_FLOAT = 8;
    static final short REDHORSE_TYPE_DOUBLE = 9;
    static final short REDHORSE_TYPE_DATE = 10;
    static final short REDHORSE_TYPE_TIME = 11;
    static final short REDHORSE_TYPE_TIME_TZ = 12;
    static final short REDHORSE_TYPE_DATETIME = 13;
    static final short REDHORSE_TYPE_DATETIME_TZ = 14;
    static final short REDHORSE_TYPE_INTERVAL_Y = 15;
    static final short REDHORSE_TYPE_INTERVAL_Y2M = 16;
    static final short REDHORSE_TYPE_INTERVAL_M = 17;
    static final short REDHORSE_TYPE_INTERVAL_D = 18;
    static final short REDHORSE_TYPE_INTERVAL_D2H = 19;
    static final short REDHORSE_TYPE_INTERVAL_H = 20;
    static final short REDHORSE_TYPE_INTERVAL_D2M = 21;
    static final short REDHORSE_TYPE_INTERVAL_H2M = 22;
    static final short REDHORSE_TYPE_INTERVAL_MI = 23;
    static final short REDHORSE_TYPE_INTERVAL_D2S = 24;
    static final short REDHORSE_TYPE_INTERVAL_H2S = 25;
    static final short REDHORSE_TYPE_INTERVAL_M2S = 26;
    static final short REDHORSE_TYPE_INTERVAL_S = 27;
    static final short REDHORSE_TYPE_ROWVERSION = 28;
    static final short REDHORSE_TYPE_GUID = 29;
    static final short REDHORSE_TYPE_CHAR = 30;
    static final short REDHORSE_TYPE_CLOB = 32;
    static final short REDHORSE_TYPE_BINARY = 33;
    static final short REDHORSE_TYPE_BLOB = 34;
    static final short REDHORSE_TYPE_GEOMETRY = 35;
    static final short REDHORSE_TYPE_POINT = 36;
    static final short REDHORSE_TYPE_BOX = 37;
    static final short REDHORSE_TYPE_POLYLINE = 38;
    static final short REDHORSE_TYPE_POLYGON = 39;
    static final short REDHORSE_TYPE_ROWID = 45;
    static final short REDHORSE_TYPE_MAX_SYS = 46;
    static final short REDHORSE_TYPE_OBJECT = 1001;
    static final short REDHORSE_TYPE_RECORD = 1003;
    static final short REDHORSE_TYPE_VARRAY = 1004;
    static final short REDHORSE_TYPE_TABLE = 1005;
    static final short REDHORSE_TYPE_CURSOR = 1007;
    static final short REDHORSE_TYPE_REFCUR = 1008;

    public static int toJavaType(int redhorseType) {
        int jdbcType;
        switch (redhorseType) {
            case 1: {
                jdbcType = 0;
                break;
            }
            case 3: {
                jdbcType = -6;
                break;
            }
            case 4: {
                jdbcType = 5;
                break;
            }
            case 5: {
                jdbcType = 4;
                break;
            }
            case 6: {
                jdbcType = 2;
                break;
            }
            case 8: {
                jdbcType = 6;
                break;
            }
            case 9: {
                jdbcType = 8;
                break;
            }
            case 7: {
                jdbcType = 2;
                break;
            }
            case 2: {
                jdbcType = 16;
                break;
            }
            case 30: {
                jdbcType = 12;
                break;
            }
            case 10: {
                jdbcType = 91;
                break;
            }
            case 11: {
                jdbcType = 92;
                break;
            }
            case 12: {
                jdbcType = 3200;
                break;
            }
            case 13: {
                jdbcType = 93;
                break;
            }
            case 14: {
                jdbcType = 3100;
                break;
            }
            case 24: {
                jdbcType = 3010;
                break;
            }
            case 16: {
                jdbcType = 3007;
                break;
            }
            case 15: {
                jdbcType = 3001;
                break;
            }
            case 17: {
                jdbcType = 3002;
                break;
            }
            case 18: {
                jdbcType = 3003;
                break;
            }
            case 20: {
                jdbcType = 3004;
                break;
            }
            case 23: {
                jdbcType = 3005;
                break;
            }
            case 27: {
                jdbcType = 3006;
                break;
            }
            case 19: {
                jdbcType = 3008;
                break;
            }
            case 21: {
                jdbcType = 3009;
                break;
            }
            case 22: {
                jdbcType = 3011;
                break;
            }
            case 25: {
                jdbcType = 3012;
                break;
            }
            case 26: {
                jdbcType = 3013;
                break;
            }
            case 33: {
                jdbcType = -2;
                break;
            }
            case 34: {
                jdbcType = 2004;
                break;
            }
            case 32: {
                jdbcType = 2005;
                break;
            }
            case 28: {
                jdbcType = 3399;
                break;
            }
            case 29: {
                jdbcType = 3400;
                break;
            }
            case 1008: {
                jdbcType = -10;
                break;
            }
            case 1007: {
                jdbcType = -11;
                break;
            }
            case 45: {
                jdbcType = -8;
                break;
            }
            case 1001: {
                jdbcType = 3600;
                break;
            }
            case 1003: {
                jdbcType = 3601;
                break;
            }
            case 1004: {
                jdbcType = 3602;
                break;
            }
            case 1005: {
                jdbcType = 3603;
                break;
            }
            default: {
                jdbcType = 12;
            }
        }
        return jdbcType;
    }

    public static String getRedhorseTypeName(int redhorseType) {
        switch (redhorseType) {
            case 1: {
                return "NULL";
            }
            case 3: {
                return "TINYINT";
            }
            case 4: {
                return "SMALLINT";
            }
            case 5: {
                return "INTEGER";
            }
            case 6: {
                return "NUMBER";
            }
            case 8: {
                return "FLOAT";
            }
            case 9: {
                return "DOUBLE";
            }
            case 7: {
                return "NUMERIC";
            }
            case 2: {
                return "BOOLEAN";
            }
            case 30: {
                return "VARCHAR";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIME";
            }
            case 12: {
                return "TIME WITH TIME ZONE";
            }
            case 13: {
                return "DATETIME";
            }
            case 14: {
                return "DATETIME WITH TIME ZONE";
            }
            case 24: {
                return "INTERVAL DAY TO SECOND";
            }
            case 16: {
                return "INTERVAL YEAR TO MONTH";
            }
            case 15: {
                return "INTERVAL YEAR";
            }
            case 17: {
                return "INTERVAL MONTH";
            }
            case 18: {
                return "INTERVAL DAY";
            }
            case 20: {
                return "INTERVAL HOUR";
            }
            case 23: {
                return "INTERVAL MINUTE";
            }
            case 27: {
                return "INTERVAL SECOND";
            }
            case 19: {
                return "INTERVAL DAY TO HOUR";
            }
            case 21: {
                return "INTERVAL DAY TO MINUTE";
            }
            case 22: {
                return "INTERVAL HOUR TO MINUTE";
            }
            case 25: {
                return "INTERVAL HOUR TO SECOND";
            }
            case 26: {
                return "INTERVAL MINUTE TO SECOND";
            }
            case 33: {
                return "BINARY";
            }
            case 32: {
                return "CLOB";
            }
            case 34: {
                return "BLOB";
            }
            case 29: {
                return "GUID";
            }
            case 1008: {
                return "REFCUR";
            }
            case 1007: {
                return "CURSOR";
            }
            case 45: {
                return "ROWID";
            }
            case 28: {
                return "ROWVERSION";
            }
            case 1001: {
                return "UDTOBJECT";
            }
            case 1003: {
                return "UDTRECORD";
            }
            case 1004: {
                return "UDTVARRAY";
            }
            case 1005: {
                return "UDTTABLE";
            }
        }
        return null;
    }

    public static String getClassName(int redhorseType) {
        String no_type = "There is no referrible type in java types";
        switch (redhorseType) {
            case 1: {
                return null;
            }
            case 3: {
                return "java.lang.Byte";
            }
            case 4: {
                return "java.lang.Short";
            }
            case 5: {
                return "java.lang.Integer";
            }
            case 6: {
                return "java.lang.Long";
            }
            case 8: {
                return "java.lang.Float";
            }
            case 9: {
                return "java.lang.Double";
            }
            case 7: {
                return "java.math.BigDecimal";
            }
            case 2: {
                return "java.lang.Boolean";
            }
            case 30: {
                return "java.lang.String";
            }
            case 10: {
                return "java.sql.Date";
            }
            case 11: {
                return "java.sql.Time";
            }
            case 13: {
                return "java.sql.Timestamp";
            }
            case 1007: 
            case 1008: {
                return no_type;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 45: 
            case 1001: 
            case 1003: 
            case 1004: 
            case 1005: {
                return "java.lang.String";
            }
            case 33: {
                return "java.sql.Blob";
            }
            case 34: {
                return "java.sql.Blob";
            }
            case 32: {
                return "java.sql.Clob";
            }
        }
        return null;
    }

    public static short toRedhorseType(int javaType) {
        short redhorseType;
        switch (javaType) {
            case 0: {
                redhorseType = 30;
                break;
            }
            case -7: {
                redhorseType = 33;
                break;
            }
            case -6: {
                redhorseType = 3;
                break;
            }
            case 5: {
                redhorseType = 4;
                break;
            }
            case 4: {
                redhorseType = 5;
                break;
            }
            case -5: {
                redhorseType = 6;
                break;
            }
            case 6: {
                redhorseType = 8;
                break;
            }
            case 7: {
                redhorseType = 8;
                break;
            }
            case 8: {
                redhorseType = 9;
                break;
            }
            case 2: {
                redhorseType = 7;
                break;
            }
            case 3: {
                redhorseType = 7;
                break;
            }
            case -15: 
            case 1: {
                redhorseType = 30;
                break;
            }
            case -16: 
            case -9: 
            case 12: {
                redhorseType = 30;
                break;
            }
            case 3399: {
                redhorseType = 28;
                break;
            }
            case 91: {
                redhorseType = 10;
                break;
            }
            case 92: {
                redhorseType = 11;
                break;
            }
            case 93: {
                redhorseType = 13;
                break;
            }
            case 3100: {
                redhorseType = 14;
                break;
            }
            case 3200: {
                redhorseType = 12;
                break;
            }
            case 3001: {
                redhorseType = 15;
                break;
            }
            case 3002: {
                redhorseType = 17;
                break;
            }
            case 3003: {
                redhorseType = 18;
                break;
            }
            case 3004: {
                redhorseType = 20;
                break;
            }
            case 3005: {
                redhorseType = 23;
                break;
            }
            case 3006: {
                redhorseType = 27;
                break;
            }
            case 3007: {
                redhorseType = 16;
                break;
            }
            case 3008: {
                redhorseType = 19;
                break;
            }
            case 3009: {
                redhorseType = 21;
                break;
            }
            case 3010: {
                redhorseType = 24;
                break;
            }
            case 3011: {
                redhorseType = 22;
                break;
            }
            case 3012: {
                redhorseType = 25;
                break;
            }
            case 3013: {
                redhorseType = 26;
                break;
            }
            case -2: {
                redhorseType = 33;
                break;
            }
            case -3: {
                redhorseType = 33;
                break;
            }
            case -4: {
                redhorseType = 34;
                break;
            }
            case 3500: {
                redhorseType = 34;
                break;
            }
            case 2004: {
                redhorseType = 34;
                break;
            }
            case 2005: 
            case 2011: {
                redhorseType = 32;
                break;
            }
            case 16: {
                redhorseType = 2;
                break;
            }
            case 3400: {
                redhorseType = 29;
                break;
            }
            case -10: {
                redhorseType = 1008;
                break;
            }
            case -11: {
                redhorseType = 1007;
                break;
            }
            case -8: {
                redhorseType = 45;
                break;
            }
            case 3600: {
                redhorseType = 1001;
                break;
            }
            case 3601: {
                redhorseType = 1003;
                break;
            }
            case 3602: {
                redhorseType = 1004;
                break;
            }
            case 3603: {
                redhorseType = 1005;
                break;
            }
            default: {
                redhorseType = 0;
            }
        }
        return redhorseType;
    }

    public static int getRedhorseType(String redhorseTypeName) {
        if (redhorseTypeName.equalsIgnoreCase("null")) {
            return 1;
        }
        if (redhorseTypeName.equalsIgnoreCase("TINYINT")) {
            return 3;
        }
        if (redhorseTypeName.equalsIgnoreCase("SMALLINT")) {
            return 4;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTEGER")) {
            return 5;
        }
        if (redhorseTypeName.equalsIgnoreCase("BIGINT")) {
            return 6;
        }
        if (redhorseTypeName.equalsIgnoreCase("FLOAT")) {
            return 8;
        }
        if (redhorseTypeName.equalsIgnoreCase("DOUBLE")) {
            return 9;
        }
        if (redhorseTypeName.equalsIgnoreCase("NUMERIC")) {
            return 7;
        }
        if (redhorseTypeName.equalsIgnoreCase("BOOLEAN")) {
            return 2;
        }
        if (redhorseTypeName.equalsIgnoreCase("CHAR")) {
            return 30;
        }
        if (redhorseTypeName.equalsIgnoreCase("VARCHAR")) {
            return 30;
        }
        if (redhorseTypeName.equalsIgnoreCase("DATE")) {
            return 10;
        }
        if (redhorseTypeName.equalsIgnoreCase("TIME")) {
            return 11;
        }
        if (redhorseTypeName.equalsIgnoreCase("TIME WITH TIME ZONE")) {
            return 12;
        }
        if (redhorseTypeName.equalsIgnoreCase("DATETIME WITH TIME ZONE")) {
            return 14;
        }
        if (redhorseTypeName.equalsIgnoreCase("DATETIME")) {
            return 13;
        }
        if (redhorseTypeName.equalsIgnoreCase("TIMESTAMP")) {
            return 13;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
            return 16;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
            return 24;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL YEAR")) {
            return 15;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL MONTH")) {
            return 17;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY")) {
            return 18;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL HOUR")) {
            return 20;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL MINUTE")) {
            return 23;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL SECOND")) {
            return 27;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL DAY TO HOUR")) {
            return 19;
        }
        if (redhorseTypeName.equalsIgnoreCase("NTERVAL DAY TO MINUTE")) {
            return 21;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL HOUR TO MINUTE")) {
            return 22;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL HOUR TO SECOND")) {
            return 25;
        }
        if (redhorseTypeName.equalsIgnoreCase("INTERVAL MINUTE TO SECOND")) {
            return 26;
        }
        if (redhorseTypeName.equalsIgnoreCase("GUID")) {
            return 29;
        }
        if (redhorseTypeName.equalsIgnoreCase("REFCUR")) {
            return 1008;
        }
        if (redhorseTypeName.equalsIgnoreCase("CURSOR")) {
            return 1007;
        }
        if (redhorseTypeName.equalsIgnoreCase("BINARY")) {
            return 33;
        }
        if (redhorseTypeName.equalsIgnoreCase("IMAGE")) {
            return 34;
        }
        if (redhorseTypeName.equalsIgnoreCase("CLOB")) {
            return 32;
        }
        if (redhorseTypeName.equalsIgnoreCase("BLOB")) {
            return 34;
        }
        if (redhorseTypeName.equalsIgnoreCase("BOX")) {
            return 37;
        }
        if (redhorseTypeName.equalsIgnoreCase("GEOMETRY")) {
            return 35;
        }
        if (redhorseTypeName.equalsIgnoreCase("POINT")) {
            return 36;
        }
        if (redhorseTypeName.equalsIgnoreCase("POLYGON")) {
            return 39;
        }
        if (redhorseTypeName.equalsIgnoreCase("POLYLINE")) {
            return 38;
        }
        if (redhorseTypeName.equalsIgnoreCase("ROWID")) {
            return 45;
        }
        if (redhorseTypeName.equalsIgnoreCase("ROWVERSION")) {
            return 28;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTOBJECT")) {
            return 1001;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTRECORD")) {
            return 1003;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTVARRAY")) {
            return 1004;
        }
        if (redhorseTypeName.equalsIgnoreCase("UDTTABLE")) {
            return 1005;
        }
        return -1000;
    }
}

