/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

public class StringUtils {
    private static boolean startsWith(byte[] dataFrom, String chars) {
        int i = 0;
        while (i < chars.length()) {
            if (dataFrom[i] != chars.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndNonAlphaNumeric(String searchIn, String searchFor) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            char c = searchIn.charAt(beginPos);
            if (Character.isLetterOrDigit(c)) break;
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            if (!Character.isWhitespace(searchIn.charAt(beginPos))) break;
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static final int indexOfIgnoreCase(int startingPosition, String searchIn, String searchFor) {
        if (searchIn == null || searchFor == null || startingPosition > searchIn.length()) {
            return -1;
        }
        int patternLength = searchFor.length();
        int stringLength = searchIn.length();
        int stopSearchingAt = stringLength - patternLength;
        int i = startingPosition;
        if (patternLength == 0) {
            return -1;
        }
        char firstCharOfPatternUc = Character.toUpperCase(searchFor.charAt(0));
        char firstCharOfPatternLc = Character.toLowerCase(searchFor.charAt(0));
        block0: while (true) {
            if (i < stopSearchingAt && Character.toUpperCase(searchIn.charAt(i)) != firstCharOfPatternUc && Character.toLowerCase(searchIn.charAt(i)) != firstCharOfPatternLc) {
                ++i;
                continue;
            }
            if (i > stopSearchingAt) {
                return -1;
            }
            int j = i + 1;
            int end = j + patternLength - 1;
            int k = 1;
            while (j < end) {
                int searchInPos = j++;
                int searchForPos = k++;
                if (Character.toUpperCase(searchIn.charAt(searchInPos)) != Character.toUpperCase(searchFor.charAt(searchForPos))) {
                    ++i;
                    continue block0;
                }
                if (Character.toLowerCase(searchIn.charAt(searchInPos)) == Character.toLowerCase(searchFor.charAt(searchForPos))) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }
}

