/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SQLXml
implements SQLXML {
    private byte[] realData = null;
    private ByteArrayOutputStream xmlArrayOuter;
    private String xmlStr;
    private boolean isFromStream;
    private Connection ownCon;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private DOMResult asDOMResult;
    private SAXResult asSAXResult;
    private SimpleSaxToReader saxToReaderConverter;
    private boolean isFree = false;
    private boolean freeMthd = false;
    private boolean isCanWrite = true;
    private boolean isCanRead = true;

    public SQLXml(byte[] struct) {
        this.realData = struct;
    }

    public SQLXml(String xmlString, Connection conn) {
        this.xmlStr = xmlString;
        this.classIntial(conn);
    }

    public SQLXml(Connection conn) {
        this.realData = new byte[0];
        this.xmlStr = new String();
        this.classIntial(conn);
    }

    private void classIntial(Connection conn) {
        this.inputFactory = XMLInputFactory.newInstance();
        this.outputFactory = XMLOutputFactory.newInstance();
        this.ownCon = conn;
    }

    @Override
    public void free() throws SQLException {
        this.freeMthd = true;
        try {
            if (!this.checkClosed()) {
                this.isFree = true;
                if (this.realData != null) {
                    this.realData = null;
                }
                if (this.xmlArrayOuter != null) {
                    this.xmlArrayOuter.close();
                    this.xmlArrayOuter = null;
                }
                if (this.xmlStr != null) {
                    this.xmlStr = null;
                }
            }
        }
        catch (IOException e) {
            throw SQLCommon.innerIOException(e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream inStream = null;
        this.checkClosed();
        this.checkRead();
        if (this.checheRealData()) {
            if (this.xmlArrayOuter != null) {
                inStream = new ByteArrayInputStream(this.xmlArrayOuter.toByteArray());
            } else {
                try {
                    inStream = new ByteArrayInputStream(this.xmlStr.getBytes(this.ownCon.getCharSet()));
                }
                catch (UnsupportedEncodingException e) {
                    throw Error.createSQLException("XML\u6587\u4ef6\u8f6c\u6362\u5931\u8d25: " + e.getMessage());
                }
            }
        }
        return inStream;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        Reader br = null;
        Object inStream = null;
        this.checkClosed();
        this.checkRead();
        if (this.checheRealData()) {
            br = this.serializeAsCharacterStream();
        }
        return br;
    }

    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkRead();
        if (clazz == null || clazz.equals(SAXSource.class)) {
            InputSource inputSource = null;
            inputSource = this.isFromStream ? new InputSource(this.serializeAsCharacterStream()) : new InputSource(new StringReader(this.xmlStr));
            return (T)new SAXSource(inputSource);
        }
        if (clazz.equals(DOMSource.class)) {
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                InputSource inputSource = null;
                inputSource = this.isFromStream ? new InputSource(this.serializeAsCharacterStream()) : new InputSource(new StringReader(this.xmlStr));
                return (T)new DOMSource(builder.parse(inputSource));
            }
            catch (Throwable t) {
                SQLException sqlEx = Error.createSQLException("Dom Error: " + t.getMessage());
                throw sqlEx;
            }
        }
        if (clazz.equals(StreamSource.class)) {
            Reader reader = null;
            reader = this.isFromStream ? this.serializeAsCharacterStream() : new StringReader(this.xmlStr);
            return (T)new StreamSource(reader);
        }
        if (clazz.equals(StAXSource.class)) {
            try {
                Reader reader = null;
                reader = this.isFromStream ? this.serializeAsCharacterStream() : new StringReader(this.xmlStr);
                return (T)new StAXSource(this.inputFactory.createXMLStreamReader(reader));
            }
            catch (XMLStreamException ex) {
                SQLException sqlEx = Error.createSQLException("XML Error: " + ex.getMessage());
                throw sqlEx;
            }
        }
        throw Error.createSQLException("[E50097]SQLXML Result\u5bf9\u8c61\u4e3a\u4e0d\u53ef\u8bc6\u522b\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50097, 50097);
    }

    @Override
    public String getString() throws SQLException {
        String str = null;
        this.checkClosed();
        this.checkRead();
        if (this.checheRealData()) {
            if (this.xmlArrayOuter != null) {
                try {
                    str = new String(this.xmlArrayOuter.toByteArray(), this.ownCon.getCharSet());
                }
                catch (UnsupportedEncodingException e) {
                    throw Error.createSQLException("XML\u6587\u4ef6\u8f6c\u6362\u5931\u8d25: " + e.getMessage());
                }
            } else {
                str = this.xmlStr;
            }
        }
        return str;
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkWrite();
        this.initOutputStream();
        return this.xmlArrayOuter;
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkWrite();
        return this.setCharacterStreamInner();
    }

    private synchronized void initOutputStream() {
        this.xmlArrayOuter = new ByteArrayOutputStream(4096);
        this.isFromStream = true;
    }

    private synchronized Writer setCharacterStreamInner() {
        this.initOutputStream();
        OutputStreamWriter innerWrite = new OutputStreamWriter(this.xmlArrayOuter);
        return innerWrite;
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        this.isFromStream = true;
        this.asDOMResult = null;
        this.asSAXResult = null;
        this.saxToReaderConverter = null;
        this.xmlStr = null;
        this.xmlArrayOuter = null;
        if (clazz == null || clazz.equals(SAXResult.class)) {
            this.saxToReaderConverter = new SimpleSaxToReader();
            this.asSAXResult = new SAXResult(this.saxToReaderConverter);
            return (T)this.asSAXResult;
        }
        if (clazz.equals(DOMResult.class)) {
            this.asDOMResult = new DOMResult();
            return (T)this.asDOMResult;
        }
        if (clazz.equals(StreamResult.class)) {
            return (T)new StreamResult(this.setCharacterStreamInner());
        }
        if (clazz.equals(StAXResult.class)) {
            try {
                if (this.outputFactory == null) {
                    this.outputFactory = XMLOutputFactory.newInstance();
                }
                return (T)new StAXResult(this.outputFactory.createXMLEventWriter(this.setCharacterStreamInner()));
            }
            catch (XMLStreamException ex) {
                SQLException sqlEx = Error.createSQLException(ex.getMessage());
                throw sqlEx;
            }
        }
        throw Error.createSQLException("[E50097]SQLXML Result\u5bf9\u8c61\u4e3a\u4e0d\u53ef\u8bc6\u522b\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50097, 50097);
    }

    @Override
    public void setString(String arg0) throws SQLException {
        this.checkClosed();
        this.checkWrite();
        this.xmlStr = arg0;
    }

    private boolean checkClosed() throws SQLException {
        if (this.isFree) {
            if (this.freeMthd) {
                return true;
            }
            throw Error.createSQLException("[E50095]SQLXML\u5bf9\u8c61\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u53ef\u8bfb\u5199", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50095, 50095);
        }
        return false;
    }

    private void checkWrite() throws SQLException {
        if (!this.isCanWrite) {
            throw Error.createSQLException("[E50096]SQLXML \u5bf9\u8c61\u6682\u65f6\u4e3a\u4e0d\u53ef\u8bfb\u5199", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50096, 50096);
        }
        this.isCanWrite = false;
    }

    private void checkRead() throws SQLException {
        if (!this.isCanRead) {
            throw Error.createSQLException("[E50096]SQLXML \u5bf9\u8c61\u6682\u65f6\u4e3a\u4e0d\u53ef\u8bfb\u5199", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50096, 50096);
        }
        this.isCanRead = false;
    }

    private boolean checheRealData() {
        boolean f = false;
        if (this.xmlStr != null || this.xmlArrayOuter != null) {
            f = true;
        }
        return f;
    }

    protected synchronized Reader serializeAsCharacterStream() throws SQLException {
        this.checkClosed();
        Reader serialReader = null;
        if (this.isFromStream) {
            if (this.xmlArrayOuter != null) {
                serialReader = this.binaryInputStreamStreamToReader(this.xmlArrayOuter);
            } else if (this.asDOMResult != null) {
                serialReader = new StringReader(this.domSourceToString());
            } else if (this.asSAXResult != null) {
                serialReader = this.saxToReaderConverter.toReader();
            }
        } else if (this.xmlStr != null) {
            serialReader = new StringReader(this.xmlStr);
        }
        return serialReader;
    }

    protected synchronized String serializeAsString() throws SQLException {
        this.checkClosed();
        String serialStr = null;
        if (this.isFromStream) {
            if (this.xmlArrayOuter != null) {
                serialStr = this.readerToString(this.binaryInputStreamStreamToReader(this.xmlArrayOuter));
            } else if (this.asDOMResult != null) {
                serialStr = this.domSourceToString();
            } else if (this.asSAXResult != null) {
                serialStr = this.readerToString(this.saxToReaderConverter.toReader());
            }
        } else if (this.xmlStr != null) {
            serialStr = this.xmlStr;
        }
        return serialStr;
    }

    private Reader binaryInputStreamStreamToReader(ByteArrayOutputStream out) {
        try {
            String encoding = "UTF-8";
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(out.toByteArray());
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(bIn);
                int eventType = 0;
                while ((eventType = reader.next()) != 8) {
                    if (eventType != 7) continue;
                    String possibleEncoding = reader.getEncoding();
                    if (possibleEncoding != null) {
                        encoding = possibleEncoding;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new StringReader(new String(out.toByteArray(), encoding));
        }
        catch (UnsupportedEncodingException badEnc) {
            throw new RuntimeException(badEnc);
        }
    }

    protected String readerToString(Reader reader) throws SQLException {
        StringBuilder buf = new StringBuilder();
        int charsRead = 0;
        char[] charBuf = new char[512];
        try {
            while ((charsRead = reader.read(charBuf)) != -1) {
                buf.append(charBuf, 0, charsRead);
            }
        }
        catch (IOException ioEx) {
            throw SQLCommon.innerIOException(ioEx);
        }
        return buf.toString();
    }

    protected String domSourceToString() throws SQLException {
        try {
            DOMSource source = new DOMSource(this.asDOMResult.getNode());
            Transformer identity = TransformerFactory.newInstance().newTransformer();
            StringWriter stringOut = new StringWriter();
            StreamResult result = new StreamResult(stringOut);
            identity.transform(source, result);
            return stringOut.toString();
        }
        catch (Throwable t) {
            SQLException sqlEx = Error.createSQLException("Dom Error: " + t.getMessage());
            throw sqlEx;
        }
    }

    class SimpleSaxToReader
    extends DefaultHandler {
        StringBuilder buf = new StringBuilder();
        private boolean inCDATA = false;

        SimpleSaxToReader() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.buf.append("<?xml version='1.0' encoding='UTF-8'?>");
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            this.buf.append("<");
            this.buf.append(qName);
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this.buf.append(" ");
                    this.buf.append(attrs.getQName(i)).append("=\"");
                    this.escapeCharsForXml(attrs.getValue(i), true);
                    this.buf.append("\"");
                    ++i;
                }
            }
            this.buf.append(">");
        }

        @Override
        public void characters(char[] buffer, int offset, int len) throws SAXException {
            if (!this.inCDATA) {
                this.escapeCharsForXml(buffer, offset, len, false);
            } else {
                this.buf.append(buffer, offset, len);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        public void startCDATA() throws SAXException {
            this.buf.append("<![CDATA[");
            this.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.inCDATA = false;
            this.buf.append("]]>");
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.buf.append("<!--");
            int i = 0;
            while (i < length) {
                this.buf.append(ch[start + i]);
                ++i;
            }
            this.buf.append("-->");
        }

        Reader toReader() {
            return new StringReader(this.buf.toString());
        }

        private void escapeCharsForXml(String str, boolean isAttributeData) {
            if (str == null) {
                return;
            }
            int strLen = str.length();
            int i = 0;
            while (i < strLen) {
                this.escapeCharsForXml(str.charAt(i), isAttributeData);
                ++i;
            }
        }

        private void escapeCharsForXml(char[] buffer, int offset, int len, boolean isAttributeData) {
            if (buffer == null) {
                return;
            }
            int i = 0;
            while (i < len) {
                this.escapeCharsForXml(buffer[offset + i], isAttributeData);
                ++i;
            }
        }

        private void escapeCharsForXml(char c, boolean isAttributeData) {
            switch (c) {
                case '<': {
                    this.buf.append("&lt;");
                    break;
                }
                case '>': {
                    this.buf.append("&gt;");
                    break;
                }
                case '&': {
                    this.buf.append("&amp;");
                    break;
                }
                case '\"': {
                    if (!isAttributeData) {
                        this.buf.append("\"");
                        break;
                    }
                    this.buf.append("&quot;");
                    break;
                }
                case '\r': {
                    this.buf.append("&#xD;");
                    break;
                }
                default: {
                    if (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028' || isAttributeData && (c == '\t' || c == '\n')) {
                        this.buf.append("&#x");
                        this.buf.append(Integer.toHexString(c).toUpperCase());
                        this.buf.append(";");
                        break;
                    }
                    this.buf.append(c);
                }
            }
        }
    }
}

