/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.ResultSet;
import java.util.Vector;

public class RowData {
    private int index = -1;
    private ResultSet owner;
    private Vector rows;
    private int rowSize;

    public RowData(Vector rows) {
        this.rows = rows;
    }

    public void addRow(byte[][] row) {
        this.rows.add(row);
    }

    public void afterLast() {
        this.index = this.rows.size();
    }

    public void beforeFirst() {
        this.index = -1;
    }

    public void beforeLast() {
        this.index = this.rows.size() - 2;
    }

    public Object[] getAt(int atIndex) {
        if (atIndex < 0 || atIndex >= this.rows.size()) {
            return null;
        }
        return (Object[])this.rows.get(atIndex);
    }

    public ResultSet getOwner() {
        return this.owner;
    }

    public boolean hasNext() {
        boolean hasMore = this.index + 1 < this.rows.size();
        return hasMore;
    }

    public boolean isAfterLast() {
        return this.index >= this.rows.size();
    }

    public boolean isBeforeFirst() {
        return this.index == -1 && this.rows.size() != 0;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        return this.index == this.rows.size() - 1;
    }

    public void moveRowRelative(int rowsToMove) {
        this.index += rowsToMove;
    }

    public Object[] getNextRow() {
        if (this.hasNext()) {
            ++this.index;
            return (Object[])this.rows.get(this.index);
        }
        return null;
    }

    public Object[] currentRow() {
        if (this.hasNext()) {
            return (Object[])this.rows.get(0);
        }
        return null;
    }

    public void removeRow(int atIndex) {
        this.rows.remove(atIndex);
    }

    public void removeCurrRow() {
        this.rows.remove(0);
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    public int size() {
        return this.rows.size();
    }

    public int capacity() {
        return this.rows.capacity();
    }

    public int getIndex() {
        return this.index;
    }

    boolean isNull() {
        boolean f = false;
        if (this.rows.isEmpty()) {
            f = true;
        }
        return f;
    }

    Vector getRows() {
        return this.rows;
    }

    void addVector(Vector v) {
        if (v != null) {
            this.rows.addAll(v);
        }
    }

    void setRowsNull() {
        this.rows = null;
    }

    void clear() {
        this.rows.clear();
        this.index = -1;
    }

    synchronized int getRowSize() {
        return this.rowSize;
    }

    synchronized void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }
}

