/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class ResultSetList {
    private int index = -1;
    private int currIndex = -1;
    private Vector resultSets;

    public ResultSetList(Vector resultSets) {
        this.resultSets = resultSets;
    }

    void addResult(java.sql.ResultSet resultSet) {
        this.resultSets.add(resultSet);
        ++this.currIndex;
    }

    void addUpdateCount(int count) {
        this.resultSets.add(count);
        ++this.currIndex;
    }

    public void close(boolean rsToNull) throws SQLException {
        this.index = -1;
        if (this.resultSets != null) {
            while (this.hasNext()) {
                Object next = this.next();
                if (this.isResultSet(next)) {
                    ((ResultSet)next).close();
                }
                Object var2_2 = null;
            }
            this.resultSets.clear();
            if (rsToNull) {
                this.resultSets = null;
            }
        }
    }

    public Object getAt(int atIndex) {
        if (atIndex < 0 || atIndex >= this.resultSets.size()) {
            return null;
        }
        return this.resultSets.get(atIndex);
    }

    public boolean hasNext() {
        boolean hasMore = this.index + 1 < this.resultSets.size();
        return hasMore;
    }

    public boolean isEmpty() {
        return this.resultSets.size() == 0;
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        if (this.resultSets.size() == 0) {
            return false;
        }
        return this.index == this.resultSets.size() - 1;
    }

    public Object next() {
        ++this.index;
        if (this.index < this.resultSets.size()) {
            return this.resultSets.get(this.index);
        }
        return null;
    }

    public void removeResultSet(int atIndex) {
        if (atIndex > -1) {
            this.resultSets.remove(atIndex);
            --this.currIndex;
        }
    }

    public void removeResultSet(Object o) {
        this.resultSets.remove(o);
        --this.currIndex;
        --this.index;
    }

    public void removeCurrResultSet() {
        if (this.currIndex != -1) {
            this.resultSets.remove(this.currIndex);
            --this.currIndex;
        }
    }

    public void setCurrentResultSet(int newIndex) {
        this.index = newIndex;
    }

    public int size() {
        return this.resultSets.size();
    }

    public int getIndex() {
        return this.index;
    }

    public int getCurrIndex() {
        return this.currIndex;
    }

    void clear() {
        this.resultSets.clear();
        this.currIndex = -1;
        this.index = -1;
    }

    boolean isResultSet(Object obj) {
        return obj instanceof java.sql.ResultSet;
    }

    ResultSet getcurrResultSet() {
        if (this.getAt(this.currIndex) instanceof ResultSet) {
            return (ResultSet)this.getAt(this.currIndex);
        }
        return null;
    }

    void setCurrResIsOver() {
        Object currObj = this.getAt(this.currIndex);
        if (this.isResultSet(currObj)) {
            ((ResultSet)currObj).setRsIsOver(true);
        }
    }
}

