/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Parameter;
import com.xugu.cloudjdbc.PreparedStatement;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class ParameterMetaData
implements java.sql.ParameterMetaData {
    static int parameterNoNulls = 0;
    static int parameterNullable = 1;
    static int parameterNullableUnknown = 2;
    static int parameterModeUnknown = 0;
    static int parameterModeIn = 1;
    static int parameterModeInOut = 2;
    static int parameterModeOut = 4;
    private Parameter[] params;
    private PreparedStatement conetPstm;

    public ParameterMetaData(Parameter[] params, PreparedStatement pstm) {
        this.params = params;
        this.conetPstm = pstm;
    }

    @Override
    public int getParameterCount() throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        return this.params.length;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return parameterNullableUnknown;
    }

    @Override
    public boolean isSigned(int paramNum) throws SQLException {
        boolean f;
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(paramNum);
        Parameter p = this.params[paramNum - 1];
        int paramsType = p.getRh_typeid();
        switch (paramsType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 30: {
                f = true;
                break;
            }
            default: {
                f = false;
            }
        }
        return f;
    }

    @Override
    public int getPrecision(int paramNum) throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(paramNum);
        Parameter p = this.params[paramNum - 1];
        return p.prec;
    }

    @Override
    public int getScale(int paramNum) throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(paramNum);
        Parameter p = this.params[paramNum - 1];
        return p.scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(param);
        return this.params[param - 1].sql_type;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(param);
        return TypesUtil.getRedhorseTypeName(this.params[param - 1].rh_typeid);
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(param);
        return TypesUtil.getClassName(this.params[param - 1].rh_typeid);
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkPstmClose();
        this.checkIsPrepared();
        this.checkParamIndex(param);
        if (this.params[param - 1].flag == 1) {
            return parameterModeIn;
        }
        if (this.params[param - 1].flag == 2) {
            return parameterModeOut;
        }
        if (this.params[param - 1].flag == 3) {
            return parameterModeInOut;
        }
        return parameterModeUnknown;
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        return false;
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }

    private void checkPstmClose() throws SQLException {
        if (this.conetPstm == null || this.conetPstm.isClosed()) {
            throw Error.createSQLException("[E50060]\u64cd\u4f5c\u5bf9\u8c61Statement\u5df2\u5173\u95ed", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50060, 50060);
        }
    }

    private void checkIsPrepared() throws SQLFeatureNotSupportedException {
        if (!this.conetPstm.isPrepared) {
            throw SQLCommon.unSupportException();
        }
    }

    private void checkParamIndex(int paramIndex) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.params.length) {
            throw Error.createSQLException("[E50031]parameter number out of range.", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50031, 50031);
        }
    }
}

