/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Parameter;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import java.sql.SQLException;

public class ParamList {
    private Parameter[] params;
    private int paramNum;

    public ParamList() {
        this.params = null;
        this.paramNum = 0;
    }

    public ParamList(int count) {
        this.paramNum = count;
        this.params = new Parameter[count];
        int i = 0;
        while (i < count) {
            this.params[i] = new Parameter();
            ++i;
        }
    }

    public void add(int ord) {
        Parameter[] newParams = new Parameter[this.paramNum + 1];
        int i = 0;
        while (i < this.paramNum) {
            newParams[i] = this.params[i];
            ++i;
        }
        Parameter para = new Parameter();
        para.ordinal = ord;
        newParams[this.paramNum] = para;
        this.params = newParams;
        ++this.paramNum;
    }

    public void setParamInfo(int paramIdx, String paramName, int paranPrdinal, int paramTypeId, int paramPrec, int paramScale, int paramFlags) throws SQLException {
        this.checkParamIndex(paramIdx);
        this.params[paramIdx].setParamInfo(paramName, paranPrdinal, paramTypeId, paramPrec, paramScale, paramFlags);
    }

    public void setParamInfo(int paramIdx, String paramName, int paramOrdinal, int paramTypeId, int paramFlags) throws SQLException {
        this.checkParamIndex(paramIdx);
        this.params[paramIdx].setParamInfo(paramName, paramOrdinal, paramTypeId, paramFlags);
    }

    public boolean setParamInfo(String name, int typeId, int scale, int flags) {
        int i = 0;
        while (i < this.paramNum) {
            Parameter param = this.params[i];
            if (param.name != null && param.name.compareToIgnoreCase(name) == 0) {
                param.rh_typeid = typeId;
                param.sql_type = TypesUtil.toJavaType(param.rh_typeid);
                param.scale = scale;
                param.flag = flags;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setParamInfo(int paramIdx, int ordinal, int typeId, int flags) throws SQLException {
        this.checkParamIndex(paramIdx);
        this.params[paramIdx].setParamInfo(ordinal, typeId, flags);
    }

    public void setParamResult(int ord, int typeId, int dLen, byte[] dat) {
        Parameter para = this.params[ord];
        para.rh_typeid = typeId;
        para.sql_type = TypesUtil.toJavaType(typeId);
        para.datLen = dLen;
        para.dat = dat;
    }

    public void setObject(int paramIdx, short type, short order, long length, Object obj) throws SQLException {
        this.checkParamIndex(paramIdx);
        Parameter param = this.params[paramIdx];
        param.rh_typeid = type;
        param.sql_type = TypesUtil.toJavaType(type);
        param.datLen = length;
        param.dat = obj;
        param.isSet = true;
        param.ordinal = order;
    }

    public Parameter[] getParameters() {
        return this.params;
    }

    public int getParamType(int paramIdx) {
        return this.params[paramIdx].sql_type;
    }

    public boolean isReturnVale(int paramIdx) {
        return this.params[paramIdx].ordinal == 0;
    }

    public int getParamNativeType(int paramIdx) {
        return this.params[paramIdx].rh_typeid;
    }

    public int getParamJavaType(int paramIdx) {
        return this.params[paramIdx].sql_type;
    }

    public long getParamLength(int paramIdx) {
        return this.params[paramIdx].datLen;
    }

    public long getParamScal(int paramIdx) {
        return this.params[paramIdx].scale;
    }

    public int getParaminoutType(int paramIdx) {
        return this.params[paramIdx].ordinal;
    }

    public Object getParamData(int paramIdx) {
        return this.params[paramIdx].dat;
    }

    void setParamData(int paramIdx, Object data) {
        this.params[paramIdx].dat = data;
    }

    void setParamName(int paramIdx, String paramName) {
        this.params[paramIdx].name = paramName;
    }

    public boolean getParamIsSet(int paramIdx) {
        return this.params[paramIdx].isSet;
    }

    public boolean getParamIsRegist(int paramIdx) {
        return this.params[paramIdx].isRegist;
    }

    public String getParamName(int paramIdx) {
        return this.params[paramIdx].name;
    }

    public boolean isAllSet() {
        int i = 0;
        while (i < this.paramNum) {
            if (!this.params[i].isSet && (this.params[i].flag & 2) == 0 && this.params[i].ordinal != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void paramDatClear() {
        int i = 0;
        while (i < this.paramNum) {
            this.params[i].dat = null;
            this.params[i].datLen = 0L;
            this.params[i].isSet = false;
            ++i;
        }
    }

    int getParamNum() {
        return this.paramNum;
    }

    private void checkParamIndex(int index) throws SQLException {
        if (index >= this.getParamNum()) {
            throw Error.createSQLException("[E50036]Beyond the parameter range", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51042, 51042);
        }
    }
}

