/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.TypesUtil;

public class Field {
    private int FIELD_BASE_TAB = 1;
    private int FIELD_NOT_NULL = 2;
    private int FIELD_IS_PRIMARY = 4;
    private int FIELD_IS_SERIAL = 8;
    private int FIELD_IS_TIMESTAMP = 16;
    private int FIELD_IS_LOB = 32;
    private int FIELD_IS_UNIQUE = 64;
    private int FIELD_IS_ROWID = 128;
    private int FIELD_IS_DUMMY = 256;
    private int FIELD_IS_HIDE = 512;
    private String columnLabel = null;
    private String tableSchema = null;
    private String columnName = null;
    private String tableName = null;
    private String databaseName = null;
    private int sqlType = -1;
    private int redhorseType = -1;
    private int flag;
    private int precision;
    private int scale;

    public Field(String fieldTotalName, int fieldTypeID, int fieldPrecisionScale, int fieldFlag, String databaseName) {
        String tableName = null;
        String fieldName = null;
        String fieldLabel = null;
        String[] nameArr = null;
        int pointIndex = fieldTotalName.indexOf(37);
        if (pointIndex > 0) {
            fieldLabel = fieldTotalName.substring(pointIndex + 1);
            fieldTotalName = fieldTotalName.substring(0, pointIndex);
        } else {
            fieldLabel = null;
        }
        pointIndex = fieldTotalName.indexOf(46);
        if (pointIndex > 0) {
            nameArr = fieldTotalName.split("\\.");
            if (nameArr.length == 3) {
                this.tableSchema = nameArr[0];
                tableName = nameArr[1];
                fieldName = nameArr[2];
            } else if (nameArr.length == 2) {
                tableName = nameArr[0];
                fieldName = nameArr[1];
            } else if (nameArr.length == 1) {
                fieldName = nameArr[0];
            }
        } else {
            tableName = null;
            fieldName = fieldTotalName;
        }
        this.columnName = fieldName;
        this.columnLabel = fieldLabel;
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.redhorseType = fieldTypeID;
        this.sqlType = TypesUtil.toJavaType(this.redhorseType);
        this.flag = fieldFlag;
        if (this.redhorseType == 7) {
            this.precision = fieldPrecisionScale >> 16;
            this.scale = fieldPrecisionScale & 0xFFFF;
        } else {
            this.precision = fieldPrecisionScale;
            this.scale = 0;
        }
    }

    public boolean isAutoIncrement() {
        return (this.flag & this.FIELD_IS_SERIAL) > 0;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public int getRedhorseType() {
        return this.redhorseType;
    }

    boolean isNotNull() {
        return (this.flag & this.FIELD_NOT_NULL) > 0;
    }

    public boolean isSigned() {
        return true;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableLable() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isPrimaryKey() {
        return (this.flag & this.FIELD_IS_PRIMARY) > 0;
    }

    public boolean isHide() {
        return (this.flag & this.FIELD_IS_HIDE) > 0;
    }

    boolean getFiledFlag() {
        return this.redhorseType == 34 || this.redhorseType == 32;
    }

    boolean isBigObject_FetchDirect() {
        return this.columnName.equalsIgnoreCase("CLOBDATA") || this.columnName.equalsIgnoreCase("LOBDATA");
    }

    String getTableSchema() {
        return this.tableSchema;
    }

    void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }
}

