/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.HashMap;

public class Error {
    public static SQLException createSQLException(String reason) {
        return new SQLException(reason);
    }

    public static SQLException createSQLException(String reason, String sqlState) {
        if (sqlState == null) {
            return new SQLException(reason);
        }
        return new SQLException(reason, sqlState);
    }

    public static SQLException createSQLException(String reason, String sqlState, int vendorCode) {
        if (vendorCode == -1) {
            if (sqlState == null) {
                return new SQLException(reason);
            }
            return new SQLException(reason, sqlState);
        }
        return new SQLException(reason, sqlState, vendorCode);
    }

    public static SQLException createSQLException(String reason, String sqlState, int vendorCode, String errType) {
        if (vendorCode == -1) {
            if (sqlState == null) {
                return new SQLException(reason);
            }
            return new SQLException(reason, sqlState);
        }
        if (errType == null) {
            return new SQLException(reason, sqlState, vendorCode);
        }
        return new SQLException(reason, sqlState, vendorCode, new Throwable(errType));
    }

    public static BatchUpdateException createBatchUpdateException(int[] updateCounts) {
        return new BatchUpdateException(updateCounts);
    }

    public static BatchUpdateException createBatchUpdateException(String reason, int[] updateCounts) {
        return new BatchUpdateException(reason, updateCounts);
    }

    public static BatchUpdateException createBatchUpdateException(String reason, String sqlState, int[] updateCounts) {
        if (sqlState == null) {
            return new BatchUpdateException(reason, updateCounts);
        }
        return new BatchUpdateException(reason, sqlState, updateCounts);
    }

    public static BatchUpdateException createBatchUpdateException(String reason, String sqlState, int vendorCode, int[] updateCounts) {
        if (vendorCode == -1) {
            if (sqlState == null) {
                return new BatchUpdateException(reason, updateCounts);
            }
            return new BatchUpdateException(reason, sqlState, updateCounts);
        }
        return new BatchUpdateException(reason, sqlState, vendorCode, updateCounts);
    }

    public static InterruptedException createInterruptedException(String reason) {
        return new InterruptedException(reason);
    }

    public static SQLClientInfoException createSQLClientInfoException(String reason, int vendorCode, String clientKey) {
        HashMap<String, ClientInfoStatus> errMap = new HashMap<String, ClientInfoStatus>(1);
        errMap.put(clientKey, ClientInfoStatus.REASON_VALUE_INVALID);
        return new SQLClientInfoException(reason, null, vendorCode, errMap);
    }
}

