/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.StringUtils;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private int MAJOR_VERSION = 3;
    private int MINOR_VERSION = 0;
    private static int connect_count = 1;
    private boolean isUrlMysql = false;
    public static final String HOST_PROPERTY_KEY = "host";
    public static final String PORT_PROPERTY_KEY = "port";
    public static final String DATABASE_PROPERTY_KEY = "database";
    public static final String USER_PROPERTY_KEY = "user";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String PROPERTY_KEY_IPS = "ips";
    public static final String PROPERTY_KEY_CONN_TYPE = "conn_type";

    static {
        try {
            DriverManager.registerDriver(new Driver());
            SQLCommon.iniSQLProperties();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u672a\u53d1\u73b0" + ReplaceEnum.excCHNStr.getReplaceStr() + "JDBC\u9a71\u52a8");
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    @Override
    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            throw Error.createSQLException("[E51030]URL\u683c\u5f0f\u9519\u8bef", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51030, 51030);
        }
        String host = props.getProperty(HOST_PROPERTY_KEY, "localhost");
        int port = Integer.parseInt(props.getProperty(PORT_PROPERTY_KEY, "5138"));
        Connection connection = new Connection(host, port, url, props);
        if (Command.debug) {
            Command.logServerUrlStr(connection.io, url);
        }
        return connection;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith("jdbc:" + ReplaceEnum.conStrProName.getReplaceStr() + ":")) {
            info = this.parseURL(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY));
        hostProp.required = true;
        hostProp.description = "Database Host";
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, "5138"));
        portProp.required = false;
        portProp.description = "Database Port";
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DATABASE_PROPERTY_KEY, info.getProperty(DATABASE_PROPERTY_KEY));
        dbProp.required = false;
        dbProp.description = "Database Name";
        DriverPropertyInfo userProp = new DriverPropertyInfo(USER_PROPERTY_KEY, info.getProperty(USER_PROPERTY_KEY));
        userProp.required = true;
        userProp.description = "Database User";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo(PASSWORD_PROPERTY_KEY, info.getProperty(PASSWORD_PROPERTY_KEY));
        passwordProp.required = true;
        passwordProp.description = "Database Password";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp};
        return dpi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps = defaults != null ? new Properties(defaults) : new Properties();
        int beginningOfSlashes = 0;
        beginningOfSlashes = StringUtils.startsWithIgnoreCase(url, "jdbc:" + ReplaceEnum.conStrProName.getReplaceStr() + ":file:") ? 13 + ReplaceEnum.conStrProName.getReplaceStr().length() : (!this.isUrlMysql ? 8 + ReplaceEnum.conStrProName.getReplaceStr().length() : 12);
        if (url == null) {
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase(url, "jdbc:" + ReplaceEnum.conStrProName.getReplaceStr() + ":") && !this.isUrlMysql || !StringUtils.startsWithIgnoreCase(url, "jdbc:mysql:") && this.isUrlMysql) {
            return null;
        }
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEquals = StringUtils.indexOfIgnoreCase(0, parameterValuePair, "=");
                String parameter = null;
                String value = null;
                if (indexOfEquals != -1) {
                    parameter = parameterValuePair.substring(0, indexOfEquals);
                    if (indexOfEquals + 1 < parameterValuePair.length()) {
                        value = parameterValuePair.substring(indexOfEquals + 1);
                    }
                }
                if (value == null || value.length() <= 0 || parameter == null || parameter.length() <= 0) continue;
                try {
                    urlProps.put(parameter.toLowerCase(), URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException badEncoding) {
                    urlProps.put(parameter, URLDecoder.decode(value));
                }
                catch (NoSuchMethodError nsme) {
                    urlProps.put(parameter, URLDecoder.decode(value));
                }
            }
        }
        url = url.substring(beginningOfSlashes);
        String hostStuff = null;
        int slashIndex = url.indexOf("/");
        if (slashIndex == -1) return null;
        hostStuff = url.substring(0, slashIndex);
        if (slashIndex + 1 < url.length()) {
            urlProps.put(DATABASE_PROPERTY_KEY, url.substring(slashIndex + 1, url.length()));
        }
        if (hostStuff != null && hostStuff.length() > 0) {
            int portIndex = hostStuff.indexOf(":");
            String hostName = null;
            if (portIndex != -1) {
                if (portIndex + 1 >= hostStuff.length()) throw Error.createSQLException("[E50030]Driver: Error about the host given in the URL", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50030, 50030);
                String port = hostStuff.substring(portIndex + 1);
                hostName = hostStuff.substring(0, portIndex);
                urlProps.put(HOST_PROPERTY_KEY, hostName);
                urlProps.put(PORT_PROPERTY_KEY, port);
            } else {
                urlProps.put(HOST_PROPERTY_KEY, hostName);
            }
        }
        if (defaults == null) return urlProps;
        Iterator<Object> propsIter = defaults.keySet().iterator();
        while (propsIter.hasNext()) {
            String key = propsIter.next().toString();
            Object value = defaults.get(key);
            if (value == null || value.equals("")) continue;
            urlProps.put(key.toLowerCase(), value);
        }
        return urlProps;
    }

    @Override
    public int getMajorVersion() {
        return this.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return this.MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

