/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Field;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.RowData;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.UnsupportedEncodingException;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private Connection connection;
    String curr_db;
    String curr_user;
    private final boolean a = false;
    int READ_ANY = 1;
    String schemaString = null;
    MessageFormat messageFormat = null;
    private final int jdbcMajorVersion = 12;
    private final int jdbcMinorVersion = 0;
    private final int jdbcprivateVersion = 0;

    public DatabaseMetaData(java.sql.Connection conn, String database) throws SQLException {
        this.connection = (Connection)conn;
        this.curr_db = this.connection.getCatalog();
        this.curr_user = this.connection.getUser();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "allProceduresAreCallable");
        }
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "allTablesAreSelectable");
        }
        boolean selectedAll = true;
        int authority = 0;
        String curruser_name = this.getUserName();
        Statement stm = (Statement)this.connection.createStatement();
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.allTablesAreSelectable"));
        Object[] selectTabObj = new Object[]{"'" + curruser_name + "'", "'" + curruser_name + "'"};
        String sql = this.messageFormat.format(selectTabObj);
        java.sql.ResultSet rs = stm.executeQuery(sql);
        while (rs.next()) {
            authority = rs.getInt(1);
            if ((authority & this.READ_ANY) == 1) continue;
            selectedAll = false;
            break;
        }
        stm.close();
        rs = null;
        stm = null;
        curruser_name = null;
        sql = null;
        return selectedAll;
    }

    @Override
    public String getURL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getURL");
        }
        return this.connection.getConnectionUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getUserName");
        }
        String user_name = null;
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getUserName"));
        String sql = this.messageFormat.format(null);
        Statement stm = (Statement)this.connection.createStatement();
        java.sql.ResultSet rs = stm.executeQuery(sql);
        while (rs.next()) {
            user_name = rs.getString(1);
        }
        stm.close();
        stm = null;
        rs = null;
        return user_name;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "isReadOnly");
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedHigh");
        }
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedLow");
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedAtStart");
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullsAreSortedAtEnd");
        }
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseProductName");
        }
        if (this.connection.isIsora()) {
            return "Oracle";
        }
        return ReplaceEnum.productName.getReplaceStr();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseProductVersion");
        }
        this.checkConnectionOpen();
        if (this.connection.isIsora()) {
            return "11";
        }
        String versionStr = null;
        java.sql.Statement stm = null;
        stm = this.connection.createStatement();
        java.sql.ResultSet rs = stm.executeQuery("show version");
        if (rs.next()) {
            versionStr = rs.getString(1);
        }
        rs.close();
        stm.close();
        return versionStr;
    }

    @Override
    public String getDriverName() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverName");
        }
        return String.valueOf(ReplaceEnum.productName.getReplaceStr()) + " JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverVersion");
        }
        return "12.0.0";
    }

    public String getJDBCVersionDate() {
        return this.connection.jdbcVersionDateString;
    }

    @Override
    public int getDriverMajorVersion() {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverMajorVersion");
        }
        return 12;
    }

    @Override
    public int getDriverMinorVersion() {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDriverMinorVersion");
        }
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "usesLocalFiles");
        }
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "usesLocalFilePerTable");
        }
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMixedCaseIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesUpperCaseIdentifiers");
        }
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesLowerCaseIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesMixedCaseIdentifiers");
        }
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMixedCaseQuotedIdentifiers");
        }
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesUpperCaseQuotedIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesLowerCaseQuotedIdentifiers");
        }
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "storesMixedCaseQuotedIdentifiers");
        }
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getIdentifierQuoteString");
        }
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSQLKeywords");
        }
        return " ABORT,ABOVE,ABSOLUTE,ACCESS,ACCOUNT,ACTION,ADD,AFTER,AGGREGATE,ALL,ALTER,ANALYSE,ANALYZE,AND,ANY,AOVERLAPS,APPEND,ARCHIVELOG,ARE,ARRAY,AS,ASC,AT,AUDIT, AUDITOR,AUTHID,AUTHORIZATION,AUTO,BACKUP,BACKWARD,BADFILE,BCONTAINS,BEFORE, BEGIN,BETWEEN,BINARY,BINTERSECTS,BIT,BLOCK, BLOCKS,\tBODY,\tBOTH,\tBOUND,\tBOVERLAPS,\tBREAK,\tBUFFER_POOL,\tBUILD,\tBULK,\tBWITHIN,\tBY,\tCACHE,\tCALL,\tCASCADE,CASE,\tCAST,\tCATCH,\tCATEGORY,\tCHAIN,\tCHAR,\tCHARACTER,\tCHARACTERISTICS,\tCHECK,\tCHECKPOINT,\tCHUNK,\tCLOSE,\tCLUSTER,\tCOALESCE,COLLATE,\tCOLLECT,\tCOLUMN,\tCOMMENT,\tCOMMIT,\tCOMMITTED,\tCOMPLETE,\t\tCOMPRESS,\tCOMPUTE,\tCONNECT,\tCONSTANT,\tCONSTRAINT,CONSTRAINTS,\tCONSTRUCTOR,\tCONTAINS,\tCONTEXT,\tCONTINUE,\tCOPY,\tCORRESPONDING,\tCREATE,\tCREATEDB,\tCREATEUSER,\tCROSS,\tCROSSES,CUBE,\tCURRENT,\tCURSOR,\tCYCLE,\tDATABASE,\tDATAFILE,\tDATE,\tDATETIME,\tDAY,\tDBA,\tDEALLOCATE,\tDEC,\tDECIMAL,\tDECLARE,\tDECODE,DECRYPT,\tDEFAULT,\tDEFERRABLE,\tDEFERRED,\tDELETE,\tDELIMITED,\tDELIMITERS,\tDEMAND,\tDESC,\tDESCRIBE,\tDETERMINISTIC,\tDIR,\tDISABLE,DISASSEMBLE,\tDISCORDFILE,\tDISJOINT,\tDISTINCT,\tDO,\tDOMAIN,\tDOUBLE,\tDRIVEN,\tDROP,\tEACH,\tELEMENT,\tELSE,\tELSEIF,\tELSIF,\tENABLE,ENCODING,\tENCRYPT,\tENCRYPTOR,\tEND,\tENDCASE,\tENDFOR,\tENDIF,\tENDLOOP,\tEQUALS,\t\tESCAPE,\tEVERY,\tEXCEPT,\tEXCEPTION,\tEXCEPTIONS,EXCLUSIVE,\tEXEC,\tEXECUTE,\tEXISTS,\tEXIT,\tEXPIRE,\tEXPLAIN,\tEXPORT,\tEXTEND,\tEXTERNAL,\tEXTRACT,\tFALSE,\tFAST,\tFETCH,\tFIELD,\tFIELDS,FILTER, FINAL,\tFINALLY,\tFIRST,\tFLOAT,\tFOLLOWING,\tFOR, FORALL,\tFORCE,\tFOREIGN,\tFORWARD,\tFOUND,\tFREELIST,\tFREELISTS,\tFROM,\tFULL,FUNCTION,\tGENERATED,\tGET,\tGLOBAL,\tGOTO,\tGRANT,\tGREATEST,\tGROUP,\tGROUPING,\tGROUPS,\tHANDLER,\tHASH,\tHAVING,\tHEAP,\tHIDE,\tHOTSPOT,HOUR,\tIDENTIFIED,\tIDENTIFIER,\tIDENTITY,\tIF,\tILIKE,\tIMMEDIATE,\tIMPORT,\tIN,\tINCLUDE,\tINCREMENT,\tINDEX,\tINDEXTYPE,\tINDICATOR,\tINDICES,INHERITS,\tINIT,\tINITIAL,\tINITIALLY,\tINITRANS,\tINNER,\tINOUT,\tINSENSITIVE,\tINSERT,\tINSTANTIABLE,\tINSTEAD,\tINTERSECT,\tINTERSECTS,INTERVAL,\tINTO,\tIO,\tIS,\tISNULL,\tISOLATION,\tISOPEN,\tJOB,\tJOIN,\tK,\tKEEP,\tKEY,\tKEYSET,\tLABEL,\tLANGUAGE,\tLAST,\tLEADING,\tLEAST,LEAVE,\tLEFT,\tLEFTOF,\tLENGTH,\tLESS,\t\tLEVEL,\tLEVELS,\tLEXER,\tLIBRARY,\tLIKE,\tLIMIT,\tLINK,\tLIST,\tLISTEN,\tLOAD,\tLOB, \tLOCAL,\tLOCATION,LOCATOR,\tLOCK,\tLOGFILE,\tLOGGING,\tLOGIN,\tLOGOUT,\tLOOP,\tLOVERLAPS,\t\tM,\tMATCH,\tMATERIALIZED,\tMAX,\tMAXEXTENTS,\tMAXSIZE,\tMAXTRANS,MAXVALUE,\tMAXVALUES,\tMEMBER,\tMEMORY,\tMERGE,\tMINEXTENTS,\tMINUS,\tMINUTE,\tMINVALUE,\tMISSING,\tMODE,\tMODIFY,\tMONTH,\tMOVEMENT,\tNAME,\tNAMES,\tNATIONAL,\tNATURAL,\tNCHAR,\tNESTED,\tNEW,\tNEWLINE,\tNEXT,\tNO,\tNOARCHIVELOG,\tNOAUDIT,\tNOCACHE,\tNOCOMPRESS,\tNOCREATEDB,\tNOCREATEUSER,NOCYCLE,\tNODE,\tNOFORCE,\tNOFOUND,\tNOLOGGING,\tNONE,\tNOORDER,\tNOPARALLEL,\tNOT,\tNOTFOUND,\tNOTHING,\tNOTIFY,\tNOTNULL,\tNOVALIDATE,NOWAIT,\tNULL,\tNULLIF,\tNULLS,\tNUMBER,\tNUMERIC,\tNVARCHAR,\tNVARCHAR2,\tNVL,\tNVL2,\tOBJECT,\tOF,\tOFF,\tOFFLINE,\tOFFSET,\t\tOIDINDEX,OIDS,\tOLD,\tON,\tONLINE,\tONLY,\tOPEN,\tOPERATOR,\tOPTION,\tOR,\tORDER,\tORGANIZATION,\tOTHERVALUES,\tOUT,\tOUTER,\tOVER,\tOVERLAPS,\tOWNER,PACKAGE,\tPARALLEL,\tPARAMETERS,\tPARTIAL,\tPARTITION,\tPARTITIONS,\tPASSWORD,\tPCTFREE,\tPCTINCREASE,\tPCTUSED,\tPCTVERSION,\tPERIOD,\tPOLICY,PRAGMA,\tPREBUILT,\tPRECEDING, \tPRECISION,\tPREPARE,\tPRESERVE,\tPRIMARY,\tPRIOR,\tPRIORITY,\tPRIVILEGES,\tPROCEDURAL,\tPROCEDURE,\tPROTECTED,PUBLIC,\tQUERY,\tQUOTA,\tRAISE,\tRANGE,\tRAW,\tREAD,\tREADS,\tREBUILD,\tRECOMPILE,\tRECORD,\tRECORDS,\tRECYCLE,\tREDUCED,\tREF,\tREFERENCES,REFERENCING,\tREFRESH, \tREINDEX,\tRELATIVE,\tRENAME,\tREPEATABLE,\tREPLACE,\tREPLICATION,\tRESOURCE,\tRESTART,\tRESTORE,\tRESTRICT,\tRESULT,RETURN,\tRETURNING,\tREVERSE,\tREVOKE,\tREWRITE,\tRIGHT,\tRIGHTOF,\tROLE,\tROLLBACK,\tROLLUP,\tROVERLAPS,\tROW,\tROWCOUNT,\tROWID,\tROWS,ROWTYPE,\tRULE,\tRUN,\tSAVEPOINT,\tSCHEMA,\tSCROLL,\tSECOND,\tSEGMENT,\tSELECT,\tSELF,\tSEQUENCE,\tSERIALIZABLE,\tSESSION,\tSET,\tSETOF,\tSETS,SHARE,\tSHOW,\tSHUTDOWN,\tSIBLINGS,\tSIZE,\tSLOW,\tSNAPSHOT,\tSOME,\tSPATIAL,\tSPLIT,\tSSO,\tSTANDBY,\tSTART,\tSTATEMENT,\tSTATIC,\tSTATISTICS,STEP,\tSTOP,\tSTORAGE,\tSTORE,\tSTREAM,\tSUBPARTITION,\tSUBPARTITIONS,\tSUBTYPE,\tSUCCESSFUL,\tSYNONYM,\tSYSTEM,\tTABLE,\tTABLESPACE,\t\tTEMP,\tTEMPLATE,TEMPORARY,\tTERMINATED,\tTHAN,\tTHEN,\tTHROW,\tTIME,\tTIMESTAMP,\tTO,\tTOP,\tTOPOVERLAPS, TOUCHES, TRACE, TRAILING,\tTRAN,\tTRANSACTION,\tTRIGGER,\tTRUE,TRUNCATE,\tTRUSTED,\tTRY,\tTYPE,\tUNBOUNDED,\tUNDER,\tUNDO,\tUNIFORM,\tUNION,\tUNIQUE,\tUNLIMITED,\tUNLISTEN,\tUNLOCK,\tUNPROTECTED,\tUNTIL,\tUOVERLAPS,UPDATE,\tUSE,\tUSER,\tUSING,\tVACUUM,\tVALID,\tVALIDATE,\tVALUE,\tVALUES,\tVARCHAR,\tVARCHAR2,\tVARRAY,\tVARYING,\tVERBOSE,\tVERSION,\tVIEW,\tVOCABLE,WAIT,\tWHEN,\tWHENEVER,\tWHERE,\tWHILE,\tWITH,\tWITHIN, \tWITHOUT,\tWORK,\tWRITE,\tXML,\tYEAR,\tZONE";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getNumericFunctions");
        }
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getNumericFunctions"));
        String sql = this.messageFormat.format(null);
        Statement stm = (Statement)this.connection.createStatement();
        String funName = null;
        java.sql.ResultSet rs = stm.executeQuery(sql);
        if (rs.next()) {
            funName = rs.getString(1);
        }
        stm.close();
        stm = null;
        rs = null;
        return funName;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getStringFunctions");
        }
        return new String("ATOF,ATOI,BOX,BTRIM,CONCAT,HEADING,INSTR,LEN,LOWER,LTRIM,PINYIN,PINYIN1,POINT,POSITION,REPLACE,REPLICATE,REVERSE_STR,RTRIM,STUFF,SUBSTR,TAILING,UPPER");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSystemFunctions");
        }
        return new String("ISNULL,CURRENT_DATE,CURRENT_DATABASE,CURRENT_DB,CURRENT_DB_ID,CURRENT_IP,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURRENT_USERID");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTimeDateFunctions");
        }
        this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTimeDateFunctions"));
        String sql = this.messageFormat.format(null);
        String timeFun = null;
        java.sql.Statement stm = this.connection.createStatement();
        java.sql.ResultSet rs = stm.executeQuery(sql);
        timeFun = this.rsToString(rs);
        stm.close();
        stm = null;
        rs = null;
        return timeFun;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSearchStringEscape");
        }
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getExtraNameCharacters");
        }
        return "$#";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsAlterTableWithAddColumn");
        }
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsAlterTableWithDropColumn");
        }
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsColumnAliasing");
        }
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "nullPlusNonNullIsNull");
        }
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsConvert");
        }
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsConvert  " + fromType + " , " + toType);
        }
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsTableCorrelationNames");
        }
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsDifferentTableCorrelationNames");
        }
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsExpressionsInOrderBy");
        }
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOrderByUnrelated");
        }
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGroupBy");
        }
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGroupByUnrelated");
        }
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGroupByBeyondSelect");
        }
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsLikeEscapeClause");
        }
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMultipleResultSets");
        }
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMultipleTransactions");
        }
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsNonNullableColumns");
        }
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMinimumSQLGrammar");
        }
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCoreSQLGrammar");
        }
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsExtendedSQLGrammar");
        }
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsANSI92EntryLevelSQL");
        }
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsANSI92IntermediateSQL");
        }
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsANSI92FullSQL");
        }
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsIntegrityEnhancementFacility");
        }
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOuterJoins");
        }
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsFullOuterJoins");
        }
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsLimitedOuterJoins");
        }
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSchemaTerm");
        }
        return "SCHEMA";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getProcedureTerm");
        }
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCatalogTerm");
        }
        return "DATABASE";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "isCatalogAtStart");
        }
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCatalogSeparator");
        }
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInDataManipulation");
        }
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInProcedureCalls");
        }
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInTableDefinitions");
        }
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInIndexDefinitions");
        }
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSchemasInPrivilegeDefinitions");
        }
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInDataManipulation");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInProcedureCalls");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInTableDefinitions");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInIndexDefinitions");
        }
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCatalogsInPrivilegeDefinitions");
        }
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsPositionedDelete");
        }
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsPositionedUpdate");
        }
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSelectForUpdate");
        }
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsStoredProcedures");
        }
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInComparisons");
        }
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInExists");
        }
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInIns");
        }
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSubqueriesInQuantifieds");
        }
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsCorrelatedSubqueries");
        }
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsUnion");
        }
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsUnionAll");
        }
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenCursorsAcrossCommit");
        }
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenCursorsAcrossRollback");
        }
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenStatementsAcrossCommit");
        }
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsOpenStatementsAcrossRollback");
        }
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxBinaryLiteralLength");
        }
        return 512;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxCharLiteralLength");
        }
        return 64;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInGroupBy");
        }
        return this.getMaxColumnsInTable();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInIndex");
        }
        return 32;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInOrderBy");
        }
        return this.getMaxColumnsInTable();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInSelect");
        }
        return this.getMaxColumnsInTable();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxColumnsInTable");
        }
        return 1024;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxConnections");
        }
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxCursorNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxIndexLength");
        }
        return 1024;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxSchemaNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxProcedureNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxCatalogNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxRowSize");
        }
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "doesMaxRowSizeIncludeBlobs");
        }
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxStatementLength");
        }
        return 65536;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxStatements");
        }
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxTableNameLength");
        }
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxTablesInSelect");
        }
        return 32;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getMaxUserNameLength");
        }
        return 64;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDefaultTransactionIsolation");
        }
        return this.connection.getTransactionIsolation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsTransactions");
        }
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsTransactionIsolationLevel");
        }
        return level == 2 || level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsDataDefinitionAndDataManipulationTransactions");
        }
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsDataManipulationTransactionsOnly");
        }
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "dataDefinitionCausesTransactionCommit");
        }
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "dataDefinitionIgnoredInTransactions");
        }
        return false;
    }

    @Override
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getProcedures  " + catalog + " , " + schemaPattern + " , " + procedureNamePattern);
        }
        java.sql.ResultSet rs = null;
        String sql = null;
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        Statement stm = (Statement)this.connection.createStatement(false);
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        }
        Object[] proceObj = null;
        if (procedureNamePattern.equals("%")) {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getProcedures%"));
            proceObj = new Object[]{"'" + real_catalog + "'", "'1'", real_schema};
            sql = this.messageFormat.format(proceObj);
        } else {
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getProcedures"));
            proceObj = new Object[]{"'" + real_catalog + "'", "'1'", real_schema, "'" + procedureNamePattern + "'"};
            sql = this.messageFormat.format(proceObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getProcedureColumns  " + catalog + " , " + schemaPattern + " , " + procedureNamePattern + " , " + columnNamePattern);
        }
        throw SQLCommon.unSupportException();
    }

    @Override
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Object[] tabObj;
        if (Command.debug) {
            String typesStr = "";
            if (types != null && types.length > 0) {
                int i = 0;
                while (i < types.length) {
                    typesStr = i == types.length - 1 ? String.valueOf(typesStr) + types[i] : String.valueOf(typesStr) + types[i] + ",";
                    ++i;
                }
            }
            if (typesStr.equals("")) {
                typesStr = "null";
            }
            Command.logDMmethods(this.connection.io, "getTables   " + catalog + " , " + schemaPattern + " , " + tableNamePattern + " , " + typesStr);
        }
        Connection conn = null;
        java.sql.ResultSet rs = null;
        conn = this.connection;
        java.sql.Statement stm = conn.createStatement(false);
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        String sql2 = "";
        String sql3 = "";
        String sql4 = "";
        String sql6 = "";
        String sql7 = "";
        String sql8 = "";
        String sql9 = "";
        if (tableNamePattern.equalsIgnoreCase("%")) {
            tabObj = new Object[]{"'" + real_catalog + "'", real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTab%"));
            sql2 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTemtab%"));
            sql3 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesView%"));
            sql4 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesSyn%"));
            sql6 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesPro%"));
            sql7 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesFun%"));
            sql8 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesUDT%"));
            sql9 = this.messageFormat.format(tabObj);
        } else {
            tabObj = new Object[]{"'" + real_catalog + "'", "'" + tableNamePattern + "'", real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTab"));
            sql2 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesTemtab"));
            sql3 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesView"));
            sql4 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesSyn"));
            sql6 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesPro"));
            sql7 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesFun"));
            sql8 = this.messageFormat.format(tabObj);
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getTablesUDT"));
            sql9 = this.messageFormat.format(tabObj);
        }
        String temp_type = null;
        String total_sql = "";
        String innerSql = null;
        MessageFormat totalFormat = SQLCommon.getMessageFormat("DatabaseMetadata.selectSql");
        String orderSql = SQLCommon.getMessageFormat("DatabaseMetadata.getTablesOrder").format(null);
        StringBuffer exeSqlBuffer = new StringBuffer();
        if (types == null) {
            innerSql = exeSqlBuffer.append("(").append(sql2).append(" union all ").append(sql3).append(" union all ").append(sql4).append(" union all ").append(sql6).append(" union all ").append(sql7).append(" union all ").append(sql8).append(" union all ").append(sql9).append(")").append(orderSql).toString();
            Object[] inObj = new Object[]{innerSql};
            total_sql = totalFormat.format(inObj);
        } else {
            String supportTypes = "TABLE,VIEW,GLOBAL TEMPORARY,SYNONYM,PROCEDURE,FUNCTION,UDT";
            int i = 0;
            while (i < types.length) {
                temp_type = types[i];
                if (supportTypes.indexOf(temp_type.toUpperCase()) != -1) {
                    if (exeSqlBuffer.length() != 0) {
                        exeSqlBuffer.append(" union all ");
                    } else {
                        exeSqlBuffer.append("(");
                    }
                    if (temp_type.equalsIgnoreCase("TABLE")) {
                        exeSqlBuffer.append(sql2);
                    }
                    if (temp_type.equalsIgnoreCase("GLOBAL TEMPORARY")) {
                        exeSqlBuffer.append(sql3);
                    }
                    if (temp_type.equalsIgnoreCase("VIEW")) {
                        exeSqlBuffer.append(sql4);
                    }
                    if (temp_type.equalsIgnoreCase("SYNONYM")) {
                        exeSqlBuffer.append(sql6);
                    }
                    if (temp_type.equalsIgnoreCase("PROCEDURE")) {
                        exeSqlBuffer.append(sql7);
                    }
                    if (temp_type.equalsIgnoreCase("FUNCTION")) {
                        exeSqlBuffer.append(sql8);
                    }
                    if (temp_type.equalsIgnoreCase("UDT")) {
                        exeSqlBuffer.append(sql9);
                    }
                }
                ++i;
            }
            if (exeSqlBuffer.length() > 0) {
                exeSqlBuffer.append(") " + orderSql);
                Object[] inObj = new Object[]{exeSqlBuffer.toString()};
                total_sql = totalFormat.format(inObj);
            } else {
                Object[] inObj = new Object[]{"dual where id is null"};
                total_sql = totalFormat.format(inObj);
            }
        }
        rs = stm.executeQuery(total_sql);
        stm.close();
        return rs;
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSchemas");
        Object[] schemaObj = new Object[]{"'" + this.curr_db + "'"};
        java.sql.ResultSet rs = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        String sql = this.messageFormat.format(schemaObj);
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCatalogs");
        }
        this.checkConnectionOpen();
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCatalogs");
        Statement stm = (Statement)this.connection.createStatement(false);
        java.sql.ResultSet rs = stm.executeQuery(this.messageFormat.format(null));
        stm.close();
        return rs;
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTableTypes");
        }
        Vector typelist = new Vector();
        String[] tabTypes = new String[]{"TABLE", "VIEW", "GLOBAL TEMPORARY", "SYSTEM TABLE", "LOCAL TEMPORARY", "SYNONYM", "PROCEDURE", "FUNCTION", "UDT"};
        RowData rd = new RowData(typelist);
        Field[] field = new Field[]{new Field("TABLE_TYPE", 30, 20, 0, this.curr_db)};
        ResultSet rs = new ResultSet(this.connection, (Statement)this.connection.createStatement(), this.curr_db, field, rd, null);
        byte[][] b1 = null;
        try {
            int i = 0;
            while (i < tabTypes.length) {
                b1 = new byte[][]{tabTypes[i].getBytes()};
                rs.addRow(b1);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getColumns   " + catalog + " , " + schemaPattern + " , " + tableNamePattern + " , " + columnNamePattern);
        }
        String table_type = "";
        java.sql.ResultSet rs = null;
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        String sql2 = "";
        String[] colObj = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        if ((table_type = this.getTableRealType(stm, tableNamePattern, real_schema)).equalsIgnoreCase("table")) {
            if (columnNamePattern.equalsIgnoreCase("%")) {
                if (tableNamePattern == null || tableNamePattern.equals("%")) {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTabNull%");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                } else {
                    this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTab%");
                    colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", "'" + tableNamePattern + "'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                    sql2 = this.messageFormat.format(colObj);
                }
            } else if (tableNamePattern == null || tableNamePattern.equals("%")) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTabNull");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsTab");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'0'", "'1'", "'" + tableNamePattern + "'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            }
            rs = stm.executeQuery(sql2);
        } else {
            if (columnNamePattern.equalsIgnoreCase("%")) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsView%");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'2'", "'" + tableNamePattern + "'", real_schema, "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getColumnsView");
                colObj = new String[]{"'" + real_catalog + "'", "'16'", "'1'", "'12'", "'-6'", "'5'", "'4'", "'-5'", "'6'", "'8'", "'2'", "'91'", "'92'", "'3200'", "'93'", "'93'", "'3100'", "'3010'", "'3007'", "'3008'", "'3009'", "'3011'", "'3012'", "'3013'", "'3003'", "'3004'", "'3005'", "'3006'", "'3002'", "'3001'", "'-2'", "'2004'", "'3500'", "'2005'", "'2'", "'" + tableNamePattern + "'", real_schema, "'" + columnNamePattern + "'", "'3400'", "'-8'", "'3399'", "'3100'"};
                sql2 = this.messageFormat.format(colObj);
            }
            rs = stm.executeQuery(sql2);
        }
        return rs;
    }

    @Override
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getColumnPrivileges\u672a\u5b9e\u73b0       " + catalog + " , " + schema + " , " + table + " , " + columnNamePattern);
        }
        this.checkConnectionOpen();
        throw SQLCommon.unSupportException();
    }

    @Override
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTablePrivileges\u672a\u5b9e\u73b0       " + catalog + " , " + schemaPattern + " , " + tableNamePattern);
        }
        throw SQLCommon.unSupportException();
    }

    @Override
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getBestRowIdentifier   " + catalog + " , " + schema + " , " + table + " , " + scope + " , " + nullable);
        }
        this.checkConnectionOpen();
        java.sql.ResultSet rs = null;
        String sql = null;
        String real_schema = this.getRealSchemas(catalog, schema);
        Statement stm = (Statement)this.connection.createStatement(false);
        if (table == null || table.equals("") || table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getBestRowIdentifier%");
            Object[] identifierObjAll = new Object[]{scope, 1, 1, real_schema};
            sql = this.messageFormat.format(identifierObjAll);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getBestRowIdentifier");
            Object[] identifierObj = new Object[]{scope, 1, 1, real_schema, "'" + table + "'"};
            sql = this.messageFormat.format(identifierObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        stm = null;
        return rs;
    }

    @Override
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Object[] exportObj;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getExportedKeys   " + catalog + " , " + schema + " , " + table);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        int f = 32;
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        String sql = null;
        Statement stm = (Statement)this.connection.createStatement();
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("PKTABLE_CAT", 30, 20, 1, real_catalog), new Field("PKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("PKTABLE_NAME", 30, 20, 1, real_catalog), new Field("PKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("FKTABLE_CAT", 30, 20, 1, real_catalog), new Field("FKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("FKTABLE_NAME", 30, 20, 1, real_catalog), new Field("FKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("KEY_SEQ", 4, 2, 1, real_catalog), new Field("UPDATE_RULE", 4, 2, 1, real_catalog), new Field("DELETE_RULE", 4, 2, 1, real_catalog), new Field("FK_NAME", 30, 20, 1, real_catalog), new Field("PK_NAME", 30, 20, 1, real_catalog), new Field("DEFERRABILITY", 4, 2, 1, real_catalog)};
        Vector array = new Vector();
        RowData rowData = new RowData(array);
        rs = new ResultSet(this.connection, stm, real_catalog, field, rowData, null);
        if (table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getExportedKeys%");
            exportObj = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", real_schema};
            sql = this.messageFormat.format(exportObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getExportedKeys");
            exportObj = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", real_schema, "'" + table + "'"};
            sql = this.messageFormat.format(exportObj);
        }
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            int i = 1;
            String f_fColumn = rs1.getString(6);
            String fColumn = null;
            String pColumn = rs1.getString(2);
            int post = 0;
            int kpost = 0;
            fColumn = f_fColumn.indexOf("(") != -1 ? f_fColumn.substring(f_fColumn.indexOf("(") + 1, f_fColumn.indexOf(")")) : f_fColumn;
            try {
                byte[][] realData;
                while ((post = fColumn.indexOf(",")) != -1) {
                    kpost = pColumn.indexOf(",");
                    realData = new byte[14][];
                    realData[0] = real_catalog.getBytes();
                    realData[1] = rs1.getString(10).getBytes();
                    realData[2] = rs1.getString(9).getBytes();
                    realData[3] = pColumn.substring(0, kpost).getBytes();
                    pColumn = pColumn.substring(kpost + 1);
                    realData[4] = real_catalog.getBytes();
                    realData[5] = rs1.getString(7).getBytes();
                    realData[6] = rs1.getString(8).getBytes();
                    f = rs1.getString(3).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 1;
                            break;
                        }
                    }
                    f = rs1.getString(4).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 1;
                            break;
                        }
                    }
                    realData[11] = rs1.getString(5).getBytes();
                    realData[12] = rs1.getString(1).getBytes();
                    realData[13] = new byte[2];
                    realData[13][0] = 0;
                    realData[13][1] = 5;
                    String p1 = fColumn.substring(0, post);
                    fColumn = fColumn.substring(post + 1);
                    realData[7] = p1.getBytes();
                    realData[8] = new byte[2];
                    realData[8][0] = (byte)((i & 0xFF00) >> 8);
                    realData[8][1] = (byte)(i & 0xFF);
                    i = (short)(i + 1);
                    rowData.addRow(realData);
                    realData = null;
                }
                realData = new byte[14][];
                realData[0] = real_catalog.getBytes();
                realData[1] = rs1.getString(10).getBytes();
                realData[2] = rs1.getString(9).getBytes();
                realData[3] = pColumn.substring(0).getBytes();
                realData[4] = real_catalog.getBytes();
                realData[5] = rs1.getString(7).getBytes();
                realData[6] = rs1.getString(8).getBytes();
                f = rs1.getString(3).charAt(0);
                switch (f) {
                    case 110: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 1;
                        break;
                    }
                }
                f = rs1.getString(4).charAt(0);
                switch (f) {
                    case 110: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 1;
                        break;
                    }
                }
                realData[11] = rs1.getString(5).getBytes();
                realData[12] = rs1.getString(1).getBytes();
                realData[13] = new byte[2];
                realData[13][0] = 0;
                realData[13][1] = 5;
                fColumn = fColumn.substring(0);
                realData[7] = fColumn.getBytes();
                realData[8] = new byte[2];
                realData[8][0] = (byte)((i & 0xFF00) >> 8);
                realData[8][1] = (byte)(i & 0xFF);
                rowData.addRow(realData);
                realData = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs1.close();
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getCrossReference   " + primaryCatalog + " , " + primarySchema + " , " + primaryTable + " , " + foreignCatalog + " , " + foreignSchema + " , " + foreignTable);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        String real_p_schema = this.getRealSchemas(primaryCatalog, primarySchema);
        String real_f_catalog = this.getRealCatalog(foreignCatalog);
        String real_f_schema = this.getRealSchemas(foreignCatalog, foreignSchema);
        int f = 32;
        Statement stm = (Statement)this.connection.createStatement();
        if (primaryTable == null || primaryTable.equals("")) {
            primaryTable = "%";
        }
        if (foreignTable == null || foreignTable.equals("")) {
            foreignTable = "%";
        }
        Field[] field = new Field[]{new Field("PKTABLE_CAT", 30, 20, 1, real_f_catalog), new Field("PKTABLE_SCHEM", 30, 20, 1, real_f_catalog), new Field("PKTABLE_NAME", 30, 20, 1, real_f_catalog), new Field("PKCOLUMN_NAME", 30, 20, 1, real_f_catalog), new Field("FKTABLE_CAT", 30, 20, 1, real_f_catalog), new Field("FKTABLE_SCHEM", 30, 20, 1, real_f_catalog), new Field("FKTABLE_NAME", 30, 20, 1, real_f_catalog), new Field("FKCOLUMN_NAME", 30, 20, 1, real_f_catalog), new Field("KEY_SEQ", 4, 2, 1, real_f_catalog), new Field("UPDATE_RULE", 4, 2, 1, real_f_catalog), new Field("DELETE_RULE", 4, 2, 1, real_f_catalog), new Field("FK_NAME", 30, 20, 1, real_f_catalog), new Field("PK_NAME", 30, 20, 1, real_f_catalog), new Field("DEFERRABILITY", 4, 2, 1, real_f_catalog)};
        String sql = null;
        Object[] crossObj = null;
        Vector array = new Vector();
        RowData rowData = new RowData(array);
        rs = new ResultSet(this.connection, stm, foreignCatalog, field, rowData, null);
        if (primaryTable.equals("%") && foreignTable.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReferenceAll%");
            crossObj = new Object[]{"'" + this.curr_db + "'", real_p_schema, "'" + this.curr_db + "'", real_f_schema};
        } else if (primaryTable.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReferencePrimary%");
            crossObj = new Object[]{"'" + this.curr_db + "'", real_p_schema, "'" + this.curr_db + "'", real_f_schema, "'" + foreignTable + "'"};
        } else if (foreignTable.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReferenceForeign%");
            crossObj = new Object[]{"'" + this.curr_db + "'", "'" + primaryTable + "'", real_p_schema, "'" + this.curr_db + "'", real_f_schema};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getCrossReference");
            crossObj = new Object[]{"'" + this.curr_db + "'", "'" + primaryTable + "'", real_p_schema, "'" + this.curr_db + "'", "'" + foreignTable + "'", real_f_schema};
        }
        sql = this.messageFormat.format(crossObj);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            int i = 1;
            String p_fColumn = rs1.getString(4);
            String fColumn = null;
            String pColumn = rs1.getString(2);
            int post = 0;
            int kpost = 0;
            fColumn = p_fColumn.indexOf("(") != -1 ? p_fColumn.substring(p_fColumn.indexOf("(") + 1, p_fColumn.indexOf(")")) : p_fColumn;
            try {
                byte[][] realData;
                while ((post = fColumn.indexOf(",")) != -1) {
                    kpost = pColumn.indexOf(",");
                    realData = new byte[14][];
                    realData[0] = rs1.getString(11).getBytes();
                    realData[1] = rs1.getString(9).getBytes();
                    realData[2] = rs1.getString(7).getBytes();
                    realData[3] = pColumn.substring(0, kpost).getBytes();
                    pColumn = pColumn.substring(kpost + 1);
                    realData[4] = rs1.getString(12).getBytes();
                    realData[5] = rs1.getString(10).getBytes();
                    realData[6] = rs1.getString(8).getBytes();
                    f = rs1.getString(5).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[9] = new byte[2];
                            realData[9][0] = 0;
                            realData[9][1] = 1;
                            break;
                        }
                    }
                    f = rs1.getString(6).charAt(0);
                    switch (f) {
                        case 78: 
                        case 110: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 3;
                            break;
                        }
                        case 67: 
                        case 99: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 0;
                            break;
                        }
                        case 85: 
                        case 117: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 2;
                            break;
                        }
                        case 68: 
                        case 100: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 4;
                            break;
                        }
                        case 82: 
                        case 114: {
                            realData[10] = new byte[2];
                            realData[10][0] = 0;
                            realData[10][1] = 1;
                            break;
                        }
                    }
                    realData[11] = rs1.getString(3).getBytes();
                    realData[12] = rs1.getString(1).getBytes();
                    realData[13] = new byte[2];
                    realData[13][0] = 0;
                    realData[13][1] = 5;
                    String p1 = fColumn.substring(0, post);
                    fColumn = fColumn.substring(post + 1);
                    realData[7] = p1.getBytes();
                    realData[8] = new byte[2];
                    realData[8][0] = (byte)((i & 0xFF00) >> 8);
                    realData[8][1] = (byte)(i & 0xFF);
                    i = (short)(i + 1);
                    rowData.addRow(realData);
                    realData = null;
                }
                realData = new byte[14][];
                realData[0] = rs1.getString(11).getBytes();
                realData[1] = rs1.getString(9).getBytes();
                realData[2] = rs1.getString(7).getBytes();
                realData[3] = pColumn.substring(0).getBytes();
                realData[4] = rs1.getString(12).getBytes();
                realData[5] = rs1.getString(10).getBytes();
                realData[6] = rs1.getString(8).getBytes();
                f = rs1.getString(5).charAt(0);
                switch (f) {
                    case 110: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[9] = new byte[2];
                        realData[9][0] = 0;
                        realData[9][1] = 1;
                        break;
                    }
                }
                f = rs1.getString(6).charAt(0);
                switch (f) {
                    case 110: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 3;
                        break;
                    }
                    case 99: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 0;
                        break;
                    }
                    case 117: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 2;
                        break;
                    }
                    case 100: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 4;
                        break;
                    }
                    case 114: {
                        realData[10] = new byte[2];
                        realData[10][0] = 0;
                        realData[10][1] = 1;
                        break;
                    }
                }
                realData[11] = rs1.getString(3).getBytes();
                realData[12] = rs1.getString(1).getBytes();
                realData[13] = new byte[2];
                realData[13][0] = 0;
                realData[13][1] = 5;
                fColumn = fColumn.substring(0);
                realData[7] = fColumn.getBytes();
                realData[8] = new byte[2];
                realData[8][0] = (byte)((i & 0xFF00) >> 8);
                realData[8][1] = (byte)(i & 0xFF);
                rowData.addRow(realData);
                realData = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs1 = null;
        stm = null;
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        byte[][] rowData;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getTypeInfo");
        }
        java.sql.ResultSet rs = null;
        ResultSet rs1 = null;
        Connection conn = this.connection;
        Statement stm = (Statement)conn.createStatement();
        Field[] filed = new Field[]{new Field("TYPE_NAME", 30, 30, 1, this.curr_db), new Field("DATA_TYPE", 5, 4, 1, this.curr_db), new Field("PRECISION", 5, 4, 1, this.curr_db), new Field("LITERAL_PREFIX", 30, 10, 1, this.curr_db), new Field("LITERAL_SUFFIX", 30, 10, 1, this.curr_db), new Field("CREATE_PARAMS", 30, 10, 1, this.curr_db), new Field("NULLABLE", 4, 2, 1, this.curr_db), new Field("CASE_SENSITIVE", 2, 1, 1, this.curr_db), new Field("SEARCHABLE", 4, 2, 1, this.curr_db), new Field("UNSIGNED_ATTRIBUTE", 2, 1, 1, this.curr_db), new Field("FIXED_PREC_SCALE", 2, 1, 1, this.curr_db), new Field("AUTO_INCREMENT", 2, 1, 1, this.curr_db), new Field("LOCAL_TYPE_NAME", 30, 30, 1, this.curr_db), new Field("MINIMUM_SCALE", 4, 2, 1, this.curr_db), new Field("MAXIMUM_SCALE", 4, 2, 1, this.curr_db), new Field("NUM_PREC_RADIX", 5, 4, 1, this.curr_db)};
        Vector array = new Vector();
        RowData rdata = new RowData(array);
        rs1 = new ResultSet(conn, stm, this.curr_db, filed, rdata, null);
        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getTypeInfo");
        String sql = this.messageFormat.format(null);
        rs = stm.executeQuery(sql);
        int type_num = 0;
        while (rs.next()) {
            rowData = new byte[16][];
            String typeName = null;
            int precision = 0;
            typeName = rs.getString(1);
            rowData[0] = typeName.getBytes();
            type_num = typeName.equalsIgnoreCase("time with time zone") || typeName.equalsIgnoreCase("datetime with time zone") || typeName.equalsIgnoreCase("interval year") || typeName.equalsIgnoreCase("interval month") || typeName.equalsIgnoreCase("interval day") || typeName.equalsIgnoreCase("interval hour") || typeName.equalsIgnoreCase("interval minute") || typeName.equalsIgnoreCase("interval second") || typeName.equalsIgnoreCase("interval year to  month") || typeName.equalsIgnoreCase("interval day to hour") || typeName.equalsIgnoreCase("interval day wo minute") || typeName.equalsIgnoreCase("interval day to second") || typeName.equalsIgnoreCase("interval hour to minute") || typeName.equalsIgnoreCase("interval hour to second") || typeName.equalsIgnoreCase("interval minute to second") || typeName.equalsIgnoreCase("geometry") || typeName.equalsIgnoreCase("point") || typeName.equalsIgnoreCase("box") || typeName.equalsIgnoreCase("polygon") || typeName.equalsIgnoreCase("polyline") ? 2001 : TypesUtil.toJavaType(TypesUtil.getRedhorseType(typeName));
            rowData[1] = new byte[4];
            rowData[1][0] = (byte)((type_num & 0xFF000000) >> 24);
            rowData[1][1] = (byte)((type_num & 0xFF0000) >> 16);
            rowData[1][2] = (byte)((type_num & 0xFF00) >> 8);
            rowData[1][3] = (byte)(type_num & 0xFF);
            if (typeName.equalsIgnoreCase("char") || typeName.equalsIgnoreCase("varchar")) {
                precision = 65536;
            }
            if (typeName.equalsIgnoreCase("numeric")) {
                precision = 38;
            }
            if (typeName.equalsIgnoreCase("time")) {
                precision = 8;
            }
            if (typeName.equalsIgnoreCase("date")) {
                precision = 10;
            }
            if (typeName.equalsIgnoreCase("datetime")) {
                precision = 20;
            }
            if (typeName.equalsIgnoreCase("boolean")) {
                precision = 1;
            }
            if (typeName.equalsIgnoreCase("time")) {
                precision = 8;
            }
            if (typeName.equalsIgnoreCase("date")) {
                precision = 10;
            }
            if (typeName.equalsIgnoreCase("datetime")) {
                precision = 20;
            }
            rowData[2] = new byte[4];
            rowData[2][0] = (byte)((precision & 0xFF000000) >> 24);
            rowData[2][1] = (byte)((precision & 0xFF0000) >> 16);
            rowData[2][2] = (byte)((precision & 0xFF00) >> 8);
            rowData[2][3] = (byte)(precision & 0xFF);
            rowData[3] = null;
            rowData[4] = null;
            rowData[5] = null;
            rowData[6] = new byte[2];
            rowData[6][0] = 0;
            rowData[6][1] = 1;
            rowData[7] = typeName.equalsIgnoreCase("char") || typeName.equalsIgnoreCase("varchar") ? String.valueOf(true).getBytes() : String.valueOf(false).getBytes();
            if (typeName.equalsIgnoreCase("blob") || typeName.equalsIgnoreCase("clob") || typeName.equalsIgnoreCase("binary") || typeName.equalsIgnoreCase("image")) {
                rowData[8] = new byte[2];
                rowData[8][0] = 0;
                rowData[8][1] = 0;
            } else {
                rowData[8] = new byte[2];
                rowData[8][0] = 0;
                rowData[8][1] = 3;
            }
            if (typeName.equalsIgnoreCase("tinyint") || typeName.equalsIgnoreCase("smallint") || typeName.equalsIgnoreCase("integer") || typeName.equalsIgnoreCase("bigint") || typeName.equalsIgnoreCase("float") || typeName.equalsIgnoreCase("double") || typeName.equalsIgnoreCase("numeric")) {
                rowData[9] = String.valueOf(false).getBytes();
                rowData[10] = String.valueOf(true).getBytes();
            } else {
                rowData[9] = String.valueOf(true).getBytes();
                rowData[10] = String.valueOf(false).getBytes();
            }
            rowData[11] = typeName.equalsIgnoreCase("integer") || typeName.equalsIgnoreCase("bigint") ? String.valueOf(true).getBytes() : String.valueOf(false).getBytes();
            rowData[12] = null;
            if (typeName.equalsIgnoreCase("numeric")) {
                rowData[13] = new byte[2];
                rowData[13][0] = 0;
                rowData[13][1] = 0;
                rowData[14] = new byte[2];
                rowData[14][0] = 0;
                rowData[14][1] = 63;
            }
            if (typeName.equalsIgnoreCase("float") || typeName.equalsIgnoreCase("double")) {
                rowData[15] = new byte[4];
                rowData[15][0] = 0;
                rowData[15][1] = 0;
                rowData[15][2] = 0;
                rowData[15][3] = 2;
            } else if (typeName.equalsIgnoreCase("numeric")) {
                rowData[15] = new byte[4];
                rowData[15][0] = 0;
                rowData[15][1] = 0;
                rowData[15][2] = 0;
                rowData[15][3] = 10;
            }
            try {
                rs1.addRow(rowData);
                rowData = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rowData = new byte[16][];
        rowData[0] = "ROWID".getBytes();
        rowData[1] = new byte[4];
        rowData[1][0] = 0;
        rowData[1][1] = 0;
        rowData[1][2] = 0;
        rowData[1][3] = 30;
        rowData[2] = new byte[4];
        rowData[2][0] = 0;
        rowData[2][1] = 0;
        rowData[2][2] = 0;
        rowData[2][3] = 16;
        rowData[3] = null;
        rowData[4] = null;
        rowData[5] = null;
        rowData[6] = new byte[2];
        rowData[6][0] = 0;
        rowData[6][1] = 0;
        rowData[7] = String.valueOf(false).getBytes();
        rowData[8] = new byte[2];
        rowData[8][0] = 0;
        rowData[8][1] = 3;
        rowData[9] = String.valueOf(true).getBytes();
        rowData[10] = String.valueOf(false).getBytes();
        rowData[11] = String.valueOf(false).getBytes();
        rowData[12] = null;
        try {
            rs1.addRow(rowData);
            rowData = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        stm.close();
        rs = null;
        stm = null;
        rs1.setRsIsOver(true);
        rs1.setManificateRs(true);
        return rs1;
    }

    @Override
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getIndexInfo  " + catalog + " , " + schema + " , " + table + " , " + unique + " , " + approximate);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        java.sql.ResultSet rs2 = null;
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        String sql = "";
        String index_key = "";
        Statement stm = (Statement)this.connection.createStatement();
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("TABLE_CAT", 30, 30, 1, real_catalog), new Field("TABLE_SCHEM", 30, 30, 1, real_catalog), new Field("TABLE_NAME", 30, 30, 1, real_catalog), new Field("NON_UNIQUE", 2, 1, 1, real_catalog), new Field("INDEX_QUALIFIER", 30, 10, 1, real_catalog), new Field("INDEX_NAME", 30, 20, 1, real_catalog), new Field("TYPE", 4, 2, 1, real_catalog), new Field("ORDINAL_POSITION", 4, 2, 1, real_catalog), new Field("COLUMN_NAME", 30, 20, 1, real_catalog), new Field("ASC_OR_DESC", 30, 1, 1, real_catalog), new Field("CARDINALITY", 5, 4, 1, real_catalog), new Field("PAGES", 5, 4, 1, real_catalog), new Field("FILTER_CONDITION", 30, 20, 1, real_catalog)};
        Object[] indexObj = null;
        Vector array = new Vector();
        RowData rd = new RowData(array);
        rs = new ResultSet(this.connection, stm, catalog, field, rd, null);
        if (table.equals("%")) {
            if (unique) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo%Unique");
                indexObj = new Object[]{real_schema, unique};
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo%");
                indexObj = new Object[]{real_schema};
            }
        } else if (unique) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfoUnique");
            indexObj = new Object[]{real_schema, unique, "'" + table + "'"};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfo");
            indexObj = new Object[]{real_schema, "'" + table + "'"};
        }
        sql = this.messageFormat.format(indexObj);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            byte[][] rowData = new byte[13][];
            rowData[0] = real_catalog.getBytes();
            rowData[1] = rs1.getString("SCHEMA_NAME").getBytes();
            rowData[2] = rs1.getString("TABLE_NAME").getBytes();
            char c = rs1.getString("IS_UNIQUE").charAt(0);
            rowData[3] = c == 'f' || c == 'F' ? String.valueOf("T").getBytes() : String.valueOf("F").getBytes();
            int i = rs1.getInt("INDEX_TYPE");
            try {
                switch (i) {
                    case 0: {
                        rowData[4] = new String("B\u6811\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                    case 1: {
                        rowData[4] = new String("R\u6811\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                    case 2: {
                        rowData[4] = new String("\u5168\u6587\u7d22\u5f15").getBytes(this.connection.getCharSet());
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            rowData[5] = rs1.getString("INDEX_NAME").getBytes();
            rowData[6] = new byte[2];
            rowData[6][0] = 0;
            rowData[6][1] = 3;
            rowData[9] = null;
            index_key = rs1.getString("KEYS");
            int total = 0;
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getIndexInfoMore");
            Object[] more = new Object[]{rs1.getString("SCHEMA_NAME"), rs1.getString("TABLE_NAME")};
            String sql2 = this.messageFormat.format(more);
            rs2 = stm.executeQuery(sql2);
            while (rs2.next()) {
                total = rs2.getInt(1);
            }
            rowData[10] = new byte[4];
            rowData[10][0] = (byte)((total & 0xFF000000) >> 24);
            rowData[10][1] = (byte)((total & 0xFF0000) >> 16);
            rowData[10][2] = (byte)((total & 0xFF00) >> 8);
            rowData[10][3] = (byte)(total & 0xFF);
            rowData[11] = new byte[4];
            rowData[11][0] = 0;
            rowData[11][1] = 0;
            rowData[11][2] = 0;
            rowData[11][3] = 1;
            rowData[12] = null;
            rowData[7] = new byte[2];
            int post = 0;
            int squ = 1;
            try {
                while ((post = index_key.indexOf(44)) != -1) {
                    byte[][] row = new byte[13][];
                    System.arraycopy(rowData, 0, row, 0, 7);
                    row[8] = index_key.substring(0, post).getBytes();
                    index_key = index_key.substring(post + 1);
                    row[7] = new byte[2];
                    row[7][0] = (byte)((squ & 0xFF00) >> 8);
                    row[7][1] = (byte)(squ & 0xFF);
                    System.arraycopy(rowData, 9, row, 9, 4);
                    rs.addRow(row);
                    squ = (short)(squ + 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rowData[8] = index_key.getBytes();
            rowData[7][0] = (byte)((squ & 0xFF00) >> 8);
            rowData[7][1] = (byte)(squ & 0xFF);
            try {
                rs.addRow(rowData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        stm.close();
        rs1 = null;
        rs2 = null;
        return rs;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsResultSetType");
        }
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsResultSetConcurrency   " + type + " , " + concurrency);
        }
        boolean flag = type == 1003 && concurrency == 1007 || type == 1004 && concurrency == 1007 || type == 1005 && concurrency == 1008;
        return flag;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "ownUpdatesAreVisible   " + type);
        }
        if (type == 1005) {
            return true;
        }
        if (type == 1003 || type == 1004) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "ownDeletesAreVisible   " + type);
        }
        if (type == 1005) {
            return true;
        }
        if (type == 1003 || type == 1004) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "ownInsertsAreVisible   " + type);
        }
        if (type == 1005) {
            return true;
        }
        if (type == 1003 || type == 1004) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "othersUpdatesAreVisible   " + type);
        }
        if (type == 1003 || type == 1004 || type == 1005) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "othersDeletesAreVisible   " + type);
        }
        if (type == 1003 || type == 1004 || type == 1005) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "othersInsertsAreVisible   " + type);
        }
        if (type == 1003 || type == 1004 || type == 1005) {
            return false;
        }
        throw Error.createSQLException("[E50067]\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "updatesAreDetected   " + type);
        }
        switch (type) {
            case 1005: {
                return true;
            }
            case 1003: 
            case 1004: {
                return false;
            }
        }
        throw Error.createSQLException("\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "deletesAreDetected   " + type);
        }
        switch (type) {
            case 1005: {
                return true;
            }
            case 1003: 
            case 1004: {
                return false;
            }
        }
        throw Error.createSQLException("\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "insertsAreDetected   " + type);
        }
        switch (type) {
            case 1005: {
                return true;
            }
            case 1003: 
            case 1004: {
                return false;
            }
        }
        throw Error.createSQLException("\u65e0\u6548\u7684ResultSet\u7c7b\u578b", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50067, 50067);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsBatchUpdates");
        }
        return true;
    }

    @Override
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (Command.debug) {
            String typesStr = "";
            if (types != null && types.length > 0) {
                int i = 0;
                while (i < types.length) {
                    typesStr = i == types.length ? String.valueOf(typesStr) + types[i] : String.valueOf(typesStr) + types[i] + ",";
                    ++i;
                }
            }
            Command.logDMmethods(this.connection.io, "getUDTs   " + catalog + " , " + schemaPattern + " , " + typeNamePattern + " , " + typesStr);
        }
        java.sql.ResultSet rs = null;
        String sp1 = null;
        String sp2 = null;
        String sql = null;
        String[] udtObj = null;
        int sepInt = 0;
        Statement stm = (Statement)this.connection.createStatement(false);
        if (typeNamePattern == null) {
            typeNamePattern = "%";
        }
        if ((sepInt = typeNamePattern.indexOf(".")) != -1) {
            sp1 = typeNamePattern.substring(0, sepInt);
            typeNamePattern = typeNamePattern.substring(sepInt + 1);
        }
        if ((sepInt = typeNamePattern.indexOf(".")) != -1) {
            sp2 = typeNamePattern.substring(0, sepInt);
            typeNamePattern = typeNamePattern.substring(sepInt + 1);
        }
        if (sp2 != null) {
            catalog = sp1;
            schemaPattern = sp2;
        }
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String inSql = "";
        String ininSql = "";
        int in = 0;
        if (types != null) {
            int j = 0;
            while (j < types.length) {
                if (in == 0) {
                    if (types[j] == 2002 || types[j] == 2001) {
                        ++in;
                        switch (types[j]) {
                            case 2002: {
                                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTsIn1");
                                break;
                            }
                            case 2001: {
                                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTsIn2");
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    switch (types[j]) {
                        case 2002: {
                            ininSql = String.valueOf(ininSql) + " or UDT_TYPE in(1001,1005)";
                            break;
                        }
                        case 2001: {
                            ininSql = String.valueOf(ininSql) + " or UDT_TYPE =1005";
                            break;
                        }
                    }
                }
                ++j;
            }
            if (in > 0) {
                inSql = this.messageFormat.format(new String[]{ininSql});
            }
        }
        if (typeNamePattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTs%");
            udtObj = new String[]{"'" + this.curr_db + "'", String.valueOf(2002), String.valueOf(2002), String.valueOf(2001), String.valueOf(2001), real_schema, inSql};
            sql = this.messageFormat.format(udtObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getUDTs");
            udtObj = new String[]{"'" + this.curr_db + "'", String.valueOf(2002), String.valueOf(2002), String.valueOf(2001), String.valueOf(2001), real_schema, "'" + typeNamePattern + "'", inSql};
            sql = this.messageFormat.format(udtObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getConnection");
        }
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsSavepoints");
        }
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsNamedParameters");
        }
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsMultipleOpenResults");
        }
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsGetGeneratedKeys");
        }
        return true;
    }

    @Override
    public java.sql.ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSuperTypes   " + catalog + " , " + schemaPattern + " , " + typeNamePattern);
        }
        java.sql.ResultSet rs = null;
        String sql = null;
        String[] sTypesObj = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        if (typeNamePattern == null) {
            typeNamePattern = "%";
        }
        if (typeNamePattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSuperTypes%");
            sTypesObj = new String[]{"'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", real_schema};
            sql = this.messageFormat.format(sTypesObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSuperTypes");
            sTypesObj = new String[]{"'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", "'" + this.curr_db + "'", real_schema, "'" + typeNamePattern + "'"};
            sql = this.messageFormat.format(sTypesObj);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        stm = null;
        return rs;
    }

    @Override
    public java.sql.ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSuperTables\u672a\u5b9e\u73b0  ");
        }
        throw SQLCommon.unSupportException();
    }

    @Override
    public java.sql.ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getAttributes   " + catalog + " , " + schemaPattern + " , " + typeNamePattern + " , " + attributeNamePattern);
        }
        this.checkConnectionOpen();
        java.sql.ResultSet rs = null;
        Object[] atrributeObj = null;
        int udtType = 0;
        Statement stm = (Statement)this.connection.createStatement(false);
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        if (typeNamePattern.equalsIgnoreCase("object")) {
            udtType = 1001;
        }
        if (typeNamePattern.equalsIgnoreCase("array")) {
            udtType = 1004;
        }
        if (typeNamePattern.equalsIgnoreCase("table")) {
            udtType = 1005;
        }
        if ((typeNamePattern == null || typeNamePattern.equals("%")) && (attributeNamePattern == null || attributeNamePattern.equals("%"))) {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttributeNameAndType%"));
        } else if (typeNamePattern == null || typeNamePattern.equals("%")) {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema, "'" + attributeNamePattern + "'"};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttributeType%"));
        } else if (attributeNamePattern == null || attributeNamePattern.equals("%")) {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema, String.valueOf(udtType)};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttributeName%"));
        } else {
            atrributeObj = new Object[]{"'" + this.curr_db + "'", (short)2, real_schema, "'" + attributeNamePattern + "'", String.valueOf(udtType)};
            this.messageFormat = new MessageFormat(SQLCommon.getProperties().getProperty("DatabaseMetadata.getAttribute"));
        }
        String sql = this.messageFormat.format(atrributeObj);
        rs = stm.executeQuery(sql);
        stm.close();
        stm = null;
        return rs;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsResultSetHoldability");
        }
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getResultSetHoldability");
        }
        return this.connection.RsHoldablity;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseMajorVersion");
        }
        String versionStr = this.getDatabaseProductVersion();
        int majorVersion = 0;
        majorVersion = this.connection.isora ? Integer.valueOf(versionStr) : Integer.parseInt(versionStr.substring(versionStr.indexOf("Server") + 7, versionStr.indexOf(".")));
        return majorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getDatabaseMinorVersion");
        }
        if (this.connection.isIsora()) {
            return 0;
        }
        String versionStr = this.getDatabaseProductVersion();
        String version = versionStr.substring(versionStr.indexOf("Server") + 7);
        int minorVersion = Integer.parseInt(version.substring(version.indexOf(".") + 1, version.lastIndexOf(".")));
        return minorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getJDBCMajorVersion");
        }
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getJDBCMinorVersion");
        }
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSQLStateType");
        }
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "locatorsUpdateCopy");
        }
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsStatementPooling");
        }
        return false;
    }

    @Override
    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getVersionColumns\u672a\u5b9e\u73b0   " + catalog + " , " + schema + " , " + table);
        }
        throw SQLCommon.unSupportException();
    }

    @Override
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getPrimaryKeys   " + catalog + " , " + schema + " , " + table);
        }
        ResultSet rs = null;
        ResultSet[] rs_more = null;
        int p = 0;
        String column_name = null;
        String c_name = null;
        Statement stm = (Statement)this.connection.createStatement(false);
        String[] s = null;
        String[] pk_name = null;
        String[] table_name = null;
        String[] schema_name = null;
        String sql1 = null;
        String sql2 = null;
        Object[] primaryObj = null;
        String real_schema = this.getRealSchemas(catalog, schema);
        int i = 1;
        int tableCount = 0;
        byte[][] line = new byte[6][];
        if (table == null) {
            table = "%";
        }
        if (table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getPrimaryKeys1");
            primaryObj = new Object[]{"'" + this.curr_db + "'", real_schema};
            sql1 = this.messageFormat.format(primaryObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getPrimaryKeys2");
            primaryObj = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + table + "'"};
            sql1 = this.messageFormat.format(primaryObj);
        }
        try {
            rs = (ResultSet)stm.executeQuery(sql1);
            tableCount = rs.getRowCount();
            if (tableCount != 0) {
                s = new String[tableCount];
                pk_name = new String[tableCount];
                table_name = new String[tableCount];
                schema_name = new String[tableCount];
                rs_more = new ResultSet[tableCount];
                int subscript = 0;
                while (rs.next()) {
                    i = 1;
                    if (subscript < tableCount) {
                        this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getPrimaryKeys3");
                        s[subscript] = rs.getString(1);
                        pk_name[subscript] = rs.getString(2);
                        table_name[subscript] = rs.getString(3);
                        schema_name[subscript] = rs.getString(4);
                        p = s[subscript].indexOf(44);
                        if (p == -1) {
                            column_name = s[subscript].substring(1, s[subscript].lastIndexOf("\""));
                            primaryObj = new Object[]{"'" + this.curr_db + "'", "'" + table_name[subscript] + "'", "'" + column_name + "'", "'" + i + "'", "'" + schema_name[subscript] + "'", "'" + table_name[subscript] + "'"};
                            sql2 = this.messageFormat.format(primaryObj);
                            rs_more[subscript] = (ResultSet)stm.executeQuery(sql2);
                        } else {
                            column_name = c_name = s[subscript].substring(1, p - 1);
                            s[subscript] = s[subscript].substring(p + 1);
                            primaryObj = new Object[]{"'" + this.curr_db + "'", "'" + table_name[subscript] + "'", "'" + column_name + "'", "'" + i + "'", "'" + schema_name[subscript] + "'", "'" + table_name[subscript] + "'"};
                            sql2 = this.messageFormat.format(primaryObj);
                            rs_more[subscript] = (ResultSet)stm.executeQuery(sql2);
                            while ((p = s[subscript].indexOf(44)) != -1) {
                                column_name = c_name = s[subscript].substring(1, p - 1);
                                s[subscript] = s[subscript].substring(p + 1);
                                line = new byte[][]{rs.getString(5).getBytes(), rs.getString(4).getBytes(), table_name[subscript].getBytes(), column_name.getBytes(), Integer.toString(++i).getBytes(), pk_name[subscript].getBytes()};
                                rs_more[subscript].addRow(line);
                            }
                            column_name = s[subscript].substring(1, s[subscript].lastIndexOf("\""));
                            line = new byte[][]{rs.getString(5).getBytes(), rs.getString(4).getBytes(), table_name[subscript].getBytes(), column_name.getBytes(), Integer.toString(++i).getBytes(), pk_name[subscript].getBytes()};
                            rs_more[subscript].addRow(line);
                        }
                    }
                    if (subscript != 0) {
                        rs_more[0].addVector(rs_more[subscript].getRs_rowdata());
                    }
                    ++subscript;
                }
                if (rs_more[0] != null) {
                    rs_more[0].setRsIsOver(true);
                    rs_more[0].setManificateRs(true);
                } else {
                    rs_more[0] = (ResultSet)stm.executeQuery(sql2);
                }
                ResultSet resultSet = rs_more[0];
                return resultSet;
            }
            java.sql.ResultSet pRS = null;
            if (table.equals("%")) {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getPrimaryKeys4");
                primaryObj = new Object[]{"'" + this.curr_db + "'", "'" + column_name + "'", "'" + i + "'", real_schema};
                sql2 = this.messageFormat.format(primaryObj);
            } else {
                this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getPrimaryKeys5");
                primaryObj = new Object[]{"'" + this.curr_db + "'", "'" + column_name + "'", "'" + i + "'", real_schema, "'" + table + "'"};
                sql2 = this.messageFormat.format(primaryObj);
            }
            java.sql.ResultSet resultSet = pRS = stm.executeQuery(sql2);
            return resultSet;
        }
        catch (Exception e) {
            java.sql.ResultSet resultSet = stm.executeQuery(sql2);
            return resultSet;
        }
        finally {
            rs.close();
            stm.close();
        }
    }

    @Override
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getImportedKeys   " + catalog + " , " + schema + " , " + table);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        String sql = null;
        Statement stm = (Statement)this.connection.createStatement();
        String real_schema = this.getRealSchemas(catalog, schema);
        String real_catalog = this.getRealCatalog(catalog);
        int f = 32;
        if (table == null) {
            table = "%";
        }
        Field[] field = new Field[]{new Field("PKTABLE_CAT", 30, 20, 1, real_catalog), new Field("PKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("PKTABLE_NAME", 30, 20, 1, real_catalog), new Field("PKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("FKTABLE_CAT", 30, 20, 1, real_catalog), new Field("FKTABLE_SCHEM", 30, 20, 1, real_catalog), new Field("FKTABLE_NAME", 30, 20, 1, real_catalog), new Field("FKCOLUMN_NAME", 30, 20, 1, real_catalog), new Field("KEY_SEQ", 4, 2, 1, real_catalog), new Field("UPDATE_RULE", 4, 2, 1, real_catalog), new Field("DELETE_RULE", 4, 2, 1, real_catalog), new Field("FK_NAME", 30, 20, 1, real_catalog), new Field("PK_NAME", 30, 20, 1, real_catalog), new Field("DEFERRABILITY", 4, 2, 1, real_catalog)};
        Vector array = new Vector();
        Object[] imortObject = null;
        RowData rowData = new RowData(array);
        rs = new ResultSet(this.connection, stm, catalog, field, rowData, null);
        if (table.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getImportedKeys%");
            imortObject = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", real_schema, real_schema};
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getImportedKeys");
            imortObject = new Object[]{"'" + this.curr_db + "'", real_schema, "'" + this.curr_db + "'", "'" + table + "'", real_schema, real_schema};
        }
        sql = this.messageFormat.format(imortObject);
        rs1 = stm.executeQuery(sql);
        while (rs1.next()) {
            byte[][] data;
            int i = 1;
            int post = 0;
            String fColumn = null;
            String f_kColumns = rs1.getString(2);
            fColumn = this.trimString(f_kColumns);
            while ((post = fColumn.indexOf(",")) != -1) {
                data = new byte[14][];
                data[0] = rs1.getString(12).getBytes();
                data[1] = rs1.getString(7).getBytes();
                data[2] = rs1.getString(8).getBytes();
                data[3] = rs1.getString(6).getBytes();
                data[4] = rs1.getString(11).getBytes();
                data[5] = rs1.getString(10).getBytes();
                data[6] = rs1.getString(9).getBytes();
                f = rs1.getString(3).charAt(0);
                switch (f) {
                    case 78: 
                    case 110: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 3;
                        break;
                    }
                    case 67: 
                    case 99: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 0;
                        break;
                    }
                    case 85: 
                    case 117: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 2;
                        break;
                    }
                    case 68: 
                    case 100: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 4;
                        break;
                    }
                    case 82: 
                    case 114: {
                        data[9] = new byte[2];
                        data[9][0] = 0;
                        data[9][1] = 1;
                        break;
                    }
                }
                f = rs1.getString(4).charAt(0);
                switch (f) {
                    case 78: 
                    case 110: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 3;
                        break;
                    }
                    case 67: 
                    case 99: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 0;
                        break;
                    }
                    case 85: 
                    case 117: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 2;
                        break;
                    }
                    case 68: 
                    case 100: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 4;
                        break;
                    }
                    case 82: 
                    case 114: {
                        data[10] = new byte[2];
                        data[10][0] = 0;
                        data[10][1] = 1;
                        break;
                    }
                }
                data[11] = rs1.getString(1).getBytes();
                data[12] = rs1.getString(5).getBytes();
                data[13] = new byte[2];
                data[13][0] = 0;
                data[13][1] = 5;
                data[7] = fColumn.substring(0, post).getBytes();
                fColumn = fColumn.substring(post + 1);
                data[8] = new byte[2];
                data[8][0] = (byte)((i & 0xFF00) >> 8);
                data[8][1] = (byte)(i & 0xFF);
                i = (short)(i + 1);
                try {
                    rs.addRow(data);
                    data = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            data = new byte[14][];
            data[0] = rs1.getString(12).getBytes();
            data[1] = rs1.getString(7).getBytes();
            data[2] = rs1.getString(8).getBytes();
            data[3] = rs1.getString(6).getBytes();
            data[4] = rs1.getString(11).getBytes();
            data[5] = rs1.getString(10).getBytes();
            data[6] = rs1.getString(9).getBytes();
            f = rs1.getString(3).charAt(0);
            switch (f) {
                case 78: 
                case 110: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 3;
                    break;
                }
                case 67: 
                case 99: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 0;
                    break;
                }
                case 85: 
                case 117: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 2;
                    break;
                }
                case 68: 
                case 100: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 4;
                    break;
                }
                case 82: 
                case 114: {
                    data[9] = new byte[2];
                    data[9][0] = 0;
                    data[9][1] = 1;
                    break;
                }
            }
            f = rs1.getString(4).charAt(0);
            switch (f) {
                case 78: 
                case 110: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 3;
                    break;
                }
                case 67: 
                case 99: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 0;
                    break;
                }
                case 85: 
                case 117: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 2;
                    break;
                }
                case 68: 
                case 100: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 4;
                    break;
                }
                case 82: 
                case 114: {
                    data[10] = new byte[2];
                    data[10][0] = 0;
                    data[10][1] = 1;
                    break;
                }
            }
            data[11] = rs1.getString(1).getBytes();
            data[12] = rs1.getString(5).getBytes();
            data[13] = new byte[2];
            data[13][0] = 0;
            data[13][1] = 5;
            data[7] = fColumn.substring(0).getBytes();
            fColumn = fColumn.substring(post + 1);
            data[8] = new byte[2];
            data[8][0] = (byte)((i & 0xFF00) >> 8);
            data[8][1] = (byte)(i & 0xFF);
            i = (short)(i + 1);
            try {
                rs.addRow(data);
                data = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stm.close();
        rs1.close();
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "autoCommitFailureClosesAllResultSets");
        }
        return false;
    }

    @Override
    public java.sql.ResultSet getClientInfoProperties() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getClientInfoProperties");
        }
        String catalog = this.getRealCatalog("");
        Properties clientInfo = this.connection.getClientInfo();
        Field[] field = new Field[]{new Field("NAME", 30, 50, 1, catalog), new Field("MAX_LEN", 5, 4, 1, catalog), new Field("DEFAULT_VALUE", 30, 50, 1, catalog), new Field("DESCRIPTION", 30, 100, 1, catalog)};
        Vector<byte[][]> clientArray = new Vector<byte[][]>();
        RowData clientRowData = new RowData(clientArray);
        Statement stm = (Statement)this.connection.createStatement();
        ResultSet cliengRs = new ResultSet(this.connection, stm, catalog, field, clientRowData, null);
        Enumeration<?> en = clientInfo.propertyNames();
        while (en.hasMoreElements()) {
            byte[][] clientBytes = new byte[4][];
            String strKey = (String)en.nextElement();
            String strValue = clientInfo.getProperty(strKey);
            clientBytes[0] = strKey.getBytes();
            clientBytes[1] = new byte[4];
            clientBytes[1][3] = 0;
            clientBytes[1][2] = 0;
            clientBytes[1][1] = 0;
            clientBytes[1][0] = 50;
            clientBytes[2] = strValue.getBytes();
            clientBytes[3] = "".getBytes();
            clientArray.add(clientBytes);
        }
        stm.close();
        cliengRs.setRsIsOver(true);
        cliengRs.setManificateRs(true);
        return cliengRs;
    }

    @Override
    public java.sql.ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getFunctionColumns\u672a\u5b9e\u73b0        " + catalog + " , " + schemaPattern + " , " + functionNamePattern + " , " + columnNamePattern);
        }
        throw SQLCommon.unSupportException();
    }

    @Override
    public java.sql.ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getFunctions   " + catalog + " , " + schemaPattern + " , " + functionNamePattern);
        }
        ResultSet rs = null;
        java.sql.ResultSet rs1 = null;
        String sql = null;
        String[] funObj = null;
        String real_schema = this.getRealSchemas(catalog, schemaPattern);
        String real_catalog = this.getRealCatalog(catalog);
        Statement stm = (Statement)this.connection.createStatement(false);
        if (functionNamePattern == null) {
            functionNamePattern = "%";
        }
        if (!functionNamePattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getFunctions");
            funObj = new String[]{"'" + this.curr_db + "'", "'1'", "'1'", "'2'", "'" + functionNamePattern + "'", real_schema};
            sql = this.messageFormat.format(funObj);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getFunctions%");
            funObj = new String[]{"'" + this.curr_db + "'", "'1'", "'1'", "'2'", real_schema};
            sql = this.messageFormat.format(funObj);
        }
        String sql1 = null;
        sql1 = functionNamePattern.equals("%") ? SQLCommon.getMessageFormat("DatabaseMetadata.getFunctionsSys%").format(null) : SQLCommon.getMessageFormat("DatabaseMetadata.getFunctionsSys").format(new String[]{"'" + functionNamePattern + "'"});
        rs = (ResultSet)stm.executeQuery(sql);
        rs1 = stm.executeQuery(sql1);
        int i = 1;
        while (rs1.next()) {
            String name = rs1.getString(1);
            byte[][] data = new byte[17][];
            data[0] = "SYSTEM".getBytes();
            data[1] = "SYSDBA".getBytes();
            data[2] = name.getBytes();
            data[3] = "System function".getBytes();
            data[4] = new byte[2];
            data[4][0] = 0;
            data[4][1] = 0;
            data[5] = (String.valueOf(name) + "_" + i).getBytes();
            ++i;
            try {
                rs.addRow(data);
                data = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rs1.close();
        stm.close();
        sql = null;
        sql1 = null;
        rs.setRsIsOver(true);
        rs.setManificateRs(true);
        return rs;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public java.sql.ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        java.sql.ResultSet rs = null;
        String sql = null;
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "getSchemas   " + catalog + " , " + schemaPattern);
        }
        Statement stm = (Statement)this.connection.createStatement(false);
        if (schemaPattern == null) {
            schemaPattern = "%";
        } else if (schemaPattern.equals("")) {
            schemaPattern = this.curr_user;
        }
        if (schemaPattern.equals("%")) {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSchemasPram%");
            Object[] sParam = new Object[]{"'" + this.curr_db + "'"};
            sql = this.messageFormat.format(sParam);
        } else {
            this.messageFormat = SQLCommon.getMessageFormat("DatabaseMetadata.getSchemasPram");
            Object[] sParam = new Object[]{"'" + this.curr_db + "'", "'" + schemaPattern + "'"};
            sql = this.messageFormat.format(sParam);
        }
        rs = stm.executeQuery(sql);
        stm.close();
        return rs;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (Command.debug) {
            Command.logDMmethods(this.connection.io, "supportsStoredFunctionsUsingCallSyntax");
        }
        return true;
    }

    private String trimString(String temp) {
        String pColumn = null;
        pColumn = temp.indexOf("(") != -1 ? temp.substring(temp.indexOf("(") + 1, temp.indexOf(")")) : temp;
        return pColumn;
    }

    private String getTableRealType(java.sql.Statement stm, String objName, String objSchema) {
        java.sql.ResultSet rs = null;
        String type = null;
        if (objName.equals("%")) {
            return "TABLE";
        }
        String sql = SQLCommon.getMessageFormat("DatabaseMetadata.getTableRealType").format(new String[]{objSchema, "'" + objName + "'"});
        try {
            rs = stm.executeQuery(sql);
            type = rs.next() ? "TABLE" : "VIEW";
            rs.close();
            rs = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return type;
    }

    private String rsToString(java.sql.ResultSet rs) throws SQLException {
        StringBuffer allString = new StringBuffer();
        int i = 0;
        allString.append("'");
        while (rs.next()) {
            if (i == 0) {
                allString.append(rs.getString(1));
            } else {
                allString.append("','");
                allString.append(rs.getString(1));
            }
            ++i;
        }
        allString.append("'");
        return allString.toString();
    }

    private String getRealSchemas(String catalog, String schema) throws SQLException {
        this.checkConnectionOpen();
        if (schema != null && !schema.equals("%") && !schema.equals("")) {
            return "'" + schema + "'";
        }
        try {
            java.sql.ResultSet schemaRs = this.getSchemas(catalog, schema);
            this.schemaString = this.rsToString(schemaRs);
            schemaRs.close();
            schemaRs = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.schemaString;
    }

    private String getRealCatalog(String catalog) {
        return this.curr_db;
    }

    private void checkConnectionOpen() throws SQLException {
        this.connection.checkOpen();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }
}

