/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.LogWriter;
import com.xugu.cloudjdbc.SSL;
import com.xugu.cloudjdbc.SlowSQLBean;
import com.xugu.cloudjdbc.TurningComputer;
import com.xugu.common.ReplaceEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionIO {
    long ConnectBeginTime = 0L;
    public LogWriter lw;
    protected static boolean logError = false;
    protected static Logger logback;
    int sessionId = 0;
    private int connIOType;
    private String connIOHashKey;
    private boolean useSSL = false;
    private String serverIp;
    private int serverPort;
    private byte[] public_key = new byte[32];
    private byte[] trail_key = new byte[32];
    private byte[] key = new byte[32];
    private TurningComputer turing_read = new TurningComputer();
    private TurningComputer turing_send = new TurningComputer();
    private final Object mutex = new Object();
    private volatile boolean bLocked = false;
    private SocketChannel socketChannel;
    private ByteBuffer byteBuffer;
    private ByteBuffer recbyteBuffer;
    private byte controlByte = 0;
    private final int bufferSize = 65536;
    private final int netBufferSize = 0x400000;
    private static int maxCommandLength;
    private volatile int connState = 0;
    private boolean isClosed;
    private String host;
    private int port = 5138;
    String connectString;
    boolean is_Object = false;
    HashMap<String, Vector<String>> connIpsPool;
    private String charSet = "GBK";
    long sqlCountIn = 1L;
    long sqlCountOut = 1L;
    SQLException streamError;
    Vector<String> streamErrVector = new Vector();
    String streamWarning;
    Receive rcThread;
    boolean isRecived = false;
    private boolean isHalt = false;
    private long stIdGen = 0L;
    private long curIdGen = 0L;
    public long serverStartT;
    public long recvStartT;
    private String executeSQL;
    private boolean ioAutoCommit = true;
    private boolean rebuildConnection = false;
    protected int serverProtocolVersion = 201;
    private int validFrequency;
    boolean isValidateCon;
    int validatePerTimes;
    private SlowSQLBean slowSQLBean;

    static {
        maxCommandLength = 0x200000;
    }

    public void setExecuteSQL(String executeSQL) {
        this.executeSQL = executeSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionIO(String host, int port, String connectString, String charset, String hashKey, int ioType, String passwd, boolean useSSL, boolean printVersion, boolean autoCommitFlag, boolean rebuildConnet, int validateFrequencyTime, int validateTimes, boolean isValidate, SlowSQLBean slowBean) throws SQLException {
        this.host = host;
        this.port = port;
        this.connectString = connectString;
        this.connIOType = ioType;
        this.connIOHashKey = hashKey;
        this.useSSL = useSSL;
        this.validFrequency = validateFrequencyTime;
        this.validatePerTimes = validateTimes;
        this.isValidateCon = isValidate;
        this.slowSQLBean = slowBean;
        this.byteBuffer = ByteBuffer.allocate(65536);
        this.recbyteBuffer = ByteBuffer.allocate(65536);
        if (ioType == 0) {
            this.createSocketChannel();
        } else {
            Object object = Connection.ipPoolLock;
            synchronized (object) {
                this.createSocketChannelMoreIps(0, false);
            }
        }
        if (Command.debug || printVersion || slowBean != null) {
            this.lw = LogWriter.getInstance();
        }
        if (logError) {
            logback = LoggerFactory.getLogger(ConnectionIO.class);
        }
        try {
            if (useSSL) {
                this.doHandShakeSSL(passwd);
            } else {
                this.doHandShake(null);
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        if (this.slowSQLBean != null) {
            this.slowSQLBean.setHost(this.serverIp);
        }
        this.ioAutoCommit = autoCommitFlag;
        this.rebuildConnection = rebuildConnet;
        this.charSet = charset;
    }

    private boolean createSocketChannel() throws SQLException {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = this.getInetSocketAddress(this.host, this.port);
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.socket().setReuseAddress(false);
            this.socketChannel.connect(inetSocketAddress);
            this.socketChannel.socket().setTcpNoDelay(true);
            this.socketChannel.socket().setSoTimeout(3600000);
            this.socketChannel.socket().setSoLinger(true, 0);
            this.socketChannel.socket().setReceiveBufferSize(0x400000);
            this.socketChannel.socket().setSendBufferSize(0x400000);
            while (!this.socketChannel.finishConnect()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            this.setConnState(-1);
            try {
                this.socketChannel.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.isClosed = true;
            throw Error.createSQLException("[E50025]\u65e0\u6cd5\u8fde\u63a5\u4e0a\u670d\u52a1\u5668\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u670d\u52a1\u5668\u5730\u5740\u9519\u8bef\n2.\u76d1\u542c\u7aef\u53e3\u9519\u8bef\n3.\u670d\u52a1\u5668\u5173\u95ed\n4.\u7f51\u7edc\u65ad\u5f00 \n5. " + e.getMessage() + " \n6. host: " + this.host + "  port: " + this.port, String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50025, 50025);
        }
        return true;
    }

    private boolean createSocketChannelRandom(int retry, String hashKey) throws SQLException {
        InetSocketAddress inetSocketAddress = null;
        Vector<String> ipsVector = Connection.ipPool.get(hashKey);
        String curIp = null;
        if (ipsVector == null || ipsVector.size() <= 0) {
            throw Error.createSQLException("[E51024]\u672a\u7ed9\u5b9a\u8fde\u63a5IP\u4fe1\u606f,\u6216\u7ed9\u5b9a\u8fde\u63a5IP\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51024, 51024);
        }
        int curr_index = new Random().nextInt(ipsVector.size());
        curIp = ipsVector.get(curr_index);
        try {
            inetSocketAddress = this.getInetSocketAddress(ipsVector.get(curr_index), this.port);
            this.socketChannel = SocketChannel.open();
            this.socketChannel.connect(inetSocketAddress);
            this.socketChannel.socket().setTcpNoDelay(true);
            this.socketChannel.socket().setSoTimeout(3600000);
            this.socketChannel.socket().setSoLinger(true, 0);
            this.socketChannel.socket().setReceiveBufferSize(0x400000);
            this.socketChannel.socket().setSendBufferSize(0x400000);
            while (!this.socketChannel.finishConnect()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.serverIp = ipsVector.get(curr_index);
        }
        catch (Exception e) {
            if (ipsVector.size() < Connection.ipPool.get(String.valueOf(hashKey) + "ipsbak").size()) {
                Vector ipsVector_bak = (Vector)Connection.ipPool.get(String.valueOf(hashKey) + "ipsbak").clone();
                ipsVector_bak.removeElement(ipsVector.get(curr_index));
                Connection.ipPool.put(hashKey, ipsVector_bak);
            } else {
                ipsVector.remove(curr_index);
            }
            if (ipsVector.size() == 0 || retry > ipsVector.size()) {
                this.setConnState(-1);
                this.isClosed = true;
                throw Error.createSQLException("[E51023]\u91cd\u8bd5" + retry + "\u6b21\uff0c\u65e0\u6cd5\u8fde\u63a5\u4e0a\u670d\u52a1\u5668:" + curIp + "\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u670d\u52a1\u5668\u5730\u5740\u9519\u8bef\n2.\u76d1\u542c\u7aef\u53e3\u9519\u8bef\n3.\u670d\u52a1\u5668\u5173\u95ed\n4.\u7f51\u7edc\u65ad\u5f00", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51023, 51023);
            }
            this.createSocketChannelRandom(++retry, hashKey);
        }
        return true;
    }

    private boolean createSocketChannelRound(int retry, String hashKey) throws SQLException {
        InetSocketAddress inetSocketAddress = null;
        Vector<String> ipsVector = Connection.ipPool.get(hashKey);
        String curIp = null;
        if (ipsVector == null || ipsVector.size() <= 0) {
            throw Error.createSQLException("[E51024]\u672a\u7ed9\u5b9a\u8fde\u63a5IP\u4fe1\u606f,\u6216\u7ed9\u5b9a\u8fde\u63a5IP\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51024, 51024);
        }
        int curr_index = 0;
        curr_index = retry > 0 ? Connection.getRoundIdx(false) % ipsVector.size() : Connection.getRoundIdx(true) % ipsVector.size();
        if (Connection.getRoundIdx(false) >= Integer.MAX_VALUE) {
            Connection.setRoundIdx(curr_index);
        }
        try {
            String curAddr = ipsVector.get(curr_index);
            int cIndex = curAddr.indexOf(":");
            curIp = curAddr.substring(0, cIndex);
            int curPort = Integer.parseInt(curAddr.substring(cIndex + 1));
            inetSocketAddress = this.getInetSocketAddress(curIp, curPort);
            this.socketChannel = SocketChannel.open();
            this.socketChannel.connect(inetSocketAddress);
            this.socketChannel.socket().setTcpNoDelay(true);
            this.socketChannel.socket().setSoTimeout(3600000);
            this.socketChannel.socket().setSoLinger(true, 0);
            this.socketChannel.socket().setReceiveBufferSize(0x400000);
            this.socketChannel.socket().setSendBufferSize(0x400000);
            while (!this.socketChannel.finishConnect()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.serverIp = curIp;
            this.serverPort = curPort;
        }
        catch (Exception e) {
            if (ipsVector.size() < Connection.ipPool.get(String.valueOf(hashKey) + "ipsbak").size()) {
                Vector ipsVector_bak = (Vector)Connection.ipPool.get(String.valueOf(hashKey) + "ipsbak").clone();
                ipsVector_bak.removeElement(ipsVector.get(curr_index));
                Connection.ipPool.put(hashKey, ipsVector_bak);
            } else if (Connection.ipPool.get(String.valueOf(hashKey) + "ipsbak").size() > 1) {
                ipsVector.remove(curr_index);
            }
            if (ipsVector.size() == 0 || retry > ipsVector.size()) {
                this.setConnState(-1);
                this.isClosed = true;
                throw Error.createSQLException("[E51023]\u91cd\u8bd5" + retry + "\u6b21\uff0c\u65e0\u6cd5\u8fde\u63a5\u4e0a\u670d\u52a1\u5668:" + curIp + "\uff0c" + e.getMessage() + ",ipsVector size is: " + ipsVector.size() + ",\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u670d\u52a1\u5668\u5730\u5740\u9519\u8bef\n2.\u76d1\u542c\u7aef\u53e3\u9519\u8bef\n3.\u670d\u52a1\u5668\u5173\u95ed\n4.\u7f51\u7edc\u65ad\u5f00", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51023, 51023);
            }
            this.createSocketChannelRound(++retry, hashKey);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSocketChannelMoreIps(int retry, boolean IsmoveIp) throws SQLException {
        InetSocketAddress inetSocketAddress = null;
        Vector<ArrayList<String>> ipVectors = Connection.ipsVector;
        ArrayList<String> perIpList = null;
        String curIp = null;
        if (ipVectors == null || ipVectors.size() <= 0) {
            throw Error.createSQLException("[E51024]\u672a\u7ed9\u5b9a\u8fde\u63a5IP\u4fe1\u606f,\u6216\u7ed9\u5b9a\u8fde\u63a5IP\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51024, 51024);
        }
        Object object = Connection.ipPoolLock;
        synchronized (object) {
            if (!Connection.isValidateFlag() && Connection.unConList.size() > 0) {
                ScheduledThreadPoolExecutor task = Connection.getValidTaskExecutor();
                if (task == null || task.isShutdown()) {
                    task = ConnectionIO.getExecutorStatic();
                    Connection.setValidTaskExecutor(task);
                    task.scheduleAtFixedRate(new detactedIpNode(), this.validFrequency, this.validFrequency, TimeUnit.MINUTES);
                }
                Connection.setValidateFlag(true);
            }
        }
        if (Connection.isNewConnection()) {
            perIpList = this.getConnectInfoListByConTimes();
            if (perIpList.get(1).equals("0")) {
                object = Connection.validTaskExecutor;
            }
            if (!Boolean.parseBoolean(perIpList.get(4))) {
                Connection.setNewConnection(false);
            }
        } else {
            perIpList = this.getConnectInfoListRound(IsmoveIp);
        }
        try {
            curIp = perIpList.get(0);
            int curPort = Integer.parseInt(perIpList.get(3));
            inetSocketAddress = this.getInetSocketAddress(curIp, curPort);
            this.socketChannel = SocketChannel.open();
            this.socketChannel.socket().setReuseAddress(false);
            this.socketChannel.connect(inetSocketAddress);
            this.socketChannel.socket().setTcpNoDelay(true);
            this.socketChannel.socket().setSoTimeout(3600000);
            this.socketChannel.socket().setSoLinger(true, 0);
            this.socketChannel.socket().setReceiveBufferSize(0x400000);
            this.socketChannel.socket().setSendBufferSize(0x400000);
            while (!this.socketChannel.finishConnect()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.serverIp = curIp;
            this.serverPort = curPort;
            perIpList.set(1, String.valueOf(Integer.parseInt(perIpList.get(1)) + 1));
        }
        catch (Exception e) {
            boolean hasMoveIp = false;
            int failedCount = Integer.parseInt(perIpList.get(2));
            if (failedCount == 0) {
                perIpList.set(2, String.valueOf(failedCount + 1));
            } else {
                ipVectors.remove(perIpList);
                hasMoveIp = true;
                if (this.isValidateCon) {
                    String[] moveIpInfo = new String[]{perIpList.get(0), perIpList.get(3)};
                    Object object2 = Connection.ipPoolLock;
                    synchronized (object2) {
                        Connection.unConList.add(moveIpInfo);
                    }
                }
            }
            if (ipVectors.size() == 0 || retry > ipVectors.size()) {
                this.setConnState(-1);
                this.isClosed = true;
                throw Error.createSQLException("[E51023]\u91cd\u8bd5" + retry + "\u6b21\uff0c\u65e0\u6cd5\u8fde\u63a5\u4e0a\u670d\u52a1\u5668:" + curIp + "\uff0c" + e.getMessage() + ",ipsVector size is: " + ipVectors.size() + ",\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u670d\u52a1\u5668\u5730\u5740\u9519\u8bef\n2.\u76d1\u542c\u7aef\u53e3\u9519\u8bef\n3.\u670d\u52a1\u5668\u5173\u95ed\n4.\u7f51\u7edc\u65ad\u5f00", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51023, 51023);
            }
            this.createSocketChannelMoreIps(++retry, hasMoveIp);
        }
        return true;
    }

    private InetSocketAddress getInetSocketAddress(String connIp, int connPort) throws SQLException {
        InetSocketAddress inetSocketAddress = null;
        InetAddress[] possibleAddresses = null;
        try {
            possibleAddresses = InetAddress.getAllByName(connIp);
        }
        catch (Exception ex) {
            throw Error.createSQLException("[E50026]\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740: " + ex.toString(), String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50026, 50026);
        }
        int i = 0;
        if (i < possibleAddresses.length) {
            try {
                inetSocketAddress = new InetSocketAddress(possibleAddresses[i], connPort);
                this.serverIp = possibleAddresses[i].toString().substring(1);
                this.serverPort = connPort;
            }
            catch (Exception ex) {
                throw Error.createSQLException("[50026]\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740: " + ex.toString(), String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50026, 50026);
            }
        }
        return inetSocketAddress;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    private boolean doHandShake(String conStr) throws SQLException {
        ByteBuffer handBuffer = null;
        byte[] connectBytes = null;
        int i = 0;
        try {
            connectBytes = conStr == null ? this.connectString.getBytes() : conStr.getBytes();
            handBuffer = ByteBuffer.allocate(connectBytes.length + 1);
            handBuffer.put(connectBytes);
            byte last = 0;
            handBuffer.put(last);
            handBuffer.flip();
            byte[] data = new byte[handBuffer.limit()];
            handBuffer.get(data);
            OutputStream netOut = this.socketChannel.socket().getOutputStream();
            netOut.write(data);
            netOut.flush();
        }
        catch (IOException e) {
            this.setConnState(-1);
            return false;
        }
        byte[] content = null;
        try {
            if (this.recbyteBuffer == null) {
                this.recbyteBuffer = ByteBuffer.allocate(65536);
            } else {
                this.recbyteBuffer.clear();
            }
            i = this.socketChannel.read(this.recbyteBuffer);
            this.recbyteBuffer.flip();
            if (i != -1) {
                content = new byte[i];
                this.recbyteBuffer.get(content);
            }
        }
        catch (IOException e) {
            this.setConnState(-1);
            return false;
        }
        return this.handleHandShakeRecv(content);
    }

    private boolean doHandShakeSSL(String passwd) throws SQLException {
        try {
            if (this.byteBuffer == null) {
                this.byteBuffer = ByteBuffer.allocate(65536);
            } else {
                this.byteBuffer.clear();
            }
            this.socketChannel.socket().getOutputStream().write("~ssl~".getBytes());
            this.socketChannel.socket().getInputStream().read(this.public_key);
            this.socketChannel.socket().getInputStream().read(this.trail_key);
            SSL.getKey(passwd);
            SSL.init_key(this.turing_read, this.turing_send, this.key);
            byte[] conBytes = SSL.encrypt_conn(this, this.connectString, this.connectString.length());
            this.socketChannel.socket().getOutputStream().write(conBytes);
        }
        catch (IOException e) {
            this.setConnState(-1);
            return false;
        }
        byte[] content = null;
        try {
            if (this.recbyteBuffer == null) {
                this.recbyteBuffer = ByteBuffer.allocate(65536);
            } else {
                this.recbyteBuffer.clear();
            }
            int i = this.socketChannel.read(this.recbyteBuffer);
            this.recbyteBuffer.flip();
            if (i != -1) {
                content = new byte[this.recbyteBuffer.limit()];
                this.recbyteBuffer.get(content);
            }
        }
        catch (IOException e) {
            this.setConnState(-1);
            return false;
        }
        content = content == null ? null : SSL.encrypt_decrypt_buff(this.turing_read, content, 1);
        return this.handleHandShakeRecv(content);
    }

    private boolean handleHandShakeRecv(byte[] contents) throws SQLException {
        boolean handResults;
        block10: {
            block9: {
                handResults = false;
                if (contents == null) break block9;
                byte bt1 = contents[0];
                switch (bt1) {
                    case 75: {
                        if (Command.debug) {
                            Command.logHandshake(this, "SSL\u63e1\u624b\u5b8c\u6210.  \u8fd4\u56de  " + (char)contents[0]);
                        }
                        this.setConnState(0);
                        handResults = true;
                        break block10;
                    }
                    case 78: {
                        if (Command.debug) {
                            Command.logHandshake(this, "SSL\u63e1\u624b\u5b8c\u6210.  \u8fd4\u56de  " + (char)contents[0]);
                        }
                        this.setServerProtocolVersion(301);
                        this.setConnState(0);
                        handResults = true;
                        break block10;
                    }
                    case 69: 
                    case 70: {
                        this.setConnState(-1);
                        String ioErrStr = new String(contents, 1, contents.length - 1).trim();
                        throw Error.createSQLException("[E50027]\u65e0\u6cd5\u8fde\u63a5\u5230\u6307\u5b9a\u670d\u52a1\u5668\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7528\u6237\u540d\u4e0d\u5b58\u5728\n2.\u5bc6\u7801\u9519\u8bef\n3.\u6570\u636e\u5e93\u4e0d\u5b58\u5728\n4.\u7528\u6237\u65e0\u767b\u5f55\u6743\n5." + ioErrStr, String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50027, 50027);
                    }
                    default: {
                        if (Command.debug) {
                            Command.logConnectError(this, " SSL\u63e1\u624b\u5931\u8d25. \u8fd4\u56de   " + (char)contents[0] + "  \u767b\u5f55\u4e32\uff1a " + this.connectString);
                        }
                        this.setConnState(-1);
                        throw Error.createSQLException("[E50027]\u65e0\u6cd5\u8fde\u63a5\u5230\u6307\u5b9a\u670d\u52a1\u5668\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7528\u6237\u540d\u4e0d\u5b58\u5728\n2.\u5bc6\u7801\u9519\u8bef\n3.\u6570\u636e\u5e93\u4e0d\u5b58\u5728\n4.\u7528\u6237\u65e0\u767b\u5f55\u6743", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50027, 50027);
                    }
                }
            }
            if (Command.debug) {
                Command.logConnectError(this, " SSL\u63e1\u624b\u5931\u8d25. \u8fd4\u56de   -1     \u767b\u5f55\u4e32\uff1a " + this.connectString);
            }
            this.setConnState(-1);
            throw Error.createSQLException("[E50027]\u65e0\u6cd5\u8fde\u63a5\u5230\u6307\u5b9a\u670d\u52a1\u5668\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7528\u6237\u540d\u4e0d\u5b58\u5728\n2.\u5bc6\u7801\u9519\u8bef\n3.\u6570\u636e\u5e93\u4e0d\u5b58\u5728\n4.\u7528\u6237\u65e0\u767b\u5f55\u6743", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50027, 50027);
        }
        return handResults;
    }

    boolean sendByte(byte sendByte) throws SQLException {
        ByteBuffer buff = ByteBuffer.allocateDirect(2);
        buff.put(sendByte);
        buff.flip();
        try {
            this.sendBuffer(buff);
            return true;
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
            return false;
        }
    }

    void sendVector(Vector v) throws SQLException {
        if (this.getConnState() == 1) {
            this.setConnState(0);
        }
        if (!this.byteBuffer.hasRemaining()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.byteBuffer.clear();
        }
        try {
            int v_size = v.size();
            int i = 0;
            while (i < v_size) {
                int v_row_cap = ((Vector)v.get(i)).size();
                int v_row_size = (Integer)((Vector)v.get(i)).get(v_row_cap - 1);
                byte[] meanBytes = (byte[])((Vector)v.get(i)).get(v_row_cap - 2);
                if (v_row_size + 4 >= this.byteBuffer.capacity()) {
                    if (this.byteBuffer.remaining() < 65536) {
                        this.byteBuffer.flip();
                        this.sendBuffer(this.byteBuffer);
                        this.byteBuffer.clear();
                    }
                    ByteBuffer bb = ByteBuffer.allocate(v_row_size + 4);
                    bb.putInt(v_row_size);
                    bb.put(meanBytes);
                    int j = 0;
                    while (j < v_row_cap - 2) {
                        if ((Integer)((Vector)v.get(i)).get(j) == 2) {
                            bb.putShort(((Integer)((Vector)v.get(i)).get(++j)).shortValue());
                        } else {
                            bb.putInt((Integer)((Vector)v.get(i)).get(++j));
                        }
                        bb.put((byte[])((Vector)v.get(i)).get(++j));
                        ++j;
                    }
                    bb.flip();
                    this.sendBuffer(bb);
                    bb = null;
                } else {
                    if (v_row_size + 4 >= this.byteBuffer.remaining()) {
                        this.byteBuffer.flip();
                        this.sendBuffer(this.byteBuffer);
                        this.byteBuffer.clear();
                    }
                    this.byteBuffer.putInt(v_row_size);
                    this.byteBuffer.put(meanBytes);
                    int j = 0;
                    while (j < v_row_cap - 2) {
                        if ((Integer)((Vector)v.get(i)).get(j) == 2) {
                            this.byteBuffer.putShort(((Integer)((Vector)v.get(i)).get(++j)).shortValue());
                        } else {
                            this.byteBuffer.putInt((Integer)((Vector)v.get(i)).get(++j));
                        }
                        this.byteBuffer.put((byte[])((Vector)v.get(i)).get(++j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
        }
    }

    void sendVectorLoad(Vector v) throws SQLException {
        if (this.getConnState() == 1) {
            this.setConnState(0);
        }
        try {
            int v_size = v.size();
            int total_size = 0;
            int row_num = 0;
            if (v.size() > 0) {
                if (this.byteBuffer.position() > 8) {
                    row_num = this.byteBuffer.getInt(0);
                    total_size = this.byteBuffer.getInt(4);
                } else {
                    this.byteBuffer.position(8);
                }
            }
            int i = 0;
            while (i < v_size) {
                int v_row_cap = ((Vector)v.get(i)).size();
                int v_row_size = (Integer)((Vector)v.get(i)).get(v_row_cap - 1);
                byte[] meanBytes = (byte[])((Vector)v.get(i)).get(v_row_cap - 2);
                if (v_row_size + 4 >= this.byteBuffer.capacity()) {
                    if (this.byteBuffer.remaining() < this.byteBuffer.capacity()) {
                        this.byteBuffer.flip();
                        this.byteBuffer.putInt(0, row_num);
                        this.byteBuffer.putInt(4, total_size);
                        this.sendBuffer(this.byteBuffer);
                        this.byteBuffer.clear();
                        row_num = 0;
                        total_size = 0;
                        this.byteBuffer.putInt(0);
                        this.byteBuffer.putInt(0);
                    }
                    ByteBuffer bb = ByteBuffer.allocate(v_row_size + 4);
                    bb.putInt(0);
                    bb.putInt(0);
                    bb.putInt(v_row_size);
                    bb.put(meanBytes);
                    int j = 0;
                    while (j < v_row_cap - 2) {
                        if ((Integer)((Vector)v.get(i)).get(j) == 2) {
                            bb.putShort(((Integer)((Vector)v.get(i)).get(++j)).shortValue());
                        } else {
                            bb.putInt((Integer)((Vector)v.get(i)).get(++j));
                        }
                        bb.put((byte[])((Vector)v.get(i)).get(++j));
                        ++j;
                    }
                    bb.flip();
                    bb.putInt(0, 1);
                    bb.putInt(4, v_row_size + 4);
                    this.sendBuffer(bb);
                    bb.clear();
                    bb = null;
                } else {
                    if (v_row_size + 4 >= this.byteBuffer.remaining()) {
                        this.byteBuffer.flip();
                        this.byteBuffer.putInt(0, row_num);
                        this.byteBuffer.putInt(4, total_size);
                        this.sendBuffer(this.byteBuffer);
                        this.byteBuffer.clear();
                        row_num = 0;
                        total_size = 0;
                        this.byteBuffer.putInt(0);
                        this.byteBuffer.putInt(0);
                    }
                    this.byteBuffer.putInt(v_row_size);
                    this.byteBuffer.put(meanBytes);
                    int j = 0;
                    while (j < v_row_cap - 2) {
                        if ((Integer)((Vector)v.get(i)).get(j) == 2) {
                            this.byteBuffer.putShort(((Integer)((Vector)v.get(i)).get(++j)).shortValue());
                        } else {
                            this.byteBuffer.putInt((Integer)((Vector)v.get(i)).get(++j));
                        }
                        this.byteBuffer.put((byte[])((Vector)v.get(i)).get(++j));
                        ++j;
                    }
                    ++row_num;
                    total_size += v_row_size + 4;
                }
                ++i;
            }
            if (row_num > 0) {
                this.byteBuffer.putInt(0, row_num);
                this.byteBuffer.putInt(4, total_size);
            }
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sendTaskNum(long taskNum) throws SQLException {
        long returnLong = 0L;
        boolean isReady = false;
        Thread recvThread = null;
        while (!isReady) {
            Object object = this.getMutex();
            synchronized (object) {
                if (!this.isBLocked()) {
                    isReady = true;
                    this.setBLocked(true);
                    this.sendI8(taskNum);
                    returnLong = this.readLong();
                    if (this.rcThread == null) {
                        this.rcThread = new Receive();
                        recvThread = new Thread((Runnable)this.rcThread, "XGReceiveThd");
                        recvThread.setPriority(10);
                        recvThread.start();
                    }
                    this.setBLocked(false);
                    if (Command.debug) {
                        Command.logBlockedState(this, "sendTaskNum " + taskNum + "   K", this.isBLocked());
                    }
                } else {
                    if (Command.debug) {
                        Command.logBlockedState(this, "sendTaskNum   " + taskNum, this.isBLocked());
                    }
                    isReady = false;
                    throw Error.createSQLException("[E50020]\u4e0e\u670d\u52a1\u5668\u7684\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed,\u65e0\u6cd5\u6267\u884c", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50020, 50020);
                }
            }
        }
        return returnLong;
    }

    void sendVector_old(Vector v) throws SQLException {
        if (this.getConnState() == 1) {
            this.setConnState(0);
        }
        if (!this.byteBuffer.hasRemaining()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.byteBuffer.clear();
        }
        try {
            int v_size = v.size();
            if (v_size == 0 && this.rcThread == null) {
                this.rcThread = new Receive();
                new Thread((Runnable)this.rcThread, "XGReceiveThd").start();
            }
            int i = 0;
            while (i < v_size) {
                int v_row_cap;
                Vector v_row = (Vector)v.get(i);
                int v_row_size = (Integer)v_row.get((v_row_cap = v_row.size()) - 1);
                if (v_row_size + 4 + v_row_cap - 1 > this.byteBuffer.capacity()) {
                    ByteBuffer bb = ByteBuffer.allocate(v_row_size + 4 + v_row_cap - 1);
                    bb.putInt(v_row_size + v_row_cap - 1);
                    int j = 0;
                    while (j < v_row_cap - 1) {
                        if (v_row.get(j) == null) {
                            bb.put((byte)124);
                        } else {
                            bb.put((byte[])v_row.get(j));
                            bb.put((byte)124);
                        }
                        ++j;
                    }
                    bb.flip();
                    this.sendBuffer(bb);
                    bb = null;
                } else {
                    if (v_row_size + 4 + v_row_cap - 1 > this.byteBuffer.remaining()) {
                        this.byteBuffer.flip();
                        this.sendBuffer(this.byteBuffer);
                        this.byteBuffer.clear();
                    }
                    this.byteBuffer.putInt(v_row_size + v_row_cap - 1);
                    int j = 0;
                    while (j < v_row_cap - 1) {
                        if (v_row.get(j) == null) {
                            this.byteBuffer.put((byte)124);
                        } else {
                            this.byteBuffer.put((byte[])v_row.get(j));
                            this.byteBuffer.put((byte)124);
                        }
                        ++j;
                    }
                }
                if (this.rcThread == null) {
                    this.rcThread = new Receive();
                    new Thread((Runnable)this.rcThread, "XGReceiveThd").start();
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
        }
    }

    private void sendBytes(byte[] bytes) throws IOException {
        int bytesLength = bytes.length;
        if (bytesLength + 4 >= 65536) {
            if (this.byteBuffer.remaining() < 65536) {
                this.byteBuffer.flip();
                this.sendBuffer(this.byteBuffer);
                this.byteBuffer.clear();
            }
            ByteBuffer bb = ByteBuffer.allocate(bytesLength + 4);
            bb.putInt(bytesLength);
            bb.put(bytes);
            bb.flip();
            this.sendBuffer(bb);
            Object var3_3 = null;
        } else {
            if (this.byteBuffer.remaining() <= bytesLength + 4) {
                this.byteBuffer.flip();
                this.sendBuffer(this.byteBuffer);
                this.byteBuffer.clear();
            }
            this.byteBuffer.putInt(bytesLength);
            this.byteBuffer.put(bytes);
        }
    }

    boolean sendStreamBytes(byte[] line) throws SQLException {
        if (this.getConnState() == 1) {
            this.setConnState(0);
        }
        if (!this.byteBuffer.hasRemaining()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.byteBuffer.clear();
        }
        try {
            this.sendBytes(line);
            if (this.rcThread == null) {
                this.rcThread = new Receive();
                new Thread((Runnable)this.rcThread, "XGReceiveThd").start();
            }
            return true;
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
            return false;
        }
    }

    boolean sendCommandBatchUnssl(String sqlCommand, ArrayList<byte[]> paramLists, int bCount, int pCount) throws SQLException {
        if (bCount > Short.MAX_VALUE || pCount > Short.MAX_VALUE) {
            throw Error.createSQLException("[E51033]PrepareStatement:\u6279\u5904\u7406\u6761\u6570\u6216\u53c2\u6570\u4e2a\u6570\u8d85\u51fa\u5141\u8bb8\u8303\u56f4", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51033, 51033);
        }
        int bufferLength = 0;
        byte[] sqlByte = null;
        try {
            sqlByte = sqlCommand.getBytes(this.charSet);
            bufferLength = sqlByte.length;
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        if (bufferLength > maxCommandLength) {
            throw Error.createSQLException("[E50028]SQL\u547d\u4ee4\u957f\u5ea6\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + " 50028", 50028);
        }
        int first = 63;
        int last = 0;
        if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endCmd") != -1 || Command.debugLevel.indexOf("endK") != -1)) {
            this.serverStartT = System.currentTimeMillis();
        }
        try {
            OutputStream socOutputStream = this.socketChannel.socket().getOutputStream();
            socOutputStream.write(first);
            socOutputStream.write(this.intLocalToNet(bufferLength));
            socOutputStream.write(sqlByte);
            socOutputStream.write(last);
            int toLen = 0;
            ByteBuffer bbf = ByteBuffer.allocate(131072);
            int i = 0;
            while (i < paramLists.size()) {
                byte[] params = paramLists.get(i);
                if (i == 0) {
                    params[0] = (byte)(bCount >>> 8 & 0xFF);
                    params[1] = (byte)(bCount & 0xFF);
                    params[2] = (byte)(pCount >>> 8 & 0xFF);
                    params[3] = (byte)(pCount & 0xFF);
                    socOutputStream.write(params);
                    socOutputStream.flush();
                } else {
                    if (bbf.remaining() < params.length) {
                        socOutputStream.write(this.intLocalToNet(toLen));
                        socOutputStream.write(bbf.array(), 0, toLen);
                        socOutputStream.flush();
                        toLen = 0;
                        bbf.clear();
                    }
                    toLen += params.length;
                    bbf.put(params);
                }
                ++i;
            }
            if (bbf.remaining() < bbf.capacity()) {
                socOutputStream.write(this.intLocalToNet(toLen));
                socOutputStream.write(bbf.array(), 0, toLen);
                socOutputStream.flush();
                bbf.clear();
            }
            bbf = null;
            return true;
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
            return false;
        }
    }

    boolean sendCommandBatch(String sqlCommand, ArrayList<byte[]> paramLists, int bCount, int pCount) throws SQLException {
        if (bCount > Short.MAX_VALUE || pCount > Short.MAX_VALUE) {
            throw Error.createSQLException("[E51033]PrepareStatement:\u6279\u5904\u7406\u6761\u6570\u6216\u53c2\u6570\u4e2a\u6570\u8d85\u51fa\u5141\u8bb8\u8303\u56f4", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51033, 51033);
        }
        int bufferLength = 0;
        byte[] sqlByte = null;
        try {
            sqlByte = sqlCommand.getBytes(this.charSet);
            bufferLength = sqlByte.length;
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        if (bufferLength > maxCommandLength) {
            throw Error.createSQLException("[E50028]SQL\u547d\u4ee4\u957f\u5ea6\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + " 50028", 50028);
        }
        byte first = 63;
        byte last = 0;
        if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endCmd") != -1 || Command.debugLevel.indexOf("endK") != -1)) {
            this.serverStartT = System.currentTimeMillis();
        }
        try {
            this.byteBuffer.clear();
            this.byteBuffer.put(first);
            this.byteBuffer.putInt(bufferLength);
            this.byteBuffer.put(sqlByte);
            this.byteBuffer.put(last);
            this.byteBuffer.flip();
            this.sendBuffer(this.byteBuffer);
            this.byteBuffer.clear();
            int toLen = 0;
            ByteBuffer bbf = ByteBuffer.allocate(32768);
            int i = 0;
            while (i < paramLists.size()) {
                byte[] params = paramLists.get(i);
                if (i == 0) {
                    params[0] = (byte)(bCount >>> 8 & 0xFF);
                    params[1] = (byte)(bCount & 0xFF);
                    params[2] = (byte)(pCount >>> 8 & 0xFF);
                    params[3] = (byte)(pCount & 0xFF);
                    this.byteBuffer.put(params);
                    this.byteBuffer.flip();
                    this.sendBuffer(this.byteBuffer);
                    this.byteBuffer.clear();
                } else {
                    if (bbf.remaining() - 4 < params.length) {
                        this.byteBuffer.putInt(toLen);
                        this.byteBuffer.put(bbf.array(), 0, toLen);
                        this.byteBuffer.flip();
                        this.sendBuffer(this.byteBuffer);
                        toLen = 0;
                        bbf.clear();
                        this.byteBuffer.clear();
                    }
                    toLen += params.length;
                    bbf.put(params);
                }
                ++i;
            }
            if (bbf.remaining() < bbf.capacity()) {
                this.byteBuffer.putInt(toLen);
                this.byteBuffer.put(bbf.array(), 0, toLen);
                this.byteBuffer.flip();
                this.sendBuffer(this.byteBuffer);
                bbf.clear();
                this.byteBuffer.clear();
            }
            bbf = null;
            return true;
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
            return false;
        }
    }

    boolean sendCommand(String sqlCommand, byte[] params) throws SQLException {
        this.executeSQL = sqlCommand;
        ++this.sqlCountIn;
        int bufferLength = 0;
        byte[] sqlByte = null;
        try {
            sqlByte = sqlCommand.getBytes(this.charSet);
            bufferLength = sqlByte.length;
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        if (bufferLength > maxCommandLength) {
            throw Error.createSQLException("[E50028]SQL\u547d\u4ee4\u957f\u5ea6 " + bufferLength + " \u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50028, 50028);
        }
        byte first = 63;
        byte last = 0;
        if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endCmd") != -1 || Command.debugLevel.indexOf("endK") != -1)) {
            this.serverStartT = System.currentTimeMillis();
        }
        try {
            if (bufferLength + 10 + params.length >= 65536) {
                ByteBuffer bb = ByteBuffer.allocateDirect(bufferLength + 10 + params.length);
                bb.put(first);
                bb.putInt(bufferLength);
                bb.put(sqlByte);
                bb.put(last);
                bb.put(params);
                bb.flip();
                this.sendBuffer(bb);
                bb = null;
            } else {
                this.byteBuffer.clear();
                this.byteBuffer.put(first);
                this.byteBuffer.putInt(bufferLength);
                this.byteBuffer.put(sqlByte);
                this.byteBuffer.put(last);
                this.byteBuffer.put(params);
                this.byteBuffer.flip();
                this.sendBuffer(this.byteBuffer);
            }
            if (this.slowSQLBean != null) {
                this.slowSQLBean.setBeginTime(System.currentTimeMillis());
            }
            return true;
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
            return false;
        }
    }

    boolean sendCommand0(String sqlCommand) throws SQLException {
        this.executeSQL = sqlCommand;
        ++this.sqlCountIn;
        byte[] sqlC = null;
        int bufferLength = 0;
        try {
            bufferLength = sqlCommand.getBytes(this.charSet).length;
            sqlC = sqlCommand.getBytes(this.charSet);
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        if (bufferLength > maxCommandLength) {
            throw Error.createSQLException("[E50028]SQL\u547d\u4ee4\u957f\u5ea6 " + bufferLength + " \u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50028, 50028);
        }
        byte first = 63;
        byte last = 0;
        if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endCmd") != -1 || Command.debugLevel.indexOf("endK") != -1)) {
            this.serverStartT = System.currentTimeMillis();
        }
        try {
            if (bufferLength + 10 >= 65536) {
                ByteBuffer bb = ByteBuffer.allocate(bufferLength + 10);
                bb.put(first);
                bb.putInt(bufferLength);
                bb.put(sqlC);
                bb.put(last);
                bb.putInt(0);
                bb.flip();
                this.sendBuffer(bb);
                bb = null;
            } else {
                this.byteBuffer.clear();
                this.byteBuffer.put(first);
                this.byteBuffer.putInt(bufferLength);
                this.byteBuffer.put(sqlC);
                this.byteBuffer.put(last);
                this.byteBuffer.putInt(0);
                this.byteBuffer.flip();
                this.sendBuffer(this.byteBuffer);
            }
            if (this.slowSQLBean != null) {
                this.slowSQLBean.setBeginTime(System.currentTimeMillis());
            }
            return true;
        }
        catch (IOException e) {
            this.close();
            this.buildNewConnection(false, "Send");
            return false;
        }
    }

    boolean sendI4(int i) throws SQLException {
        try {
            this.byteBuffer.clear();
            this.byteBuffer.putInt(i);
            this.byteBuffer.flip();
            this.sendBuffer(this.byteBuffer);
            this.byteBuffer.clear();
            return true;
        }
        catch (IOException e) {
            throw Error.createSQLException("[E50029]Send integer error", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50029, 50029);
        }
    }

    byte[] readBytes(int len) throws SQLException {
        int length = len;
        int left = 0;
        int leftbyte_start = 0;
        int read_len = 0;
        byte[] backBytes = new byte[length];
        while (length > 0) {
            left = this.recbyteBuffer.remaining();
            if (left >= length) {
                this.recbyteBuffer.get(backBytes, leftbyte_start, length);
                break;
            }
            if (left > 0) {
                this.recbyteBuffer.get(backBytes, leftbyte_start, left);
                leftbyte_start += left;
                length -= left;
            }
            try {
                this.recbyteBuffer.clear();
                this.recbyteBuffer.limit(65536);
                read_len = this.socketChannel.read(this.recbyteBuffer);
                while (read_len <= 0) {
                    if (read_len == -1) {
                        System.out.println("\u7f51\u8def\u8fd4\u56de-1 execute sql is " + this.executeSQL);
                        this.close();
                        this.buildNewConnection(false, "Read");
                    }
                    if (read_len != 0) continue;
                    read_len = this.socketChannel.read(this.recbyteBuffer);
                }
                if (read_len < this.recbyteBuffer.limit()) {
                    this.recbyteBuffer.limit(read_len);
                }
                this.recbyteBuffer.flip();
                if (this.useSSL) {
                    this.recbyteBuffer.put(SSL.encrypt_decrypt_buff(this.turing_read, this.recbyteBuffer.array(), this.recbyteBuffer.limit()));
                    this.recbyteBuffer.flip();
                }
            }
            catch (IOException e) {
                this.close();
                this.buildNewConnection(false, "Read");
                return null;
            }
            left = this.recbyteBuffer.limit();
        }
        return backBytes;
    }

    byte readByte() throws SQLException {
        if (this.controlByte != 0) {
            byte ret_byte = this.controlByte;
            this.controlByte = 0;
            return ret_byte;
        }
        if (this.recbyteBuffer.remaining() > 0) {
            return this.recbyteBuffer.get();
        }
        byte[] backBytes = this.readBytes(1);
        return backBytes[0];
    }

    int readInt() throws SQLException {
        if (this.recbyteBuffer.remaining() >= 4) {
            return this.recbyteBuffer.getInt();
        }
        byte[] backBytes = this.readBytes(4);
        int aaa = (backBytes[0] & 0xFF) << 24 | (backBytes[1] & 0xFF) << 16 | (backBytes[2] & 0xFF) << 8 | backBytes[3] & 0xFF;
        return aaa;
    }

    long readLong() throws SQLException {
        if (this.recbyteBuffer.remaining() >= 8) {
            return this.recbyteBuffer.getLong();
        }
        byte[] backBytes = this.readBytes(8);
        long aaa = (backBytes[0] & 0xFF) << 56 | (backBytes[1] & 0xFF) << 48 | (backBytes[2] & 0xFF) << 40 | (backBytes[3] & 0xFF) << 32 | (backBytes[4] & 0xFF) << 24 | (backBytes[5] & 0xFF) << 16 | (backBytes[6] & 0xFF) << 8 | backBytes[7] & 0xFF;
        return aaa;
    }

    void backByte(byte b) {
        this.controlByte = b;
    }

    String readStr() throws SQLException {
        String readString = null;
        int s_len = this.readInt();
        if (s_len == 0) {
            return null;
        }
        byte[] bytes = this.readBytes(s_len);
        try {
            readString = new String(bytes, this.charSet);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return readString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int executeOther(String sqlString) throws SQLException {
        boolean isReady = false;
        String err = null;
        while (!isReady) {
            Object object = this.getMutex();
            synchronized (object) {
                if (!this.isBLocked()) {
                    byte bb;
                    this.setBLocked(true);
                    isReady = true;
                    this.sendCommand0(sqlString);
                    byte first = this.readByte();
                    if (first == 75) {
                        this.setBLocked(false);
                        if (Command.debug) {
                            if (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endK") != -1) {
                                this.lw.write(this.sessionId, sqlString, LogWriter.CmdState.endK);
                            }
                            Command.logBlockedState(this, "K  " + sqlString, this.bLocked);
                        }
                        return 0;
                    }
                    if (first != 69 && first != 70 && first != 87 && first != 77) {
                        throw Error.createSQLException("\u8fdd\u53cd" + ReplaceEnum.excCHNStr.getReplaceStr() + "\u534f\u8bae  " + first);
                    }
                    err = this.readStr();
                    if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endEF") != -1)) {
                        this.lw.write(this.sessionId, String.valueOf(sqlString) + "," + err, LogWriter.CmdState.endEF);
                    }
                    if ((bb = this.readByte()) == 75) {
                        this.setBLocked(false);
                        if (Command.debug) {
                            if (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endK") != -1) {
                                this.lw.write(this.sessionId, sqlString, LogWriter.CmdState.endK);
                            }
                            Command.logBlockedState(this, "K  " + sqlString, this.bLocked);
                        }
                        if (err != null) {
                            throw Error.createSQLException(err);
                        }
                    }
                } else {
                    if (Command.debug) {
                        Command.logBlockedState(this, sqlString, this.bLocked);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return -1;
    }

    static int getMaxBuf() {
        return maxCommandLength;
    }

    void close() throws SQLException {
        if (this.streamErrVector != null) {
            this.streamErrVector.clear();
            this.streamErrVector = null;
        }
        if (this.byteBuffer != null) {
            this.byteBuffer = null;
        }
        if (this.recbyteBuffer != null) {
            this.recbyteBuffer = null;
        }
        try {
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                    this.isClosed = true;
                }
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
                this.socketChannel = null;
            }
        }
        finally {
            this.socketChannel = null;
        }
    }

    synchronized int getConnState() {
        return this.connState;
    }

    synchronized void setConnState(int connState) {
        this.connState = connState;
    }

    public boolean getIsClosed() {
        return this.isClosed;
    }

    void clearBuffer() {
        this.byteBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void buildNewConnection(boolean isSystem, String errType) throws SQLException {
        if (this.rebuildConnection) {
            try {
                if (this.connIOType == 0) {
                    Thread.sleep(1000L);
                    this.createSocketChannel();
                } else {
                    Object object;
                    if (this.connIOType == 1) {
                        object = Connection.ipPoolLock;
                        synchronized (object) {
                            this.createSocketChannelRandom(0, this.connIOHashKey);
                        }
                    }
                    object = Connection.ipPoolLock;
                    synchronized (object) {
                        this.createSocketChannelRound(0, this.connIOHashKey);
                    }
                }
                this.socketChannel.socket().setReceiveBufferSize(0x400000);
                this.socketChannel.socket().setSendBufferSize(0x400000);
                this.byteBuffer = ByteBuffer.allocate(65536);
                this.recbyteBuffer = ByteBuffer.allocate(65536);
                String conStr = this.rebuildConnectString();
                this.doHandShake(conStr);
                this.setConnState(1);
                this.isClosed = false;
                this.resumeConnection();
            }
            catch (InterruptedException e1) {
                this.isClosed = true;
                this.setConnState(-1);
                e1.printStackTrace();
            }
            catch (IOException e2) {
                this.isClosed = true;
                this.setConnState(-1);
            }
            if (!isSystem) {
                if (this.getConnState() == 1) {
                    if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("buildNewConnection") != -1)) {
                        this.lw.write(this.sessionId, "\u65b0\u5efa\u8fde\u63a5\u6210\u529f", LogWriter.CmdState.buildNewConnection);
                    }
                    throw Error.createSQLException("[E50021]\u4e0e\u670d\u52a1\u5668\u91cd\u65b0\u5efa\u7acb\u8fde\u63a5\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u7f51\u7edc\u53d1\u751f\u95ea\u65ad\n2.\u670d\u52a1\u5668\u91cd\u542f\n3.\u8fde\u63a5\u8d85\u65f6", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50021, 50021);
                }
                if (this.getConnState() == -1) {
                    if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("buildNewConnection") != -1)) {
                        this.lw.write(this.sessionId, "\u65b0\u5efa\u8fde\u63a5\u5931\u8d25\uff0c\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5", LogWriter.CmdState.buildNewConnection);
                    }
                    throw Error.createSQLException("[E50022]\u4e0e\u670d\u52a1\u5668\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00,\u53ef\u80fd\u539f\u56e0:\n1.\u957f\u65f6\u95f4\u65e0\u52a8\u4f5c\u54cd\u5e94\n2.\u7f51\u7edc\u65ad\u5f00\n3.\u670d\u52a1\u5668\u5173\u95ed", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50022, 50022, errType);
                }
            }
        } else {
            this.setConnState(-1);
            throw Error.createSQLException("[E50022]\u4e0e\u670d\u52a1\u5668\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00,\u53ef\u80fd\u539f\u56e0:\n1.\u957f\u65f6\u95f4\u65e0\u52a8\u4f5c\u54cd\u5e94\n2.\u7f51\u7edc\u65ad\u5f00\n3.\u670d\u52a1\u5668\u5173\u95ed", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50022, 50022, errType);
        }
    }

    public void endStream() throws SQLException {
        this.sendI4(0);
        try {
            while (!this.isRecived) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    boolean flush() throws SQLException, IOException {
        boolean isSend = false;
        this.isRecived = false;
        SQLException stremException = null;
        if (this.byteBuffer.remaining() < this.byteBuffer.limit()) {
            this.byteBuffer.flip();
            this.sendBuffer(this.byteBuffer);
            this.byteBuffer.clear();
            isSend = true;
        }
        this.byteBuffer.putInt(0);
        this.byteBuffer.flip();
        this.sendBuffer(this.byteBuffer);
        this.byteBuffer.clear();
        if (this.rcThread == null) {
            this.rcThread = new Receive();
            new Thread((Runnable)this.rcThread, "XGReceiveThd").start();
        }
        while (!this.isRecived) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.bLocked = false;
        this.byteBuffer = ByteBuffer.allocate(65536);
        if (Command.debug) {
            Command.logBlockedState(this, "Flush   ", this.bLocked);
        }
        this.rcThread = null;
        if (this.streamWarning != null) {
            stremException = Error.createSQLException(this.streamWarning);
        }
        this.streamWarning = null;
        if (this.streamError != null) {
            throw this.streamError;
        }
        if (stremException != null) {
            throw stremException;
        }
        return isSend;
    }

    boolean sendI8(long i) throws SQLException {
        try {
            this.byteBuffer.clear();
            this.byteBuffer.putLong(i);
            this.byteBuffer.flip();
            this.sendBuffer(this.byteBuffer);
            this.byteBuffer.clear();
            return true;
        }
        catch (IOException e) {
            throw Error.createSQLException("[E50029]Send integer error", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50029, 50029);
        }
    }

    synchronized boolean getIsRecived() {
        return this.isRecived;
    }

    Object getMutex() {
        return this.mutex;
    }

    protected void setIOAutoCommit(boolean autoCommitFlag) {
        this.ioAutoCommit = autoCommitFlag;
    }

    private String rebuildConnectString() {
        String[] conStrs;
        String conStr = this.connectString;
        StringBuffer conSb = new StringBuffer();
        String[] stringArray = conStrs = conStr.split(" ");
        int n = conStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String perStr = stringArray[n2];
            if (perStr.indexOf("auto") == -1) {
                conSb.append(" ").append(perStr);
            }
            ++n2;
        }
        conSb.append(" ").append("auto_commit=");
        conSb.append(this.ioAutoCommit ? "on" : "off");
        conStr = conSb.toString().trim();
        return conStr;
    }

    void resumeConnection() {
        this.isRecived = false;
        this.is_Object = false;
        this.isClosed = false;
        this.streamWarning = null;
        this.streamError = null;
        this.sqlCountIn = 1L;
        this.sqlCountOut = 1L;
        this.setHalt(false);
        this.bLocked = false;
        if (this.slowSQLBean != null) {
            this.slowSQLBean.setHost(this.serverIp);
        }
        if (Command.debug) {
            Command.logBlockedState(this, "buildNewConnectuon   ", this.bLocked);
        }
    }

    public synchronized void resumeConnectState() {
        if (this.connState == 1) {
            this.connState = 0;
        }
    }

    boolean isHalt() {
        return this.isHalt;
    }

    void setHalt(boolean isHalt) {
        this.isHalt = isHalt;
    }

    void cleanNetBytes() throws IOException, SQLException {
        byte[] backBytes = new byte[20000];
        int len = this.socketChannel.socket().getInputStream().read(backBytes, 0, 2000);
        int i = 1;
        while (len != 0) {
            if (++i % 100 == 0) {
                len = this.socketChannel.socket().getInputStream().read(backBytes, 0, 7000);
            }
            len = i == 995 ? this.socketChannel.socket().getInputStream().read(backBytes, 0, 2000) : this.socketChannel.socket().getInputStream().read(backBytes, 0, 2000);
        }
    }

    Vector<String> getStreamErrVector() {
        return this.streamErrVector;
    }

    public byte[] getPublic_key() {
        return this.public_key;
    }

    public byte[] getTrail_key() {
        return this.trail_key;
    }

    public void sendBuffer(ByteBuffer buff) throws IOException {
        if (this.useSSL) {
            byte[] data = new byte[buff.limit()];
            buff.get(data);
            data = SSL.encrypt_decrypt_buff(this.turing_send, data, buff.limit());
            OutputStream netOut = this.socketChannel.socket().getOutputStream();
            netOut.write(data);
            netOut.flush();
        } else {
            this.socketChannel.write(buff);
        }
    }

    synchronized ByteBuffer getRecbyteBuffer() {
        return this.recbyteBuffer;
    }

    synchronized void setRecbyteBuffer(ByteBuffer recbyteBuffer) {
        this.recbyteBuffer = recbyteBuffer;
    }

    synchronized boolean isBLocked() {
        return this.bLocked;
    }

    synchronized void setBLocked(boolean locked) {
        this.bLocked = locked;
    }

    protected synchronized long getStIdGen() {
        return this.stIdGen++;
    }

    protected synchronized long getCurIdGen() {
        return this.curIdGen++;
    }

    private byte[] intLocalToNet(int localInt) {
        byte[] intBytes = new byte[]{(byte)(localInt >> 24 & 0xFF), (byte)(localInt >> 16 & 0xFF), (byte)(localInt >> 8 & 0xFF), (byte)(localInt & 0xFF)};
        return intBytes;
    }

    private void rebackRowAndLen(ByteBuffer bf, int rowSize, int totalLen) {
        bf.putInt(0, rowSize);
        bf.putInt(4, totalLen);
    }

    protected void reSizeBuffer() {
        this.byteBuffer = ByteBuffer.allocate(0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getConnectInfoListByConTimes() {
        List<ArrayList<String>> sortList = null;
        Object object = Connection.ipPoolLock;
        synchronized (object) {
            Vector<ArrayList<String>> ipVectors = Connection.ipsVector;
            sortList = ipVectors.subList(0, ipVectors.size());
            Collections.sort(sortList, new Comparator<ArrayList<String>>(){

                @Override
                public int compare(ArrayList<String> o1, ArrayList<String> o2) {
                    Integer cmp1 = Integer.parseInt(o1.get(1));
                    Integer cmp2 = Integer.parseInt(o2.get(1));
                    int i = cmp1.compareTo(cmp2);
                    return i;
                }
            });
        }
        ArrayList<String> firtList = sortList.get(0);
        return firtList;
    }

    private ArrayList<String> getConnectInfoListRound(boolean IsmoveIp) {
        Vector<ArrayList<String>> ipVectors = Connection.ipsVector;
        int curr_index = Connection.getRoundIdx(!IsmoveIp) % ipVectors.size();
        if (Connection.getRoundIdx(false) >= Integer.MAX_VALUE) {
            Connection.setRoundIdx(curr_index);
        }
        return ipVectors.get(curr_index);
    }

    protected static ScheduledThreadPoolExecutor getExecutorStatic() {
        return new ScheduledThreadPoolExecutor(1);
    }

    protected int getServerProtocolVersion() {
        return this.serverProtocolVersion;
    }

    protected void setServerProtocolVersion(int serverProtocolVersion) {
        this.serverProtocolVersion = serverProtocolVersion;
    }

    static /* synthetic */ InetSocketAddress access$0(ConnectionIO connectionIO, String string, int n) throws SQLException {
        return connectionIO.getInetSocketAddress(string, n);
    }

    class Receive
    implements Runnable {
        Receive() {
        }

        @Override
        public void run() {
            try {
                try {
                    byte bt;
                    ConnectionIO.this.streamErrVector.clear();
                    ConnectionIO.this.streamWarning = null;
                    block10: while ((bt = ConnectionIO.this.readByte()) != 75) {
                        switch (bt) {
                            case 69: {
                                String err = ConnectionIO.this.readStr();
                                ConnectionIO.this.streamError = Error.createSQLException(err);
                                ConnectionIO.this.streamErrVector.add(err);
                                break;
                            }
                            case 79: {
                                ConnectionIO.this.readInt();
                                int d_len = ConnectionIO.this.readInt();
                                if (d_len <= 0) continue block10;
                                ConnectionIO.this.readBytes(d_len);
                                break;
                            }
                            case 87: {
                                String warning = ConnectionIO.this.readStr();
                                if (ConnectionIO.this.streamWarning == null) {
                                    ConnectionIO.this.streamWarning = warning;
                                } else if (ConnectionIO.this.streamWarning.indexOf(warning) != -1) {
                                    ConnectionIO.this.streamWarning = String.valueOf(ConnectionIO.this.streamWarning) + "\r\n" + warning;
                                }
                                ConnectionIO.this.streamErrVector.add(warning);
                                break;
                            }
                            default: {
                                throw Error.createSQLException("\u8fdd\u53cd" + ReplaceEnum.excCHNStr.getReplaceStr() + "\u534f\u8bae byte: " + bt);
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    ConnectionIO.this.streamError = e;
                    ConnectionIO.this.isRecived = true;
                }
            }
            finally {
                ConnectionIO.this.isRecived = true;
            }
        }
    }

    private class detactedIpNode
    implements Runnable {
        InetSocketAddress inetAddress = null;
        int exeTimes = 0;

        private detactedIpNode() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 16[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

