/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.OracleMethod;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.WatchableOutputStream;
import com.xugu.cloudjdbc.WatchableWriter;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;

public class Clob
implements java.sql.Clob,
Serializable {
    protected String charData;
    protected boolean is_path = false;
    String clobDesciptor;
    long clobLen;
    Statement stm;
    long clob_index;
    ResultSet clob_rs;
    int colNum;
    static OracleMethod orclMethod = null;
    Connection clobConnection = null;
    boolean isClobEmpty;
    boolean isFreeClob;

    public Clob() {
        this.charData = new String();
        this.is_path = false;
    }

    public Clob(String charDataInit) {
        this.charData = charDataInit;
        this.is_path = false;
    }

    Clob(String charDataInit, ResultSet rs, Connection clobConn, int col_index) {
        this.clobConnection = clobConn;
        this.charData = charDataInit;
        this.clob_rs = rs;
        this.colNum = col_index;
        this.is_path = false;
    }

    Clob(byte[] charDataInit, boolean is_path, Statement stm) {
        try {
            if (charDataInit != null) {
                this.charData = new String(charDataInit, stm.connection.getCharSet());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.stm = stm;
        this.is_path = is_path;
        if (is_path) {
            int sepIndex = this.charData.indexOf(32);
            this.clobDesciptor = this.charData.substring(0, sepIndex);
            this.clobLen = Long.parseLong(this.charData.substring(sepIndex + 1));
        }
    }

    Clob(byte[] charDataInit, boolean is_path, Statement stm, ResultSet rs, int col_index) {
        try {
            if (charDataInit != null) {
                this.charData = new String(charDataInit, stm.connection.getCharSet());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.stm = stm;
        this.clob_rs = rs;
        this.colNum = col_index;
        this.is_path = is_path;
        if (is_path) {
            int sepIndex = this.charData.indexOf(32);
            this.clobDesciptor = this.charData.substring(0, sepIndex);
            this.clobLen = Long.parseLong(this.charData.substring(sepIndex + 1));
        } else {
            this.charData = this.charData.substring(1);
        }
    }

    public Clob(Reader rd) {
        StringBuffer clob_str = new StringBuffer();
        String sb_clob = null;
        BufferedReader clob_br = new BufferedReader(rd);
        try {
            int times = 0;
            while ((sb_clob = clob_br.readLine()) != null) {
                if (times++ != 0) {
                    clob_str.append("\r\n");
                }
                clob_str.append(sb_clob);
            }
            this.charData = clob_str.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.is_path = false;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkClobFree();
        if (this.isClobEmpty()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayInputStream clobInputStream = null;
        java.sql.ResultSet rs = null;
        byte[] asciiBytes = null;
        if (this.charData != null) {
            block12: {
                try {
                    if (!this.is_path) {
                        asciiBytes = this.charData.getBytes("US-ASCII");
                        clobInputStream = new ByteArrayInputStream(asciiBytes);
                        break block12;
                    }
                    if (this.clobLen == 0L) {
                        return null;
                    }
                    try {
                        rs = this.stm.getLobResultSet(this.clobDesciptor, 0L, this.clobLen);
                        if (rs.next()) {
                            clobInputStream = new ByteArrayInputStream(rs.getString(1).getBytes("US-ASCII"));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            return clobInputStream;
        }
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkClobFree();
        if (this.isClobEmpty()) {
            return new StringReader(new String(new byte[0]));
        }
        if (this.charData != null) {
            if (!this.is_path) {
                return new StringReader(this.charData);
            }
            if (this.clobLen == 0L) {
                return null;
            }
            java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, 0L, this.clobLen);
            if (rs.next()) {
                return new StringReader(rs.getString(1));
            }
            rs.close();
        }
        return null;
    }

    @Override
    public String getSubString(long startPos, int length) throws SQLException {
        this.checkClobFree();
        int adjustedStartPos = (int)startPos - 1;
        String subString = null;
        if (adjustedStartPos < 0) {
            throw Error.createSQLException("[E50011]Clob: can't get the bytes from the beginning of startPos<1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50011, 50011);
        }
        if (length < 0) {
            throw Error.createSQLException("[E50012]Clob: can't get the bytes which's length lesser than 1 byte", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50012, 50012);
        }
        if ((long)length > this.length() && this.length() != 0L) {
            throw Error.createSQLException("[E50013]Clob: can't get the bytes which's length bigger than the Clob's length", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50013, 50013);
        }
        if (this.isClobEmpty()) {
            return new String("");
        }
        if (this.charData != null) {
            if (!this.is_path) {
                subString = this.charData.substring(adjustedStartPos, adjustedStartPos + length);
            } else {
                if (this.clobLen == 0L) {
                    return null;
                }
                java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, adjustedStartPos, length);
                if (rs.next()) {
                    subString = rs.getString(1);
                }
                rs.close();
            }
        }
        return subString;
    }

    @Override
    public long length() throws SQLException {
        this.checkClobFree();
        if (this.charData != null) {
            if (!this.is_path) {
                if (this.isClobEmpty()) {
                    return 0L;
                }
                return this.charData.length();
            }
            return this.clobLen;
        }
        return 0L;
    }

    @Override
    public long position(java.sql.Clob searchstr, long start) throws SQLException {
        this.checkClobFree();
        Reader clobRd = searchstr.getCharacterStream();
        StringBuffer clobSB = new StringBuffer();
        char[] cbuf = new char[10240];
        int readLen = 0;
        try {
            while ((readLen = clobRd.read(cbuf)) != -1) {
                clobSB.append(cbuf, 0, readLen);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.position(clobSB.toString(), start);
    }

    @Override
    public long position(String stringToFind, long startPos) throws SQLException {
        this.checkClobFree();
        if (startPos < 1L) {
            throw Error.createSQLException("[E51026]Clob: can't get the bytes from the beginning of startPos<1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51026, 51026);
        }
        if (startPos > this.length() + 1L) {
            throw Error.createSQLException("[E51027]Clob: can't search the bytes from the beginning of the param start>Clob's length", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51027, 51027);
        }
        int pos = -1;
        if (this.charData != null) {
            if (!this.is_path) {
                pos = this.charData.indexOf(stringToFind, (int)(startPos - 1L));
            } else {
                if (this.clobLen == 0L) {
                    return -1L;
                }
                java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, startPos, this.clobLen);
                if (rs.next()) {
                    String subString = rs.getString(1);
                    pos = subString.indexOf(stringToFind);
                }
                rs.close();
            }
        }
        return pos == -1 ? -1 : pos + 1;
    }

    @Override
    public OutputStream setAsciiStream(long indexToWriteAt) throws SQLException {
        this.checkClobFree();
        if (indexToWriteAt < 0L) {
            throw Error.createSQLException("[E50014]Clob: indexToWriteAt can't be smaller than 1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50014, 50014);
        }
        this.clob_index = indexToWriteAt;
        StringBuffer comString = new StringBuffer();
        WatchableOutputStream clobOut = new WatchableOutputStream();
        if (this.charData != null) {
            if (!this.is_path) {
                clobOut.setWatcher(this, (int)indexToWriteAt);
            } else {
                if (this.clobLen == 0L) {
                    return null;
                }
                this.stm.checkClosed();
                java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, 0L, this.clobLen);
                if (rs.next()) {
                    comString.append(rs.getString(1).substring(0, (int)indexToWriteAt - 1));
                    comString.append(rs.getString(1));
                }
                rs.close();
            }
        } else {
            return null;
        }
        this.setClobEmpty(false);
        return clobOut;
    }

    @Override
    public Writer setCharacterStream(long indexToWriteAt) throws SQLException {
        this.checkClobFree();
        if (indexToWriteAt < 0L) {
            throw Error.createSQLException("[E50014]Clob: indexToWriteAt can't be smaller than 1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50014, 50014);
        }
        this.clob_index = indexToWriteAt;
        StringBuffer comString = new StringBuffer();
        WatchableWriter clobWriter = new WatchableWriter();
        if (this.charData != null) {
            if (!this.is_path) {
                clobWriter.setWatcher(this, indexToWriteAt);
            } else {
                if (this.clobLen == 0L) {
                    return null;
                }
                this.stm.checkClosed();
                java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, 0L, this.clobLen);
                if (rs.next()) {
                    comString.append(rs.getString(1).substring(0, (int)indexToWriteAt - 1));
                    comString.append(rs.getString(1));
                }
                rs.close();
            }
        } else {
            return null;
        }
        this.setClobEmpty(false);
        return clobWriter;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 1, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkClobFree();
        this.checkIndexOut(pos, this.length());
        StringBuffer clobBuffer = new StringBuffer();
        String realClob = this.charData;
        if (str == null) {
            return 0;
        }
        if (realClob != null) {
            if (this.is_path && this.clobLen > 0L) {
                java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, 0L, this.clobLen);
                if (rs.next()) {
                    realClob = rs.getString(1);
                }
                rs.close();
            }
            clobBuffer.append(realClob.substring(0, (int)(pos - 1L)));
        }
        clobBuffer.append(str.substring(offset - 1, offset - 1 + len));
        if (pos - 1L + (long)len < (long)realClob.length()) {
            clobBuffer.append(realClob.substring((int)pos + len - 1));
        }
        this.is_path = false;
        this.charData = clobBuffer.toString();
        this.setClobEmpty(false);
        return len;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.checkClobFree();
        if (this.charData != null) {
            if (!this.is_path) {
                this.charData = this.charData.substring(0, (int)length);
            } else {
                if (this.clobLen != 0L) {
                    java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, 0L, length);
                    if (rs.next()) {
                        this.charData = rs.getString(1);
                    }
                    rs.close();
                } else {
                    this.charData = null;
                }
                this.is_path = false;
            }
        }
    }

    public void writerClosed(char[] charDataBeingWritten) {
        this.charData = new String(charDataBeingWritten);
    }

    public void writerClosed(WatchableWriter out) {
        this.charData = out.getWriterString();
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.isFreeClob) {
            return;
        }
        this.isFreeClob = true;
        this.charData = null;
        this.clobDesciptor = null;
        this.clob_rs = null;
        this.stm = null;
        this.clobConnection = null;
    }

    private synchronized boolean getClobIsFree() {
        return this.isFreeClob;
    }

    private void checkClobFree() throws SQLException {
        if (this.getClobIsFree()) {
            throw Error.createSQLException("[E50005]lob: lob\u4e0d\u53ef\u7528\uff0c", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50005, 50005);
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkClobFree();
        if (pos < 1L) {
            throw Error.createSQLException("[E50011]Clob: can't get the bytes from the beginning of pos<1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50011, 50011);
        }
        if (length < 1L) {
            throw Error.createSQLException("[E50012]Clob: can't get the bytes which's length lesser than 1 byte", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50012, 50012);
        }
        if (length > this.length()) {
            throw Error.createSQLException("[E50013]Clob: can't get the bytes which's length bigger than the Clob's length", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50013, 50013);
        }
        StringReader r = null;
        if (this.isClobEmpty()) {
            return new StringReader(new String(new byte[0]));
        }
        if (this.charData != null) {
            if (!this.is_path) {
                String sub_charData = this.charData.substring((int)pos - 1, (int)(pos + length - 1L));
                r = new StringReader(sub_charData);
            } else {
                if (this.clobLen == 0L) {
                    return null;
                }
                this.stm.checkClosed();
                java.sql.ResultSet rs = this.stm.getLobResultSet(this.clobDesciptor, pos - 1L, length);
                if (rs.next()) {
                    r = new StringReader(rs.getString(1));
                }
                rs.close();
            }
        }
        return r;
    }

    void setCharData(byte[] bytedata) throws SQLException {
        if (this.is_path) {
            throw SQLCommon.unSupportException();
        }
        this.charData = null;
        this.charData = new String(bytedata);
        this.setClobEmpty(false);
    }

    String getCharData() {
        if (this.isClobEmpty()) {
            return new String(new byte[0]);
        }
        return this.charData;
    }

    void setIs_path(boolean path) {
        this.is_path = path;
    }

    boolean getIs_path() {
        return this.is_path;
    }

    void checkIndexOut(long index, long totleLength) {
        if (index < 1L) {
            Error.createSQLException("[E51028]\u5f00\u59cb\u5199\u5165\u6b64\u5bf9\u8c61\u7684\u4f4d\u7f6e\u4e0b\u6807\u4e0d\u80fd\u5c0f\u4e8e1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51028, 51028);
        }
        if (index > totleLength) {
            Error.createSQLException("[E51029]\u5f00\u59cb\u5199\u5165\u6b64\u5bf9\u8c61\u7684\u4f4d\u7f6e\u4e0b\u6807\u4e0d\u80fd\u5927\u4e8e\u8be5\u5bf9\u8c61\u7684\u957f\u5ea6", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51029, 51029);
        }
    }

    public static Clob getEmptyCLOB() {
        return OracleMethod.getEmptyCLOB();
    }

    ResultSet getClobRS() {
        return this.clob_rs;
    }

    int getColNum() {
        return this.colNum;
    }

    public String getClobDesciptor() {
        return String.valueOf(this.clobDesciptor) + "," + this.clobLen;
    }

    public boolean isInRow() {
        return !this.is_path;
    }

    public static Clob createTemporary(Connection clobConnection, boolean cache, int duration, short flag) {
        return OracleMethod.createTemporary(clobConnection, cache, duration, flag);
    }

    public static Clob createTemporary(Connection clobConnection, boolean cache, int duration) {
        return Clob.createTemporary(clobConnection, cache, duration, (short)1);
    }

    public static void freeTemporary(Clob clob) throws SQLException {
        OracleMethod.freeTemporary(clob);
    }

    public void freeTemporary() throws SQLException {
        Clob.freeTemporary(this);
    }

    Connection getClobConnection() {
        return this.clobConnection;
    }

    boolean isClobEmpty() {
        return this.isClobEmpty;
    }

    void setClobEmpty(boolean isClobEmpty) {
        this.isClobEmpty = isClobEmpty;
    }
}

