/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.OracleMethod;
import com.xugu.cloudjdbc.PreparedStatement;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.WatchableOutputStream;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;

public class Blob
implements java.sql.Blob,
Serializable {
    static final long serialVersionUID = 0L;
    private byte[] binaryData = null;
    boolean is_path = false;
    String blobDesciptor;
    long blobLen;
    Statement stm;
    Connection blobConnection = null;
    static Blob bb = new Blob("0".getBytes());
    ResultSet blob_rs;
    int colNum;
    boolean isBlobEmpty;
    boolean isFree;

    public Blob(byte[] data) {
        this.setBinaryData(data);
        this.is_path = false;
    }

    public Blob(byte[] data, ResultSet rs, Connection clobConn, int col_index) {
        this.setBinaryData(data);
        this.blobConnection = clobConn;
        this.is_path = false;
        this.blob_rs = rs;
        this.colNum = col_index;
    }

    public Blob(byte[] data, boolean is_path, Statement st, ResultSet rs, int col_index) {
        this.is_path = is_path;
        this.setBinaryData(data);
        this.stm = st;
        this.blob_rs = rs;
        this.colNum = col_index;
        if (is_path) {
            String dataString = new String(data);
            int sepIndex = dataString.indexOf(32);
            this.blobDesciptor = dataString.substring(0, sepIndex);
            this.blobLen = Long.parseLong(dataString.substring(sepIndex + 1));
        } else {
            this.setBinaryData(data, 1, data.length - 1);
        }
    }

    public Blob(byte[] data, boolean is_path, Statement st) {
        this.is_path = is_path;
        this.setBinaryData(data);
        this.stm = st;
        if (is_path) {
            String dataString = new String(data);
            int sepIndex = dataString.indexOf(32);
            this.blobDesciptor = dataString.substring(0, sepIndex);
            this.blobLen = Long.parseLong(dataString.substring(sepIndex + 1));
        }
    }

    public Blob(InputStream in) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] temp = new byte[PreparedStatement.byteSize];
        int readLength = 0;
        try {
            while ((readLength = in.read(temp)) != -1) {
                byteOut.write(temp, 0, readLength);
            }
            this.binaryData = byteOut.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.is_path = false;
    }

    byte[] getBinaryData() throws SQLException {
        return this.binaryData;
    }

    protected byte[] getBinaryData(long start, long len) throws SQLException {
        this.checkBlob();
        if (this.isBlobEmpty()) {
            return new byte[0];
        }
        if (start < 0L) {
            throw Error.createSQLException("[E50001]Blob: can't get the bytes from the beginning of " + start, String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50001, 50001);
        }
        if (len < 1L && len != -1L) {
            throw Error.createSQLException("[E50002]Blob: access bytes length cannot be less than 1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50002, 50002);
        }
        if (len > this.length()) {
            throw Error.createSQLException("[E50003]Blob: access bytes length cannot be bigger than the greatest length", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50003, 50003);
        }
        if (this.is_path) {
            byte[] binaryBytes = null;
            java.sql.ResultSet rs = null;
            rs = len == -1L ? this.stm.getLobResultSet(this.blobDesciptor, start - 1L, this.blobLen) : this.stm.getLobResultSet(this.blobDesciptor, start - 1L, len);
            rs.next();
            binaryBytes = rs.getBytes(1);
            rs.close();
            return binaryBytes;
        }
        if (len == -1L) {
            return this.binaryData;
        }
        byte[] subData = new byte[(int)len];
        System.arraycopy(this.binaryData, (int)start - 1, subData, 0, (int)len);
        return subData;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBinaryData(1L, -1L));
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.getBinaryData(pos, length);
    }

    @Override
    public long length() throws SQLException {
        if (this.binaryData != null) {
            if (!this.is_path) {
                if (this.isBlobEmpty()) {
                    return 0L;
                }
                return this.binaryData.length;
            }
            return this.blobLen;
        }
        return 0L;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkBlob();
        if (start < 1L) {
            throw Error.createSQLException("[E50001]Blob: can't search the bytes from the beginning of the param start<1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50001, 50001);
        }
        if (start > this.length() + 1L) {
            throw Error.createSQLException("[E51047]Blob: can't search the bytes from the beginning of the param start>Blob's length", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51047, 51047);
        }
        if ((long)pattern.length > this.length() - (start - 1L)) {
            return -1L;
        }
        int pos = -1;
        byte[] subLobData = this.getBinaryData(start, this.length() - start);
        byte[] ssData = new byte[pattern.length];
        int i = 0;
        while (i < subLobData.length) {
            if (subLobData.length - i <= pattern.length) break;
            if (subLobData[i] == pattern[0]) {
                System.arraycopy(subLobData, i, ssData, 0, ssData.length);
                if (Arrays.equals(ssData, pattern)) {
                    pos = i;
                    break;
                }
            }
            ++i;
        }
        return pos == -1 ? -1L : (long)pos + start;
    }

    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        return this.position(((Blob)pattern).getBinaryData(1L, -1L), start);
    }

    void setBinaryData(byte[] newBinaryData) {
        this.binaryData = newBinaryData;
        this.setBlobEmpty(false);
    }

    void setBinaryData(byte[] newBinaryData, int start, int length) {
        this.binaryData = new byte[length];
        System.arraycopy(newBinaryData, start, this.binaryData, 0, length);
        this.setBlobEmpty(false);
    }

    @Override
    public OutputStream setBinaryStream(long indexToWriteAt) throws SQLException {
        if (indexToWriteAt < 0L) {
            throw Error.createSQLException("[E50004]Blob: indexToWriteAt can't be smaller than 1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50004, 50004);
        }
        if (indexToWriteAt > (long)this.binaryData.length) {
            throw Error.createSQLException("Blob: indexToWriteAt can't be biger than Blob's length");
        }
        if (indexToWriteAt == 1L) {
            int index_start = (int)indexToWriteAt;
            WatchableOutputStream bytesOut = new WatchableOutputStream();
            bytesOut.setWatcher(this, index_start);
            this.is_path = false;
            return bytesOut;
        }
        throw SQLCommon.unSupportException();
    }

    @Override
    public int setBytes(long writeAt, byte[] bytes) throws SQLException {
        return this.setBytes(writeAt, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        if (writeAt < 1L) {
            throw Error.createSQLException("[E50004]Blob: indexToWriteAt can't be smaller than 1", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50004, 50004);
        }
        if (writeAt > (long)this.binaryData.length) {
            throw Error.createSQLException("[E51025]Blob: indexToWriteAt can't be biger than Blob's length", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51025, 51025);
        }
        byte[] lobData = this.getBinaryData(1L, -1L);
        if ((long)length > this.length() - (writeAt - 1L)) {
            byte[] newData = new byte[(int)(writeAt - 1L) + length];
            System.arraycopy(lobData, 0, newData, 0, (int)writeAt - 1);
            System.arraycopy(bytes, offset, newData, (int)writeAt - 1, length);
            this.binaryData = newData;
        } else {
            System.arraycopy(bytes, offset, lobData, (int)writeAt - 1, length);
            this.binaryData = lobData;
        }
        this.is_path = false;
        this.setBlobEmpty(false);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.binaryData = this.getBinaryData(1L, length);
        this.is_path = false;
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.isFree) {
            return;
        }
        this.isFree = true;
        this.binaryData = null;
        this.blobDesciptor = null;
        this.blob_rs = null;
        this.stm = null;
        this.blobConnection = null;
    }

    private synchronized boolean getBlobIsFree() {
        return this.isFree;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkBlob();
        return new ByteArrayInputStream(this.getBinaryData(pos, length));
    }

    public void streamClosed(byte[] byteData) {
        this.binaryData = byteData;
    }

    public void streamClosed(WatchableOutputStream out) {
        int streamSize = out.size();
        if (streamSize < this.binaryData.length) {
            out.write(this.binaryData, streamSize, this.binaryData.length - streamSize);
        }
        this.binaryData = out.toByteArray();
    }

    void setIs_path(boolean b) {
        this.is_path = b;
    }

    boolean getIs_path() {
        return this.is_path;
    }

    void updateBlob(byte[] blobBytes) {
        this.setBinaryData(blobBytes);
    }

    public static Blob getEmptyBLOB() {
        return OracleMethod.getEmptyBLOB();
    }

    ResultSet getBlobRS() {
        return this.blob_rs;
    }

    int getColNum() {
        return this.colNum;
    }

    public String getBlobDesciptor() {
        return String.valueOf(this.blobDesciptor) + "," + this.blobLen;
    }

    public boolean isInRow() {
        return !this.is_path;
    }

    private void checkBlob() throws SQLException {
        if (this.getBlobIsFree()) {
            throw Error.createSQLException("[E50005]lob: lob\u6682\u4e0d\u53ef\u7528", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 50005, 50005);
        }
        if (this.binaryData == null) {
            throw Error.createSQLException("[E51003]lob: lob\u5bf9\u8c61\u4e3a\u7a7a\u5bf9\u8c61", String.valueOf(ReplaceEnum.excStr.getReplaceStr()) + 51003, 51003);
        }
    }

    Connection getBlobConnection() {
        return this.blobConnection;
    }

    public static Blob createTemporary(Connection blobConnection, boolean cache, int duration) {
        return OracleMethod.createTemporary(blobConnection, cache, duration);
    }

    public static void freeTemporary(Blob temBlob) throws SQLException {
        OracleMethod.freeTemporary(temBlob);
    }

    public void freeTemporary() throws SQLException {
        OracleMethod.freeTemporary(this);
    }

    boolean isBlobEmpty() {
        return this.isBlobEmpty;
    }

    void setBlobEmpty(boolean isEmpty) {
        this.isBlobEmpty = isEmpty;
    }
}

